//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/serialconsole/armserialconsole"
	"net/http"
	"net/url"
	"regexp"
)

// MicrosoftSerialConsoleServer is a fake server for instances of the armserialconsole.MicrosoftSerialConsoleClient type.
type MicrosoftSerialConsoleServer struct {
	// DisableConsole is the fake for method MicrosoftSerialConsoleClient.DisableConsole
	// HTTP status codes to indicate success:
	//   - http.StatusOK (returns armserialconsole.DisableSerialConsoleResult)
	//   - http.StatusNotFound (returns armserialconsole.GetSerialConsoleSubscriptionNotFound)
	DisableConsole func(ctx context.Context, defaultParam string, options *armserialconsole.MicrosoftSerialConsoleClientDisableConsoleOptions) (resp azfake.Responder[armserialconsole.MicrosoftSerialConsoleClientDisableConsoleResponse], errResp azfake.ErrorResponder)

	// EnableConsole is the fake for method MicrosoftSerialConsoleClient.EnableConsole
	// HTTP status codes to indicate success:
	//   - http.StatusOK (returns armserialconsole.EnableSerialConsoleResult)
	//   - http.StatusNotFound (returns armserialconsole.GetSerialConsoleSubscriptionNotFound)
	EnableConsole func(ctx context.Context, defaultParam string, options *armserialconsole.MicrosoftSerialConsoleClientEnableConsoleOptions) (resp azfake.Responder[armserialconsole.MicrosoftSerialConsoleClientEnableConsoleResponse], errResp azfake.ErrorResponder)

	// GetConsoleStatus is the fake for method MicrosoftSerialConsoleClient.GetConsoleStatus
	// HTTP status codes to indicate success:
	//   - http.StatusOK (returns armserialconsole.Status)
	//   - http.StatusNotFound (returns armserialconsole.GetSerialConsoleSubscriptionNotFound)
	GetConsoleStatus func(ctx context.Context, defaultParam string, options *armserialconsole.MicrosoftSerialConsoleClientGetConsoleStatusOptions) (resp azfake.Responder[armserialconsole.MicrosoftSerialConsoleClientGetConsoleStatusResponse], errResp azfake.ErrorResponder)

	// ListOperations is the fake for method MicrosoftSerialConsoleClient.ListOperations
	// HTTP status codes to indicate success: http.StatusOK
	ListOperations func(ctx context.Context, options *armserialconsole.MicrosoftSerialConsoleClientListOperationsOptions) (resp azfake.Responder[armserialconsole.MicrosoftSerialConsoleClientListOperationsResponse], errResp azfake.ErrorResponder)
}

// NewMicrosoftSerialConsoleServerTransport creates a new instance of MicrosoftSerialConsoleServerTransport with the provided implementation.
// The returned MicrosoftSerialConsoleServerTransport instance is connected to an instance of armserialconsole.MicrosoftSerialConsoleClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMicrosoftSerialConsoleServerTransport(srv *MicrosoftSerialConsoleServer) *MicrosoftSerialConsoleServerTransport {
	return &MicrosoftSerialConsoleServerTransport{srv: srv}
}

// MicrosoftSerialConsoleServerTransport connects instances of armserialconsole.MicrosoftSerialConsoleClient to instances of MicrosoftSerialConsoleServer.
// Don't use this type directly, use NewMicrosoftSerialConsoleServerTransport instead.
type MicrosoftSerialConsoleServerTransport struct {
	srv *MicrosoftSerialConsoleServer
}

// Do implements the policy.Transporter interface for MicrosoftSerialConsoleServerTransport.
func (m *MicrosoftSerialConsoleServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MicrosoftSerialConsoleClient.DisableConsole":
		resp, err = m.dispatchDisableConsole(req)
	case "MicrosoftSerialConsoleClient.EnableConsole":
		resp, err = m.dispatchEnableConsole(req)
	case "MicrosoftSerialConsoleClient.GetConsoleStatus":
		resp, err = m.dispatchGetConsoleStatus(req)
	case "MicrosoftSerialConsoleClient.ListOperations":
		resp, err = m.dispatchListOperations(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MicrosoftSerialConsoleServerTransport) dispatchDisableConsole(req *http.Request) (*http.Response, error) {
	if m.srv.DisableConsole == nil {
		return nil, &nonRetriableError{errors.New("fake for method DisableConsole not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/consoleServices/(?P<default>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disableConsole`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	defaultParamParam, err := url.PathUnescape(matches[regex.SubexpIndex("default")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.DisableConsole(req.Context(), defaultParamParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MicrosoftSerialConsoleServerTransport) dispatchEnableConsole(req *http.Request) (*http.Response, error) {
	if m.srv.EnableConsole == nil {
		return nil, &nonRetriableError{errors.New("fake for method EnableConsole not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/consoleServices/(?P<default>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enableConsole`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	defaultParamParam, err := url.PathUnescape(matches[regex.SubexpIndex("default")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.EnableConsole(req.Context(), defaultParamParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MicrosoftSerialConsoleServerTransport) dispatchGetConsoleStatus(req *http.Request) (*http.Response, error) {
	if m.srv.GetConsoleStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetConsoleStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/consoleServices/(?P<default>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	defaultParamParam, err := url.PathUnescape(matches[regex.SubexpIndex("default")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetConsoleStatus(req.Context(), defaultParamParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MicrosoftSerialConsoleServerTransport) dispatchListOperations(req *http.Request) (*http.Response, error) {
	if m.srv.ListOperations == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListOperations not implemented")}
	}
	respr, errRespr := m.srv.ListOperations(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Operations, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
