//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedLedgerDigestUploadsServer is a fake server for instances of the armsql.ManagedLedgerDigestUploadsClient type.
type ManagedLedgerDigestUploadsServer struct {
	// BeginCreateOrUpdate is the fake for method ManagedLedgerDigestUploadsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ledgerDigestUploads armsql.ManagedLedgerDigestUploadsName, parameters armsql.ManagedLedgerDigestUploads, options *armsql.ManagedLedgerDigestUploadsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.ManagedLedgerDigestUploadsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDisable is the fake for method ManagedLedgerDigestUploadsClient.BeginDisable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDisable func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ledgerDigestUploads armsql.ManagedLedgerDigestUploadsName, options *armsql.ManagedLedgerDigestUploadsClientBeginDisableOptions) (resp azfake.PollerResponder[armsql.ManagedLedgerDigestUploadsClientDisableResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedLedgerDigestUploadsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ledgerDigestUploads armsql.ManagedLedgerDigestUploadsName, options *armsql.ManagedLedgerDigestUploadsClientGetOptions) (resp azfake.Responder[armsql.ManagedLedgerDigestUploadsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method ManagedLedgerDigestUploadsClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(resourceGroupName string, managedInstanceName string, databaseName string, options *armsql.ManagedLedgerDigestUploadsClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.ManagedLedgerDigestUploadsClientListByDatabaseResponse])
}

// NewManagedLedgerDigestUploadsServerTransport creates a new instance of ManagedLedgerDigestUploadsServerTransport with the provided implementation.
// The returned ManagedLedgerDigestUploadsServerTransport instance is connected to an instance of armsql.ManagedLedgerDigestUploadsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedLedgerDigestUploadsServerTransport(srv *ManagedLedgerDigestUploadsServer) *ManagedLedgerDigestUploadsServerTransport {
	return &ManagedLedgerDigestUploadsServerTransport{
		srv:                    srv,
		beginCreateOrUpdate:    newTracker[azfake.PollerResponder[armsql.ManagedLedgerDigestUploadsClientCreateOrUpdateResponse]](),
		beginDisable:           newTracker[azfake.PollerResponder[armsql.ManagedLedgerDigestUploadsClientDisableResponse]](),
		newListByDatabasePager: newTracker[azfake.PagerResponder[armsql.ManagedLedgerDigestUploadsClientListByDatabaseResponse]](),
	}
}

// ManagedLedgerDigestUploadsServerTransport connects instances of armsql.ManagedLedgerDigestUploadsClient to instances of ManagedLedgerDigestUploadsServer.
// Don't use this type directly, use NewManagedLedgerDigestUploadsServerTransport instead.
type ManagedLedgerDigestUploadsServerTransport struct {
	srv                    *ManagedLedgerDigestUploadsServer
	beginCreateOrUpdate    *tracker[azfake.PollerResponder[armsql.ManagedLedgerDigestUploadsClientCreateOrUpdateResponse]]
	beginDisable           *tracker[azfake.PollerResponder[armsql.ManagedLedgerDigestUploadsClientDisableResponse]]
	newListByDatabasePager *tracker[azfake.PagerResponder[armsql.ManagedLedgerDigestUploadsClientListByDatabaseResponse]]
}

// Do implements the policy.Transporter interface for ManagedLedgerDigestUploadsServerTransport.
func (m *ManagedLedgerDigestUploadsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedLedgerDigestUploadsClient.BeginCreateOrUpdate":
		resp, err = m.dispatchBeginCreateOrUpdate(req)
	case "ManagedLedgerDigestUploadsClient.BeginDisable":
		resp, err = m.dispatchBeginDisable(req)
	case "ManagedLedgerDigestUploadsClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedLedgerDigestUploadsClient.NewListByDatabasePager":
		resp, err = m.dispatchNewListByDatabasePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedLedgerDigestUploadsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := m.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads/(?P<ledgerDigestUploads>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ManagedLedgerDigestUploads](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		ledgerDigestUploadsParam, err := parseWithCast(matches[regex.SubexpIndex("ledgerDigestUploads")], func(v string) (armsql.ManagedLedgerDigestUploadsName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.ManagedLedgerDigestUploadsName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, ledgerDigestUploadsParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		m.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		m.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (m *ManagedLedgerDigestUploadsServerTransport) dispatchBeginDisable(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDisable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisable not implemented")}
	}
	beginDisable := m.beginDisable.get(req)
	if beginDisable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads/(?P<ledgerDigestUploads>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disable`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		ledgerDigestUploadsParam, err := parseWithCast(matches[regex.SubexpIndex("ledgerDigestUploads")], func(v string) (armsql.ManagedLedgerDigestUploadsName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.ManagedLedgerDigestUploadsName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDisable(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, ledgerDigestUploadsParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisable = &respr
		m.beginDisable.add(req, beginDisable)
	}

	resp, err := server.PollerResponderNext(beginDisable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginDisable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisable) {
		m.beginDisable.remove(req)
	}

	return resp, nil
}

func (m *ManagedLedgerDigestUploadsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads/(?P<ledgerDigestUploads>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	ledgerDigestUploadsParam, err := parseWithCast(matches[regex.SubexpIndex("ledgerDigestUploads")], func(v string) (armsql.ManagedLedgerDigestUploadsName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.ManagedLedgerDigestUploadsName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, ledgerDigestUploadsParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedLedgerDigestUploads, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedLedgerDigestUploadsServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := m.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ledgerDigestUploads`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByDatabasePager(resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, nil)
		newListByDatabasePager = &resp
		m.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.ManagedLedgerDigestUploadsClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		m.newListByDatabasePager.remove(req)
	}
	return resp, nil
}
