//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SyncMembersServer is a fake server for instances of the armsql.SyncMembersClient type.
type SyncMembersServer struct {
	// BeginCreateOrUpdate is the fake for method SyncMembersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters armsql.SyncMember, options *armsql.SyncMembersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.SyncMembersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SyncMembersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, options *armsql.SyncMembersClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.SyncMembersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SyncMembersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, options *armsql.SyncMembersClientGetOptions) (resp azfake.Responder[armsql.SyncMembersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySyncGroupPager is the fake for method SyncMembersClient.NewListBySyncGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySyncGroupPager func(resourceGroupName string, serverName string, databaseName string, syncGroupName string, options *armsql.SyncMembersClientListBySyncGroupOptions) (resp azfake.PagerResponder[armsql.SyncMembersClientListBySyncGroupResponse])

	// NewListMemberSchemasPager is the fake for method SyncMembersClient.NewListMemberSchemasPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMemberSchemasPager func(resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, options *armsql.SyncMembersClientListMemberSchemasOptions) (resp azfake.PagerResponder[armsql.SyncMembersClientListMemberSchemasResponse])

	// BeginRefreshMemberSchema is the fake for method SyncMembersClient.BeginRefreshMemberSchema
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRefreshMemberSchema func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, options *armsql.SyncMembersClientBeginRefreshMemberSchemaOptions) (resp azfake.PollerResponder[armsql.SyncMembersClientRefreshMemberSchemaResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method SyncMembersClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters armsql.SyncMember, options *armsql.SyncMembersClientBeginUpdateOptions) (resp azfake.PollerResponder[armsql.SyncMembersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSyncMembersServerTransport creates a new instance of SyncMembersServerTransport with the provided implementation.
// The returned SyncMembersServerTransport instance is connected to an instance of armsql.SyncMembersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSyncMembersServerTransport(srv *SyncMembersServer) *SyncMembersServerTransport {
	return &SyncMembersServerTransport{
		srv:                       srv,
		beginCreateOrUpdate:       newTracker[azfake.PollerResponder[armsql.SyncMembersClientCreateOrUpdateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armsql.SyncMembersClientDeleteResponse]](),
		newListBySyncGroupPager:   newTracker[azfake.PagerResponder[armsql.SyncMembersClientListBySyncGroupResponse]](),
		newListMemberSchemasPager: newTracker[azfake.PagerResponder[armsql.SyncMembersClientListMemberSchemasResponse]](),
		beginRefreshMemberSchema:  newTracker[azfake.PollerResponder[armsql.SyncMembersClientRefreshMemberSchemaResponse]](),
		beginUpdate:               newTracker[azfake.PollerResponder[armsql.SyncMembersClientUpdateResponse]](),
	}
}

// SyncMembersServerTransport connects instances of armsql.SyncMembersClient to instances of SyncMembersServer.
// Don't use this type directly, use NewSyncMembersServerTransport instead.
type SyncMembersServerTransport struct {
	srv                       *SyncMembersServer
	beginCreateOrUpdate       *tracker[azfake.PollerResponder[armsql.SyncMembersClientCreateOrUpdateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armsql.SyncMembersClientDeleteResponse]]
	newListBySyncGroupPager   *tracker[azfake.PagerResponder[armsql.SyncMembersClientListBySyncGroupResponse]]
	newListMemberSchemasPager *tracker[azfake.PagerResponder[armsql.SyncMembersClientListMemberSchemasResponse]]
	beginRefreshMemberSchema  *tracker[azfake.PollerResponder[armsql.SyncMembersClientRefreshMemberSchemaResponse]]
	beginUpdate               *tracker[azfake.PollerResponder[armsql.SyncMembersClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for SyncMembersServerTransport.
func (s *SyncMembersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SyncMembersClient.BeginCreateOrUpdate":
		resp, err = s.dispatchBeginCreateOrUpdate(req)
	case "SyncMembersClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SyncMembersClient.Get":
		resp, err = s.dispatchGet(req)
	case "SyncMembersClient.NewListBySyncGroupPager":
		resp, err = s.dispatchNewListBySyncGroupPager(req)
	case "SyncMembersClient.NewListMemberSchemasPager":
		resp, err = s.dispatchNewListMemberSchemasPager(req)
	case "SyncMembersClient.BeginRefreshMemberSchema":
		resp, err = s.dispatchBeginRefreshMemberSchema(req)
	case "SyncMembersClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SyncMembersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := s.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncMembers/(?P<syncMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.SyncMember](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		syncMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncMemberName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, syncGroupNameParam, syncMemberNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		s.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		s.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (s *SyncMembersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncMembers/(?P<syncMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		syncMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncMemberName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, syncGroupNameParam, syncMemberNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SyncMembersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncMembers/(?P<syncMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
	if err != nil {
		return nil, err
	}
	syncMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncMemberName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, syncGroupNameParam, syncMemberNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SyncMember, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SyncMembersServerTransport) dispatchNewListBySyncGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySyncGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySyncGroupPager not implemented")}
	}
	newListBySyncGroupPager := s.newListBySyncGroupPager.get(req)
	if newListBySyncGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncMembers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListBySyncGroupPager(resourceGroupNameParam, serverNameParam, databaseNameParam, syncGroupNameParam, nil)
		newListBySyncGroupPager = &resp
		s.newListBySyncGroupPager.add(req, newListBySyncGroupPager)
		server.PagerResponderInjectNextLinks(newListBySyncGroupPager, req, func(page *armsql.SyncMembersClientListBySyncGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySyncGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySyncGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySyncGroupPager) {
		s.newListBySyncGroupPager.remove(req)
	}
	return resp, nil
}

func (s *SyncMembersServerTransport) dispatchNewListMemberSchemasPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListMemberSchemasPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMemberSchemasPager not implemented")}
	}
	newListMemberSchemasPager := s.newListMemberSchemasPager.get(req)
	if newListMemberSchemasPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncMembers/(?P<syncMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/schemas`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		syncMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncMemberName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListMemberSchemasPager(resourceGroupNameParam, serverNameParam, databaseNameParam, syncGroupNameParam, syncMemberNameParam, nil)
		newListMemberSchemasPager = &resp
		s.newListMemberSchemasPager.add(req, newListMemberSchemasPager)
		server.PagerResponderInjectNextLinks(newListMemberSchemasPager, req, func(page *armsql.SyncMembersClientListMemberSchemasResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListMemberSchemasPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListMemberSchemasPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMemberSchemasPager) {
		s.newListMemberSchemasPager.remove(req)
	}
	return resp, nil
}

func (s *SyncMembersServerTransport) dispatchBeginRefreshMemberSchema(req *http.Request) (*http.Response, error) {
	if s.srv.BeginRefreshMemberSchema == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRefreshMemberSchema not implemented")}
	}
	beginRefreshMemberSchema := s.beginRefreshMemberSchema.get(req)
	if beginRefreshMemberSchema == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncMembers/(?P<syncMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refreshSchema`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		syncMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncMemberName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginRefreshMemberSchema(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, syncGroupNameParam, syncMemberNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRefreshMemberSchema = &respr
		s.beginRefreshMemberSchema.add(req, beginRefreshMemberSchema)
	}

	resp, err := server.PollerResponderNext(beginRefreshMemberSchema, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginRefreshMemberSchema.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRefreshMemberSchema) {
		s.beginRefreshMemberSchema.remove(req)
	}

	return resp, nil
}

func (s *SyncMembersServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncMembers/(?P<syncMemberName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.SyncMember](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		syncMemberNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncMemberName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, syncGroupNameParam, syncMemberNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
