//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// WorkloadClassifiersServer is a fake server for instances of the armsql.WorkloadClassifiersClient type.
type WorkloadClassifiersServer struct {
	// BeginCreateOrUpdate is the fake for method WorkloadClassifiersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string, parameters armsql.WorkloadClassifier, options *armsql.WorkloadClassifiersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.WorkloadClassifiersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method WorkloadClassifiersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string, options *armsql.WorkloadClassifiersClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.WorkloadClassifiersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method WorkloadClassifiersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string, options *armsql.WorkloadClassifiersClientGetOptions) (resp azfake.Responder[armsql.WorkloadClassifiersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByWorkloadGroupPager is the fake for method WorkloadClassifiersClient.NewListByWorkloadGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByWorkloadGroupPager func(resourceGroupName string, serverName string, databaseName string, workloadGroupName string, options *armsql.WorkloadClassifiersClientListByWorkloadGroupOptions) (resp azfake.PagerResponder[armsql.WorkloadClassifiersClientListByWorkloadGroupResponse])
}

// NewWorkloadClassifiersServerTransport creates a new instance of WorkloadClassifiersServerTransport with the provided implementation.
// The returned WorkloadClassifiersServerTransport instance is connected to an instance of armsql.WorkloadClassifiersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkloadClassifiersServerTransport(srv *WorkloadClassifiersServer) *WorkloadClassifiersServerTransport {
	return &WorkloadClassifiersServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armsql.WorkloadClassifiersClientCreateOrUpdateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armsql.WorkloadClassifiersClientDeleteResponse]](),
		newListByWorkloadGroupPager: newTracker[azfake.PagerResponder[armsql.WorkloadClassifiersClientListByWorkloadGroupResponse]](),
	}
}

// WorkloadClassifiersServerTransport connects instances of armsql.WorkloadClassifiersClient to instances of WorkloadClassifiersServer.
// Don't use this type directly, use NewWorkloadClassifiersServerTransport instead.
type WorkloadClassifiersServerTransport struct {
	srv                         *WorkloadClassifiersServer
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armsql.WorkloadClassifiersClientCreateOrUpdateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armsql.WorkloadClassifiersClientDeleteResponse]]
	newListByWorkloadGroupPager *tracker[azfake.PagerResponder[armsql.WorkloadClassifiersClientListByWorkloadGroupResponse]]
}

// Do implements the policy.Transporter interface for WorkloadClassifiersServerTransport.
func (w *WorkloadClassifiersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkloadClassifiersClient.BeginCreateOrUpdate":
		resp, err = w.dispatchBeginCreateOrUpdate(req)
	case "WorkloadClassifiersClient.BeginDelete":
		resp, err = w.dispatchBeginDelete(req)
	case "WorkloadClassifiersClient.Get":
		resp, err = w.dispatchGet(req)
	case "WorkloadClassifiersClient.NewListByWorkloadGroupPager":
		resp, err = w.dispatchNewListByWorkloadGroupPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkloadClassifiersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := w.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadGroups/(?P<workloadGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadClassifiers/(?P<workloadClassifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.WorkloadClassifier](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		workloadGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workloadGroupName")])
		if err != nil {
			return nil, err
		}
		workloadClassifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workloadClassifierName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, workloadGroupNameParam, workloadClassifierNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		w.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		w.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		w.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (w *WorkloadClassifiersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := w.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadGroups/(?P<workloadGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadClassifiers/(?P<workloadClassifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		workloadGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workloadGroupName")])
		if err != nil {
			return nil, err
		}
		workloadClassifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workloadClassifierName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDelete(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, workloadGroupNameParam, workloadClassifierNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		w.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		w.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		w.beginDelete.remove(req)
	}

	return resp, nil
}

func (w *WorkloadClassifiersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadGroups/(?P<workloadGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadClassifiers/(?P<workloadClassifierName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	workloadGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workloadGroupName")])
	if err != nil {
		return nil, err
	}
	workloadClassifierNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workloadClassifierName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, workloadGroupNameParam, workloadClassifierNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkloadClassifier, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkloadClassifiersServerTransport) dispatchNewListByWorkloadGroupPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListByWorkloadGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByWorkloadGroupPager not implemented")}
	}
	newListByWorkloadGroupPager := w.newListByWorkloadGroupPager.get(req)
	if newListByWorkloadGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadGroups/(?P<workloadGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/workloadClassifiers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		workloadGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workloadGroupName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListByWorkloadGroupPager(resourceGroupNameParam, serverNameParam, databaseNameParam, workloadGroupNameParam, nil)
		newListByWorkloadGroupPager = &resp
		w.newListByWorkloadGroupPager.add(req, newListByWorkloadGroupPager)
		server.PagerResponderInjectNextLinks(newListByWorkloadGroupPager, req, func(page *armsql.WorkloadClassifiersClientListByWorkloadGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByWorkloadGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListByWorkloadGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByWorkloadGroupPager) {
		w.newListByWorkloadGroupPager.remove(req)
	}
	return resp, nil
}
