//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstandbypool

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// StandbyContainerGroupPoolsClient contains the methods for the StandbyContainerGroupPools group.
// Don't use this type directly, use NewStandbyContainerGroupPoolsClient() instead.
type StandbyContainerGroupPoolsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewStandbyContainerGroupPoolsClient creates a new instance of StandbyContainerGroupPoolsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewStandbyContainerGroupPoolsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*StandbyContainerGroupPoolsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &StandbyContainerGroupPoolsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Create a StandbyContainerGroupPoolResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - standbyContainerGroupPoolName - Name of the standby container group pool
//   - resource - Resource create parameters.
//   - options - StandbyContainerGroupPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the StandbyContainerGroupPoolsClient.BeginCreateOrUpdate
//     method.
func (client *StandbyContainerGroupPoolsClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, resource StandbyContainerGroupPoolResource, options *StandbyContainerGroupPoolsClientBeginCreateOrUpdateOptions) (*runtime.Poller[StandbyContainerGroupPoolsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, standbyContainerGroupPoolName, resource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StandbyContainerGroupPoolsClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StandbyContainerGroupPoolsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Create a StandbyContainerGroupPoolResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
func (client *StandbyContainerGroupPoolsClient) createOrUpdate(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, resource StandbyContainerGroupPoolResource, options *StandbyContainerGroupPoolsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "StandbyContainerGroupPoolsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, standbyContainerGroupPoolName, resource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *StandbyContainerGroupPoolsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, resource StandbyContainerGroupPoolResource, options *StandbyContainerGroupPoolsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyContainerGroupPools/{standbyContainerGroupPoolName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if standbyContainerGroupPoolName == "" {
		return nil, errors.New("parameter standbyContainerGroupPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{standbyContainerGroupPoolName}", url.PathEscape(standbyContainerGroupPoolName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete a StandbyContainerGroupPoolResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - standbyContainerGroupPoolName - Name of the standby container group pool
//   - options - StandbyContainerGroupPoolsClientBeginDeleteOptions contains the optional parameters for the StandbyContainerGroupPoolsClient.BeginDelete
//     method.
func (client *StandbyContainerGroupPoolsClient) BeginDelete(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, options *StandbyContainerGroupPoolsClientBeginDeleteOptions) (*runtime.Poller[StandbyContainerGroupPoolsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, standbyContainerGroupPoolName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[StandbyContainerGroupPoolsClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[StandbyContainerGroupPoolsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete a StandbyContainerGroupPoolResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
func (client *StandbyContainerGroupPoolsClient) deleteOperation(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, options *StandbyContainerGroupPoolsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "StandbyContainerGroupPoolsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, standbyContainerGroupPoolName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *StandbyContainerGroupPoolsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, options *StandbyContainerGroupPoolsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyContainerGroupPools/{standbyContainerGroupPoolName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if standbyContainerGroupPoolName == "" {
		return nil, errors.New("parameter standbyContainerGroupPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{standbyContainerGroupPoolName}", url.PathEscape(standbyContainerGroupPoolName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a StandbyContainerGroupPoolResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - standbyContainerGroupPoolName - Name of the standby container group pool
//   - options - StandbyContainerGroupPoolsClientGetOptions contains the optional parameters for the StandbyContainerGroupPoolsClient.Get
//     method.
func (client *StandbyContainerGroupPoolsClient) Get(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, options *StandbyContainerGroupPoolsClientGetOptions) (StandbyContainerGroupPoolsClientGetResponse, error) {
	var err error
	const operationName = "StandbyContainerGroupPoolsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, standbyContainerGroupPoolName, options)
	if err != nil {
		return StandbyContainerGroupPoolsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StandbyContainerGroupPoolsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StandbyContainerGroupPoolsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *StandbyContainerGroupPoolsClient) getCreateRequest(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, options *StandbyContainerGroupPoolsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyContainerGroupPools/{standbyContainerGroupPoolName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if standbyContainerGroupPoolName == "" {
		return nil, errors.New("parameter standbyContainerGroupPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{standbyContainerGroupPoolName}", url.PathEscape(standbyContainerGroupPoolName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *StandbyContainerGroupPoolsClient) getHandleResponse(resp *http.Response) (StandbyContainerGroupPoolsClientGetResponse, error) {
	result := StandbyContainerGroupPoolsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StandbyContainerGroupPoolResource); err != nil {
		return StandbyContainerGroupPoolsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List StandbyContainerGroupPoolResource resources by resource group
//
// Generated from API version 2023-12-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - StandbyContainerGroupPoolsClientListByResourceGroupOptions contains the optional parameters for the StandbyContainerGroupPoolsClient.NewListByResourceGroupPager
//     method.
func (client *StandbyContainerGroupPoolsClient) NewListByResourceGroupPager(resourceGroupName string, options *StandbyContainerGroupPoolsClientListByResourceGroupOptions) *runtime.Pager[StandbyContainerGroupPoolsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[StandbyContainerGroupPoolsClientListByResourceGroupResponse]{
		More: func(page StandbyContainerGroupPoolsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StandbyContainerGroupPoolsClientListByResourceGroupResponse) (StandbyContainerGroupPoolsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StandbyContainerGroupPoolsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return StandbyContainerGroupPoolsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *StandbyContainerGroupPoolsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *StandbyContainerGroupPoolsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyContainerGroupPools"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *StandbyContainerGroupPoolsClient) listByResourceGroupHandleResponse(resp *http.Response) (StandbyContainerGroupPoolsClientListByResourceGroupResponse, error) {
	result := StandbyContainerGroupPoolsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StandbyContainerGroupPoolResourceListResult); err != nil {
		return StandbyContainerGroupPoolsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List StandbyContainerGroupPoolResource resources by subscription ID
//
// Generated from API version 2023-12-01-preview
//   - options - StandbyContainerGroupPoolsClientListBySubscriptionOptions contains the optional parameters for the StandbyContainerGroupPoolsClient.NewListBySubscriptionPager
//     method.
func (client *StandbyContainerGroupPoolsClient) NewListBySubscriptionPager(options *StandbyContainerGroupPoolsClientListBySubscriptionOptions) *runtime.Pager[StandbyContainerGroupPoolsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[StandbyContainerGroupPoolsClientListBySubscriptionResponse]{
		More: func(page StandbyContainerGroupPoolsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StandbyContainerGroupPoolsClientListBySubscriptionResponse) (StandbyContainerGroupPoolsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StandbyContainerGroupPoolsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return StandbyContainerGroupPoolsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *StandbyContainerGroupPoolsClient) listBySubscriptionCreateRequest(ctx context.Context, options *StandbyContainerGroupPoolsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.StandbyPool/standbyContainerGroupPools"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *StandbyContainerGroupPoolsClient) listBySubscriptionHandleResponse(resp *http.Response) (StandbyContainerGroupPoolsClientListBySubscriptionResponse, error) {
	result := StandbyContainerGroupPoolsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StandbyContainerGroupPoolResourceListResult); err != nil {
		return StandbyContainerGroupPoolsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Update - Update a StandbyContainerGroupPoolResource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-12-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - standbyContainerGroupPoolName - Name of the standby container group pool
//   - properties - The resource properties to be updated.
//   - options - StandbyContainerGroupPoolsClientUpdateOptions contains the optional parameters for the StandbyContainerGroupPoolsClient.Update
//     method.
func (client *StandbyContainerGroupPoolsClient) Update(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, properties StandbyContainerGroupPoolResourceUpdate, options *StandbyContainerGroupPoolsClientUpdateOptions) (StandbyContainerGroupPoolsClientUpdateResponse, error) {
	var err error
	const operationName = "StandbyContainerGroupPoolsClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, standbyContainerGroupPoolName, properties, options)
	if err != nil {
		return StandbyContainerGroupPoolsClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return StandbyContainerGroupPoolsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return StandbyContainerGroupPoolsClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *StandbyContainerGroupPoolsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, standbyContainerGroupPoolName string, properties StandbyContainerGroupPoolResourceUpdate, options *StandbyContainerGroupPoolsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyContainerGroupPools/{standbyContainerGroupPoolName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if standbyContainerGroupPoolName == "" {
		return nil, errors.New("parameter standbyContainerGroupPoolName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{standbyContainerGroupPoolName}", url.PathEscape(standbyContainerGroupPoolName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *StandbyContainerGroupPoolsClient) updateHandleResponse(resp *http.Response) (StandbyContainerGroupPoolsClientUpdateResponse, error) {
	result := StandbyContainerGroupPoolsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StandbyContainerGroupPoolResource); err != nil {
		return StandbyContainerGroupPoolsClientUpdateResponse{}, err
	}
	return result, nil
}
