//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armstoragecache.ClientFactory type.
type ServerFactory struct {
	AmlFilesystemsServer AmlFilesystemsServer
	AscOperationsServer  AscOperationsServer
	AscUsagesServer      AscUsagesServer
	CachesServer         CachesServer
	ManagementServer     ManagementServer
	OperationsServer     OperationsServer
	SKUsServer           SKUsServer
	StorageTargetServer  StorageTargetServer
	StorageTargetsServer StorageTargetsServer
	UsageModelsServer    UsageModelsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armstoragecache.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armstoragecache.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                    *ServerFactory
	trMu                   sync.Mutex
	trAmlFilesystemsServer *AmlFilesystemsServerTransport
	trAscOperationsServer  *AscOperationsServerTransport
	trAscUsagesServer      *AscUsagesServerTransport
	trCachesServer         *CachesServerTransport
	trManagementServer     *ManagementServerTransport
	trOperationsServer     *OperationsServerTransport
	trSKUsServer           *SKUsServerTransport
	trStorageTargetServer  *StorageTargetServerTransport
	trStorageTargetsServer *StorageTargetsServerTransport
	trUsageModelsServer    *UsageModelsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AmlFilesystemsClient":
		initServer(s, &s.trAmlFilesystemsServer, func() *AmlFilesystemsServerTransport {
			return NewAmlFilesystemsServerTransport(&s.srv.AmlFilesystemsServer)
		})
		resp, err = s.trAmlFilesystemsServer.Do(req)
	case "AscOperationsClient":
		initServer(s, &s.trAscOperationsServer, func() *AscOperationsServerTransport {
			return NewAscOperationsServerTransport(&s.srv.AscOperationsServer)
		})
		resp, err = s.trAscOperationsServer.Do(req)
	case "AscUsagesClient":
		initServer(s, &s.trAscUsagesServer, func() *AscUsagesServerTransport { return NewAscUsagesServerTransport(&s.srv.AscUsagesServer) })
		resp, err = s.trAscUsagesServer.Do(req)
	case "CachesClient":
		initServer(s, &s.trCachesServer, func() *CachesServerTransport { return NewCachesServerTransport(&s.srv.CachesServer) })
		resp, err = s.trCachesServer.Do(req)
	case "ManagementClient":
		initServer(s, &s.trManagementServer, func() *ManagementServerTransport { return NewManagementServerTransport(&s.srv.ManagementServer) })
		resp, err = s.trManagementServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "SKUsClient":
		initServer(s, &s.trSKUsServer, func() *SKUsServerTransport { return NewSKUsServerTransport(&s.srv.SKUsServer) })
		resp, err = s.trSKUsServer.Do(req)
	case "StorageTargetClient":
		initServer(s, &s.trStorageTargetServer, func() *StorageTargetServerTransport {
			return NewStorageTargetServerTransport(&s.srv.StorageTargetServer)
		})
		resp, err = s.trStorageTargetServer.Do(req)
	case "StorageTargetsClient":
		initServer(s, &s.trStorageTargetsServer, func() *StorageTargetsServerTransport {
			return NewStorageTargetsServerTransport(&s.srv.StorageTargetsServer)
		})
		resp, err = s.trStorageTargetsServer.Do(req)
	case "UsageModelsClient":
		initServer(s, &s.trUsageModelsServer, func() *UsageModelsServerTransport { return NewUsageModelsServerTransport(&s.srv.UsageModelsServer) })
		resp, err = s.trUsageModelsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
