//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FileSharesClient contains the methods for the FileShares group.
// Don't use this type directly, use NewFileSharesClient() instead.
type FileSharesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFileSharesClient creates a new instance of FileSharesClient with the specified values.
//   - subscriptionID - The subscription id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFileSharesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FileSharesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FileSharesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates or updates the file share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-10-01
//   - deviceName - The device name.
//   - fileServerName - The file server name.
//   - shareName - The file share name.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - fileShare - The file share.
//   - options - FileSharesClientBeginCreateOrUpdateOptions contains the optional parameters for the FileSharesClient.BeginCreateOrUpdate
//     method.
func (client *FileSharesClient) BeginCreateOrUpdate(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, fileShare FileShare, options *FileSharesClientBeginCreateOrUpdateOptions) (*runtime.Poller[FileSharesClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, deviceName, fileServerName, shareName, resourceGroupName, managerName, fileShare, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[FileSharesClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[FileSharesClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Creates or updates the file share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-10-01
func (client *FileSharesClient) createOrUpdate(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, fileShare FileShare, options *FileSharesClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "FileSharesClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, deviceName, fileServerName, shareName, resourceGroupName, managerName, fileShare, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *FileSharesClient) createOrUpdateCreateRequest(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, fileShare FileShare, options *FileSharesClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/shares/{shareName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, fileShare); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes the file share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-10-01
//   - deviceName - The device name.
//   - fileServerName - The file server name.
//   - shareName - The file share Name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - FileSharesClientBeginDeleteOptions contains the optional parameters for the FileSharesClient.BeginDelete method.
func (client *FileSharesClient) BeginDelete(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientBeginDeleteOptions) (*runtime.Poller[FileSharesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, fileServerName, shareName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[FileSharesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[FileSharesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes the file share.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-10-01
func (client *FileSharesClient) deleteOperation(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "FileSharesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, deviceName, fileServerName, shareName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *FileSharesClient) deleteCreateRequest(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/shares/{shareName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns the properties of the specified file share name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-10-01
//   - deviceName - The device name.
//   - fileServerName - The file server name.
//   - shareName - The file share name.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - FileSharesClientGetOptions contains the optional parameters for the FileSharesClient.Get method.
func (client *FileSharesClient) Get(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientGetOptions) (FileSharesClientGetResponse, error) {
	var err error
	const operationName = "FileSharesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, deviceName, fileServerName, shareName, resourceGroupName, managerName, options)
	if err != nil {
		return FileSharesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileSharesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileSharesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *FileSharesClient) getCreateRequest(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/shares/{shareName}"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FileSharesClient) getHandleResponse(resp *http.Response) (FileSharesClientGetResponse, error) {
	result := FileSharesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileShare); err != nil {
		return FileSharesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDevicePager - Retrieves all the file shares in a device.
//
// Generated from API version 2016-10-01
//   - deviceName - The device name.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - FileSharesClientListByDeviceOptions contains the optional parameters for the FileSharesClient.NewListByDevicePager
//     method.
func (client *FileSharesClient) NewListByDevicePager(deviceName string, resourceGroupName string, managerName string, options *FileSharesClientListByDeviceOptions) *runtime.Pager[FileSharesClientListByDeviceResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileSharesClientListByDeviceResponse]{
		More: func(page FileSharesClientListByDeviceResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileSharesClientListByDeviceResponse) (FileSharesClientListByDeviceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FileSharesClient.NewListByDevicePager")
			req, err := client.listByDeviceCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return FileSharesClientListByDeviceResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return FileSharesClientListByDeviceResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileSharesClientListByDeviceResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDeviceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByDeviceCreateRequest creates the ListByDevice request.
func (client *FileSharesClient) listByDeviceCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *FileSharesClientListByDeviceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/shares"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDeviceHandleResponse handles the ListByDevice response.
func (client *FileSharesClient) listByDeviceHandleResponse(resp *http.Response) (FileSharesClientListByDeviceResponse, error) {
	result := FileSharesClientListByDeviceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileShareList); err != nil {
		return FileSharesClientListByDeviceResponse{}, err
	}
	return result, nil
}

// NewListByFileServerPager - Retrieves all the file shares in a file server.
//
// Generated from API version 2016-10-01
//   - deviceName - The device name.
//   - fileServerName - The file server name.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - FileSharesClientListByFileServerOptions contains the optional parameters for the FileSharesClient.NewListByFileServerPager
//     method.
func (client *FileSharesClient) NewListByFileServerPager(deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileSharesClientListByFileServerOptions) *runtime.Pager[FileSharesClientListByFileServerResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileSharesClientListByFileServerResponse]{
		More: func(page FileSharesClientListByFileServerResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileSharesClientListByFileServerResponse) (FileSharesClientListByFileServerResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FileSharesClient.NewListByFileServerPager")
			req, err := client.listByFileServerCreateRequest(ctx, deviceName, fileServerName, resourceGroupName, managerName, options)
			if err != nil {
				return FileSharesClientListByFileServerResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return FileSharesClientListByFileServerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileSharesClientListByFileServerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByFileServerHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByFileServerCreateRequest creates the ListByFileServer request.
func (client *FileSharesClient) listByFileServerCreateRequest(ctx context.Context, deviceName string, fileServerName string, resourceGroupName string, managerName string, options *FileSharesClientListByFileServerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/shares"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByFileServerHandleResponse handles the ListByFileServer response.
func (client *FileSharesClient) listByFileServerHandleResponse(resp *http.Response) (FileSharesClientListByFileServerResponse, error) {
	result := FileSharesClientListByFileServerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileShareList); err != nil {
		return FileSharesClientListByFileServerResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Retrieves metric definitions of all metrics aggregated at the file share.
//
// Generated from API version 2016-10-01
//   - deviceName - The device name.
//   - fileServerName - The file server name.
//   - shareName - The file share name.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - FileSharesClientListMetricDefinitionOptions contains the optional parameters for the FileSharesClient.NewListMetricDefinitionPager
//     method.
func (client *FileSharesClient) NewListMetricDefinitionPager(deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientListMetricDefinitionOptions) *runtime.Pager[FileSharesClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileSharesClientListMetricDefinitionResponse]{
		More: func(page FileSharesClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileSharesClientListMetricDefinitionResponse) (FileSharesClientListMetricDefinitionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FileSharesClient.NewListMetricDefinitionPager")
			req, err := client.listMetricDefinitionCreateRequest(ctx, deviceName, fileServerName, shareName, resourceGroupName, managerName, options)
			if err != nil {
				return FileSharesClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return FileSharesClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileSharesClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *FileSharesClient) listMetricDefinitionCreateRequest(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/shares/{shareName}/metricsDefinitions"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *FileSharesClient) listMetricDefinitionHandleResponse(resp *http.Response) (FileSharesClientListMetricDefinitionResponse, error) {
	result := FileSharesClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return FileSharesClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Gets the file share metrics
//
// Generated from API version 2016-10-01
//   - deviceName - The device name.
//   - fileServerName - The file server name.
//   - shareName - The file share name.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - FileSharesClientListMetricsOptions contains the optional parameters for the FileSharesClient.NewListMetricsPager
//     method.
func (client *FileSharesClient) NewListMetricsPager(deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientListMetricsOptions) *runtime.Pager[FileSharesClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[FileSharesClientListMetricsResponse]{
		More: func(page FileSharesClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *FileSharesClientListMetricsResponse) (FileSharesClientListMetricsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FileSharesClient.NewListMetricsPager")
			req, err := client.listMetricsCreateRequest(ctx, deviceName, fileServerName, shareName, resourceGroupName, managerName, options)
			if err != nil {
				return FileSharesClientListMetricsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return FileSharesClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FileSharesClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *FileSharesClient) listMetricsCreateRequest(ctx context.Context, deviceName string, fileServerName string, shareName string, resourceGroupName string, managerName string, options *FileSharesClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/fileservers/{fileServerName}/shares/{shareName}/metrics"
	if deviceName == "" {
		return nil, errors.New("parameter deviceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", url.PathEscape(deviceName))
	if fileServerName == "" {
		return nil, errors.New("parameter fileServerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileServerName}", url.PathEscape(fileServerName))
	if shareName == "" {
		return nil, errors.New("parameter shareName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{shareName}", url.PathEscape(shareName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *FileSharesClient) listMetricsHandleResponse(resp *http.Response) (FileSharesClientListMetricsResponse, error) {
	result := FileSharesClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return FileSharesClientListMetricsResponse{}, err
	}
	return result, nil
}
