//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewChatTranscriptsClient creates a new instance of ChatTranscriptsClient.
func (c *ClientFactory) NewChatTranscriptsClient() *ChatTranscriptsClient {
	return &ChatTranscriptsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewChatTranscriptsNoSubscriptionClient creates a new instance of ChatTranscriptsNoSubscriptionClient.
func (c *ClientFactory) NewChatTranscriptsNoSubscriptionClient() *ChatTranscriptsNoSubscriptionClient {
	return &ChatTranscriptsNoSubscriptionClient{
		internal: c.internal,
	}
}

// NewCommunicationsClient creates a new instance of CommunicationsClient.
func (c *ClientFactory) NewCommunicationsClient() *CommunicationsClient {
	return &CommunicationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCommunicationsNoSubscriptionClient creates a new instance of CommunicationsNoSubscriptionClient.
func (c *ClientFactory) NewCommunicationsNoSubscriptionClient() *CommunicationsNoSubscriptionClient {
	return &CommunicationsNoSubscriptionClient{
		internal: c.internal,
	}
}

// NewFileWorkspacesClient creates a new instance of FileWorkspacesClient.
func (c *ClientFactory) NewFileWorkspacesClient() *FileWorkspacesClient {
	return &FileWorkspacesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewFileWorkspacesNoSubscriptionClient creates a new instance of FileWorkspacesNoSubscriptionClient.
func (c *ClientFactory) NewFileWorkspacesNoSubscriptionClient() *FileWorkspacesNoSubscriptionClient {
	return &FileWorkspacesNoSubscriptionClient{
		internal: c.internal,
	}
}

// NewFilesClient creates a new instance of FilesClient.
func (c *ClientFactory) NewFilesClient() *FilesClient {
	return &FilesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewFilesNoSubscriptionClient creates a new instance of FilesNoSubscriptionClient.
func (c *ClientFactory) NewFilesNoSubscriptionClient() *FilesNoSubscriptionClient {
	return &FilesNoSubscriptionClient{
		internal: c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewProblemClassificationsClient creates a new instance of ProblemClassificationsClient.
func (c *ClientFactory) NewProblemClassificationsClient() *ProblemClassificationsClient {
	return &ProblemClassificationsClient{
		internal: c.internal,
	}
}

// NewServicesClient creates a new instance of ServicesClient.
func (c *ClientFactory) NewServicesClient() *ServicesClient {
	return &ServicesClient{
		internal: c.internal,
	}
}

// NewTicketsClient creates a new instance of TicketsClient.
func (c *ClientFactory) NewTicketsClient() *TicketsClient {
	return &TicketsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewTicketsNoSubscriptionClient creates a new instance of TicketsNoSubscriptionClient.
func (c *ClientFactory) NewTicketsNoSubscriptionClient() *TicketsNoSubscriptionClient {
	return &TicketsNoSubscriptionClient{
		internal: c.internal,
	}
}
