//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvirtualmachineimagebuilder

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/virtualmachineimagebuilder/armvirtualmachineimagebuilder"
	moduleVersion = "v2.2.0"
)

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// OnBuildError - Error handling behavior upon build failure
type OnBuildError string

const (
	OnBuildErrorAbort   OnBuildError = "abort"
	OnBuildErrorCleanup OnBuildError = "cleanup"
)

// PossibleOnBuildErrorValues returns the possible values for the OnBuildError const type.
func PossibleOnBuildErrorValues() []OnBuildError {
	return []OnBuildError{
		OnBuildErrorAbort,
		OnBuildErrorCleanup,
	}
}

// ProvisioningErrorCode - Error code of the provisioning failure
type ProvisioningErrorCode string

const (
	ProvisioningErrorCodeBadCustomizerType           ProvisioningErrorCode = "BadCustomizerType"
	ProvisioningErrorCodeBadDistributeType           ProvisioningErrorCode = "BadDistributeType"
	ProvisioningErrorCodeBadManagedImageSource       ProvisioningErrorCode = "BadManagedImageSource"
	ProvisioningErrorCodeBadPIRSource                ProvisioningErrorCode = "BadPIRSource"
	ProvisioningErrorCodeBadSharedImageDistribute    ProvisioningErrorCode = "BadSharedImageDistribute"
	ProvisioningErrorCodeBadSharedImageVersionSource ProvisioningErrorCode = "BadSharedImageVersionSource"
	ProvisioningErrorCodeBadSourceType               ProvisioningErrorCode = "BadSourceType"
	ProvisioningErrorCodeBadStagingResourceGroup     ProvisioningErrorCode = "BadStagingResourceGroup"
	ProvisioningErrorCodeBadValidatorType            ProvisioningErrorCode = "BadValidatorType"
	ProvisioningErrorCodeNoCustomizerScript          ProvisioningErrorCode = "NoCustomizerScript"
	ProvisioningErrorCodeNoValidatorScript           ProvisioningErrorCode = "NoValidatorScript"
	ProvisioningErrorCodeOther                       ProvisioningErrorCode = "Other"
	ProvisioningErrorCodeServerError                 ProvisioningErrorCode = "ServerError"
	ProvisioningErrorCodeUnsupportedCustomizerType   ProvisioningErrorCode = "UnsupportedCustomizerType"
	ProvisioningErrorCodeUnsupportedValidatorType    ProvisioningErrorCode = "UnsupportedValidatorType"
)

// PossibleProvisioningErrorCodeValues returns the possible values for the ProvisioningErrorCode const type.
func PossibleProvisioningErrorCodeValues() []ProvisioningErrorCode {
	return []ProvisioningErrorCode{
		ProvisioningErrorCodeBadCustomizerType,
		ProvisioningErrorCodeBadDistributeType,
		ProvisioningErrorCodeBadManagedImageSource,
		ProvisioningErrorCodeBadPIRSource,
		ProvisioningErrorCodeBadSharedImageDistribute,
		ProvisioningErrorCodeBadSharedImageVersionSource,
		ProvisioningErrorCodeBadSourceType,
		ProvisioningErrorCodeBadStagingResourceGroup,
		ProvisioningErrorCodeBadValidatorType,
		ProvisioningErrorCodeNoCustomizerScript,
		ProvisioningErrorCodeNoValidatorScript,
		ProvisioningErrorCodeOther,
		ProvisioningErrorCodeServerError,
		ProvisioningErrorCodeUnsupportedCustomizerType,
		ProvisioningErrorCodeUnsupportedValidatorType,
	}
}

// ProvisioningState - Provisioning state of the resource
type ProvisioningState string

const (
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateCreating  ProvisioningState = "Creating"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	ProvisioningStateUpdating  ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateCreating,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// ResourceIdentityType - The type of identity used for the image template. The type 'None' will remove any identities from
// the image template.
type ResourceIdentityType string

const (
	ResourceIdentityTypeNone         ResourceIdentityType = "None"
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns the possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{
		ResourceIdentityTypeNone,
		ResourceIdentityTypeUserAssigned,
	}
}

// RunState - State of the last run
type RunState string

const (
	RunStateCanceled           RunState = "Canceled"
	RunStateCanceling          RunState = "Canceling"
	RunStateFailed             RunState = "Failed"
	RunStatePartiallySucceeded RunState = "PartiallySucceeded"
	RunStateRunning            RunState = "Running"
	RunStateSucceeded          RunState = "Succeeded"
)

// PossibleRunStateValues returns the possible values for the RunState const type.
func PossibleRunStateValues() []RunState {
	return []RunState{
		RunStateCanceled,
		RunStateCanceling,
		RunStateFailed,
		RunStatePartiallySucceeded,
		RunStateRunning,
		RunStateSucceeded,
	}
}

// RunSubState - Sub-state of the last run
type RunSubState string

const (
	RunSubStateBuilding     RunSubState = "Building"
	RunSubStateCustomizing  RunSubState = "Customizing"
	RunSubStateDistributing RunSubState = "Distributing"
	RunSubStateOptimizing   RunSubState = "Optimizing"
	RunSubStateQueued       RunSubState = "Queued"
	RunSubStateValidating   RunSubState = "Validating"
)

// PossibleRunSubStateValues returns the possible values for the RunSubState const type.
func PossibleRunSubStateValues() []RunSubState {
	return []RunSubState{
		RunSubStateBuilding,
		RunSubStateCustomizing,
		RunSubStateDistributing,
		RunSubStateOptimizing,
		RunSubStateQueued,
		RunSubStateValidating,
	}
}

// SharedImageStorageAccountType - Specifies the storage account type to be used to store the Azure Compute Gallery image
// version in.
type SharedImageStorageAccountType string

const (
	SharedImageStorageAccountTypePremiumLRS  SharedImageStorageAccountType = "Premium_LRS"
	SharedImageStorageAccountTypeStandardLRS SharedImageStorageAccountType = "Standard_LRS"
	SharedImageStorageAccountTypeStandardZRS SharedImageStorageAccountType = "Standard_ZRS"
)

// PossibleSharedImageStorageAccountTypeValues returns the possible values for the SharedImageStorageAccountType const type.
func PossibleSharedImageStorageAccountTypeValues() []SharedImageStorageAccountType {
	return []SharedImageStorageAccountType{
		SharedImageStorageAccountTypePremiumLRS,
		SharedImageStorageAccountTypeStandardLRS,
		SharedImageStorageAccountTypeStandardZRS,
	}
}

// VMBootOptimizationState - Enabling this field will improve VM boot time by optimizing the final customized image output.
type VMBootOptimizationState string

const (
	VMBootOptimizationStateDisabled VMBootOptimizationState = "Disabled"
	VMBootOptimizationStateEnabled  VMBootOptimizationState = "Enabled"
)

// PossibleVMBootOptimizationStateValues returns the possible values for the VMBootOptimizationState const type.
func PossibleVMBootOptimizationStateValues() []VMBootOptimizationState {
	return []VMBootOptimizationState{
		VMBootOptimizationStateDisabled,
		VMBootOptimizationStateEnabled,
	}
}
