//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvoiceservices

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// NameAvailabilityClient contains the methods for the NameAvailability group.
// Don't use this type directly, use NewNameAvailabilityClient() instead.
type NameAvailabilityClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewNameAvailabilityClient creates a new instance of NameAvailabilityClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewNameAvailabilityClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*NameAvailabilityClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &NameAvailabilityClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CheckLocal - Check whether the resource name is available in the given region.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-31
//   - location - The location in which uniqueness will be verified.
//   - body - The check availability request body.
//   - options - NameAvailabilityClientCheckLocalOptions contains the optional parameters for the NameAvailabilityClient.CheckLocal
//     method.
func (client *NameAvailabilityClient) CheckLocal(ctx context.Context, location string, body CheckNameAvailabilityRequest, options *NameAvailabilityClientCheckLocalOptions) (NameAvailabilityClientCheckLocalResponse, error) {
	var err error
	const operationName = "NameAvailabilityClient.CheckLocal"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.checkLocalCreateRequest(ctx, location, body, options)
	if err != nil {
		return NameAvailabilityClientCheckLocalResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return NameAvailabilityClientCheckLocalResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return NameAvailabilityClientCheckLocalResponse{}, err
	}
	resp, err := client.checkLocalHandleResponse(httpResp)
	return resp, err
}

// checkLocalCreateRequest creates the CheckLocal request.
func (client *NameAvailabilityClient) checkLocalCreateRequest(ctx context.Context, location string, body CheckNameAvailabilityRequest, options *NameAvailabilityClientCheckLocalOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.VoiceServices/locations/{location}/checkNameAvailability"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-31")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// checkLocalHandleResponse handles the CheckLocal response.
func (client *NameAvailabilityClient) checkLocalHandleResponse(resp *http.Response) (NameAvailabilityClientCheckLocalResponse, error) {
	result := NameAvailabilityClientCheckLocalResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckNameAvailabilityResponse); err != nil {
		return NameAvailabilityClientCheckLocalResponse{}, err
	}
	return result, nil
}
