//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armworkloads

// ClientSAPAvailabilityZoneDetailsResponse contains the response from method Client.SAPAvailabilityZoneDetails.
type ClientSAPAvailabilityZoneDetailsResponse struct {
	// The list of supported availability zone pairs which are part of SAP HA deployment.
	SAPAvailabilityZoneDetailsResult
}

// ClientSAPDiskConfigurationsResponse contains the response from method Client.SAPDiskConfigurations.
type ClientSAPDiskConfigurationsResponse struct {
	// The list of disk configuration for vmSku which are part of SAP deployment.
	SAPDiskConfigurationsResult
}

// ClientSAPSizingRecommendationsResponse contains the response from method Client.SAPSizingRecommendations.
type ClientSAPSizingRecommendationsResponse struct {
	// The SAP sizing recommendation result.
	SAPSizingRecommendationResultClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClientSAPSizingRecommendationsResponse.
func (c *ClientSAPSizingRecommendationsResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalSAPSizingRecommendationResultClassification(data)
	if err != nil {
		return err
	}
	c.SAPSizingRecommendationResultClassification = res
	return nil
}

// ClientSAPSupportedSKUResponse contains the response from method Client.SAPSupportedSKU.
type ClientSAPSupportedSKUResponse struct {
	// The list of supported SKUs for different resources which are part of SAP deployment.
	SAPSupportedResourceSKUsResult
}

// MonitorsClientCreateResponse contains the response from method MonitorsClient.BeginCreate.
type MonitorsClientCreateResponse struct {
	// SAP monitor info on Azure (ARM properties and SAP monitor properties)
	Monitor
}

// MonitorsClientDeleteResponse contains the response from method MonitorsClient.BeginDelete.
type MonitorsClientDeleteResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// MonitorsClientGetResponse contains the response from method MonitorsClient.Get.
type MonitorsClientGetResponse struct {
	// SAP monitor info on Azure (ARM properties and SAP monitor properties)
	Monitor
}

// MonitorsClientListByResourceGroupResponse contains the response from method MonitorsClient.NewListByResourceGroupPager.
type MonitorsClientListByResourceGroupResponse struct {
	// The response from the List SAP monitors operation.
	MonitorListResult
}

// MonitorsClientListResponse contains the response from method MonitorsClient.NewListPager.
type MonitorsClientListResponse struct {
	// The response from the List SAP monitors operation.
	MonitorListResult
}

// MonitorsClientUpdateResponse contains the response from method MonitorsClient.Update.
type MonitorsClientUpdateResponse struct {
	// SAP monitor info on Azure (ARM properties and SAP monitor properties)
	Monitor
}

// OperationsClientListResponse contains the response from method OperationsClient.NewListPager.
type OperationsClientListResponse struct {
	// A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.
	OperationListResult
}

// ProviderInstancesClientCreateResponse contains the response from method ProviderInstancesClient.BeginCreate.
type ProviderInstancesClientCreateResponse struct {
	// A provider instance associated with SAP monitor.
	ProviderInstance
}

// ProviderInstancesClientDeleteResponse contains the response from method ProviderInstancesClient.BeginDelete.
type ProviderInstancesClientDeleteResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// ProviderInstancesClientGetResponse contains the response from method ProviderInstancesClient.Get.
type ProviderInstancesClientGetResponse struct {
	// A provider instance associated with SAP monitor.
	ProviderInstance
}

// ProviderInstancesClientListResponse contains the response from method ProviderInstancesClient.NewListPager.
type ProviderInstancesClientListResponse struct {
	// The response from the List provider instances operation.
	ProviderInstanceListResult
}

// SAPApplicationServerInstancesClientCreateResponse contains the response from method SAPApplicationServerInstancesClient.BeginCreate.
type SAPApplicationServerInstancesClientCreateResponse struct {
	// Define the SAP Application Server Instance resource.
	SAPApplicationServerInstance
}

// SAPApplicationServerInstancesClientDeleteResponse contains the response from method SAPApplicationServerInstancesClient.BeginDelete.
type SAPApplicationServerInstancesClientDeleteResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPApplicationServerInstancesClientGetResponse contains the response from method SAPApplicationServerInstancesClient.Get.
type SAPApplicationServerInstancesClientGetResponse struct {
	// Define the SAP Application Server Instance resource.
	SAPApplicationServerInstance
}

// SAPApplicationServerInstancesClientListResponse contains the response from method SAPApplicationServerInstancesClient.NewListPager.
type SAPApplicationServerInstancesClientListResponse struct {
	// Defines the collection of SAP Application Server Instance resources.
	SAPApplicationServerInstanceList
}

// SAPApplicationServerInstancesClientStartInstanceResponse contains the response from method SAPApplicationServerInstancesClient.BeginStartInstance.
type SAPApplicationServerInstancesClientStartInstanceResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPApplicationServerInstancesClientStopInstanceResponse contains the response from method SAPApplicationServerInstancesClient.BeginStopInstance.
type SAPApplicationServerInstancesClientStopInstanceResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPApplicationServerInstancesClientUpdateResponse contains the response from method SAPApplicationServerInstancesClient.BeginUpdate.
type SAPApplicationServerInstancesClientUpdateResponse struct {
	// Define the SAP Application Server Instance resource.
	SAPApplicationServerInstance
}

// SAPCentralInstancesClientCreateResponse contains the response from method SAPCentralInstancesClient.BeginCreate.
type SAPCentralInstancesClientCreateResponse struct {
	// Define the SAP Central Services Instance resource.
	SAPCentralServerInstance
}

// SAPCentralInstancesClientDeleteResponse contains the response from method SAPCentralInstancesClient.BeginDelete.
type SAPCentralInstancesClientDeleteResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPCentralInstancesClientGetResponse contains the response from method SAPCentralInstancesClient.Get.
type SAPCentralInstancesClientGetResponse struct {
	// Define the SAP Central Services Instance resource.
	SAPCentralServerInstance
}

// SAPCentralInstancesClientListResponse contains the response from method SAPCentralInstancesClient.NewListPager.
type SAPCentralInstancesClientListResponse struct {
	// Defines the collection of SAP Central Services Instance resources.
	SAPCentralInstanceList
}

// SAPCentralInstancesClientStartInstanceResponse contains the response from method SAPCentralInstancesClient.BeginStartInstance.
type SAPCentralInstancesClientStartInstanceResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPCentralInstancesClientStopInstanceResponse contains the response from method SAPCentralInstancesClient.BeginStopInstance.
type SAPCentralInstancesClientStopInstanceResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPCentralInstancesClientUpdateResponse contains the response from method SAPCentralInstancesClient.BeginUpdate.
type SAPCentralInstancesClientUpdateResponse struct {
	// Define the SAP Central Services Instance resource.
	SAPCentralServerInstance
}

// SAPDatabaseInstancesClientCreateResponse contains the response from method SAPDatabaseInstancesClient.BeginCreate.
type SAPDatabaseInstancesClientCreateResponse struct {
	// Define the Database resource.
	SAPDatabaseInstance
}

// SAPDatabaseInstancesClientDeleteResponse contains the response from method SAPDatabaseInstancesClient.BeginDelete.
type SAPDatabaseInstancesClientDeleteResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPDatabaseInstancesClientGetResponse contains the response from method SAPDatabaseInstancesClient.Get.
type SAPDatabaseInstancesClientGetResponse struct {
	// Define the Database resource.
	SAPDatabaseInstance
}

// SAPDatabaseInstancesClientListResponse contains the response from method SAPDatabaseInstancesClient.NewListPager.
type SAPDatabaseInstancesClientListResponse struct {
	// Defines the collection of SAP Database Instances.
	SAPDatabaseInstanceList
}

// SAPDatabaseInstancesClientStartInstanceResponse contains the response from method SAPDatabaseInstancesClient.BeginStartInstance.
type SAPDatabaseInstancesClientStartInstanceResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPDatabaseInstancesClientStopInstanceResponse contains the response from method SAPDatabaseInstancesClient.BeginStopInstance.
type SAPDatabaseInstancesClientStopInstanceResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPDatabaseInstancesClientUpdateResponse contains the response from method SAPDatabaseInstancesClient.BeginUpdate.
type SAPDatabaseInstancesClientUpdateResponse struct {
	// Define the Database resource.
	SAPDatabaseInstance
}

// SAPVirtualInstancesClientCreateResponse contains the response from method SAPVirtualInstancesClient.BeginCreate.
type SAPVirtualInstancesClientCreateResponse struct {
	// Define the Virtual Instance for SAP solutions resource.
	SAPVirtualInstance
}

// SAPVirtualInstancesClientDeleteResponse contains the response from method SAPVirtualInstancesClient.BeginDelete.
type SAPVirtualInstancesClientDeleteResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPVirtualInstancesClientGetResponse contains the response from method SAPVirtualInstancesClient.Get.
type SAPVirtualInstancesClientGetResponse struct {
	// Define the Virtual Instance for SAP solutions resource.
	SAPVirtualInstance
}

// SAPVirtualInstancesClientListByResourceGroupResponse contains the response from method SAPVirtualInstancesClient.NewListByResourceGroupPager.
type SAPVirtualInstancesClientListByResourceGroupResponse struct {
	// Defines the collection of Virtual Instance for SAP solutions resources.
	SAPVirtualInstanceList
}

// SAPVirtualInstancesClientListBySubscriptionResponse contains the response from method SAPVirtualInstancesClient.NewListBySubscriptionPager.
type SAPVirtualInstancesClientListBySubscriptionResponse struct {
	// Defines the collection of Virtual Instance for SAP solutions resources.
	SAPVirtualInstanceList
}

// SAPVirtualInstancesClientStartResponse contains the response from method SAPVirtualInstancesClient.BeginStart.
type SAPVirtualInstancesClientStartResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPVirtualInstancesClientStopResponse contains the response from method SAPVirtualInstancesClient.BeginStop.
type SAPVirtualInstancesClientStopResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// SAPVirtualInstancesClientUpdateResponse contains the response from method SAPVirtualInstancesClient.Update.
type SAPVirtualInstancesClientUpdateResponse struct {
	// Define the Virtual Instance for SAP solutions resource.
	SAPVirtualInstance
}

// SapLandscapeMonitorClientCreateResponse contains the response from method SapLandscapeMonitorClient.Create.
type SapLandscapeMonitorClientCreateResponse struct {
	// configuration associated with SAP Landscape Monitor Dashboard.
	SapLandscapeMonitor
}

// SapLandscapeMonitorClientDeleteResponse contains the response from method SapLandscapeMonitorClient.Delete.
type SapLandscapeMonitorClientDeleteResponse struct {
	// placeholder for future response values
}

// SapLandscapeMonitorClientGetResponse contains the response from method SapLandscapeMonitorClient.Get.
type SapLandscapeMonitorClientGetResponse struct {
	// configuration associated with SAP Landscape Monitor Dashboard.
	SapLandscapeMonitor
}

// SapLandscapeMonitorClientListResponse contains the response from method SapLandscapeMonitorClient.List.
type SapLandscapeMonitorClientListResponse struct {
	// The response from the List SAP Landscape Monitor Dashboard operation.
	SapLandscapeMonitorListResult
}

// SapLandscapeMonitorClientUpdateResponse contains the response from method SapLandscapeMonitorClient.Update.
type SapLandscapeMonitorClientUpdateResponse struct {
	// configuration associated with SAP Landscape Monitor Dashboard.
	SapLandscapeMonitor
}
