package action

// ./apiv3.sh > apiv3.go
var v3Paths map[string][]string = map[string][]string{
	"delete": {
		"app/installations/{installation_id}", "Delete an installation for the authenticated app",
		"app/installations/{installation_id}/suspended", "Unsuspend an app installation",
		"applications/{client_id}/grant", "Delete an app authorization",
		"applications/{client_id}/token", "Delete an app token",
		"enterprises/{enterprise}/code-security/configurations/{configuration_id}", "Delete a code security configuration for an enterprise",
		"gists/{gist_id}", "Delete a gist",
		"gists/{gist_id}/comments/{comment_id}", "Delete a gist comment",
		"gists/{gist_id}/star", "Unstar a gist",
		"installation/token", "Revoke an installation access token",
		"notifications/threads/{thread_id}", "Mark a thread as done",
		"notifications/threads/{thread_id}/subscription", "Delete a thread subscription",
		"orgs/{org}", "Delete an organization",
		"orgs/{org}/actions/hosted-runners/{hosted_runner_id}", "Delete a GitHub-hosted runner for an organization",
		"orgs/{org}/actions/permissions/repositories/{repository_id}", "Disable a selected repository for GitHub Actions in an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}", "Delete a self-hosted runner group from an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}", "Remove repository access to a self-hosted runner group in an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}", "Remove a self-hosted runner from a group for an organization",
		"orgs/{org}/actions/runners/{runner_id}", "Delete a self-hosted runner from an organization",
		"orgs/{org}/actions/runners/{runner_id}/labels", "Remove all custom labels from a self-hosted runner for an organization",
		"orgs/{org}/actions/runners/{runner_id}/labels/{label}", "Remove a custom label from a self-hosted runner for an organization",
		"orgs/{org}/actions/secrets/{secret_name}", "Delete an organization secret",
		"orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}", "Remove selected repository from an organization secret",
		"orgs/{org}/actions/variables/{name}", "Delete an organization variable",
		"orgs/{org}/actions/variables/{name}/repositories/{repository_id}", "Remove selected repository from an organization variable",
		"orgs/{org}/blocks/{username}", "Unblock a user from an organization",
		"orgs/{org}/code-security/configurations/detach", "Detach configurations from repositories",
		"orgs/{org}/code-security/configurations/{configuration_id}", "Delete a code security configuration",
		"orgs/{org}/codespaces/access/selected_users", "Remove users from Codespaces access for an organization",
		"orgs/{org}/codespaces/secrets/{secret_name}", "Delete an organization secret",
		"orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}", "Remove selected repository from an organization secret",
		"orgs/{org}/copilot/billing/selected_teams", "Remove teams from the Copilot subscription for an organization",
		"orgs/{org}/copilot/billing/selected_users", "Remove users from the Copilot subscription for an organization",
		"orgs/{org}/dependabot/secrets/{secret_name}", "Delete an organization secret",
		"orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}", "Remove selected repository from an organization secret",
		"orgs/{org}/hooks/{hook_id}", "Delete an organization webhook",
		"orgs/{org}/interaction-limits", "Remove interaction restrictions for an organization",
		"orgs/{org}/invitations/{invitation_id}", "Cancel an organization invitation",
		"orgs/{org}/members/{username}", "Remove an organization member",
		"orgs/{org}/members/{username}/codespaces/{codespace_name}", "Delete a codespace from the organization",
		"orgs/{org}/memberships/{username}", "Remove organization membership for a user",
		"orgs/{org}/migrations/{migration_id}/archive", "Delete an organization migration archive",
		"orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock", "Unlock an organization repository",
		"orgs/{org}/organization-roles/teams/{team_slug}", "Remove all organization roles for a team",
		"orgs/{org}/organization-roles/teams/{team_slug}/{role_id}", "Remove an organization role from a team",
		"orgs/{org}/organization-roles/users/{username}", "Remove all organization roles for a user",
		"orgs/{org}/organization-roles/users/{username}/{role_id}", "Remove an organization role from a user",
		"orgs/{org}/outside_collaborators/{username}", "Remove outside collaborator from an organization",
		"orgs/{org}/packages/{package_type}/{package_name}", "Delete a package for an organization",
		"orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}", "Delete package version for an organization",
		"orgs/{org}/private-registries/{secret_name}", "Delete a private registry for an organization",
		"orgs/{org}/properties/schema/{custom_property_name}", "Remove a custom property for an organization",
		"orgs/{org}/public_members/{username}", "Remove public organization membership for the authenticated user",
		"orgs/{org}/rulesets/{ruleset_id}", "Delete an organization repository ruleset",
		"orgs/{org}/security-managers/teams/{team_slug}", "Remove a security manager team",
		"orgs/{org}/settings/network-configurations/{network_configuration_id}", "Delete a hosted compute network configuration from an organization",
		"orgs/{org}/teams/{team_slug}", "Delete a team",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}", "Delete a discussion",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}", "Delete a discussion comment",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}", "Delete team discussion comment reaction",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}", "Delete team discussion reaction",
		"orgs/{org}/teams/{team_slug}/memberships/{username}", "Remove team membership for a user",
		"orgs/{org}/teams/{team_slug}/projects/{project_id}", "Remove a project from a team",
		"orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}", "Remove a repository from a team",
		"projects/columns/cards/{card_id}", "Delete a project card",
		"projects/columns/{column_id}", "Delete a project column",
		"projects/{project_id}", "Delete a project",
		"projects/{project_id}/collaborators/{username}", "Remove user as a collaborator",
		"repos/{owner}/{repo}", "Delete a repository",
		"repos/{owner}/{repo}/actions/artifacts/{artifact_id}", "Delete an artifact",
		"repos/{owner}/{repo}/actions/caches", "Delete GitHub Actions caches for a repository (using a cache key)",
		"repos/{owner}/{repo}/actions/caches/{cache_id}", "Delete a GitHub Actions cache for a repository (using a cache ID)",
		"repos/{owner}/{repo}/actions/runners/{runner_id}", "Delete a self-hosted runner from a repository",
		"repos/{owner}/{repo}/actions/runners/{runner_id}/labels", "Remove all custom labels from a self-hosted runner for a repository",
		"repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{label}", "Remove a custom label from a self-hosted runner for a repository",
		"repos/{owner}/{repo}/actions/runs/{run_id}", "Delete a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/logs", "Delete workflow run logs",
		"repos/{owner}/{repo}/actions/secrets/{secret_name}", "Delete a repository secret",
		"repos/{owner}/{repo}/actions/variables/{name}", "Delete a repository variable",
		"repos/{owner}/{repo}/autolinks/{autolink_id}", "Delete an autolink reference from a repository",
		"repos/{owner}/{repo}/automated-security-fixes", "Disable Dependabot security updates",
		"repos/{owner}/{repo}/branches/{branch}/protection", "Delete branch protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins", "Delete admin branch protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews", "Delete pull request review protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_signatures", "Delete commit signature protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks", "Remove status check protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts", "Remove status check contexts",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions", "Delete access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps", "Remove app access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams", "Remove team access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users", "Remove user access restrictions",
		"repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}", "Delete a code scanning analysis from a repository",
		"repos/{owner}/{repo}/code-scanning/codeql/databases/{language}", "Delete a CodeQL database",
		"repos/{owner}/{repo}/codespaces/secrets/{secret_name}", "Delete a repository secret",
		"repos/{owner}/{repo}/collaborators/{username}", "Remove a repository collaborator",
		"repos/{owner}/{repo}/comments/{comment_id}", "Delete a commit comment",
		"repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}", "Delete a commit comment reaction",
		"repos/{owner}/{repo}/contents/{path}", "Delete a file",
		"repos/{owner}/{repo}/dependabot/secrets/{secret_name}", "Delete a repository secret",
		"repos/{owner}/{repo}/deployments/{deployment_id}", "Delete a deployment",
		"repos/{owner}/{repo}/environments/{environment_name}", "Delete an environment",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}", "Delete a deployment branch policy",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}", "Disable a custom protection rule for an environment",
		"repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}", "Delete an environment secret",
		"repos/{owner}/{repo}/environments/{environment_name}/variables/{name}", "Delete an environment variable",
		"repos/{owner}/{repo}/git/refs/{ref}", "Delete a reference",
		"repos/{owner}/{repo}/hooks/{hook_id}", "Delete a repository webhook",
		"repos/{owner}/{repo}/import", "Cancel an import",
		"repos/{owner}/{repo}/interaction-limits", "Remove interaction restrictions for a repository",
		"repos/{owner}/{repo}/invitations/{invitation_id}", "Delete a repository invitation",
		"repos/{owner}/{repo}/issues/comments/{comment_id}", "Delete an issue comment",
		"repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}", "Delete an issue comment reaction",
		"repos/{owner}/{repo}/issues/{issue_number}/assignees", "Remove assignees from an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/labels", "Remove all labels from an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/labels/{label}", "Remove a label from an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/lock", "Unlock an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}", "Delete an issue reaction",
		"repos/{owner}/{repo}/issues/{issue_number}/sub_issue", "Remove sub-issue",
		"repos/{owner}/{repo}/keys/{key_id}", "Delete a deploy key",
		"repos/{owner}/{repo}/labels/{label}", "Delete a label",
		"repos/{owner}/{repo}/milestones/{milestone_number}", "Delete a milestone",
		"repos/{owner}/{repo}/pages", "Delete a GitHub Pages site",
		"repos/{owner}/{repo}/private-vulnerability-reporting", "Disable private vulnerability reporting for a repository",
		"repos/{owner}/{repo}/pulls/comments/{comment_id}", "Delete a review comment for a pull request",
		"repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}", "Delete a pull request comment reaction",
		"repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers", "Remove requested reviewers from a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}", "Delete a pending review for a pull request",
		"repos/{owner}/{repo}/releases/assets/{asset_id}", "Delete a release asset",
		"repos/{owner}/{repo}/releases/{release_id}", "Delete a release",
		"repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}", "Delete a release reaction",
		"repos/{owner}/{repo}/rulesets/{ruleset_id}", "Delete a repository ruleset",
		"repos/{owner}/{repo}/subscription", "Delete a repository subscription",
		"repos/{owner}/{repo}/tags/protection/{tag_protection_id}", "Closing down - Delete a tag protection state for a repository",
		"repos/{owner}/{repo}/vulnerability-alerts", "Disable vulnerability alerts",
		"teams/{team_id}", "Delete a team (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}", "Delete a discussion (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}", "Delete a discussion comment (Legacy)",
		"teams/{team_id}/members/{username}", "Remove team member (Legacy)",
		"teams/{team_id}/memberships/{username}", "Remove team membership for a user (Legacy)",
		"teams/{team_id}/projects/{project_id}", "Remove a project from a team (Legacy)",
		"teams/{team_id}/repos/{owner}/{repo}", "Remove a repository from a team (Legacy)",
		"user/blocks/{username}", "Unblock a user",
		"user/codespaces/secrets/{secret_name}", "Delete a secret for the authenticated user",
		"user/codespaces/secrets/{secret_name}/repositories/{repository_id}", "Remove a selected repository from a user secret",
		"user/codespaces/{codespace_name}", "Delete a codespace for the authenticated user",
		"user/emails", "Delete an email address for the authenticated user",
		"user/following/{username}", "Unfollow a user",
		"user/gpg_keys/{gpg_key_id}", "Delete a GPG key for the authenticated user",
		"user/installations/{installation_id}/repositories/{repository_id}", "Remove a repository from an app installation",
		"user/interaction-limits", "Remove interaction restrictions from your public repositories",
		"user/keys/{key_id}", "Delete a public SSH key for the authenticated user",
		"user/migrations/{migration_id}/archive", "Delete a user migration archive",
		"user/migrations/{migration_id}/repos/{repo_name}/lock", "Unlock a user repository",
		"user/packages/{package_type}/{package_name}", "Delete a package for the authenticated user",
		"user/packages/{package_type}/{package_name}/versions/{package_version_id}", "Delete a package version for the authenticated user",
		"user/repository_invitations/{invitation_id}", "Decline a repository invitation",
		"user/social_accounts", "Delete social accounts for the authenticated user",
		"user/ssh_signing_keys/{ssh_signing_key_id}", "Delete an SSH signing key for the authenticated user",
		"user/starred/{owner}/{repo}", "Unstar a repository for the authenticated user",
		"users/{username}/packages/{package_type}/{package_name}", "Delete a package for a user",
		"users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}", "Delete package version for a user",
	},
	"get": {
		"advisories", "List global security advisories",
		"advisories/{ghsa_id}", "Get a global security advisory",
		"app", "Get the authenticated app",
		"app/hook/config", "Get a webhook configuration for an app",
		"app/hook/deliveries", "List deliveries for an app webhook",
		"app/hook/deliveries/{delivery_id}", "Get a delivery for an app webhook",
		"app/installation-requests", "List installation requests for the authenticated app",
		"app/installations", "List installations for the authenticated app",
		"app/installations/{installation_id}", "Get an installation for the authenticated app",
		"apps/{app_slug}", "Get an app",
		"assignments/{assignment_id}", "Get an assignment",
		"assignments/{assignment_id}/accepted_assignments", "List accepted assignments for an assignment",
		"assignments/{assignment_id}/grades", "Get assignment grades",
		"classrooms", "List classrooms",
		"classrooms/{classroom_id}", "Get a classroom",
		"classrooms/{classroom_id}/assignments", "List assignments for a classroom",
		"codes_of_conduct", "Get all codes of conduct",
		"codes_of_conduct/{coc_key}", "Get a code of conduct",
		"emojis", "Get emojis",
		"enterprises/{enterprise}/code-security/configurations", "Get code security configurations for an enterprise",
		"enterprises/{enterprise}/code-security/configurations/defaults", "Get default code security configurations for an enterprise",
		"enterprises/{enterprise}/code-security/configurations/{configuration_id}", "Retrieve a code security configuration of an enterprise",
		"enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories", "Get repositories associated with an enterprise code security configuration",
		"enterprises/{enterprise}/dependabot/alerts", "List Dependabot alerts for an enterprise",
		"enterprises/{enterprise}/secret-scanning/alerts", "List secret scanning alerts for an enterprise",
		"events", "List public events",
		"feeds", "Get feeds",
		"gists", "List gists for the authenticated user",
		"gists/public", "List public gists",
		"gists/starred", "List starred gists",
		"gists/{gist_id}", "Get a gist",
		"gists/{gist_id}/comments", "List gist comments",
		"gists/{gist_id}/comments/{comment_id}", "Get a gist comment",
		"gists/{gist_id}/commits", "List gist commits",
		"gists/{gist_id}/forks", "List gist forks",
		"gists/{gist_id}/star", "Check if a gist is starred",
		"gists/{gist_id}/{sha}", "Get a gist revision",
		"gitignore/templates", "Get all gitignore templates",
		"gitignore/templates/{gitignore_name}", "Get a gitignore template",
		"installation/repositories", "List repositories accessible to the app installation",
		"issues", "List issues assigned to the authenticated user",
		"licenses", "Get all commonly used licenses",
		"licenses/{license}", "Get a license",
		"marketplace_listing/accounts/{account_id}", "Get a subscription plan for an account",
		"marketplace_listing/plans", "List plans",
		"marketplace_listing/plans/{plan_id}/accounts", "List accounts for a plan",
		"marketplace_listing/stubbed/accounts/{account_id}", "Get a subscription plan for an account (stubbed)",
		"marketplace_listing/stubbed/plans", "List plans (stubbed)",
		"marketplace_listing/stubbed/plans/{plan_id}/accounts", "List accounts for a plan (stubbed)",
		"meta", "Get GitHub meta information",
		"networks/{owner}/{repo}/events", "List public events for a network of repositories",
		"notifications", "List notifications for the authenticated user",
		"notifications/threads/{thread_id}", "Get a thread",
		"notifications/threads/{thread_id}/subscription", "Get a thread subscription for the authenticated user",
		"octocat", "Get Octocat",
		"organizations", "List organizations",
		"organizations/{org}/settings/billing/usage", "Get billing usage report for an organization",
		"orgs/{org}", "Get an organization",
		"orgs/{org}/actions/cache/usage", "Get GitHub Actions cache usage for an organization",
		"orgs/{org}/actions/cache/usage-by-repository", "List repositories with GitHub Actions cache usage for an organization",
		"orgs/{org}/actions/hosted-runners", "List GitHub-hosted runners for an organization",
		"orgs/{org}/actions/hosted-runners/images/github-owned", "Get GitHub-owned images for GitHub-hosted runners in an organization",
		"orgs/{org}/actions/hosted-runners/images/partner", "Get partner images for GitHub-hosted runners in an organization",
		"orgs/{org}/actions/hosted-runners/limits", "Get limits on GitHub-hosted runners for an organization",
		"orgs/{org}/actions/hosted-runners/machine-sizes", "Get GitHub-hosted runners machine specs for an organization",
		"orgs/{org}/actions/hosted-runners/platforms", "Get platforms for GitHub-hosted runners in an organization",
		"orgs/{org}/actions/hosted-runners/{hosted_runner_id}", "Get a GitHub-hosted runner for an organization",
		"orgs/{org}/actions/oidc/customization/sub", "Get the customization template for an OIDC subject claim for an organization",
		"orgs/{org}/actions/permissions", "Get GitHub Actions permissions for an organization",
		"orgs/{org}/actions/permissions/repositories", "List selected repositories enabled for GitHub Actions in an organization",
		"orgs/{org}/actions/permissions/selected-actions", "Get allowed actions and reusable workflows for an organization",
		"orgs/{org}/actions/permissions/workflow", "Get default workflow permissions for an organization",
		"orgs/{org}/actions/runner-groups", "List self-hosted runner groups for an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}", "Get a self-hosted runner group for an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners", "List GitHub-hosted runners in a group for an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/repositories", "List repository access to a self-hosted runner group in an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/runners", "List self-hosted runners in a group for an organization",
		"orgs/{org}/actions/runners", "List self-hosted runners for an organization",
		"orgs/{org}/actions/runners/downloads", "List runner applications for an organization",
		"orgs/{org}/actions/runners/{runner_id}", "Get a self-hosted runner for an organization",
		"orgs/{org}/actions/runners/{runner_id}/labels", "List labels for a self-hosted runner for an organization",
		"orgs/{org}/actions/secrets", "List organization secrets",
		"orgs/{org}/actions/secrets/public-key", "Get an organization public key",
		"orgs/{org}/actions/secrets/{secret_name}", "Get an organization secret",
		"orgs/{org}/actions/secrets/{secret_name}/repositories", "List selected repositories for an organization secret",
		"orgs/{org}/actions/variables", "List organization variables",
		"orgs/{org}/actions/variables/{name}", "Get an organization variable",
		"orgs/{org}/actions/variables/{name}/repositories", "List selected repositories for an organization variable",
		"orgs/{org}/attestations/{subject_digest}", "List attestations",
		"orgs/{org}/blocks", "List users blocked by an organization",
		"orgs/{org}/blocks/{username}", "Check if a user is blocked by an organization",
		"orgs/{org}/code-scanning/alerts", "List code scanning alerts for an organization",
		"orgs/{org}/code-security/configurations", "Get code security configurations for an organization",
		"orgs/{org}/code-security/configurations/defaults", "Get default code security configurations",
		"orgs/{org}/code-security/configurations/{configuration_id}", "Get a code security configuration",
		"orgs/{org}/code-security/configurations/{configuration_id}/repositories", "Get repositories associated with a code security configuration",
		"orgs/{org}/codespaces", "List codespaces for the organization",
		"orgs/{org}/codespaces/secrets", "List organization secrets",
		"orgs/{org}/codespaces/secrets/public-key", "Get an organization public key",
		"orgs/{org}/codespaces/secrets/{secret_name}", "Get an organization secret",
		"orgs/{org}/codespaces/secrets/{secret_name}/repositories", "List selected repositories for an organization secret",
		"orgs/{org}/copilot/billing", "Get Copilot seat information and settings for an organization",
		"orgs/{org}/copilot/billing/seats", "List all Copilot seat assignments for an organization",
		"orgs/{org}/copilot/metrics", "Get Copilot metrics for an organization",
		"orgs/{org}/copilot/usage", "Get a summary of Copilot usage for organization members",
		"orgs/{org}/dependabot/alerts", "List Dependabot alerts for an organization",
		"orgs/{org}/dependabot/secrets", "List organization secrets",
		"orgs/{org}/dependabot/secrets/public-key", "Get an organization public key",
		"orgs/{org}/dependabot/secrets/{secret_name}", "Get an organization secret",
		"orgs/{org}/dependabot/secrets/{secret_name}/repositories", "List selected repositories for an organization secret",
		"orgs/{org}/docker/conflicts", "Get list of conflicting packages during Docker migration for organization",
		"orgs/{org}/events", "List public organization events",
		"orgs/{org}/failed_invitations", "List failed organization invitations",
		"orgs/{org}/hooks", "List organization webhooks",
		"orgs/{org}/hooks/{hook_id}", "Get an organization webhook",
		"orgs/{org}/hooks/{hook_id}/config", "Get a webhook configuration for an organization",
		"orgs/{org}/hooks/{hook_id}/deliveries", "List deliveries for an organization webhook",
		"orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}", "Get a webhook delivery for an organization webhook",
		"orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}", "Get route stats by actor",
		"orgs/{org}/insights/api/subject-stats", "Get subject stats",
		"orgs/{org}/insights/api/summary-stats", "Get summary stats",
		"orgs/{org}/insights/api/summary-stats/users/{user_id}", "Get summary stats by user",
		"orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}", "Get summary stats by actor",
		"orgs/{org}/insights/api/time-stats", "Get time stats",
		"orgs/{org}/insights/api/time-stats/users/{user_id}", "Get time stats by user",
		"orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}", "Get time stats by actor",
		"orgs/{org}/insights/api/user-stats/{user_id}", "Get user stats",
		"orgs/{org}/installation", "Get an organization installation for the authenticated app",
		"orgs/{org}/installations", "List app installations for an organization",
		"orgs/{org}/interaction-limits", "Get interaction restrictions for an organization",
		"orgs/{org}/invitations", "List pending organization invitations",
		"orgs/{org}/invitations/{invitation_id}/teams", "List organization invitation teams",
		"orgs/{org}/issues", "List organization issues assigned to the authenticated user",
		"orgs/{org}/members", "List organization members",
		"orgs/{org}/members/{username}", "Check organization membership for a user",
		"orgs/{org}/members/{username}/codespaces", "List codespaces for a user in organization",
		"orgs/{org}/members/{username}/copilot", "Get Copilot seat assignment details for a user",
		"orgs/{org}/memberships/{username}", "Get organization membership for a user",
		"orgs/{org}/migrations", "List organization migrations",
		"orgs/{org}/migrations/{migration_id}", "Get an organization migration status",
		"orgs/{org}/migrations/{migration_id}/archive", "Download an organization migration archive",
		"orgs/{org}/migrations/{migration_id}/repositories", "List repositories in an organization migration",
		"orgs/{org}/organization-roles", "Get all organization roles for an organization",
		"orgs/{org}/organization-roles/{role_id}", "Get an organization role",
		"orgs/{org}/organization-roles/{role_id}/teams", "List teams that are assigned to an organization role",
		"orgs/{org}/organization-roles/{role_id}/users", "List users that are assigned to an organization role",
		"orgs/{org}/outside_collaborators", "List outside collaborators for an organization",
		"orgs/{org}/packages", "List packages for an organization",
		"orgs/{org}/packages/{package_type}/{package_name}", "Get a package for an organization",
		"orgs/{org}/packages/{package_type}/{package_name}/versions", "List package versions for a package owned by an organization",
		"orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}", "Get a package version for an organization",
		"orgs/{org}/personal-access-token-requests", "List requests to access organization resources with fine-grained personal access tokens",
		"orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories", "List repositories requested to be accessed by a fine-grained personal access token",
		"orgs/{org}/personal-access-tokens", "List fine-grained personal access tokens with access to organization resources",
		"orgs/{org}/personal-access-tokens/{pat_id}/repositories", "List repositories a fine-grained personal access token has access to",
		"orgs/{org}/private-registries", "List private registries for an organization",
		"orgs/{org}/private-registries/public-key", "Get private registries public key for an organization",
		"orgs/{org}/private-registries/{secret_name}", "Get a private registry for an organization",
		"orgs/{org}/projects", "List organization projects",
		"orgs/{org}/properties/schema", "Get all custom properties for an organization",
		"orgs/{org}/properties/schema/{custom_property_name}", "Get a custom property for an organization",
		"orgs/{org}/properties/values", "List custom property values for organization repositories",
		"orgs/{org}/public_members", "List public organization members",
		"orgs/{org}/public_members/{username}", "Check public organization membership for a user",
		"orgs/{org}/repos", "List organization repositories",
		"orgs/{org}/rulesets", "Get all organization repository rulesets",
		"orgs/{org}/rulesets/rule-suites", "List organization rule suites",
		"orgs/{org}/rulesets/rule-suites/{rule_suite_id}", "Get an organization rule suite",
		"orgs/{org}/rulesets/{ruleset_id}", "Get an organization repository ruleset",
		"orgs/{org}/secret-scanning/alerts", "List secret scanning alerts for an organization",
		"orgs/{org}/security-advisories", "List repository security advisories for an organization",
		"orgs/{org}/security-managers", "List security manager teams",
		"orgs/{org}/settings/billing/actions", "Get GitHub Actions billing for an organization",
		"orgs/{org}/settings/billing/packages", "Get GitHub Packages billing for an organization",
		"orgs/{org}/settings/billing/shared-storage", "Get shared storage billing for an organization",
		"orgs/{org}/settings/network-configurations", "List hosted compute network configurations for an organization",
		"orgs/{org}/settings/network-configurations/{network_configuration_id}", "Get a hosted compute network configuration for an organization",
		"orgs/{org}/settings/network-settings/{network_settings_id}", "Get a hosted compute network settings resource for an organization",
		"orgs/{org}/team/{team_slug}/copilot/metrics", "Get Copilot metrics for a team",
		"orgs/{org}/team/{team_slug}/copilot/usage", "Get a summary of Copilot usage for a team",
		"orgs/{org}/teams", "List teams",
		"orgs/{org}/teams/{team_slug}", "Get a team by name",
		"orgs/{org}/teams/{team_slug}/discussions", "List discussions",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}", "Get a discussion",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments", "List discussion comments",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}", "Get a discussion comment",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions", "List reactions for a team discussion comment",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions", "List reactions for a team discussion",
		"orgs/{org}/teams/{team_slug}/invitations", "List pending team invitations",
		"orgs/{org}/teams/{team_slug}/members", "List team members",
		"orgs/{org}/teams/{team_slug}/memberships/{username}", "Get team membership for a user",
		"orgs/{org}/teams/{team_slug}/projects", "List team projects",
		"orgs/{org}/teams/{team_slug}/projects/{project_id}", "Check team permissions for a project",
		"orgs/{org}/teams/{team_slug}/repos", "List team repositories",
		"orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}", "Check team permissions for a repository",
		"orgs/{org}/teams/{team_slug}/teams", "List child teams",
		"projects/columns/cards/{card_id}", "Get a project card",
		"projects/columns/{column_id}", "Get a project column",
		"projects/columns/{column_id}/cards", "List project cards",
		"projects/{project_id}", "Get a project",
		"projects/{project_id}/collaborators", "List project collaborators",
		"projects/{project_id}/collaborators/{username}/permission", "Get project permission for a user",
		"projects/{project_id}/columns", "List project columns",
		"rate_limit", "Get rate limit status for the authenticated user",
		"repos/{owner}/{repo}", "Get a repository",
		"repos/{owner}/{repo}/actions/artifacts", "List artifacts for a repository",
		"repos/{owner}/{repo}/actions/artifacts/{artifact_id}", "Get an artifact",
		"repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}", "Download an artifact",
		"repos/{owner}/{repo}/actions/cache/usage", "Get GitHub Actions cache usage for a repository",
		"repos/{owner}/{repo}/actions/caches", "List GitHub Actions caches for a repository",
		"repos/{owner}/{repo}/actions/jobs/{job_id}", "Get a job for a workflow run",
		"repos/{owner}/{repo}/actions/jobs/{job_id}/logs", "Download job logs for a workflow run",
		"repos/{owner}/{repo}/actions/oidc/customization/sub", "Get the customization template for an OIDC subject claim for a repository",
		"repos/{owner}/{repo}/actions/organization-secrets", "List repository organization secrets",
		"repos/{owner}/{repo}/actions/organization-variables", "List repository organization variables",
		"repos/{owner}/{repo}/actions/permissions", "Get GitHub Actions permissions for a repository",
		"repos/{owner}/{repo}/actions/permissions/access", "Get the level of access for workflows outside of the repository",
		"repos/{owner}/{repo}/actions/permissions/selected-actions", "Get allowed actions and reusable workflows for a repository",
		"repos/{owner}/{repo}/actions/permissions/workflow", "Get default workflow permissions for a repository",
		"repos/{owner}/{repo}/actions/runners", "List self-hosted runners for a repository",
		"repos/{owner}/{repo}/actions/runners/downloads", "List runner applications for a repository",
		"repos/{owner}/{repo}/actions/runners/{runner_id}", "Get a self-hosted runner for a repository",
		"repos/{owner}/{repo}/actions/runners/{runner_id}/labels", "List labels for a self-hosted runner for a repository",
		"repos/{owner}/{repo}/actions/runs", "List workflow runs for a repository",
		"repos/{owner}/{repo}/actions/runs/{run_id}", "Get a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/approvals", "Get the review history for a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/artifacts", "List workflow run artifacts",
		"repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}", "Get a workflow run attempt",
		"repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs", "List jobs for a workflow run attempt",
		"repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs", "Download workflow run attempt logs",
		"repos/{owner}/{repo}/actions/runs/{run_id}/jobs", "List jobs for a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/logs", "Download workflow run logs",
		"repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments", "Get pending deployments for a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/timing", "Get workflow run usage",
		"repos/{owner}/{repo}/actions/secrets", "List repository secrets",
		"repos/{owner}/{repo}/actions/secrets/public-key", "Get a repository public key",
		"repos/{owner}/{repo}/actions/secrets/{secret_name}", "Get a repository secret",
		"repos/{owner}/{repo}/actions/variables", "List repository variables",
		"repos/{owner}/{repo}/actions/variables/{name}", "Get a repository variable",
		"repos/{owner}/{repo}/actions/workflows", "List repository workflows",
		"repos/{owner}/{repo}/actions/workflows/{workflow_id}", "Get a workflow",
		"repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs", "List workflow runs for a workflow",
		"repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing", "Get workflow usage",
		"repos/{owner}/{repo}/activity", "List repository activities",
		"repos/{owner}/{repo}/assignees", "List assignees",
		"repos/{owner}/{repo}/assignees/{assignee}", "Check if a user can be assigned",
		"repos/{owner}/{repo}/attestations/{subject_digest}", "List attestations",
		"repos/{owner}/{repo}/autolinks", "Get all autolinks of a repository",
		"repos/{owner}/{repo}/autolinks/{autolink_id}", "Get an autolink reference of a repository",
		"repos/{owner}/{repo}/automated-security-fixes", "Check if Dependabot security updates are enabled for a repository",
		"repos/{owner}/{repo}/branches", "List branches",
		"repos/{owner}/{repo}/branches/{branch}", "Get a branch",
		"repos/{owner}/{repo}/branches/{branch}/protection", "Get branch protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins", "Get admin branch protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews", "Get pull request review protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_signatures", "Get commit signature protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks", "Get status checks protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts", "Get all status check contexts",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions", "Get access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps", "Get apps with access to the protected branch",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams", "Get teams with access to the protected branch",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users", "Get users with access to the protected branch",
		"repos/{owner}/{repo}/check-runs/{check_run_id}", "Get a check run",
		"repos/{owner}/{repo}/check-runs/{check_run_id}/annotations", "List check run annotations",
		"repos/{owner}/{repo}/check-suites/{check_suite_id}", "Get a check suite",
		"repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs", "List check runs in a check suite",
		"repos/{owner}/{repo}/code-scanning/alerts", "List code scanning alerts for a repository",
		"repos/{owner}/{repo}/code-scanning/alerts/{alert_number}", "Get a code scanning alert",
		"repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix", "Get the status of an autofix for a code scanning alert",
		"repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances", "List instances of a code scanning alert",
		"repos/{owner}/{repo}/code-scanning/analyses", "List code scanning analyses for a repository",
		"repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}", "Get a code scanning analysis for a repository",
		"repos/{owner}/{repo}/code-scanning/codeql/databases", "List CodeQL databases for a repository",
		"repos/{owner}/{repo}/code-scanning/codeql/databases/{language}", "Get a CodeQL database for a repository",
		"repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}", "Get the summary of a CodeQL variant analysis",
		"repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}", "Get the analysis status of a repository in a CodeQL variant analysis",
		"repos/{owner}/{repo}/code-scanning/default-setup", "Get a code scanning default setup configuration",
		"repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}", "Get information about a SARIF upload",
		"repos/{owner}/{repo}/code-security-configuration", "Get the code security configuration associated with a repository",
		"repos/{owner}/{repo}/codeowners/errors", "List CODEOWNERS errors",
		"repos/{owner}/{repo}/codespaces", "List codespaces in a repository for the authenticated user",
		"repos/{owner}/{repo}/codespaces/devcontainers", "List devcontainer configurations in a repository for the authenticated user",
		"repos/{owner}/{repo}/codespaces/machines", "List available machine types for a repository",
		"repos/{owner}/{repo}/codespaces/new", "Get default attributes for a codespace",
		"repos/{owner}/{repo}/codespaces/permissions_check", "Check if permissions defined by a devcontainer have been accepted by the authenticated user",
		"repos/{owner}/{repo}/codespaces/secrets", "List repository secrets",
		"repos/{owner}/{repo}/codespaces/secrets/public-key", "Get a repository public key",
		"repos/{owner}/{repo}/codespaces/secrets/{secret_name}", "Get a repository secret",
		"repos/{owner}/{repo}/collaborators", "List repository collaborators",
		"repos/{owner}/{repo}/collaborators/{username}", "Check if a user is a repository collaborator",
		"repos/{owner}/{repo}/collaborators/{username}/permission", "Get repository permissions for a user",
		"repos/{owner}/{repo}/comments", "List commit comments for a repository",
		"repos/{owner}/{repo}/comments/{comment_id}", "Get a commit comment",
		"repos/{owner}/{repo}/comments/{comment_id}/reactions", "List reactions for a commit comment",
		"repos/{owner}/{repo}/commits", "List commits",
		"repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head", "List branches for HEAD commit",
		"repos/{owner}/{repo}/commits/{commit_sha}/comments", "List commit comments",
		"repos/{owner}/{repo}/commits/{commit_sha}/pulls", "List pull requests associated with a commit",
		"repos/{owner}/{repo}/commits/{ref}", "Get a commit",
		"repos/{owner}/{repo}/commits/{ref}/check-runs", "List check runs for a Git reference",
		"repos/{owner}/{repo}/commits/{ref}/check-suites", "List check suites for a Git reference",
		"repos/{owner}/{repo}/commits/{ref}/status", "Get the combined status for a specific reference",
		"repos/{owner}/{repo}/commits/{ref}/statuses", "List commit statuses for a reference",
		"repos/{owner}/{repo}/community/profile", "Get community profile metrics",
		"repos/{owner}/{repo}/compare/{basehead}", "Compare two commits",
		"repos/{owner}/{repo}/contents/{path}", "Get repository content",
		"repos/{owner}/{repo}/contributors", "List repository contributors",
		"repos/{owner}/{repo}/dependabot/alerts", "List Dependabot alerts for a repository",
		"repos/{owner}/{repo}/dependabot/alerts/{alert_number}", "Get a Dependabot alert",
		"repos/{owner}/{repo}/dependabot/secrets", "List repository secrets",
		"repos/{owner}/{repo}/dependabot/secrets/public-key", "Get a repository public key",
		"repos/{owner}/{repo}/dependabot/secrets/{secret_name}", "Get a repository secret",
		"repos/{owner}/{repo}/dependency-graph/compare/{basehead}", "Get a diff of the dependencies between commits",
		"repos/{owner}/{repo}/dependency-graph/sbom", "Export a software bill of materials (SBOM) for a repository.",
		"repos/{owner}/{repo}/deployments", "List deployments",
		"repos/{owner}/{repo}/deployments/{deployment_id}", "Get a deployment",
		"repos/{owner}/{repo}/deployments/{deployment_id}/statuses", "List deployment statuses",
		"repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}", "Get a deployment status",
		"repos/{owner}/{repo}/environments", "List environments",
		"repos/{owner}/{repo}/environments/{environment_name}", "Get an environment",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies", "List deployment branch policies",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}", "Get a deployment branch policy",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules", "Get all deployment protection rules for an environment",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps", "List custom deployment rule integrations available for an environment",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}", "Get a custom deployment protection rule",
		"repos/{owner}/{repo}/environments/{environment_name}/secrets", "List environment secrets",
		"repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key", "Get an environment public key",
		"repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}", "Get an environment secret",
		"repos/{owner}/{repo}/environments/{environment_name}/variables", "List environment variables",
		"repos/{owner}/{repo}/environments/{environment_name}/variables/{name}", "Get an environment variable",
		"repos/{owner}/{repo}/events", "List repository events",
		"repos/{owner}/{repo}/forks", "List forks",
		"repos/{owner}/{repo}/git/blobs/{file_sha}", "Get a blob",
		"repos/{owner}/{repo}/git/commits/{commit_sha}", "Get a commit object",
		"repos/{owner}/{repo}/git/matching-refs/{ref}", "List matching references",
		"repos/{owner}/{repo}/git/ref/{ref}", "Get a reference",
		"repos/{owner}/{repo}/git/tags/{tag_sha}", "Get a tag",
		"repos/{owner}/{repo}/git/trees/{tree_sha}", "Get a tree",
		"repos/{owner}/{repo}/hooks", "List repository webhooks",
		"repos/{owner}/{repo}/hooks/{hook_id}", "Get a repository webhook",
		"repos/{owner}/{repo}/hooks/{hook_id}/config", "Get a webhook configuration for a repository",
		"repos/{owner}/{repo}/hooks/{hook_id}/deliveries", "List deliveries for a repository webhook",
		"repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}", "Get a delivery for a repository webhook",
		"repos/{owner}/{repo}/import", "Get an import status",
		"repos/{owner}/{repo}/import/authors", "Get commit authors",
		"repos/{owner}/{repo}/import/large_files", "Get large files",
		"repos/{owner}/{repo}/installation", "Get a repository installation for the authenticated app",
		"repos/{owner}/{repo}/interaction-limits", "Get interaction restrictions for a repository",
		"repos/{owner}/{repo}/invitations", "List repository invitations",
		"repos/{owner}/{repo}/issues", "List repository issues",
		"repos/{owner}/{repo}/issues/comments", "List issue comments for a repository",
		"repos/{owner}/{repo}/issues/comments/{comment_id}", "Get an issue comment",
		"repos/{owner}/{repo}/issues/comments/{comment_id}/reactions", "List reactions for an issue comment",
		"repos/{owner}/{repo}/issues/events", "List issue events for a repository",
		"repos/{owner}/{repo}/issues/events/{event_id}", "Get an issue event",
		"repos/{owner}/{repo}/issues/{issue_number}", "Get an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}", "Check if a user can be assigned to a issue",
		"repos/{owner}/{repo}/issues/{issue_number}/comments", "List issue comments",
		"repos/{owner}/{repo}/issues/{issue_number}/events", "List issue events",
		"repos/{owner}/{repo}/issues/{issue_number}/labels", "List labels for an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/reactions", "List reactions for an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/sub_issues", "List sub-issues",
		"repos/{owner}/{repo}/issues/{issue_number}/timeline", "List timeline events for an issue",
		"repos/{owner}/{repo}/keys", "List deploy keys",
		"repos/{owner}/{repo}/keys/{key_id}", "Get a deploy key",
		"repos/{owner}/{repo}/labels", "List labels for a repository",
		"repos/{owner}/{repo}/labels/{label}", "Get a label",
		"repos/{owner}/{repo}/languages", "List repository languages",
		"repos/{owner}/{repo}/license", "Get the license for a repository",
		"repos/{owner}/{repo}/milestones", "List milestones",
		"repos/{owner}/{repo}/milestones/{milestone_number}", "Get a milestone",
		"repos/{owner}/{repo}/milestones/{milestone_number}/labels", "List labels for issues in a milestone",
		"repos/{owner}/{repo}/notifications", "List repository notifications for the authenticated user",
		"repos/{owner}/{repo}/pages", "Get a GitHub Pages site",
		"repos/{owner}/{repo}/pages/builds", "List GitHub Pages builds",
		"repos/{owner}/{repo}/pages/builds/latest", "Get latest Pages build",
		"repos/{owner}/{repo}/pages/builds/{build_id}", "Get GitHub Pages build",
		"repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}", "Get the status of a GitHub Pages deployment",
		"repos/{owner}/{repo}/pages/health", "Get a DNS health check for GitHub Pages",
		"repos/{owner}/{repo}/private-vulnerability-reporting", "Check if private vulnerability reporting is enabled for a repository",
		"repos/{owner}/{repo}/projects", "List repository projects",
		"repos/{owner}/{repo}/properties/values", "Get all custom property values for a repository",
		"repos/{owner}/{repo}/pulls", "List pull requests",
		"repos/{owner}/{repo}/pulls/comments", "List review comments in a repository",
		"repos/{owner}/{repo}/pulls/comments/{comment_id}", "Get a review comment for a pull request",
		"repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions", "List reactions for a pull request review comment",
		"repos/{owner}/{repo}/pulls/{pull_number}", "Get a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/comments", "List review comments on a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/commits", "List commits on a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/files", "List pull requests files",
		"repos/{owner}/{repo}/pulls/{pull_number}/merge", "Check if a pull request has been merged",
		"repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers", "Get all requested reviewers for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews", "List reviews for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}", "Get a review for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments", "List comments for a pull request review",
		"repos/{owner}/{repo}/readme", "Get a repository README",
		"repos/{owner}/{repo}/readme/{dir}", "Get a repository README for a directory",
		"repos/{owner}/{repo}/releases", "List releases",
		"repos/{owner}/{repo}/releases/assets/{asset_id}", "Get a release asset",
		"repos/{owner}/{repo}/releases/latest", "Get the latest release",
		"repos/{owner}/{repo}/releases/tags/{tag}", "Get a release by tag name",
		"repos/{owner}/{repo}/releases/{release_id}", "Get a release",
		"repos/{owner}/{repo}/releases/{release_id}/assets", "List release assets",
		"repos/{owner}/{repo}/releases/{release_id}/reactions", "List reactions for a release",
		"repos/{owner}/{repo}/rules/branches/{branch}", "Get rules for a branch",
		"repos/{owner}/{repo}/rulesets", "Get all repository rulesets",
		"repos/{owner}/{repo}/rulesets/rule-suites", "List repository rule suites",
		"repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}", "Get a repository rule suite",
		"repos/{owner}/{repo}/rulesets/{ruleset_id}", "Get a repository ruleset",
		"repos/{owner}/{repo}/secret-scanning/alerts", "List secret scanning alerts for a repository",
		"repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}", "Get a secret scanning alert",
		"repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations", "List locations for a secret scanning alert",
		"repos/{owner}/{repo}/secret-scanning/scan-history", "Get secret scanning scan history for a repository",
		"repos/{owner}/{repo}/security-advisories", "List repository security advisories",
		"repos/{owner}/{repo}/security-advisories/{ghsa_id}", "Get a repository security advisory",
		"repos/{owner}/{repo}/stargazers", "List stargazers",
		"repos/{owner}/{repo}/stats/code_frequency", "Get the weekly commit activity",
		"repos/{owner}/{repo}/stats/commit_activity", "Get the last year of commit activity",
		"repos/{owner}/{repo}/stats/contributors", "Get all contributor commit activity",
		"repos/{owner}/{repo}/stats/participation", "Get the weekly commit count",
		"repos/{owner}/{repo}/stats/punch_card", "Get the hourly commit count for each day",
		"repos/{owner}/{repo}/subscribers", "List watchers",
		"repos/{owner}/{repo}/subscription", "Get a repository subscription",
		"repos/{owner}/{repo}/tags", "List repository tags",
		"repos/{owner}/{repo}/tags/protection", "Closing down - List tag protection states for a repository",
		"repos/{owner}/{repo}/tarball/{ref}", "Download a repository archive (tar)",
		"repos/{owner}/{repo}/teams", "List repository teams",
		"repos/{owner}/{repo}/topics", "Get all repository topics",
		"repos/{owner}/{repo}/traffic/clones", "Get repository clones",
		"repos/{owner}/{repo}/traffic/popular/paths", "Get top referral paths",
		"repos/{owner}/{repo}/traffic/popular/referrers", "Get top referral sources",
		"repos/{owner}/{repo}/traffic/views", "Get page views",
		"repos/{owner}/{repo}/vulnerability-alerts", "Check if vulnerability alerts are enabled for a repository",
		"repos/{owner}/{repo}/zipball/{ref}", "Download a repository archive (zip)",
		"repositories", "List public repositories",
		"search/code", "Search code",
		"search/commits", "Search commits",
		"search/issues", "Search issues and pull requests",
		"search/labels", "Search labels",
		"search/repositories", "Search repositories",
		"search/topics", "Search topics",
		"search/users", "Search users",
		"teams/{team_id}", "Get a team (Legacy)",
		"teams/{team_id}/discussions", "List discussions (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}", "Get a discussion (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/comments", "List discussion comments (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}", "Get a discussion comment (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions", "List reactions for a team discussion comment (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/reactions", "List reactions for a team discussion (Legacy)",
		"teams/{team_id}/invitations", "List pending team invitations (Legacy)",
		"teams/{team_id}/members", "List team members (Legacy)",
		"teams/{team_id}/members/{username}", "Get team member (Legacy)",
		"teams/{team_id}/memberships/{username}", "Get team membership for a user (Legacy)",
		"teams/{team_id}/projects", "List team projects (Legacy)",
		"teams/{team_id}/projects/{project_id}", "Check team permissions for a project (Legacy)",
		"teams/{team_id}/repos", "List team repositories (Legacy)",
		"teams/{team_id}/repos/{owner}/{repo}", "Check team permissions for a repository (Legacy)",
		"teams/{team_id}/teams", "List child teams (Legacy)",
		"user", "Get the authenticated user",
		"user/blocks", "List users blocked by the authenticated user",
		"user/blocks/{username}", "Check if a user is blocked by the authenticated user",
		"user/codespaces", "List codespaces for the authenticated user",
		"user/codespaces/secrets", "List secrets for the authenticated user",
		"user/codespaces/secrets/public-key", "Get public key for the authenticated user",
		"user/codespaces/secrets/{secret_name}", "Get a secret for the authenticated user",
		"user/codespaces/secrets/{secret_name}/repositories", "List selected repositories for a user secret",
		"user/codespaces/{codespace_name}", "Get a codespace for the authenticated user",
		"user/codespaces/{codespace_name}/exports/{export_id}", "Get details about a codespace export",
		"user/codespaces/{codespace_name}/machines", "List machine types for a codespace",
		"user/docker/conflicts", "Get list of conflicting packages during Docker migration for authenticated-user",
		"user/emails", "List email addresses for the authenticated user",
		"user/followers", "List followers of the authenticated user",
		"user/following", "List the people the authenticated user follows",
		"user/following/{username}", "Check if a person is followed by the authenticated user",
		"user/gpg_keys", "List GPG keys for the authenticated user",
		"user/gpg_keys/{gpg_key_id}", "Get a GPG key for the authenticated user",
		"user/installations", "List app installations accessible to the user access token",
		"user/installations/{installation_id}/repositories", "List repositories accessible to the user access token",
		"user/interaction-limits", "Get interaction restrictions for your public repositories",
		"user/issues", "List user account issues assigned to the authenticated user",
		"user/keys", "List public SSH keys for the authenticated user",
		"user/keys/{key_id}", "Get a public SSH key for the authenticated user",
		"user/marketplace_purchases", "List subscriptions for the authenticated user",
		"user/marketplace_purchases/stubbed", "List subscriptions for the authenticated user (stubbed)",
		"user/memberships/orgs", "List organization memberships for the authenticated user",
		"user/memberships/orgs/{org}", "Get an organization membership for the authenticated user",
		"user/migrations", "List user migrations",
		"user/migrations/{migration_id}", "Get a user migration status",
		"user/migrations/{migration_id}/archive", "Download a user migration archive",
		"user/migrations/{migration_id}/repositories", "List repositories for a user migration",
		"user/orgs", "List organizations for the authenticated user",
		"user/packages", "List packages for the authenticated user's namespace",
		"user/packages/{package_type}/{package_name}", "Get a package for the authenticated user",
		"user/packages/{package_type}/{package_name}/versions", "List package versions for a package owned by the authenticated user",
		"user/packages/{package_type}/{package_name}/versions/{package_version_id}", "Get a package version for the authenticated user",
		"user/public_emails", "List public email addresses for the authenticated user",
		"user/repos", "List repositories for the authenticated user",
		"user/repository_invitations", "List repository invitations for the authenticated user",
		"user/social_accounts", "List social accounts for the authenticated user",
		"user/ssh_signing_keys", "List SSH signing keys for the authenticated user",
		"user/ssh_signing_keys/{ssh_signing_key_id}", "Get an SSH signing key for the authenticated user",
		"user/starred", "List repositories starred by the authenticated user",
		"user/starred/{owner}/{repo}", "Check if a repository is starred by the authenticated user",
		"user/subscriptions", "List repositories watched by the authenticated user",
		"user/teams", "List teams for the authenticated user",
		"user/{account_id}", "Get a user using their ID",
		"users", "List users",
		"users/{username}", "Get a user",
		"users/{username}/attestations/{subject_digest}", "List attestations",
		"users/{username}/docker/conflicts", "Get list of conflicting packages during Docker migration for user",
		"users/{username}/events", "List events for the authenticated user",
		"users/{username}/events/orgs/{org}", "List organization events for the authenticated user",
		"users/{username}/events/public", "List public events for a user",
		"users/{username}/followers", "List followers of a user",
		"users/{username}/following", "List the people a user follows",
		"users/{username}/following/{target_user}", "Check if a user follows another user",
		"users/{username}/gists", "List gists for a user",
		"users/{username}/gpg_keys", "List GPG keys for a user",
		"users/{username}/hovercard", "Get contextual information for a user",
		"users/{username}/installation", "Get a user installation for the authenticated app",
		"users/{username}/keys", "List public keys for a user",
		"users/{username}/orgs", "List organizations for a user",
		"users/{username}/packages", "List packages for a user",
		"users/{username}/packages/{package_type}/{package_name}", "Get a package for a user",
		"users/{username}/packages/{package_type}/{package_name}/versions", "List package versions for a package owned by a user",
		"users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}", "Get a package version for a user",
		"users/{username}/projects", "List user projects",
		"users/{username}/received_events", "List events received by the authenticated user",
		"users/{username}/received_events/public", "List public events received by a user",
		"users/{username}/repos", "List repositories for a user",
		"users/{username}/settings/billing/actions", "Get GitHub Actions billing for a user",
		"users/{username}/settings/billing/packages", "Get GitHub Packages billing for a user",
		"users/{username}/settings/billing/shared-storage", "Get shared storage billing for a user",
		"users/{username}/social_accounts", "List social accounts for a user",
		"users/{username}/ssh_signing_keys", "List SSH signing keys for a user",
		"users/{username}/starred", "List repositories starred by a user",
		"users/{username}/subscriptions", "List repositories watched by a user",
		"versions", "Get all API versions",
		"zen", "Get the Zen of GitHub",
	},
	"patch": {
		"app/hook/config", "Update a webhook configuration for an app",
		"applications/{client_id}/token", "Reset a token",
		"enterprises/{enterprise}/code-security/configurations/{configuration_id}", "Update a custom code security configuration for an enterprise",
		"gists/{gist_id}", "Update a gist",
		"gists/{gist_id}/comments/{comment_id}", "Update a gist comment",
		"notifications/threads/{thread_id}", "Mark a thread as read",
		"orgs/{org}", "Update an organization",
		"orgs/{org}/actions/hosted-runners/{hosted_runner_id}", "Update a GitHub-hosted runner for an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}", "Update a self-hosted runner group for an organization",
		"orgs/{org}/actions/variables/{name}", "Update an organization variable",
		"orgs/{org}/code-security/configurations/{configuration_id}", "Update a code security configuration",
		"orgs/{org}/hooks/{hook_id}", "Update an organization webhook",
		"orgs/{org}/hooks/{hook_id}/config", "Update a webhook configuration for an organization",
		"orgs/{org}/private-registries/{secret_name}", "Update a private registry for an organization",
		"orgs/{org}/properties/schema", "Create or update custom properties for an organization",
		"orgs/{org}/properties/values", "Create or update custom property values for organization repositories",
		"orgs/{org}/settings/network-configurations/{network_configuration_id}", "Update a hosted compute network configuration for an organization",
		"orgs/{org}/teams/{team_slug}", "Update a team",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}", "Update a discussion",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}", "Update a discussion comment",
		"projects/columns/cards/{card_id}", "Update an existing project card",
		"projects/columns/{column_id}", "Update an existing project column",
		"projects/{project_id}", "Update a project",
		"repos/{owner}/{repo}", "Update a repository",
		"repos/{owner}/{repo}/actions/variables/{name}", "Update a repository variable",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews", "Update pull request review protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks", "Update status check protection",
		"repos/{owner}/{repo}/check-runs/{check_run_id}", "Update a check run",
		"repos/{owner}/{repo}/check-suites/preferences", "Update repository preferences for check suites",
		"repos/{owner}/{repo}/code-scanning/alerts/{alert_number}", "Update a code scanning alert",
		"repos/{owner}/{repo}/code-scanning/default-setup", "Update a code scanning default setup configuration",
		"repos/{owner}/{repo}/comments/{comment_id}", "Update a commit comment",
		"repos/{owner}/{repo}/dependabot/alerts/{alert_number}", "Update a Dependabot alert",
		"repos/{owner}/{repo}/environments/{environment_name}/variables/{name}", "Update an environment variable",
		"repos/{owner}/{repo}/git/refs/{ref}", "Update a reference",
		"repos/{owner}/{repo}/hooks/{hook_id}", "Update a repository webhook",
		"repos/{owner}/{repo}/hooks/{hook_id}/config", "Update a webhook configuration for a repository",
		"repos/{owner}/{repo}/import", "Update an import",
		"repos/{owner}/{repo}/import/authors/{author_id}", "Map a commit author",
		"repos/{owner}/{repo}/import/lfs", "Update Git LFS preference",
		"repos/{owner}/{repo}/invitations/{invitation_id}", "Update a repository invitation",
		"repos/{owner}/{repo}/issues/comments/{comment_id}", "Update an issue comment",
		"repos/{owner}/{repo}/issues/{issue_number}", "Update an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority", "Reprioritize sub-issue",
		"repos/{owner}/{repo}/labels/{label}", "Update a label",
		"repos/{owner}/{repo}/milestones/{milestone_number}", "Update a milestone",
		"repos/{owner}/{repo}/properties/values", "Create or update custom property values for a repository",
		"repos/{owner}/{repo}/pulls/comments/{comment_id}", "Update a review comment for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}", "Update a pull request",
		"repos/{owner}/{repo}/releases/assets/{asset_id}", "Update a release asset",
		"repos/{owner}/{repo}/releases/{release_id}", "Update a release",
		"repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}", "Update a secret scanning alert",
		"repos/{owner}/{repo}/security-advisories/{ghsa_id}", "Update a repository security advisory",
		"teams/{team_id}", "Update a team (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}", "Update a discussion (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}", "Update a discussion comment (Legacy)",
		"user", "Update the authenticated user",
		"user/codespaces/{codespace_name}", "Update a codespace for the authenticated user",
		"user/email/visibility", "Set primary email visibility for the authenticated user",
		"user/memberships/orgs/{org}", "Update an organization membership for the authenticated user",
		"user/repository_invitations/{invitation_id}", "Accept a repository invitation",
	},
	"post": {
		"app-manifests/{code}/conversions", "Create a GitHub App from a manifest",
		"app/hook/deliveries/{delivery_id}/attempts", "Redeliver a delivery for an app webhook",
		"app/installations/{installation_id}/access_tokens", "Create an installation access token for an app",
		"applications/{client_id}/token", "Check a token",
		"applications/{client_id}/token/scoped", "Create a scoped access token",
		"enterprises/{enterprise}/code-security/configurations", "Create a code security configuration for an enterprise",
		"enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach", "Attach an enterprise configuration to repositories",
		"gists", "Create a gist",
		"gists/{gist_id}/comments", "Create a gist comment",
		"gists/{gist_id}/forks", "Fork a gist",
		"markdown", "Render a Markdown document",
		"markdown/raw", "Render a Markdown document in raw mode",
		"orgs/{org}/actions/hosted-runners", "Create a GitHub-hosted runner for an organization",
		"orgs/{org}/actions/runner-groups", "Create a self-hosted runner group for an organization",
		"orgs/{org}/actions/runners/generate-jitconfig", "Create configuration for a just-in-time runner for an organization",
		"orgs/{org}/actions/runners/registration-token", "Create a registration token for an organization",
		"orgs/{org}/actions/runners/remove-token", "Create a remove token for an organization",
		"orgs/{org}/actions/runners/{runner_id}/labels", "Add custom labels to a self-hosted runner for an organization",
		"orgs/{org}/actions/variables", "Create an organization variable",
		"orgs/{org}/code-security/configurations", "Create a code security configuration",
		"orgs/{org}/code-security/configurations/{configuration_id}/attach", "Attach a configuration to repositories",
		"orgs/{org}/codespaces/access/selected_users", "Add users to Codespaces access for an organization",
		"orgs/{org}/copilot/billing/selected_teams", "Add teams to the Copilot subscription for an organization",
		"orgs/{org}/copilot/billing/selected_users", "Add users to the Copilot subscription for an organization",
		"orgs/{org}/hooks", "Create an organization webhook",
		"orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts", "Redeliver a delivery for an organization webhook",
		"orgs/{org}/hooks/{hook_id}/pings", "Ping an organization webhook",
		"orgs/{org}/invitations", "Create an organization invitation",
		"orgs/{org}/members/{username}/codespaces/{codespace_name}/stop", "Stop a codespace for an organization user",
		"orgs/{org}/migrations", "Start an organization migration",
		"orgs/{org}/packages/{package_type}/{package_name}/restore", "Restore a package for an organization",
		"orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore", "Restore package version for an organization",
		"orgs/{org}/personal-access-token-requests", "Review requests to access organization resources with fine-grained personal access tokens",
		"orgs/{org}/personal-access-token-requests/{pat_request_id}", "Review a request to access organization resources with a fine-grained personal access token",
		"orgs/{org}/personal-access-tokens", "Update the access to organization resources via fine-grained personal access tokens",
		"orgs/{org}/personal-access-tokens/{pat_id}", "Update the access a fine-grained personal access token has to organization resources",
		"orgs/{org}/private-registries", "Create a private registry for an organization",
		"orgs/{org}/projects", "Create an organization project",
		"orgs/{org}/repos", "Create an organization repository",
		"orgs/{org}/rulesets", "Create an organization repository ruleset",
		"orgs/{org}/settings/network-configurations", "Create a hosted compute network configuration for an organization",
		"orgs/{org}/teams", "Create a team",
		"orgs/{org}/teams/{team_slug}/discussions", "Create a discussion",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments", "Create a discussion comment",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions", "Create reaction for a team discussion comment",
		"orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions", "Create reaction for a team discussion",
		"orgs/{org}/{security_product}/{enablement}", "Enable or disable a security feature for an organization",
		"projects/columns/cards/{card_id}/moves", "Move a project card",
		"projects/columns/{column_id}/cards", "Create a project card",
		"projects/columns/{column_id}/moves", "Move a project column",
		"projects/{project_id}/columns", "Create a project column",
		"repos/{owner}/{repo}/actions/jobs/{job_id}/rerun", "Re-run a job from a workflow run",
		"repos/{owner}/{repo}/actions/runners/generate-jitconfig", "Create configuration for a just-in-time runner for a repository",
		"repos/{owner}/{repo}/actions/runners/registration-token", "Create a registration token for a repository",
		"repos/{owner}/{repo}/actions/runners/remove-token", "Create a remove token for a repository",
		"repos/{owner}/{repo}/actions/runners/{runner_id}/labels", "Add custom labels to a self-hosted runner for a repository",
		"repos/{owner}/{repo}/actions/runs/{run_id}/approve", "Approve a workflow run for a fork pull request",
		"repos/{owner}/{repo}/actions/runs/{run_id}/cancel", "Cancel a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule", "Review custom deployment protection rules for a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel", "Force cancel a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments", "Review pending deployments for a workflow run",
		"repos/{owner}/{repo}/actions/runs/{run_id}/rerun", "Re-run a workflow",
		"repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs", "Re-run failed jobs from a workflow run",
		"repos/{owner}/{repo}/actions/variables", "Create a repository variable",
		"repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches", "Create a workflow dispatch event",
		"repos/{owner}/{repo}/attestations", "Create an attestation",
		"repos/{owner}/{repo}/autolinks", "Create an autolink reference for a repository",
		"repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins", "Set admin branch protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_signatures", "Create commit signature protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts", "Add status check contexts",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps", "Add app access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams", "Add team access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users", "Add user access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/rename", "Rename a branch",
		"repos/{owner}/{repo}/check-runs", "Create a check run",
		"repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest", "Rerequest a check run",
		"repos/{owner}/{repo}/check-suites", "Create a check suite",
		"repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest", "Rerequest a check suite",
		"repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix", "Create an autofix for a code scanning alert",
		"repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits", "Commit an autofix for a code scanning alert",
		"repos/{owner}/{repo}/code-scanning/codeql/variant-analyses", "Create a CodeQL variant analysis",
		"repos/{owner}/{repo}/code-scanning/sarifs", "Upload an analysis as SARIF data",
		"repos/{owner}/{repo}/codespaces", "Create a codespace in a repository",
		"repos/{owner}/{repo}/comments/{comment_id}/reactions", "Create reaction for a commit comment",
		"repos/{owner}/{repo}/commits/{commit_sha}/comments", "Create a commit comment",
		"repos/{owner}/{repo}/dependency-graph/snapshots", "Create a snapshot of dependencies for a repository",
		"repos/{owner}/{repo}/deployments", "Create a deployment",
		"repos/{owner}/{repo}/deployments/{deployment_id}/statuses", "Create a deployment status",
		"repos/{owner}/{repo}/dispatches", "Create a repository dispatch event",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies", "Create a deployment branch policy",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules", "Create a custom deployment protection rule on an environment",
		"repos/{owner}/{repo}/environments/{environment_name}/variables", "Create an environment variable",
		"repos/{owner}/{repo}/forks", "Create a fork",
		"repos/{owner}/{repo}/git/blobs", "Create a blob",
		"repos/{owner}/{repo}/git/commits", "Create a commit",
		"repos/{owner}/{repo}/git/refs", "Create a reference",
		"repos/{owner}/{repo}/git/tags", "Create a tag object",
		"repos/{owner}/{repo}/git/trees", "Create a tree",
		"repos/{owner}/{repo}/hooks", "Create a repository webhook",
		"repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts", "Redeliver a delivery for a repository webhook",
		"repos/{owner}/{repo}/hooks/{hook_id}/pings", "Ping a repository webhook",
		"repos/{owner}/{repo}/hooks/{hook_id}/tests", "Test the push repository webhook",
		"repos/{owner}/{repo}/issues", "Create an issue",
		"repos/{owner}/{repo}/issues/comments/{comment_id}/reactions", "Create reaction for an issue comment",
		"repos/{owner}/{repo}/issues/{issue_number}/assignees", "Add assignees to an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/comments", "Create an issue comment",
		"repos/{owner}/{repo}/issues/{issue_number}/labels", "Add labels to an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/reactions", "Create reaction for an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/sub_issues", "Add sub-issue",
		"repos/{owner}/{repo}/keys", "Create a deploy key",
		"repos/{owner}/{repo}/labels", "Create a label",
		"repos/{owner}/{repo}/merge-upstream", "Sync a fork branch with the upstream repository",
		"repos/{owner}/{repo}/merges", "Merge a branch",
		"repos/{owner}/{repo}/milestones", "Create a milestone",
		"repos/{owner}/{repo}/pages", "Create a GitHub Pages site",
		"repos/{owner}/{repo}/pages/builds", "Request a GitHub Pages build",
		"repos/{owner}/{repo}/pages/deployments", "Create a GitHub Pages deployment",
		"repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel", "Cancel a GitHub Pages deployment",
		"repos/{owner}/{repo}/projects", "Create a repository project",
		"repos/{owner}/{repo}/pulls", "Create a pull request",
		"repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions", "Create reaction for a pull request review comment",
		"repos/{owner}/{repo}/pulls/{pull_number}/codespaces", "Create a codespace from a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/comments", "Create a review comment for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies", "Create a reply for a review comment",
		"repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers", "Request reviewers for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews", "Create a review for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events", "Submit a review for a pull request",
		"repos/{owner}/{repo}/releases", "Create a release",
		"repos/{owner}/{repo}/releases/generate-notes", "Generate release notes content for a release",
		"repos/{owner}/{repo}/releases/{release_id}/assets", "Upload a release asset",
		"repos/{owner}/{repo}/releases/{release_id}/reactions", "Create reaction for a release",
		"repos/{owner}/{repo}/rulesets", "Create a repository ruleset",
		"repos/{owner}/{repo}/secret-scanning/push-protection-bypasses", "Create a push protection bypass",
		"repos/{owner}/{repo}/security-advisories", "Create a repository security advisory",
		"repos/{owner}/{repo}/security-advisories/reports", "Privately report a security vulnerability",
		"repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve", "Request a CVE for a repository security advisory",
		"repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks", "Create a temporary private fork",
		"repos/{owner}/{repo}/statuses/{sha}", "Create a commit status",
		"repos/{owner}/{repo}/tags/protection", "Closing down - Create a tag protection state for a repository",
		"repos/{owner}/{repo}/transfer", "Transfer a repository",
		"repos/{template_owner}/{template_repo}/generate", "Create a repository using a template",
		"teams/{team_id}/discussions", "Create a discussion (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/comments", "Create a discussion comment (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions", "Create reaction for a team discussion comment (Legacy)",
		"teams/{team_id}/discussions/{discussion_number}/reactions", "Create reaction for a team discussion (Legacy)",
		"user/codespaces", "Create a codespace for the authenticated user",
		"user/codespaces/{codespace_name}/exports", "Export a codespace for the authenticated user",
		"user/codespaces/{codespace_name}/publish", "Create a repository from an unpublished codespace",
		"user/codespaces/{codespace_name}/start", "Start a codespace for the authenticated user",
		"user/codespaces/{codespace_name}/stop", "Stop a codespace for the authenticated user",
		"user/emails", "Add an email address for the authenticated user",
		"user/gpg_keys", "Create a GPG key for the authenticated user",
		"user/keys", "Create a public SSH key for the authenticated user",
		"user/migrations", "Start a user migration",
		"user/packages/{package_type}/{package_name}/restore", "Restore a package for the authenticated user",
		"user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore", "Restore a package version for the authenticated user",
		"user/projects", "Create a user project",
		"user/repos", "Create a repository for the authenticated user",
		"user/social_accounts", "Add social accounts for the authenticated user",
		"user/ssh_signing_keys", "Create a SSH signing key for the authenticated user",
		"users/{username}/packages/{package_type}/{package_name}/restore", "Restore a package for a user",
		"users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore", "Restore package version for a user",
	},
	"put": {
		"app/installations/{installation_id}/suspended", "Suspend an app installation",
		"enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults", "Set a code security configuration as a default for an enterprise",
		"gists/{gist_id}/star", "Star a gist",
		"notifications", "Mark notifications as read",
		"notifications/threads/{thread_id}/subscription", "Set a thread subscription",
		"orgs/{org}/actions/oidc/customization/sub", "Set the customization template for an OIDC subject claim for an organization",
		"orgs/{org}/actions/permissions", "Set GitHub Actions permissions for an organization",
		"orgs/{org}/actions/permissions/repositories", "Set selected repositories enabled for GitHub Actions in an organization",
		"orgs/{org}/actions/permissions/repositories/{repository_id}", "Enable a selected repository for GitHub Actions in an organization",
		"orgs/{org}/actions/permissions/selected-actions", "Set allowed actions and reusable workflows for an organization",
		"orgs/{org}/actions/permissions/workflow", "Set default workflow permissions for an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/repositories", "Set repository access for a self-hosted runner group in an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}", "Add repository access to a self-hosted runner group in an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/runners", "Set self-hosted runners in a group for an organization",
		"orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}", "Add a self-hosted runner to a group for an organization",
		"orgs/{org}/actions/runners/{runner_id}/labels", "Set custom labels for a self-hosted runner for an organization",
		"orgs/{org}/actions/secrets/{secret_name}", "Create or update an organization secret",
		"orgs/{org}/actions/secrets/{secret_name}/repositories", "Set selected repositories for an organization secret",
		"orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}", "Add selected repository to an organization secret",
		"orgs/{org}/actions/variables/{name}/repositories", "Set selected repositories for an organization variable",
		"orgs/{org}/actions/variables/{name}/repositories/{repository_id}", "Add selected repository to an organization variable",
		"orgs/{org}/blocks/{username}", "Block a user from an organization",
		"orgs/{org}/code-security/configurations/{configuration_id}/defaults", "Set a code security configuration as a default for an organization",
		"orgs/{org}/codespaces/access", "Manage access control for organization codespaces",
		"orgs/{org}/codespaces/secrets/{secret_name}", "Create or update an organization secret",
		"orgs/{org}/codespaces/secrets/{secret_name}/repositories", "Set selected repositories for an organization secret",
		"orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}", "Add selected repository to an organization secret",
		"orgs/{org}/dependabot/secrets/{secret_name}", "Create or update an organization secret",
		"orgs/{org}/dependabot/secrets/{secret_name}/repositories", "Set selected repositories for an organization secret",
		"orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}", "Add selected repository to an organization secret",
		"orgs/{org}/interaction-limits", "Set interaction restrictions for an organization",
		"orgs/{org}/memberships/{username}", "Set organization membership for a user",
		"orgs/{org}/organization-roles/teams/{team_slug}/{role_id}", "Assign an organization role to a team",
		"orgs/{org}/organization-roles/users/{username}/{role_id}", "Assign an organization role to a user",
		"orgs/{org}/outside_collaborators/{username}", "Convert an organization member to outside collaborator",
		"orgs/{org}/properties/schema/{custom_property_name}", "Create or update a custom property for an organization",
		"orgs/{org}/public_members/{username}", "Set public organization membership for the authenticated user",
		"orgs/{org}/rulesets/{ruleset_id}", "Update an organization repository ruleset",
		"orgs/{org}/security-managers/teams/{team_slug}", "Add a security manager team",
		"orgs/{org}/teams/{team_slug}/memberships/{username}", "Add or update team membership for a user",
		"orgs/{org}/teams/{team_slug}/projects/{project_id}", "Add or update team project permissions",
		"orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}", "Add or update team repository permissions",
		"projects/{project_id}/collaborators/{username}", "Add project collaborator",
		"repos/{owner}/{repo}/actions/oidc/customization/sub", "Set the customization template for an OIDC subject claim for a repository",
		"repos/{owner}/{repo}/actions/permissions", "Set GitHub Actions permissions for a repository",
		"repos/{owner}/{repo}/actions/permissions/access", "Set the level of access for workflows outside of the repository",
		"repos/{owner}/{repo}/actions/permissions/selected-actions", "Set allowed actions and reusable workflows for a repository",
		"repos/{owner}/{repo}/actions/permissions/workflow", "Set default workflow permissions for a repository",
		"repos/{owner}/{repo}/actions/runners/{runner_id}/labels", "Set custom labels for a self-hosted runner for a repository",
		"repos/{owner}/{repo}/actions/secrets/{secret_name}", "Create or update a repository secret",
		"repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable", "Disable a workflow",
		"repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable", "Enable a workflow",
		"repos/{owner}/{repo}/automated-security-fixes", "Enable Dependabot security updates",
		"repos/{owner}/{repo}/branches/{branch}/protection", "Update branch protection",
		"repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts", "Set status check contexts",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps", "Set app access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams", "Set team access restrictions",
		"repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users", "Set user access restrictions",
		"repos/{owner}/{repo}/codespaces/secrets/{secret_name}", "Create or update a repository secret",
		"repos/{owner}/{repo}/collaborators/{username}", "Add a repository collaborator",
		"repos/{owner}/{repo}/contents/{path}", "Create or update file contents",
		"repos/{owner}/{repo}/dependabot/secrets/{secret_name}", "Create or update a repository secret",
		"repos/{owner}/{repo}/environments/{environment_name}", "Create or update an environment",
		"repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}", "Update a deployment branch policy",
		"repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}", "Create or update an environment secret",
		"repos/{owner}/{repo}/import", "Start an import",
		"repos/{owner}/{repo}/interaction-limits", "Set interaction restrictions for a repository",
		"repos/{owner}/{repo}/issues/{issue_number}/labels", "Set labels for an issue",
		"repos/{owner}/{repo}/issues/{issue_number}/lock", "Lock an issue",
		"repos/{owner}/{repo}/notifications", "Mark repository notifications as read",
		"repos/{owner}/{repo}/pages", "Update information about a GitHub Pages site",
		"repos/{owner}/{repo}/private-vulnerability-reporting", "Enable private vulnerability reporting for a repository",
		"repos/{owner}/{repo}/pulls/{pull_number}/merge", "Merge a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}", "Update a review for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals", "Dismiss a review for a pull request",
		"repos/{owner}/{repo}/pulls/{pull_number}/update-branch", "Update a pull request branch",
		"repos/{owner}/{repo}/rulesets/{ruleset_id}", "Update a repository ruleset",
		"repos/{owner}/{repo}/subscription", "Set a repository subscription",
		"repos/{owner}/{repo}/topics", "Replace all repository topics",
		"repos/{owner}/{repo}/vulnerability-alerts", "Enable vulnerability alerts",
		"teams/{team_id}/members/{username}", "Add team member (Legacy)",
		"teams/{team_id}/memberships/{username}", "Add or update team membership for a user (Legacy)",
		"teams/{team_id}/projects/{project_id}", "Add or update team project permissions (Legacy)",
		"teams/{team_id}/repos/{owner}/{repo}", "Add or update team repository permissions (Legacy)",
		"user/blocks/{username}", "Block a user",
		"user/codespaces/secrets/{secret_name}", "Create or update a secret for the authenticated user",
		"user/codespaces/secrets/{secret_name}/repositories", "Set selected repositories for a user secret",
		"user/codespaces/secrets/{secret_name}/repositories/{repository_id}", "Add a selected repository to a user secret",
		"user/following/{username}", "Follow a user",
		"user/installations/{installation_id}/repositories/{repository_id}", "Add a repository to an app installation",
		"user/interaction-limits", "Set interaction restrictions for your public repositories",
		"user/starred/{owner}/{repo}", "Star a repository for the authenticated user",
	},
}
