# v1.4 - Bridge Inspector

![](./v1.4/banner.png)

Looking into details.

## Detect

Added `carapace --detect COMMAND` to auto-detect bridgeable frameworks.

![](./v1.4/detect.cast)

> **WARNING:** This invokes given command multiple times with various arguments.

## Urfavecli

Added support for [urfave/cli](https://github.com/urfave/cli) v3 and updated [identifiers](../bridges.md).

- `argcomplete`
- `argcomplete@v1` (legacy)
- `urfavecli`
- `urfavecli@v1` (legacy)

Also renamed `ArgcompleteLegacy` to `ArgcompleteV1`.

## Termux

Now in official package repo [termux/termux-packages](https://github.com/termux/termux-packages).

```sh
pkg install carapace
```

## Alias

Added [variable substitution](https://github.com/drone/envsubst) to [aliases](../spec/run.html#alias).

```yaml
# yaml-language-server: $schema=https://carapace.sh/schemas/command.json
name: example
run: "[gh, issue, --repo, '${REPO}']"
```

![](./v1.4/alias.cast)

## Lint

Removed `carapace-fmt` and integrated formatting into `carapace-lint`.

![](./v1.4/lint.cast)

## Hidden

Updated [CARAPACE_HIDDEN](../setup/environment.md#carapace_hidden) for more granular control.

- `0` - disabled
- `1` - enabled
- `2` - enabled including `_carapace`

![](./v1.4/hidden.cast)
