// Code generated by yy. DO NOT EDIT.

// Copyright 2016 The CC Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package cc // import "modernc.org/cc"

import (
	"fmt"
)

func ExampleAbstractDeclarator() {
	fmt.Println(exampleAST(185, "\U00100001 ( _Bool * )"))
	// Output:
	// &cc.AbstractDeclarator{
	// · Pointer: &cc.Pointer{
	// · · Token: example185.c:1:10: '*',
	// · },
	// }
}

func ExampleAbstractDeclarator_case1() {
	fmt.Println(exampleAST(186, "\U00100001 ( _Bool ( ) )"))
	// Output:
	// &cc.AbstractDeclarator{
	// · Case: 1,
	// · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · Case: 6,
	// · · Token: example186.c:1:10: '(',
	// · · Token2: example186.c:1:12: ')',
	// · },
	// }
}

func ExampleAbstractDeclaratorOpt() {
	fmt.Println(exampleAST(187, "\U00100001 ( _Bool )") == (*AbstractDeclaratorOpt)(nil))
	// Output:
	// true
}

func ExampleAbstractDeclaratorOpt_case1() {
	fmt.Println(exampleAST(188, "\U00100001 ( _Bool * )"))
	// Output:
	// &cc.AbstractDeclaratorOpt{
	// · AbstractDeclarator: &cc.AbstractDeclarator{
	// · · Pointer: &cc.Pointer{
	// · · · Token: example188.c:1:10: '*',
	// · · },
	// · },
	// }
}

func ExampleArgumentExpressionList() {
	fmt.Println(exampleAST(8, "\U00100001 'a' ( 'b' )"))
	// Output:
	// &cc.ArgumentExpressionList{
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example8.c:1:8: CHARCONST "'b'",
	// · },
	// }
}

func ExampleArgumentExpressionList_case1() {
	fmt.Println(exampleAST(9, "\U00100001 'a' ( 'b' , 'c' )"))
	// Output:
	// &cc.ArgumentExpressionList{
	// · ArgumentExpressionList: &cc.ArgumentExpressionList{
	// · · Case: 1,
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example9.c:1:14: CHARCONST "'c'",
	// · · },
	// · · Token: example9.c:1:12: ',',
	// · },
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example9.c:1:8: CHARCONST "'b'",
	// · },
	// }
}

func ExampleArgumentExpressionListOpt() {
	fmt.Println(exampleAST(10, "\U00100001 'a' ( )") == (*ArgumentExpressionListOpt)(nil))
	// Output:
	// true
}

func ExampleArgumentExpressionListOpt_case1() {
	fmt.Println(exampleAST(11, "\U00100001 'a' ( 'b' )"))
	// Output:
	// &cc.ArgumentExpressionListOpt{
	// · ArgumentExpressionList: &cc.ArgumentExpressionList{
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example11.c:1:8: CHARCONST "'b'",
	// · · },
	// · },
	// }
}

func ExampleAssemblerInstructions() {
	fmt.Println(exampleAST(265, "\U00100002 asm ( \"a\" )"))
	// Output:
	// &cc.AssemblerInstructions{
	// · Token: example265.c:1:8: STRINGLITERAL "\"a\"",
	// }
}

func ExampleAssemblerInstructions_case1() {
	fmt.Println(exampleAST(266, "\U00100002 asm ( \"a\" \"b\" )"))
	// Output:
	// &cc.AssemblerInstructions{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Case: 1,
	// · · Token: example266.c:1:12: STRINGLITERAL "\"b\"",
	// · },
	// · Token: example266.c:1:8: STRINGLITERAL "\"a\"",
	// }
}

func ExampleAssemblerOperand() {
	fmt.Println(exampleAST(270, "\U00100002 a asm ( \"b\" : \"c\" ( 'd' ) )"))
	// Output:
	// &cc.AssemblerOperand{
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example270.c:1:22: CHARCONST "'d'",
	// · },
	// · Token: example270.c:1:16: STRINGLITERAL "\"c\"",
	// · Token2: example270.c:1:20: '(',
	// · Token3: example270.c:1:26: ')',
	// }
}

func ExampleAssemblerOperands() {
	fmt.Println(exampleAST(271, "\U00100002 a asm ( \"b\" : \"c\" ( 'd' ) )"))
	// Output:
	// &cc.AssemblerOperands{
	// · AssemblerOperand: &cc.AssemblerOperand{
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example271.c:1:22: CHARCONST "'d'",
	// · · },
	// · · Token: example271.c:1:16: STRINGLITERAL "\"c\"",
	// · · Token2: example271.c:1:20: '(',
	// · · Token3: example271.c:1:26: ')',
	// · },
	// }
}

func ExampleAssemblerOperands_case1() {
	fmt.Println(exampleAST(272, "\U00100002 a asm ( \"b\" : \"c\" ( 'd' ) , \"e\" ( 'f' ) )"))
	// Output:
	// &cc.AssemblerOperands{
	// · AssemblerOperand: &cc.AssemblerOperand{
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example272.c:1:22: CHARCONST "'d'",
	// · · },
	// · · Token: example272.c:1:16: STRINGLITERAL "\"c\"",
	// · · Token2: example272.c:1:20: '(',
	// · · Token3: example272.c:1:26: ')',
	// · },
	// · AssemblerOperands: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example272.c:1:36: CHARCONST "'f'",
	// · · · },
	// · · · Token: example272.c:1:30: STRINGLITERAL "\"e\"",
	// · · · Token2: example272.c:1:34: '(',
	// · · · Token3: example272.c:1:40: ')',
	// · · },
	// · · Case: 1,
	// · · Token: example272.c:1:28: ',',
	// · },
	// }
}

func ExampleAssemblerStatement() {
	fmt.Println(exampleAST(277, "\U00100002 a asm ( \"b\" ) !"))
	// Output:
	// &cc.AssemblerStatement{
	// · BasicAssemblerStatement: &cc.BasicAssemblerStatement{
	// · · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · · Token: example277.c:1:10: STRINGLITERAL "\"b\"",
	// · · },
	// · · Token: example277.c:1:4: ASM "asm",
	// · · Token2: example277.c:1:8: '(',
	// · · Token3: example277.c:1:14: ')',
	// · },
	// }
}

func ExampleAssemblerStatement_case1() {
	fmt.Println(exampleAST(278, "\U00100002 a asm ( \"b\" : \"c\" ( 'd' ) ) !"))
	// Output:
	// &cc.AssemblerStatement{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Token: example278.c:1:10: STRINGLITERAL "\"b\"",
	// · },
	// · AssemblerOperands: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example278.c:1:22: CHARCONST "'d'",
	// · · · },
	// · · · Token: example278.c:1:16: STRINGLITERAL "\"c\"",
	// · · · Token2: example278.c:1:20: '(',
	// · · · Token3: example278.c:1:26: ')',
	// · · },
	// · },
	// · Case: 1,
	// · Token: example278.c:1:4: ASM "asm",
	// · Token2: example278.c:1:8: '(',
	// · Token3: example278.c:1:14: ':',
	// · Token4: example278.c:1:28: ')',
	// }
}

func ExampleAssemblerStatement_case2() {
	fmt.Println(exampleAST(279, "\U00100002 a asm ( \"b\" : \"c\" ( 'd' ) : \"e\" ( 'f' ) ) !"))
	// Output:
	// &cc.AssemblerStatement{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Token: example279.c:1:10: STRINGLITERAL "\"b\"",
	// · },
	// · AssemblerOperands: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example279.c:1:22: CHARCONST "'d'",
	// · · · },
	// · · · Token: example279.c:1:16: STRINGLITERAL "\"c\"",
	// · · · Token2: example279.c:1:20: '(',
	// · · · Token3: example279.c:1:26: ')',
	// · · },
	// · },
	// · AssemblerOperands2: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example279.c:1:36: CHARCONST "'f'",
	// · · · },
	// · · · Token: example279.c:1:30: STRINGLITERAL "\"e\"",
	// · · · Token2: example279.c:1:34: '(',
	// · · · Token3: example279.c:1:40: ')',
	// · · },
	// · },
	// · Case: 2,
	// · Token: example279.c:1:4: ASM "asm",
	// · Token2: example279.c:1:8: '(',
	// · Token3: example279.c:1:14: ':',
	// · Token4: example279.c:1:28: ':',
	// · Token5: example279.c:1:42: ')',
	// }
}

func ExampleAssemblerStatement_case3() {
	fmt.Println(exampleAST(280, "\U00100002 a asm ( \"b\" : \"c\" ( 'd' ) : \"e\" ( 'f' ) : \"g\" ) !"))
	// Output:
	// &cc.AssemblerStatement{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Token: example280.c:1:10: STRINGLITERAL "\"b\"",
	// · },
	// · AssemblerOperands: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example280.c:1:22: CHARCONST "'d'",
	// · · · },
	// · · · Token: example280.c:1:16: STRINGLITERAL "\"c\"",
	// · · · Token2: example280.c:1:20: '(',
	// · · · Token3: example280.c:1:26: ')',
	// · · },
	// · },
	// · AssemblerOperands2: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example280.c:1:36: CHARCONST "'f'",
	// · · · },
	// · · · Token: example280.c:1:30: STRINGLITERAL "\"e\"",
	// · · · Token2: example280.c:1:34: '(',
	// · · · Token3: example280.c:1:40: ')',
	// · · },
	// · },
	// · Case: 3,
	// · Clobbers: &cc.Clobbers{
	// · · Token: example280.c:1:44: STRINGLITERAL "\"g\"",
	// · },
	// · Token: example280.c:1:4: ASM "asm",
	// · Token2: example280.c:1:8: '(',
	// · Token3: example280.c:1:14: ':',
	// · Token4: example280.c:1:28: ':',
	// · Token5: example280.c:1:42: ':',
	// · Token6: example280.c:1:48: ')',
	// }
}

func ExampleAssemblerStatement_case4() {
	fmt.Println(exampleAST(281, "\U00100002 a asm goto ( \"b\" : : \"c\" ( 'd' ) : \"e\" : f ) !"))
	// Output:
	// &cc.AssemblerStatement{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Token: example281.c:1:15: STRINGLITERAL "\"b\"",
	// · },
	// · AssemblerOperands: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example281.c:1:29: CHARCONST "'d'",
	// · · · },
	// · · · Token: example281.c:1:23: STRINGLITERAL "\"c\"",
	// · · · Token2: example281.c:1:27: '(',
	// · · · Token3: example281.c:1:33: ')',
	// · · },
	// · },
	// · Case: 4,
	// · Clobbers: &cc.Clobbers{
	// · · Token: example281.c:1:37: STRINGLITERAL "\"e\"",
	// · },
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: example281.c:1:43: IDENTIFIER "f",
	// · },
	// · Token: example281.c:1:4: ASM "asm",
	// · Token2: example281.c:1:8: GOTO "goto",
	// · Token3: example281.c:1:13: '(',
	// · Token4: example281.c:1:19: ':',
	// · Token5: example281.c:1:21: ':',
	// · Token6: example281.c:1:35: ':',
	// · Token7: example281.c:1:41: ':',
	// · Token8: example281.c:1:45: ')',
	// }
}

func ExampleAssemblerStatement_case5() {
	fmt.Println(exampleAST(282, "\U00100002 a asm ( \"b\" : ) !"))
	// Output:
	// &cc.AssemblerStatement{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Token: example282.c:1:10: STRINGLITERAL "\"b\"",
	// · },
	// · Case: 5,
	// · Token: example282.c:1:4: ASM "asm",
	// · Token2: example282.c:1:8: '(',
	// · Token3: example282.c:1:14: ':',
	// · Token4: example282.c:1:16: ')',
	// }
}

func ExampleAssemblerStatement_case6() {
	fmt.Println(exampleAST(283, "\U00100002 a asm ( \"b\" : : \"c\" ( 'd' ) ) !"))
	// Output:
	// &cc.AssemblerStatement{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Token: example283.c:1:10: STRINGLITERAL "\"b\"",
	// · },
	// · AssemblerOperands: &cc.AssemblerOperands{
	// · · AssemblerOperand: &cc.AssemblerOperand{
	// · · · Expression: &cc.Expression{
	// · · · · Case: 1,
	// · · · · Token: example283.c:1:24: CHARCONST "'d'",
	// · · · },
	// · · · Token: example283.c:1:18: STRINGLITERAL "\"c\"",
	// · · · Token2: example283.c:1:22: '(',
	// · · · Token3: example283.c:1:28: ')',
	// · · },
	// · },
	// · Case: 6,
	// · Token: example283.c:1:4: ASM "asm",
	// · Token2: example283.c:1:8: '(',
	// · Token3: example283.c:1:14: ':',
	// · Token4: example283.c:1:16: ':',
	// · Token5: example283.c:1:30: ')',
	// }
}

func ExampleAssemblerSymbolicNameOpt() {
	fmt.Println(exampleAST(273, "\U00100002 a asm goto ( \"b\" : : \"c\"") == (*AssemblerSymbolicNameOpt)(nil))
	// Output:
	// true
}

func ExampleAssemblerSymbolicNameOpt_case1() {
	fmt.Println(exampleAST(274, "\U00100002 a asm ( \"b\" : [ c ] \"d\""))
	// Output:
	// &cc.AssemblerSymbolicNameOpt{
	// · Token: example274.c:1:16: '[',
	// · Token2: example274.c:1:18: IDENTIFIER "c",
	// · Token3: example274.c:1:20: ']',
	// }
}

func ExampleBasicAssemblerStatement() {
	fmt.Println(exampleAST(267, "\U00100002 asm ( \"a\" ) !"))
	// Output:
	// &cc.BasicAssemblerStatement{
	// · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · Token: example267.c:1:8: STRINGLITERAL "\"a\"",
	// · },
	// · Token: example267.c:1:2: ASM "asm",
	// · Token2: example267.c:1:6: '(',
	// · Token3: example267.c:1:12: ')',
	// }
}

func ExampleBlockItem() {
	fmt.Println(exampleAST(230, "\U00100001 ( { auto ; !"))
	// Output:
	// &cc.BlockItem{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: example230.c:1:6: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: example230.c:1:11: ';',
	// · },
	// }
}

func ExampleBlockItem_case1() {
	fmt.Println(exampleAST(231, "\U00100001 ( { ; !"))
	// Output:
	// &cc.BlockItem{
	// · Case: 1,
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example231.c:1:6: ';',
	// · · },
	// · },
	// }
}

func ExampleBlockItemList() {
	fmt.Println(exampleAST(226, "\U00100001 ( { ; !"))
	// Output:
	// &cc.BlockItemList{
	// · BlockItem: &cc.BlockItem{
	// · · Case: 1,
	// · · Statement: &cc.Statement{
	// · · · Case: 2,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Token: example226.c:1:6: ';',
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleBlockItemList_case1() {
	fmt.Println(exampleAST(227, "\U00100001 ( { ; ; !"))
	// Output:
	// &cc.BlockItemList{
	// · BlockItem: &cc.BlockItem{
	// · · Case: 1,
	// · · Statement: &cc.Statement{
	// · · · Case: 2,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Token: example227.c:1:6: ';',
	// · · · },
	// · · },
	// · },
	// · BlockItemList: &cc.BlockItemList{
	// · · BlockItem: &cc.BlockItem{
	// · · · Case: 1,
	// · · · Statement: &cc.Statement{
	// · · · · Case: 2,
	// · · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · · Token: example227.c:1:8: ';',
	// · · · · },
	// · · · },
	// · · },
	// · · Case: 1,
	// · },
	// }
}

func ExampleBlockItemListOpt() {
	fmt.Println(exampleAST(228, "\U00100001 ( { }") == (*BlockItemListOpt)(nil))
	// Output:
	// true
}

func ExampleBlockItemListOpt_case1() {
	fmt.Println(exampleAST(229, "\U00100001 ( { ; }"))
	// Output:
	// &cc.BlockItemListOpt{
	// · BlockItemList: &cc.BlockItemList{
	// · · BlockItem: &cc.BlockItem{
	// · · · Case: 1,
	// · · · Statement: &cc.Statement{
	// · · · · Case: 2,
	// · · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · · Token: example229.c:1:6: ';',
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleClobbers() {
	fmt.Println(exampleAST(275, "\U00100002 a asm goto ( \"b\" : : \"c\" ( 'd' ) : \"e\" )"))
	// Output:
	// &cc.Clobbers{
	// · Token: example275.c:1:37: STRINGLITERAL "\"e\"",
	// }
}

func ExampleClobbers_case1() {
	fmt.Println(exampleAST(276, "\U00100002 a asm goto ( \"b\" : : \"c\" ( 'd' ) : \"e\" , \"f\" )"))
	// Output:
	// &cc.Clobbers{
	// · Clobbers: &cc.Clobbers{
	// · · Case: 1,
	// · · Token: example276.c:1:41: ',',
	// · · Token2: example276.c:1:43: STRINGLITERAL "\"f\"",
	// · },
	// · Token: example276.c:1:37: STRINGLITERAL "\"e\"",
	// }
}

func ExampleCommaOpt() {
	fmt.Println(exampleAST(135, "\U00100002 auto a = { }") == (*CommaOpt)(nil))
	// Output:
	// true
}

func ExampleCommaOpt_case1() {
	fmt.Println(exampleAST(136, "\U00100002 auto a = { , }"))
	// Output:
	// &cc.CommaOpt{
	// · Token: example136.c:1:13: ',',
	// }
}

func ExampleCompoundStatement() {
	fmt.Println(exampleAST(225, "\U00100001 ( { }"))
	// Output:
	// &cc.CompoundStatement{
	// · Token: example225.c:1:4: '{',
	// · Token2: example225.c:1:6: '}',
	// }
}

func ExampleConstantExpression() {
	fmt.Println(exampleAST(79, "\U00100001 'a'"))
	// Output:
	// &cc.ConstantExpression{
	// · Type: int,
	// · Value: 97,
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 97,
	// · · Case: 1,
	// · · Token: example79.c:1:2: CHARCONST "'a'",
	// · },
	// }
}

func ExampleControlLine() {
	fmt.Println(exampleAST(307, "\U00100000 \n#define a "))
	// Output:
	// &cc.ControlLine{
	// · ReplacementList: []xc.Token{ // len 1
	// · · 0: example307.c:2:10: ' ',
	// · },
	// · Token: example307.c:2:2: PPDEFINE,
	// · Token2: example307.c:2:9: IDENTIFIER "a",
	// }
}

func ExampleControlLine_case01() {
	fmt.Println(exampleAST(308, "\U00100000 \n#define a( ... ) "))
	// Output:
	// &cc.ControlLine{
	// · Case: 1,
	// · ReplacementList: []xc.Token{ // len 1
	// · · 0: example308.c:2:17: ' ',
	// · },
	// · Token: example308.c:2:2: PPDEFINE,
	// · Token2: example308.c:2:9: IDENTIFIER_LPAREN "a(",
	// · Token3: example308.c:2:12: DDD,
	// · Token4: example308.c:2:16: ')',
	// }
}

func ExampleControlLine_case02() {
	fmt.Println(exampleAST(309, "\U00100000 \n#define a( b , ... ) "))
	// Output:
	// &cc.ControlLine{
	// · Case: 2,
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: example309.c:2:12: IDENTIFIER "b",
	// · },
	// · ReplacementList: []xc.Token{ // len 1
	// · · 0: example309.c:2:21: ' ',
	// · },
	// · Token: example309.c:2:2: PPDEFINE,
	// · Token2: example309.c:2:9: IDENTIFIER_LPAREN "a(",
	// · Token3: example309.c:2:14: ',',
	// · Token4: example309.c:2:16: DDD,
	// · Token5: example309.c:2:20: ')',
	// }
}

func ExampleControlLine_case03() {
	fmt.Println(exampleAST(310, "\U00100000 \n#define a( ) "))
	// Output:
	// &cc.ControlLine{
	// · Case: 3,
	// · ReplacementList: []xc.Token{ // len 1
	// · · 0: example310.c:2:13: ' ',
	// · },
	// · Token: example310.c:2:2: PPDEFINE,
	// · Token2: example310.c:2:9: IDENTIFIER_LPAREN "a(",
	// · Token3: example310.c:2:12: ')',
	// }
}

func ExampleControlLine_case04() {
	fmt.Println(exampleAST(311, "\U00100000 \n#error "))
	// Output:
	// &cc.ControlLine{
	// · Case: 4,
	// · PPTokenListOpt: []xc.Token{ // len 1
	// · · 0: example311.c:2:7: ' ',
	// · },
	// · Token: example311.c:2:2: PPERROR,
	// }
}

func ExampleControlLine_case05() {
	fmt.Println(exampleAST(312, "\U00100000 \n#"))
	// Output:
	// &cc.ControlLine{
	// · Case: 5,
	// · Token: example312.c:2:2: PPHASH_NL,
	// }
}

func ExampleControlLine_case06() {
	fmt.Println(exampleAST(313, "\U00100000 \n#include other_a "))
	// Output:
	// &cc.ControlLine{
	// · Case: 6,
	// · PPTokenList: []xc.Token{ // len 3
	// · · 0: example313.c:2:9: ' ',
	// · · 1: example313.c:2:10: IDENTIFIER "other_a",
	// · · 2: example313.c:2:17: ' ',
	// · },
	// · Token: example313.c:2:2: PPINCLUDE,
	// · Token2: example313.c:2:18: '\n',
	// }
}

func ExampleControlLine_case07() {
	fmt.Println(exampleAST(314, "\U00100000 \n#line other_a "))
	// Output:
	// &cc.ControlLine{
	// · Case: 7,
	// · PPTokenList: []xc.Token{ // len 3
	// · · 0: example314.c:2:6: ' ',
	// · · 1: example314.c:2:7: IDENTIFIER "other_a",
	// · · 2: example314.c:2:14: ' ',
	// · },
	// · Token: example314.c:2:2: PPLINE,
	// · Token2: example314.c:2:15: '\n',
	// }
}

func ExampleControlLine_case08() {
	fmt.Println(exampleAST(315, "\U00100000 \n#pragma "))
	// Output:
	// &cc.ControlLine{
	// · Case: 8,
	// · PPTokenListOpt: []xc.Token{ // len 1
	// · · 0: example315.c:2:8: ' ',
	// · },
	// · Token: example315.c:2:2: PPPRAGMA,
	// }
}

func ExampleControlLine_case09() {
	fmt.Println(exampleAST(316, "\U00100000 \n#undef foo"))
	// Output:
	// &cc.ControlLine{
	// · Case: 9,
	// · Token: example316.c:2:2: PPUNDEF,
	// · Token2: example316.c:2:8: IDENTIFIER "foo",
	// · Token3: example316.c:2:11: '\n',
	// }
}

func ExampleControlLine_case10() {
	fmt.Println(exampleAST(317, "\U00100000 \n#define a( b ... ) "))
	// Output:
	// &cc.ControlLine{
	// · Case: 10,
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: example317.c:2:12: IDENTIFIER "b",
	// · },
	// · ReplacementList: []xc.Token{ // len 1
	// · · 0: example317.c:2:19: ' ',
	// · },
	// · Token: example317.c:2:2: PPDEFINE,
	// · Token2: example317.c:2:9: IDENTIFIER_LPAREN "a(",
	// · Token3: example317.c:2:14: DDD,
	// · Token4: example317.c:2:18: ')',
	// }
}

func ExampleControlLine_case11() {
	fmt.Println(exampleAST(318, "\U00100000 \n#define "))
	// Output:
	// &cc.ControlLine{
	// · Case: 11,
	// · Token: example318.c:2:2: PPDEFINE,
	// · Token2: example318.c:2:9: '\n',
	// }
}

func ExampleControlLine_case12() {
	fmt.Println(exampleAST(319, "\U00100000 \n#undef foo(bar)"))
	// Output:
	// &cc.ControlLine{
	// · Case: 12,
	// · PPTokenList: []xc.Token{ // len 3
	// · · 0: example319.c:2:11: '(',
	// · · 1: example319.c:2:12: IDENTIFIER "bar",
	// · · 2: example319.c:2:15: ')',
	// · },
	// · Token: example319.c:2:2: PPUNDEF,
	// · Token2: example319.c:2:8: IDENTIFIER "foo",
	// · Token3: example319.c:2:16: '\n',
	// }
}

func ExampleControlLine_case13() {
	fmt.Println(exampleAST(320, "\U00100000 \n#include_next other_a "))
	// Output:
	// &cc.ControlLine{
	// · Case: 13,
	// · PPTokenList: []xc.Token{ // len 3
	// · · 0: example320.c:2:14: ' ',
	// · · 1: example320.c:2:15: IDENTIFIER "other_a",
	// · · 2: example320.c:2:22: ' ',
	// · },
	// · Token: example320.c:2:2: PPINCLUDE_NEXT,
	// · Token2: example320.c:2:23: '\n',
	// }
}

func ExampleDeclaration() {
	fmt.Println(exampleAST(80, "\U00100002 auto ;"))
	// Output:
	// &cc.Declaration{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Case: 3,
	// · · · Token: example80.c:1:2: AUTO "auto",
	// · · },
	// · },
	// · Token: example80.c:1:7: ';',
	// }
}

func ExampleDeclaration_case1() {
	fmt.Println(exampleAST(81, "\U00100002 _Static_assert ( 'a' , \"b\" ) ;"))
	// Output:
	// &cc.Declaration{
	// · Case: 1,
	// · StaticAssertDeclaration: &cc.StaticAssertDeclaration{
	// · · ConstantExpression: &cc.ConstantExpression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Expression: &cc.Expression{
	// · · · · Type: int,
	// · · · · Value: 97,
	// · · · · Case: 1,
	// · · · · Token: example81.c:1:19: CHARCONST "'a'",
	// · · · },
	// · · },
	// · · Token: example81.c:1:2: STATIC_ASSERT "_Static_assert",
	// · · Token2: example81.c:1:17: '(',
	// · · Token3: example81.c:1:23: ',',
	// · · Token4: example81.c:1:25: STRINGLITERAL "\"b\"",
	// · · Token5: example81.c:1:29: ')',
	// · · Token6: example81.c:1:31: ';',
	// · },
	// }
}

func ExampleDeclarationList() {
	fmt.Println(exampleAST(260, "\U00100002 a auto ; {"))
	// Output:
	// &cc.DeclarationList{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: example260.c:1:4: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: example260.c:1:9: ';',
	// · },
	// }
}

func ExampleDeclarationList_case1() {
	fmt.Println(exampleAST(261, "\U00100002 a auto ; auto ; {"))
	// Output:
	// &cc.DeclarationList{
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: example261.c:1:4: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: example261.c:1:9: ';',
	// · },
	// · DeclarationList: &cc.DeclarationList{
	// · · Case: 1,
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: example261.c:1:11: AUTO "auto",
	// · · · · },
	// · · · },
	// · · · Token: example261.c:1:16: ';',
	// · · },
	// · },
	// }
}

func ExampleDeclarationListOpt() {
	fmt.Println(exampleAST(262, "\U00100002 a {") == (*DeclarationListOpt)(nil))
	// Output:
	// true
}

func ExampleDeclarationListOpt_case1() {
	fmt.Println(exampleAST(264, "\U00100002 a auto ; {"))
	// Output:
	// &cc.DeclarationListOpt{
	// · DeclarationList: &cc.DeclarationList{
	// · · Declaration: &cc.Declaration{
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: example264.c:1:4: AUTO "auto",
	// · · · · },
	// · · · },
	// · · · Token: example264.c:1:9: ';',
	// · · },
	// · },
	// }
}

func ExampleDeclarationSpecifiers() {
	fmt.Println(exampleAST(82, "\U00100002 auto ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · Case: 3,
	// · · Token: example82.c:1:2: AUTO "auto",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_case1() {
	fmt.Println(exampleAST(83, "\U00100002 _Bool ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: 1,
	// · TypeSpecifier: &cc.TypeSpecifier{
	// · · Case: 9,
	// · · Token: example83.c:1:2: BOOL "_Bool",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_case2() {
	fmt.Println(exampleAST(84, "\U00100002 const ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: 2,
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: example84.c:1:2: CONST "const",
	// · },
	// }
}

func ExampleDeclarationSpecifiers_case3() {
	fmt.Println(exampleAST(85, "\U00100002 inline ("))
	// Output:
	// &cc.DeclarationSpecifiers{
	// · Case: 3,
	// · FunctionSpecifier: &cc.FunctionSpecifier{
	// · · Token: example85.c:1:2: INLINE "inline",
	// · },
	// }
}

func ExampleDeclarationSpecifiersOpt() {
	fmt.Println(exampleAST(86, "\U00100002 auto (") == (*DeclarationSpecifiersOpt)(nil))
	// Output:
	// true
}

func ExampleDeclarationSpecifiersOpt_case1() {
	fmt.Println(exampleAST(87, "\U00100002 auto auto ("))
	// Output:
	// &cc.DeclarationSpecifiersOpt{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Case: 3,
	// · · · Token: example87.c:1:7: AUTO "auto",
	// · · },
	// · },
	// }
}

func ExampleDeclarator() {
	fmt.Println(exampleAST(149, "\U00100002 a )"))
	// Output:
	// &cc.Declarator{
	// · Linkage: None,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Token: example149.c:1:2: IDENTIFIER "a",
	// · },
	// }
}

func ExampleDeclaratorOpt() {
	fmt.Println(exampleAST(150, "\U00100002 struct { _Bool :") == (*DeclaratorOpt)(nil))
	// Output:
	// true
}

func ExampleDeclaratorOpt_case1() {
	fmt.Println(exampleAST(151, "\U00100002 struct { _Bool a :"))
	// Output:
	// &cc.DeclaratorOpt{
	// · Declarator: &cc.Declarator{
	// · · Linkage: None,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example151.c:1:17: IDENTIFIER "a",
	// · · },
	// · },
	// }
}

func ExampleDesignation() {
	fmt.Println(exampleAST(207, "\U00100002 auto a = { . b = !"))
	// Output:
	// &cc.Designation{
	// · DesignatorList: &cc.DesignatorList{
	// · · Designator: &cc.Designator{
	// · · · Case: 1,
	// · · · Token: example207.c:1:13: '.',
	// · · · Token2: example207.c:1:15: IDENTIFIER "b",
	// · · },
	// · },
	// · Token: example207.c:1:17: '=',
	// }
}

func ExampleDesignationOpt() {
	fmt.Println(exampleAST(208, "\U00100002 auto a = { !") == (*DesignationOpt)(nil))
	// Output:
	// true
}

func ExampleDesignationOpt_case1() {
	fmt.Println(exampleAST(209, "\U00100002 auto a = { . b = !"))
	// Output:
	// &cc.DesignationOpt{
	// · Designation: &cc.Designation{
	// · · DesignatorList: &cc.DesignatorList{
	// · · · Designator: &cc.Designator{
	// · · · · Case: 1,
	// · · · · Token: example209.c:1:13: '.',
	// · · · · Token2: example209.c:1:15: IDENTIFIER "b",
	// · · · },
	// · · },
	// · · Token: example209.c:1:17: '=',
	// · },
	// }
}

func ExampleDesignator() {
	fmt.Println(exampleAST(212, "\U00100002 auto a = { [ 'b' ] ."))
	// Output:
	// &cc.Designator{
	// · ConstantExpression: &cc.ConstantExpression{
	// · · Type: int,
	// · · Value: 98,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 98,
	// · · · Case: 1,
	// · · · Token: example212.c:1:15: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: example212.c:1:13: '[',
	// · Token2: example212.c:1:19: ']',
	// }
}

func ExampleDesignator_case1() {
	fmt.Println(exampleAST(213, "\U00100002 auto a = { . b ."))
	// Output:
	// &cc.Designator{
	// · Case: 1,
	// · Token: example213.c:1:13: '.',
	// · Token2: example213.c:1:15: IDENTIFIER "b",
	// }
}

func ExampleDesignatorList() {
	fmt.Println(exampleAST(210, "\U00100002 auto a = { . b ."))
	// Output:
	// &cc.DesignatorList{
	// · Designator: &cc.Designator{
	// · · Case: 1,
	// · · Token: example210.c:1:13: '.',
	// · · Token2: example210.c:1:15: IDENTIFIER "b",
	// · },
	// }
}

func ExampleDesignatorList_case1() {
	fmt.Println(exampleAST(211, "\U00100002 auto a = { . b . c ."))
	// Output:
	// &cc.DesignatorList{
	// · Designator: &cc.Designator{
	// · · Case: 1,
	// · · Token: example211.c:1:13: '.',
	// · · Token2: example211.c:1:15: IDENTIFIER "b",
	// · },
	// · DesignatorList: &cc.DesignatorList{
	// · · Case: 1,
	// · · Designator: &cc.Designator{
	// · · · Case: 1,
	// · · · Token: example211.c:1:17: '.',
	// · · · Token2: example211.c:1:19: IDENTIFIER "c",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator() {
	fmt.Println(exampleAST(189, "\U00100001 ( _Bool ( * ) ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · AbstractDeclarator: &cc.AbstractDeclarator{
	// · · Pointer: &cc.Pointer{
	// · · · Token: example189.c:1:12: '*',
	// · · },
	// · },
	// · Token: example189.c:1:10: '(',
	// · Token2: example189.c:1:14: ')',
	// }
}

func ExampleDirectAbstractDeclarator_case1() {
	fmt.Println(exampleAST(190, "\U00100001 ( _Bool [ ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 1,
	// · Token: example190.c:1:10: '[',
	// · Token2: example190.c:1:12: ']',
	// }
}

func ExampleDirectAbstractDeclarator_case2() {
	fmt.Println(exampleAST(191, "\U00100001 ( _Bool [ const ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 2,
	// · Token: example191.c:1:10: '[',
	// · Token2: example191.c:1:18: ']',
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: example191.c:1:12: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_case3() {
	fmt.Println(exampleAST(192, "\U00100001 ( _Bool [ static 'a' ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 3,
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 97,
	// · · Case: 1,
	// · · Token: example192.c:1:19: CHARCONST "'a'",
	// · },
	// · Token: example192.c:1:10: '[',
	// · Token2: example192.c:1:12: STATIC "static",
	// · Token3: example192.c:1:23: ']',
	// }
}

func ExampleDirectAbstractDeclarator_case4() {
	fmt.Println(exampleAST(193, "\U00100001 ( _Bool [ const static 'a' ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 4,
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 97,
	// · · Case: 1,
	// · · Token: example193.c:1:25: CHARCONST "'a'",
	// · },
	// · Token: example193.c:1:10: '[',
	// · Token2: example193.c:1:18: STATIC "static",
	// · Token3: example193.c:1:29: ']',
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: example193.c:1:12: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectAbstractDeclarator_case5() {
	fmt.Println(exampleAST(194, "\U00100001 ( _Bool [ * ] ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 5,
	// · Token: example194.c:1:10: '[',
	// · Token2: example194.c:1:12: '*',
	// · Token3: example194.c:1:14: ']',
	// }
}

func ExampleDirectAbstractDeclarator_case6() {
	fmt.Println(exampleAST(196, "\U00100001 ( _Bool ( ) ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 6,
	// · Token: example196.c:1:10: '(',
	// · Token2: example196.c:1:12: ')',
	// }
}

func ExampleDirectAbstractDeclarator_case7() {
	fmt.Println(exampleAST(198, "\U00100001 ( _Bool ( ) ( ) ("))
	// Output:
	// &cc.DirectAbstractDeclarator{
	// · Case: 7,
	// · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · Case: 6,
	// · · Token: example198.c:1:10: '(',
	// · · Token2: example198.c:1:12: ')',
	// · },
	// · Token: example198.c:1:14: '(',
	// · Token2: example198.c:1:16: ')',
	// }
}

func ExampleDirectAbstractDeclaratorOpt() {
	fmt.Println(exampleAST(199, "\U00100001 ( _Bool [") == (*DirectAbstractDeclaratorOpt)(nil))
	// Output:
	// true
}

func ExampleDirectAbstractDeclaratorOpt_case1() {
	fmt.Println(exampleAST(200, "\U00100001 ( _Bool ( ) ["))
	// Output:
	// &cc.DirectAbstractDeclaratorOpt{
	// · DirectAbstractDeclarator: &cc.DirectAbstractDeclarator{
	// · · Case: 6,
	// · · Token: example200.c:1:10: '(',
	// · · Token2: example200.c:1:12: ')',
	// · },
	// }
}

func ExampleDirectDeclarator() {
	fmt.Println(exampleAST(152, "\U00100002 a ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Token: example152.c:1:2: IDENTIFIER "a",
	// }
}

func ExampleDirectDeclarator_case1() {
	fmt.Println(exampleAST(153, "\U00100002 ( a ) ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: 1,
	// · Declarator: &cc.Declarator{
	// · · Linkage: None,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example153.c:1:4: IDENTIFIER "a",
	// · · },
	// · },
	// · Token: example153.c:1:2: '(',
	// · Token2: example153.c:1:6: ')',
	// }
}

func ExampleDirectDeclarator_case2() {
	fmt.Println(exampleAST(154, "\U00100002 a [ ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: 2,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Token: example154.c:1:2: IDENTIFIER "a",
	// · },
	// · Token: example154.c:1:4: '[',
	// · Token2: example154.c:1:6: ']',
	// }
}

func ExampleDirectDeclarator_case3() {
	fmt.Println(exampleAST(155, "\U00100002 a [ static 'b' ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: 3,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Token: example155.c:1:2: IDENTIFIER "a",
	// · },
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 98,
	// · · Case: 1,
	// · · Token: example155.c:1:13: CHARCONST "'b'",
	// · },
	// · Token: example155.c:1:4: '[',
	// · Token2: example155.c:1:6: STATIC "static",
	// · Token3: example155.c:1:17: ']',
	// }
}

func ExampleDirectDeclarator_case4() {
	fmt.Println(exampleAST(156, "\U00100002 a [ const static 'b' ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: 4,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Token: example156.c:1:2: IDENTIFIER "a",
	// · },
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 98,
	// · · Case: 1,
	// · · Token: example156.c:1:19: CHARCONST "'b'",
	// · },
	// · Token: example156.c:1:4: '[',
	// · Token2: example156.c:1:12: STATIC "static",
	// · Token3: example156.c:1:23: ']',
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: example156.c:1:6: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleDirectDeclarator_case5() {
	fmt.Println(exampleAST(157, "\U00100002 a [ * ] ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: 5,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Token: example157.c:1:2: IDENTIFIER "a",
	// · },
	// · Token: example157.c:1:4: '[',
	// · Token2: example157.c:1:6: '*',
	// · Token3: example157.c:1:8: ']',
	// }
}

func ExampleDirectDeclarator_case6() {
	fmt.Println(exampleAST(159, "\U00100002 a ( auto ) ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: 6,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Token: example159.c:1:2: IDENTIFIER "a",
	// · },
	// · ParameterTypeList: &cc.ParameterTypeList{
	// · · ParameterList: &cc.ParameterList{
	// · · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · · Case: 1,
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · Case: 3,
	// · · · · · · Token: example159.c:1:6: AUTO "auto",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example159.c:1:4: '(',
	// · Token2: example159.c:1:11: ')',
	// }
}

func ExampleDirectDeclarator_case7() {
	fmt.Println(exampleAST(160, "\U00100002 a ( ) ("))
	// Output:
	// &cc.DirectDeclarator{
	// · Case: 7,
	// · DirectDeclarator: &cc.DirectDeclarator{
	// · · Token: example160.c:1:2: IDENTIFIER "a",
	// · },
	// · Token: example160.c:1:4: '(',
	// · Token2: example160.c:1:6: ')',
	// }
}

func ExampleElifGroup() {
	fmt.Println(exampleAST(302, "\U00100000 \n#if other_a  \n#elif other_b  \n#elif"))
	// Output:
	// &cc.ElifGroup{
	// · PPTokenList: []xc.Token{ // len 4
	// · · 0: example302.c:3:6: ' ',
	// · · 1: example302.c:3:7: IDENTIFIER "other_b",
	// · · 2: example302.c:3:14: ' ',
	// · · 3: example302.c:3:16: ' ',
	// · },
	// · Token: example302.c:3:2: PPELIF,
	// · Token2: example302.c:3:16: '\n',
	// }
}

func ExampleElifGroupList() {
	fmt.Println(exampleAST(298, "\U00100000 \n#if other_a  \n#elif other_b  \n#elif"))
	// Output:
	// &cc.ElifGroupList{
	// · ElifGroup: &cc.ElifGroup{
	// · · PPTokenList: []xc.Token{ // len 4
	// · · · 0: example298.c:3:6: ' ',
	// · · · 1: example298.c:3:7: IDENTIFIER "other_b",
	// · · · 2: example298.c:3:14: ' ',
	// · · · 3: example298.c:3:16: ' ',
	// · · },
	// · · Token: example298.c:3:2: PPELIF,
	// · · Token2: example298.c:3:16: '\n',
	// · },
	// }
}

func ExampleElifGroupList_case1() {
	fmt.Println(exampleAST(299, "\U00100000 \n#if other_a  \n#elif other_b  \n#elif other_c  \n#elif"))
	// Output:
	// &cc.ElifGroupList{
	// · ElifGroup: &cc.ElifGroup{
	// · · PPTokenList: []xc.Token{ // len 4
	// · · · 0: example299.c:3:6: ' ',
	// · · · 1: example299.c:3:7: IDENTIFIER "other_b",
	// · · · 2: example299.c:3:14: ' ',
	// · · · 3: example299.c:3:16: ' ',
	// · · },
	// · · Token: example299.c:3:2: PPELIF,
	// · · Token2: example299.c:3:16: '\n',
	// · },
	// · ElifGroupList: &cc.ElifGroupList{
	// · · Case: 1,
	// · · ElifGroup: &cc.ElifGroup{
	// · · · PPTokenList: []xc.Token{ // len 4
	// · · · · 0: example299.c:4:6: ' ',
	// · · · · 1: example299.c:4:7: IDENTIFIER "other_c",
	// · · · · 2: example299.c:4:14: ' ',
	// · · · · 3: example299.c:4:16: ' ',
	// · · · },
	// · · · Token: example299.c:4:2: PPELIF,
	// · · · Token2: example299.c:4:16: '\n',
	// · · },
	// · },
	// }
}

func ExampleElifGroupListOpt() {
	fmt.Println(exampleAST(300, "\U00100000 \n#if other_a  \n#else") == (*ElifGroupListOpt)(nil))
	// Output:
	// true
}

func ExampleElifGroupListOpt_case1() {
	fmt.Println(exampleAST(301, "\U00100000 \n#if other_a  \n#elif other_b  \n#else"))
	// Output:
	// &cc.ElifGroupListOpt{
	// · ElifGroupList: &cc.ElifGroupList{
	// · · ElifGroup: &cc.ElifGroup{
	// · · · PPTokenList: []xc.Token{ // len 4
	// · · · · 0: example301.c:3:6: ' ',
	// · · · · 1: example301.c:3:7: IDENTIFIER "other_b",
	// · · · · 2: example301.c:3:14: ' ',
	// · · · · 3: example301.c:3:16: ' ',
	// · · · },
	// · · · Token: example301.c:3:2: PPELIF,
	// · · · Token2: example301.c:3:16: '\n',
	// · · },
	// · },
	// }
}

func ExampleElseGroup() {
	fmt.Println(exampleAST(303, "\U00100000 \n#if other_a  \n#else  \n#endif"))
	// Output:
	// &cc.ElseGroup{
	// · Token: example303.c:3:2: PPELSE,
	// · Token2: example303.c:3:8: '\n',
	// }
}

func ExampleElseGroupOpt() {
	fmt.Println(exampleAST(304, "\U00100000 \n#if other_a  \n#endif") == (*ElseGroupOpt)(nil))
	// Output:
	// true
}

func ExampleElseGroupOpt_case1() {
	fmt.Println(exampleAST(305, "\U00100000 \n#if other_a  \n#else  \n#endif"))
	// Output:
	// &cc.ElseGroupOpt{
	// · ElseGroup: &cc.ElseGroup{
	// · · Token: example305.c:3:2: PPELSE,
	// · · Token2: example305.c:3:8: '\n',
	// · },
	// }
}

func ExampleEndifLine() {
	fmt.Println(exampleAST(306, "\U00100000 \n#if other_a  \n#endif"))
	// Output:
	// &cc.EndifLine{
	// · Token: example306.c:3:2: PPENDIF,
	// }
}

func ExampleEnumSpecifier() {
	fmt.Println(exampleAST(138, "\U00100002 enum { a } ("))
	// Output:
	// &cc.EnumSpecifier{
	// · EnumeratorList: &cc.EnumeratorList{
	// · · Enumerator: &cc.Enumerator{
	// · · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · · Token: example138.c:1:9: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// · Token: example138.c:1:2: ENUM "enum",
	// · Token2: example138.c:1:7: '{',
	// · Token3: example138.c:1:11: '}',
	// }
}

func ExampleEnumSpecifier_case1() {
	fmt.Println(exampleAST(139, "\U00100002 enum a ("))
	// Output:
	// &cc.EnumSpecifier{
	// · Case: 1,
	// · Token: example139.c:1:2: ENUM "enum",
	// · Token2: example139.c:1:7: IDENTIFIER "a",
	// }
}

func ExampleEnumerationConstant() {
	fmt.Println(exampleAST(7, "\U00100002 enum { a ,"))
	// Output:
	// &cc.EnumerationConstant{
	// · Token: example7.c:1:9: IDENTIFIER "a",
	// }
}

func ExampleEnumerator() {
	fmt.Println(exampleAST(142, "\U00100002 enum { a ,"))
	// Output:
	// &cc.Enumerator{
	// · EnumerationConstant: &cc.EnumerationConstant{
	// · · Token: example142.c:1:9: IDENTIFIER "a",
	// · },
	// }
}

func ExampleEnumerator_case1() {
	fmt.Println(exampleAST(143, "\U00100002 enum { a = 'b' ,"))
	// Output:
	// &cc.Enumerator{
	// · Value: 98,
	// · Case: 1,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · Type: int,
	// · · Value: 98,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 98,
	// · · · Case: 1,
	// · · · Token: example143.c:1:13: CHARCONST "'b'",
	// · · },
	// · },
	// · EnumerationConstant: &cc.EnumerationConstant{
	// · · Token: example143.c:1:9: IDENTIFIER "a",
	// · },
	// · Token: example143.c:1:11: '=',
	// }
}

func ExampleEnumeratorList() {
	fmt.Println(exampleAST(140, "\U00100002 enum { a ,"))
	// Output:
	// &cc.EnumeratorList{
	// · Enumerator: &cc.Enumerator{
	// · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · Token: example140.c:1:9: IDENTIFIER "a",
	// · · },
	// · },
	// }
}

func ExampleEnumeratorList_case1() {
	fmt.Println(exampleAST(141, "\U00100002 enum { a , b ,"))
	// Output:
	// &cc.EnumeratorList{
	// · Enumerator: &cc.Enumerator{
	// · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · Token: example141.c:1:9: IDENTIFIER "a",
	// · · },
	// · },
	// · EnumeratorList: &cc.EnumeratorList{
	// · · Case: 1,
	// · · Enumerator: &cc.Enumerator{
	// · · · Value: 1,
	// · · · EnumerationConstant: &cc.EnumerationConstant{
	// · · · · Token: example141.c:1:13: IDENTIFIER "b",
	// · · · },
	// · · },
	// · · Token: example141.c:1:11: ',',
	// · },
	// }
}

func ExampleExpression() {
	fmt.Println(exampleAST(12, "\U00100001 a"))
	// Output:
	// &cc.Expression{
	// · Token: example12.c:1:2: IDENTIFIER "a",
	// }
}

func ExampleExpression_case01() {
	fmt.Println(exampleAST(13, "\U00100001 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 1,
	// · Token: example13.c:1:2: CHARCONST "'a'",
	// }
}

func ExampleExpression_case02() {
	fmt.Println(exampleAST(14, "\U00100001 1.97"))
	// Output:
	// &cc.Expression{
	// · Case: 2,
	// · Token: example14.c:1:2: FLOATCONST "1.97",
	// }
}

func ExampleExpression_case03() {
	fmt.Println(exampleAST(15, "\U00100001 97"))
	// Output:
	// &cc.Expression{
	// · Case: 3,
	// · Token: example15.c:1:2: INTCONST "97",
	// }
}

func ExampleExpression_case04() {
	fmt.Println(exampleAST(16, "\U00100001 L'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 4,
	// · Token: example16.c:1:2: LONGCHARCONST "L'a'",
	// }
}

func ExampleExpression_case05() {
	fmt.Println(exampleAST(17, "\U00100001 L\"a\""))
	// Output:
	// &cc.Expression{
	// · Case: 5,
	// · Token: example17.c:1:2: LONGSTRINGLITERAL "L\"a\"",
	// }
}

func ExampleExpression_case06() {
	fmt.Println(exampleAST(18, "\U00100001 \"a\""))
	// Output:
	// &cc.Expression{
	// · Case: 6,
	// · Token: example18.c:1:2: STRINGLITERAL "\"a\"",
	// }
}

func ExampleExpression_case07() {
	fmt.Println(exampleAST(19, "\U00100001 ( 'a' )"))
	// Output:
	// &cc.Expression{
	// · Case: 7,
	// · ExpressionList: &cc.ExpressionList{
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example19.c:1:4: CHARCONST "'a'",
	// · · },
	// · },
	// · Token: example19.c:1:2: '(',
	// · Token2: example19.c:1:8: ')',
	// }
}

func ExampleExpression_case08() {
	fmt.Println(exampleAST(20, "\U00100001 'a' [ 'b' ]"))
	// Output:
	// &cc.Expression{
	// · Case: 8,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example20.c:1:2: CHARCONST "'a'",
	// · },
	// · ExpressionList: &cc.ExpressionList{
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example20.c:1:8: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: example20.c:1:6: '[',
	// · Token2: example20.c:1:12: ']',
	// }
}

func ExampleExpression_case09() {
	fmt.Println(exampleAST(21, "\U00100001 'a' ( )"))
	// Output:
	// &cc.Expression{
	// · Case: 9,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example21.c:1:2: CHARCONST "'a'",
	// · },
	// · Token: example21.c:1:6: '(',
	// · Token2: example21.c:1:8: ')',
	// }
}

func ExampleExpression_case10() {
	fmt.Println(exampleAST(22, "\U00100001 'a' . b"))
	// Output:
	// &cc.Expression{
	// · Case: 10,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example22.c:1:2: CHARCONST "'a'",
	// · },
	// · Token: example22.c:1:6: '.',
	// · Token2: example22.c:1:8: IDENTIFIER "b",
	// }
}

func ExampleExpression_case11() {
	fmt.Println(exampleAST(23, "\U00100001 'a' -> b"))
	// Output:
	// &cc.Expression{
	// · Case: 11,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example23.c:1:2: CHARCONST "'a'",
	// · },
	// · Token: example23.c:1:6: ARROW,
	// · Token2: example23.c:1:9: IDENTIFIER "b",
	// }
}

func ExampleExpression_case12() {
	fmt.Println(exampleAST(24, "\U00100001 'a' ++"))
	// Output:
	// &cc.Expression{
	// · Case: 12,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example24.c:1:2: CHARCONST "'a'",
	// · },
	// · Token: example24.c:1:6: INC,
	// }
}

func ExampleExpression_case13() {
	fmt.Println(exampleAST(25, "\U00100001 'a' --"))
	// Output:
	// &cc.Expression{
	// · Case: 13,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example25.c:1:2: CHARCONST "'a'",
	// · },
	// · Token: example25.c:1:6: DEC,
	// }
}

func ExampleExpression_case14() {
	fmt.Println(exampleAST(26, "\U00100001 ( _Bool ) { }"))
	// Output:
	// &cc.Expression{
	// · Case: 14,
	// · Token: example26.c:1:2: '(',
	// · Token2: example26.c:1:10: ')',
	// · Token3: example26.c:1:12: '{',
	// · Token4: example26.c:1:14: '}',
	// · TypeName: &cc.TypeName{
	// · · Type: bool,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: 9,
	// · · · · Token: example26.c:1:4: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpression_case15() {
	fmt.Println(exampleAST(27, "\U00100001 ++ 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 15,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example27.c:1:5: CHARCONST "'a'",
	// · },
	// · Token: example27.c:1:2: INC,
	// }
}

func ExampleExpression_case16() {
	fmt.Println(exampleAST(28, "\U00100001 -- 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 16,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example28.c:1:5: CHARCONST "'a'",
	// · },
	// · Token: example28.c:1:2: DEC,
	// }
}

func ExampleExpression_case17() {
	fmt.Println(exampleAST(29, "\U00100001 & 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 17,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example29.c:1:4: CHARCONST "'a'",
	// · },
	// · Token: example29.c:1:2: '&',
	// }
}

func ExampleExpression_case18() {
	fmt.Println(exampleAST(30, "\U00100001 * 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 18,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example30.c:1:4: CHARCONST "'a'",
	// · },
	// · Token: example30.c:1:2: '*',
	// }
}

func ExampleExpression_case19() {
	fmt.Println(exampleAST(31, "\U00100001 + 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 19,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example31.c:1:4: CHARCONST "'a'",
	// · },
	// · Token: example31.c:1:2: '+',
	// }
}

func ExampleExpression_case20() {
	fmt.Println(exampleAST(32, "\U00100001 - 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 20,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example32.c:1:4: CHARCONST "'a'",
	// · },
	// · Token: example32.c:1:2: '-',
	// }
}

func ExampleExpression_case21() {
	fmt.Println(exampleAST(33, "\U00100001 ~ 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 21,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example33.c:1:4: CHARCONST "'a'",
	// · },
	// · Token: example33.c:1:2: '~',
	// }
}

func ExampleExpression_case22() {
	fmt.Println(exampleAST(34, "\U00100001 ! 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 22,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example34.c:1:4: CHARCONST "'a'",
	// · },
	// · Token: example34.c:1:2: '!',
	// }
}

func ExampleExpression_case23() {
	fmt.Println(exampleAST(35, "\U00100001 sizeof 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 23,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example35.c:1:9: CHARCONST "'a'",
	// · },
	// · Token: example35.c:1:2: SIZEOF "sizeof",
	// }
}

func ExampleExpression_case24() {
	fmt.Println(exampleAST(36, "\U00100001 sizeof ( _Bool )"))
	// Output:
	// &cc.Expression{
	// · Case: 24,
	// · Token: example36.c:1:2: SIZEOF "sizeof",
	// · Token2: example36.c:1:9: '(',
	// · Token3: example36.c:1:17: ')',
	// · TypeName: &cc.TypeName{
	// · · Type: bool,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: 9,
	// · · · · Token: example36.c:1:11: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpression_case25() {
	fmt.Println(exampleAST(37, "\U00100001 ( _Bool ) 'a'"))
	// Output:
	// &cc.Expression{
	// · Case: 25,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example37.c:1:12: CHARCONST "'a'",
	// · },
	// · Token: example37.c:1:2: '(',
	// · Token2: example37.c:1:10: ')',
	// · TypeName: &cc.TypeName{
	// · · Type: bool,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: 9,
	// · · · · Token: example37.c:1:4: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpression_case26() {
	fmt.Println(exampleAST(38, "\U00100001 'a' * 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 26,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example38.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example38.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example38.c:1:6: '*',
	// }
}

func ExampleExpression_case27() {
	fmt.Println(exampleAST(39, "\U00100001 'a' / 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 27,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example39.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example39.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example39.c:1:6: '/',
	// }
}

func ExampleExpression_case28() {
	fmt.Println(exampleAST(40, "\U00100001 'a' % 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 28,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example40.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example40.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example40.c:1:6: '%',
	// }
}

func ExampleExpression_case29() {
	fmt.Println(exampleAST(41, "\U00100001 'a' + 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 29,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example41.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example41.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example41.c:1:6: '+',
	// }
}

func ExampleExpression_case30() {
	fmt.Println(exampleAST(42, "\U00100001 'a' - 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 30,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example42.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example42.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example42.c:1:6: '-',
	// }
}

func ExampleExpression_case31() {
	fmt.Println(exampleAST(43, "\U00100001 'a' << 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 31,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example43.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example43.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example43.c:1:6: LSH,
	// }
}

func ExampleExpression_case32() {
	fmt.Println(exampleAST(44, "\U00100001 'a' >> 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 32,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example44.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example44.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example44.c:1:6: RSH,
	// }
}

func ExampleExpression_case33() {
	fmt.Println(exampleAST(45, "\U00100001 'a' < 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 33,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example45.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example45.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example45.c:1:6: '<',
	// }
}

func ExampleExpression_case34() {
	fmt.Println(exampleAST(46, "\U00100001 'a' > 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 34,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example46.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example46.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example46.c:1:6: '>',
	// }
}

func ExampleExpression_case35() {
	fmt.Println(exampleAST(47, "\U00100001 'a' <= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 35,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example47.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example47.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example47.c:1:6: LEQ,
	// }
}

func ExampleExpression_case36() {
	fmt.Println(exampleAST(48, "\U00100001 'a' >= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 36,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example48.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example48.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example48.c:1:6: GEQ,
	// }
}

func ExampleExpression_case37() {
	fmt.Println(exampleAST(49, "\U00100001 'a' == 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 37,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example49.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example49.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example49.c:1:6: EQ,
	// }
}

func ExampleExpression_case38() {
	fmt.Println(exampleAST(50, "\U00100001 'a' != 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 38,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example50.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example50.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example50.c:1:6: NEQ,
	// }
}

func ExampleExpression_case39() {
	fmt.Println(exampleAST(51, "\U00100001 'a' & 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 39,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example51.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example51.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example51.c:1:6: '&',
	// }
}

func ExampleExpression_case40() {
	fmt.Println(exampleAST(52, "\U00100001 'a' ^ 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 40,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example52.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example52.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example52.c:1:6: '^',
	// }
}

func ExampleExpression_case41() {
	fmt.Println(exampleAST(53, "\U00100001 'a' | 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 41,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example53.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example53.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example53.c:1:6: '|',
	// }
}

func ExampleExpression_case42() {
	fmt.Println(exampleAST(54, "\U00100001 'a' && 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 42,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example54.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example54.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example54.c:1:6: ANDAND,
	// }
}

func ExampleExpression_case43() {
	fmt.Println(exampleAST(55, "\U00100001 'a' || 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 43,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example55.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example55.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example55.c:1:6: OROR,
	// }
}

func ExampleExpression_case44() {
	fmt.Println(exampleAST(56, "\U00100001 'a' ? 'b' : 'c'"))
	// Output:
	// &cc.Expression{
	// · Case: 44,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example56.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example56.c:1:14: CHARCONST "'c'",
	// · },
	// · ExpressionList: &cc.ExpressionList{
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example56.c:1:8: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: example56.c:1:6: '?',
	// · Token2: example56.c:1:12: ':',
	// }
}

func ExampleExpression_case45() {
	fmt.Println(exampleAST(57, "\U00100001 'a' = 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 45,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example57.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example57.c:1:8: CHARCONST "'b'",
	// · },
	// · Token: example57.c:1:6: '=',
	// }
}

func ExampleExpression_case46() {
	fmt.Println(exampleAST(58, "\U00100001 'a' *= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 46,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example58.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example58.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example58.c:1:6: MULASSIGN,
	// }
}

func ExampleExpression_case47() {
	fmt.Println(exampleAST(59, "\U00100001 'a' /= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 47,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example59.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example59.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example59.c:1:6: DIVASSIGN,
	// }
}

func ExampleExpression_case48() {
	fmt.Println(exampleAST(60, "\U00100001 'a' %= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 48,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example60.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example60.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example60.c:1:6: MODASSIGN,
	// }
}

func ExampleExpression_case49() {
	fmt.Println(exampleAST(61, "\U00100001 'a' += 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 49,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example61.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example61.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example61.c:1:6: ADDASSIGN,
	// }
}

func ExampleExpression_case50() {
	fmt.Println(exampleAST(62, "\U00100001 'a' -= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 50,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example62.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example62.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example62.c:1:6: SUBASSIGN,
	// }
}

func ExampleExpression_case51() {
	fmt.Println(exampleAST(63, "\U00100001 'a' <<= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 51,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example63.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example63.c:1:10: CHARCONST "'b'",
	// · },
	// · Token: example63.c:1:6: LSHASSIGN,
	// }
}

func ExampleExpression_case52() {
	fmt.Println(exampleAST(64, "\U00100001 'a' >>= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 52,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example64.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example64.c:1:10: CHARCONST "'b'",
	// · },
	// · Token: example64.c:1:6: RSHASSIGN,
	// }
}

func ExampleExpression_case53() {
	fmt.Println(exampleAST(65, "\U00100001 'a' &= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 53,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example65.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example65.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example65.c:1:6: ANDASSIGN,
	// }
}

func ExampleExpression_case54() {
	fmt.Println(exampleAST(66, "\U00100001 'a' ^= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 54,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example66.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example66.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example66.c:1:6: XORASSIGN,
	// }
}

func ExampleExpression_case55() {
	fmt.Println(exampleAST(67, "\U00100001 'a' |= 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 55,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example67.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example67.c:1:9: CHARCONST "'b'",
	// · },
	// · Token: example67.c:1:6: ORASSIGN,
	// }
}

func ExampleExpression_case56() {
	fmt.Println(exampleAST(68, "\U00100001 _Alignof ( _Bool )"))
	// Output:
	// &cc.Expression{
	// · Case: 56,
	// · Token: example68.c:1:2: ALIGNOF "_Alignof",
	// · Token2: example68.c:1:11: '(',
	// · Token3: example68.c:1:19: ')',
	// · TypeName: &cc.TypeName{
	// · · Type: bool,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: 9,
	// · · · · Token: example68.c:1:13: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExpression_case57() {
	fmt.Println(exampleAST(69, "\U00100001 ( { } )"))
	// Output:
	// &cc.Expression{
	// · Case: 57,
	// · CompoundStatement: &cc.CompoundStatement{
	// · · Token: example69.c:1:4: '{',
	// · · Token2: example69.c:1:6: '}',
	// · },
	// · Token: example69.c:1:2: '(',
	// · Token2: example69.c:1:8: ')',
	// }
}

func ExampleExpression_case58() {
	fmt.Println(exampleAST(70, "\U00100001 && a"))
	// Output:
	// &cc.Expression{
	// · Case: 58,
	// · Token: example70.c:1:2: ANDAND,
	// · Token2: example70.c:1:5: IDENTIFIER "a",
	// }
}

func ExampleExpression_case59() {
	fmt.Println(exampleAST(71, "\U00100001 'a' ? : 'b'"))
	// Output:
	// &cc.Expression{
	// · Case: 59,
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example71.c:1:2: CHARCONST "'a'",
	// · },
	// · Expression2: &cc.Expression{
	// · · Case: 1,
	// · · Token: example71.c:1:10: CHARCONST "'b'",
	// · },
	// · Token: example71.c:1:6: '?',
	// · Token2: example71.c:1:8: ':',
	// }
}

func ExampleExpressionList() {
	fmt.Println(exampleAST(74, "\U00100001 ( 'a' )"))
	// Output:
	// &cc.ExpressionList{
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example74.c:1:4: CHARCONST "'a'",
	// · },
	// }
}

func ExampleExpressionList_case1() {
	fmt.Println(exampleAST(75, "\U00100001 ( 'a' , 'b' )"))
	// Output:
	// &cc.ExpressionList{
	// · Expression: &cc.Expression{
	// · · Case: 1,
	// · · Token: example75.c:1:4: CHARCONST "'a'",
	// · },
	// · ExpressionList: &cc.ExpressionList{
	// · · Case: 1,
	// · · Expression: &cc.Expression{
	// · · · Case: 1,
	// · · · Token: example75.c:1:10: CHARCONST "'b'",
	// · · },
	// · · Token: example75.c:1:8: ',',
	// · },
	// }
}

func ExampleExpressionListOpt() {
	fmt.Println(exampleAST(76, "\U00100001 ( { ;") == (*ExpressionListOpt)(nil))
	// Output:
	// true
}

func ExampleExpressionListOpt_case1() {
	fmt.Println(exampleAST(77, "\U00100001 ( { 'a' )"))
	// Output:
	// &cc.ExpressionListOpt{
	// · ExpressionList: &cc.ExpressionList{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example77.c:1:6: CHARCONST "'a'",
	// · · },
	// · },
	// }
}

func ExampleExpressionOpt() {
	fmt.Println(exampleAST(72, "\U00100001 ( _Bool [ ]") == (*ExpressionOpt)(nil))
	// Output:
	// true
}

func ExampleExpressionOpt_case1() {
	fmt.Println(exampleAST(73, "\U00100002 a [ 'b' ]"))
	// Output:
	// &cc.ExpressionOpt{
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 98,
	// · · Case: 1,
	// · · Token: example73.c:1:6: CHARCONST "'b'",
	// · },
	// }
}

func ExampleExpressionStatement() {
	fmt.Println(exampleAST(232, "\U00100001 ( { ; !"))
	// Output:
	// &cc.ExpressionStatement{
	// · Token: example232.c:1:6: ';',
	// }
}

func ExampleExternalDeclaration() {
	fmt.Println(exampleAST(247, "\U00100002 a { }"))
	// Output:
	// &cc.ExternalDeclaration{
	// · FunctionDefinition: &cc.FunctionDefinition{
	// · · Case: 1,
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: External,
	// · · · Type: int,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Token: example247.c:1:2: IDENTIFIER "a",
	// · · · },
	// · · },
	// · · FunctionBody: &cc.FunctionBody{
	// · · · CompoundStatement: &cc.CompoundStatement{
	// · · · · Token: example247.c:1:4: '{',
	// · · · · Token2: example247.c:1:6: '}',
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleExternalDeclaration_case1() {
	fmt.Println(exampleAST(248, "\U00100002 auto ;"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Case: 1,
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: example248.c:1:2: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: example248.c:1:7: ';',
	// · },
	// }
}

func ExampleExternalDeclaration_case2() {
	fmt.Println(exampleAST(249, "\U00100002 asm ( \"a\" ) ;"))
	// Output:
	// &cc.ExternalDeclaration{
	// · BasicAssemblerStatement: &cc.BasicAssemblerStatement{
	// · · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · · Token: example249.c:1:8: STRINGLITERAL "\"a\"",
	// · · },
	// · · Token: example249.c:1:2: ASM "asm",
	// · · Token2: example249.c:1:6: '(',
	// · · Token3: example249.c:1:12: ')',
	// · },
	// · Case: 2,
	// · Token: example249.c:1:14: ';',
	// }
}

func ExampleExternalDeclaration_case3() {
	fmt.Println(exampleAST(250, "\U00100002 ;"))
	// Output:
	// &cc.ExternalDeclaration{
	// · Case: 3,
	// · Token: example250.c:1:2: ';',
	// }
}

func ExampleFunctionBody() {
	fmt.Println(exampleAST(257, "\U00100002 a { }"))
	// Output:
	// &cc.FunctionBody{
	// · CompoundStatement: &cc.CompoundStatement{
	// · · Token: example257.c:1:4: '{',
	// · · Token2: example257.c:1:6: '}',
	// · },
	// }
}

func ExampleFunctionBody_case1() {
	fmt.Println(exampleAST(259, "\U00100002 a asm ( \"b\" ) ;"))
	// Output:
	// &cc.FunctionBody{
	// · AssemblerStatement: &cc.AssemblerStatement{
	// · · BasicAssemblerStatement: &cc.BasicAssemblerStatement{
	// · · · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · · · Token: example259.c:1:10: STRINGLITERAL "\"b\"",
	// · · · },
	// · · · Token: example259.c:1:4: ASM "asm",
	// · · · Token2: example259.c:1:8: '(',
	// · · · Token3: example259.c:1:14: ')',
	// · · },
	// · },
	// · Case: 1,
	// · Token: example259.c:1:16: ';',
	// }
}

func ExampleFunctionDefinition() {
	fmt.Println(exampleAST(252, "\U00100002 auto a { }"))
	// Output:
	// &cc.FunctionDefinition{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Case: 3,
	// · · · Token: example252.c:1:2: AUTO "auto",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · Linkage: None,
	// · · Type: auto int,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example252.c:1:7: IDENTIFIER "a",
	// · · },
	// · },
	// · FunctionBody: &cc.FunctionBody{
	// · · CompoundStatement: &cc.CompoundStatement{
	// · · · Token: example252.c:1:9: '{',
	// · · · Token2: example252.c:1:11: '}',
	// · · },
	// · },
	// }
}

func ExampleFunctionDefinition_case1() {
	fmt.Println(exampleAST(255, "\U00100002 a { }"))
	// Output:
	// &cc.FunctionDefinition{
	// · Case: 1,
	// · Declarator: &cc.Declarator{
	// · · Linkage: External,
	// · · Type: int,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example255.c:1:2: IDENTIFIER "a",
	// · · },
	// · },
	// · FunctionBody: &cc.FunctionBody{
	// · · CompoundStatement: &cc.CompoundStatement{
	// · · · Token: example255.c:1:4: '{',
	// · · · Token2: example255.c:1:6: '}',
	// · · },
	// · },
	// }
}

func ExampleFunctionSpecifier() {
	fmt.Println(exampleAST(147, "\U00100002 inline ("))
	// Output:
	// &cc.FunctionSpecifier{
	// · Token: example147.c:1:2: INLINE "inline",
	// }
}

func ExampleFunctionSpecifier_case1() {
	fmt.Println(exampleAST(148, "\U00100002 _Noreturn ("))
	// Output:
	// &cc.FunctionSpecifier{
	// · Case: 1,
	// · Token: example148.c:1:2: NORETURN "_Noreturn",
	// }
}

func ExampleGroupList() {
	fmt.Println(exampleAST(286, "\U00100000 "))
	// Output:
	// &cc.GroupList{
	// }
}

func ExampleGroupList_case1() {
	fmt.Println(exampleAST(287, "\U00100000int\nf() {}"))
	// Output:
	// &cc.GroupList{
	// · GroupList: &cc.GroupList{
	// · · Case: 1,
	// · · GroupPart: []xc.Token{ // len 6
	// · · · 0: example287.c:2:1: IDENTIFIER "f",
	// · · · 1: example287.c:2:2: '(',
	// · · · 2: example287.c:2:3: ')',
	// · · · 3: example287.c:2:4: ' ',
	// · · · 4: example287.c:2:5: '{',
	// · · · 5: example287.c:2:6: '}',
	// · · },
	// · },
	// · GroupPart: []xc.Token{ // len 2
	// · · 0: example287.c:1:1: IDENTIFIER "int",
	// · · 1: example287.c:1:4: ' ',
	// · },
	// }
}

func ExampleGroupListOpt() {
	fmt.Println(exampleAST(288, "\U00100000 \n#ifndef a  \n#elif") == (*GroupListOpt)(nil))
	// Output:
	// true
}

func ExampleGroupListOpt_case1() {
	fmt.Println(exampleAST(289, "\U00100000 \n#ifndef a\nb\n#elif"))
	// Output:
	// &cc.GroupListOpt{
	// · GroupList: &cc.GroupList{
	// · · GroupPart: []xc.Token{ // len 2
	// · · · 0: example289.c:3:1: IDENTIFIER "b",
	// · · · 1: example289.c:3:2: ' ',
	// · · },
	// · },
	// }
}

func ExampleIdentifierList() {
	fmt.Println(exampleAST(177, "\U00100002 a ( b )"))
	// Output:
	// &cc.IdentifierList{
	// · Token: example177.c:1:6: IDENTIFIER "b",
	// }
}

func ExampleIdentifierList_case1() {
	fmt.Println(exampleAST(178, "\U00100002 a ( b , c )"))
	// Output:
	// &cc.IdentifierList{
	// · IdentifierList: &cc.IdentifierList{
	// · · Case: 1,
	// · · Token: example178.c:1:8: ',',
	// · · Token2: example178.c:1:10: IDENTIFIER "c",
	// · },
	// · Token: example178.c:1:6: IDENTIFIER "b",
	// }
}

func ExampleIdentifierListOpt() {
	fmt.Println(exampleAST(179, "\U00100002 a ( )") == (*IdentifierListOpt)(nil))
	// Output:
	// true
}

func ExampleIdentifierListOpt_case1() {
	fmt.Println(exampleAST(180, "\U00100002 a ( b )"))
	// Output:
	// &cc.IdentifierListOpt{
	// · IdentifierList: &cc.IdentifierList{
	// · · Token: example180.c:1:6: IDENTIFIER "b",
	// · },
	// }
}

func ExampleIdentifierOpt() {
	fmt.Println(exampleAST(181, "\U00100002 struct {") == (*IdentifierOpt)(nil))
	// Output:
	// true
}

func ExampleIdentifierOpt_case1() {
	fmt.Println(exampleAST(182, "\U00100002 enum a {"))
	// Output:
	// &cc.IdentifierOpt{
	// · Token: example182.c:1:7: IDENTIFIER "a",
	// }
}

func ExampleIfGroup() {
	fmt.Println(exampleAST(295, "\U00100000 \n#if other_a  \n#elif"))
	// Output:
	// &cc.IfGroup{
	// · PPTokenList: []xc.Token{ // len 4
	// · · 0: example295.c:2:4: ' ',
	// · · 1: example295.c:2:5: IDENTIFIER "other_a",
	// · · 2: example295.c:2:12: ' ',
	// · · 3: example295.c:2:14: ' ',
	// · },
	// · Token: example295.c:2:2: PPIF,
	// · Token2: example295.c:2:14: '\n',
	// }
}

func ExampleIfGroup_case1() {
	fmt.Println(exampleAST(296, "\U00100000 \n#ifdef a  \n#elif"))
	// Output:
	// &cc.IfGroup{
	// · Case: 1,
	// · Token: example296.c:2:2: PPIFDEF,
	// · Token2: example296.c:2:8: IDENTIFIER "a",
	// · Token3: example296.c:2:11: '\n',
	// }
}

func ExampleIfGroup_case2() {
	fmt.Println(exampleAST(297, "\U00100000 \n#ifndef a  \n#elif"))
	// Output:
	// &cc.IfGroup{
	// · Case: 2,
	// · Token: example297.c:2:2: PPIFNDEF,
	// · Token2: example297.c:2:9: IDENTIFIER "a",
	// · Token3: example297.c:2:12: '\n',
	// }
}

func ExampleIfSection() {
	fmt.Println(exampleAST(294, "\U00100000 \n#if other_a  \n#endif"))
	// Output:
	// &cc.IfSection{
	// · EndifLine: &cc.EndifLine{
	// · · Token: example294.c:3:2: PPENDIF,
	// · },
	// · IfGroup: &cc.IfGroup{
	// · · PPTokenList: []xc.Token{ // len 4
	// · · · 0: example294.c:2:4: ' ',
	// · · · 1: example294.c:2:5: IDENTIFIER "other_a",
	// · · · 2: example294.c:2:12: ' ',
	// · · · 3: example294.c:2:14: ' ',
	// · · },
	// · · Token: example294.c:2:2: PPIF,
	// · · Token2: example294.c:2:14: '\n',
	// · },
	// }
}

func ExampleInitDeclarator() {
	fmt.Println(exampleAST(92, "\U00100002 a auto b ,"))
	// Output:
	// &cc.InitDeclarator{
	// · Declarator: &cc.Declarator{
	// · · Linkage: None,
	// · · Type: auto undefined,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example92.c:1:9: IDENTIFIER "b",
	// · · },
	// · },
	// }
}

func ExampleInitDeclarator_case1() {
	fmt.Println(exampleAST(94, "\U00100002 auto a = 'b' ,"))
	// Output:
	// &cc.InitDeclarator{
	// · Case: 1,
	// · Declarator: &cc.Declarator{
	// · · Linkage: None,
	// · · Type: auto undefined,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example94.c:1:7: IDENTIFIER "a",
	// · · },
	// · },
	// · Initializer: &cc.Initializer{
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 98,
	// · · · Case: 1,
	// · · · Token: example94.c:1:11: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: example94.c:1:9: '=',
	// }
}

func ExampleInitDeclaratorList() {
	fmt.Println(exampleAST(88, "\U00100002 auto a ,"))
	// Output:
	// &cc.InitDeclaratorList{
	// · InitDeclarator: &cc.InitDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: None,
	// · · · Type: auto undefined,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Token: example88.c:1:7: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleInitDeclaratorList_case1() {
	fmt.Println(exampleAST(89, "\U00100002 auto a , b ,"))
	// Output:
	// &cc.InitDeclaratorList{
	// · InitDeclarator: &cc.InitDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: None,
	// · · · Type: auto undefined,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Token: example89.c:1:7: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · Case: 1,
	// · · InitDeclarator: &cc.InitDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: None,
	// · · · · Type: auto undefined,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Token: example89.c:1:11: IDENTIFIER "b",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example89.c:1:9: ',',
	// · },
	// }
}

func ExampleInitDeclaratorListOpt() {
	fmt.Println(exampleAST(90, "\U00100002 auto ;") == (*InitDeclaratorListOpt)(nil))
	// Output:
	// true
}

func ExampleInitDeclaratorListOpt_case1() {
	fmt.Println(exampleAST(91, "\U00100002 auto a ;"))
	// Output:
	// &cc.InitDeclaratorListOpt{
	// · InitDeclaratorList: &cc.InitDeclaratorList{
	// · · InitDeclarator: &cc.InitDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: None,
	// · · · · Type: auto undefined,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Token: example91.c:1:7: IDENTIFIER "a",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleInitializer() {
	fmt.Println(exampleAST(201, "\U00100002 auto a = 'b' ,"))
	// Output:
	// &cc.Initializer{
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 98,
	// · · Case: 1,
	// · · Token: example201.c:1:11: CHARCONST "'b'",
	// · },
	// }
}

func ExampleInitializer_case1() {
	fmt.Println(exampleAST(202, "\U00100002 auto a = { } ,"))
	// Output:
	// &cc.Initializer{
	// · Case: 1,
	// · Token: example202.c:1:11: '{',
	// · Token2: example202.c:1:13: '}',
	// }
}

func ExampleInitializer_case2() {
	fmt.Println(exampleAST(203, "\U00100002 auto a = b : 'c' ,"))
	// Output:
	// &cc.Initializer{
	// · Case: 2,
	// · Initializer: &cc.Initializer{
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 99,
	// · · · Case: 1,
	// · · · Token: example203.c:1:15: CHARCONST "'c'",
	// · · },
	// · },
	// · Token: example203.c:1:11: IDENTIFIER "b",
	// · Token2: example203.c:1:13: ':',
	// }
}

func ExampleInitializerList() {
	fmt.Println(exampleAST(204, "\U00100002 auto a = { 'b' ,"))
	// Output:
	// &cc.InitializerList{
	// · Initializer: &cc.Initializer{
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 98,
	// · · · Case: 1,
	// · · · Token: example204.c:1:13: CHARCONST "'b'",
	// · · },
	// · },
	// }
}

func ExampleInitializerList_case1() {
	fmt.Println(exampleAST(205, "\U00100002 auto a = { , 'b' ,"))
	// Output:
	// &cc.InitializerList{
	// · Case: 1,
	// · Initializer: &cc.Initializer{
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 98,
	// · · · Case: 1,
	// · · · Token: example205.c:1:15: CHARCONST "'b'",
	// · · },
	// · },
	// · Token: example205.c:1:13: ',',
	// }
}

func ExampleInitializerList_case2() {
	fmt.Println(exampleAST(206, "\U00100002 auto a = { ,") == (*InitializerList)(nil))
	// Output:
	// true
}

func ExampleIterationStatement() {
	fmt.Println(exampleAST(236, "\U00100001 ( { while ( 'a' ) ; !"))
	// Output:
	// &cc.IterationStatement{
	// · ExpressionList: &cc.ExpressionList{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example236.c:1:14: CHARCONST "'a'",
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example236.c:1:20: ';',
	// · · },
	// · },
	// · Token: example236.c:1:6: WHILE "while",
	// · Token2: example236.c:1:12: '(',
	// · Token3: example236.c:1:18: ')',
	// }
}

func ExampleIterationStatement_case1() {
	fmt.Println(exampleAST(237, "\U00100001 ( { do ; while ( 'a' ) ; !"))
	// Output:
	// &cc.IterationStatement{
	// · Case: 1,
	// · ExpressionList: &cc.ExpressionList{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example237.c:1:19: CHARCONST "'a'",
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example237.c:1:9: ';',
	// · · },
	// · },
	// · Token: example237.c:1:6: DO "do",
	// · Token2: example237.c:1:11: WHILE "while",
	// · Token3: example237.c:1:17: '(',
	// · Token4: example237.c:1:23: ')',
	// · Token5: example237.c:1:25: ';',
	// }
}

func ExampleIterationStatement_case2() {
	fmt.Println(exampleAST(238, "\U00100001 ( { for ( ; ; ) ; !"))
	// Output:
	// &cc.IterationStatement{
	// · Case: 2,
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example238.c:1:18: ';',
	// · · },
	// · },
	// · Token: example238.c:1:6: FOR "for",
	// · Token2: example238.c:1:10: '(',
	// · Token3: example238.c:1:12: ';',
	// · Token4: example238.c:1:14: ';',
	// · Token5: example238.c:1:16: ')',
	// }
}

func ExampleIterationStatement_case3() {
	fmt.Println(exampleAST(239, "\U00100001 ( { for ( auto ; ; ) ; !"))
	// Output:
	// &cc.IterationStatement{
	// · Case: 3,
	// · Declaration: &cc.Declaration{
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: example239.c:1:12: AUTO "auto",
	// · · · },
	// · · },
	// · · Token: example239.c:1:17: ';',
	// · },
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example239.c:1:23: ';',
	// · · },
	// · },
	// · Token: example239.c:1:6: FOR "for",
	// · Token2: example239.c:1:10: '(',
	// · Token3: example239.c:1:19: ';',
	// · Token4: example239.c:1:21: ')',
	// }
}

func ExampleJumpStatement() {
	fmt.Println(exampleAST(240, "\U00100001 ( { goto a ; !"))
	// Output:
	// &cc.JumpStatement{
	// · Token: example240.c:1:6: GOTO "goto",
	// · Token2: example240.c:1:11: IDENTIFIER "a",
	// · Token3: example240.c:1:13: ';',
	// }
}

func ExampleJumpStatement_case1() {
	fmt.Println(exampleAST(241, "\U00100001 ( { continue ; !"))
	// Output:
	// &cc.JumpStatement{
	// · Case: 1,
	// · Token: example241.c:1:6: CONTINUE "continue",
	// · Token2: example241.c:1:15: ';',
	// }
}

func ExampleJumpStatement_case2() {
	fmt.Println(exampleAST(242, "\U00100001 ( { break ; !"))
	// Output:
	// &cc.JumpStatement{
	// · Case: 2,
	// · Token: example242.c:1:6: BREAK "break",
	// · Token2: example242.c:1:12: ';',
	// }
}

func ExampleJumpStatement_case3() {
	fmt.Println(exampleAST(243, "\U00100001 ( { return ; !"))
	// Output:
	// &cc.JumpStatement{
	// · Case: 3,
	// · Token: example243.c:1:6: RETURN "return",
	// · Token2: example243.c:1:13: ';',
	// }
}

func ExampleJumpStatement_case4() {
	fmt.Println(exampleAST(244, "\U00100001 ( { goto 'a' ; !"))
	// Output:
	// &cc.JumpStatement{
	// · Case: 4,
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 97,
	// · · Case: 1,
	// · · Token: example244.c:1:11: CHARCONST "'a'",
	// · },
	// · Token: example244.c:1:6: GOTO "goto",
	// · Token2: example244.c:1:15: ';',
	// }
}

func ExampleLabeledStatement() {
	fmt.Println(exampleAST(221, "\U00100001 ( { a : ; !"))
	// Output:
	// &cc.LabeledStatement{
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example221.c:1:10: ';',
	// · · },
	// · },
	// · Token: example221.c:1:6: IDENTIFIER "a",
	// · Token2: example221.c:1:8: ':',
	// }
}

func ExampleLabeledStatement_case1() {
	fmt.Println(exampleAST(222, "\U00100001 ( { case 'a' : ; !"))
	// Output:
	// &cc.LabeledStatement{
	// · Case: 1,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example222.c:1:11: CHARCONST "'a'",
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example222.c:1:17: ';',
	// · · },
	// · },
	// · Token: example222.c:1:6: CASE "case",
	// · Token2: example222.c:1:15: ':',
	// }
}

func ExampleLabeledStatement_case2() {
	fmt.Println(exampleAST(223, "\U00100001 ( { default : ; !"))
	// Output:
	// &cc.LabeledStatement{
	// · Case: 2,
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example223.c:1:16: ';',
	// · · },
	// · },
	// · Token: example223.c:1:6: DEFAULT "default",
	// · Token2: example223.c:1:14: ':',
	// }
}

func ExampleParameterDeclaration() {
	fmt.Println(exampleAST(175, "\U00100002 a ( auto b )"))
	// Output:
	// &cc.ParameterDeclaration{
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Case: 3,
	// · · · Token: example175.c:1:6: AUTO "auto",
	// · · },
	// · },
	// · Declarator: &cc.Declarator{
	// · · Linkage: None,
	// · · Type: auto undefined,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example175.c:1:11: IDENTIFIER "b",
	// · · },
	// · },
	// }
}

func ExampleParameterDeclaration_case1() {
	fmt.Println(exampleAST(176, "\U00100002 a ( auto )"))
	// Output:
	// &cc.ParameterDeclaration{
	// · Case: 1,
	// · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · Case: 3,
	// · · · Token: example176.c:1:6: AUTO "auto",
	// · · },
	// · },
	// }
}

func ExampleParameterList() {
	fmt.Println(exampleAST(173, "\U00100002 a ( auto )"))
	// Output:
	// &cc.ParameterList{
	// · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · Case: 1,
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: example173.c:1:6: AUTO "auto",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleParameterList_case1() {
	fmt.Println(exampleAST(174, "\U00100002 a ( auto , auto )"))
	// Output:
	// &cc.ParameterList{
	// · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · Case: 1,
	// · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · Case: 3,
	// · · · · Token: example174.c:1:6: AUTO "auto",
	// · · · },
	// · · },
	// · },
	// · ParameterList: &cc.ParameterList{
	// · · Case: 1,
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · Case: 1,
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: example174.c:1:13: AUTO "auto",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example174.c:1:11: ',',
	// · },
	// }
}

func ExampleParameterTypeList() {
	fmt.Println(exampleAST(169, "\U00100002 a ( auto )"))
	// Output:
	// &cc.ParameterTypeList{
	// · ParameterList: &cc.ParameterList{
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · Case: 1,
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: example169.c:1:6: AUTO "auto",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleParameterTypeList_case1() {
	fmt.Println(exampleAST(170, "\U00100002 a ( auto , ... )"))
	// Output:
	// &cc.ParameterTypeList{
	// · Case: 1,
	// · ParameterList: &cc.ParameterList{
	// · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · Case: 1,
	// · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: example170.c:1:6: AUTO "auto",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example170.c:1:11: ',',
	// · Token2: example170.c:1:13: DDD,
	// }
}

func ExampleParameterTypeListOpt() {
	fmt.Println(exampleAST(171, "\U00100001 ( _Bool ( )") == (*ParameterTypeListOpt)(nil))
	// Output:
	// true
}

func ExampleParameterTypeListOpt_case1() {
	fmt.Println(exampleAST(172, "\U00100001 ( _Bool ( auto )"))
	// Output:
	// &cc.ParameterTypeListOpt{
	// · ParameterTypeList: &cc.ParameterTypeList{
	// · · ParameterList: &cc.ParameterList{
	// · · · ParameterDeclaration: &cc.ParameterDeclaration{
	// · · · · Case: 1,
	// · · · · DeclarationSpecifiers: &cc.DeclarationSpecifiers{
	// · · · · · StorageClassSpecifier: &cc.StorageClassSpecifier{
	// · · · · · · Case: 3,
	// · · · · · · Token: example172.c:1:12: AUTO "auto",
	// · · · · · },
	// · · · · },
	// · · · },
	// · · },
	// · },
	// }
}

func ExamplePointer() {
	fmt.Println(exampleAST(161, "\U00100002 * ("))
	// Output:
	// &cc.Pointer{
	// · Token: example161.c:1:2: '*',
	// }
}

func ExamplePointer_case1() {
	fmt.Println(exampleAST(162, "\U00100002 * * ("))
	// Output:
	// &cc.Pointer{
	// · Case: 1,
	// · Pointer: &cc.Pointer{
	// · · Token: example162.c:1:4: '*',
	// · },
	// · Token: example162.c:1:2: '*',
	// }
}

func ExamplePointerOpt() {
	fmt.Println(exampleAST(163, "\U00100002 auto (") == (*PointerOpt)(nil))
	// Output:
	// true
}

func ExamplePointerOpt_case1() {
	fmt.Println(exampleAST(164, "\U00100001 ( _Bool * ("))
	// Output:
	// &cc.PointerOpt{
	// · Pointer: &cc.Pointer{
	// · · Token: example164.c:1:10: '*',
	// · },
	// }
}

func ExamplePreprocessingFile() {
	fmt.Println(exampleAST(285, "\U00100000 "))
	// Output:
	// &cc.PreprocessingFile{
	// · GroupList: &cc.GroupList{
	// · },
	// }
}

func ExampleSelectionStatement() {
	fmt.Println(exampleAST(233, "\U00100001 ( { if ( 'a' ) ; !"))
	// Output:
	// &cc.SelectionStatement{
	// · ExpressionList: &cc.ExpressionList{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example233.c:1:11: CHARCONST "'a'",
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example233.c:1:17: ';',
	// · · },
	// · },
	// · Token: example233.c:1:6: IF "if",
	// · Token2: example233.c:1:9: '(',
	// · Token3: example233.c:1:15: ')',
	// }
}

func ExampleSelectionStatement_case1() {
	fmt.Println(exampleAST(234, "\U00100001 ( { if ( 'a' ) ; else ; !"))
	// Output:
	// &cc.SelectionStatement{
	// · Case: 1,
	// · ExpressionList: &cc.ExpressionList{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example234.c:1:11: CHARCONST "'a'",
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example234.c:1:17: ';',
	// · · },
	// · },
	// · Statement2: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example234.c:1:24: ';',
	// · · },
	// · },
	// · Token: example234.c:1:6: IF "if",
	// · Token2: example234.c:1:9: '(',
	// · Token3: example234.c:1:15: ')',
	// · Token4: example234.c:1:19: ELSE "else",
	// }
}

func ExampleSelectionStatement_case2() {
	fmt.Println(exampleAST(235, "\U00100001 ( { switch ( 'a' ) ; !"))
	// Output:
	// &cc.SelectionStatement{
	// · Case: 2,
	// · ExpressionList: &cc.ExpressionList{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example235.c:1:15: CHARCONST "'a'",
	// · · },
	// · },
	// · Statement: &cc.Statement{
	// · · Case: 2,
	// · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · Token: example235.c:1:21: ';',
	// · · },
	// · },
	// · Token: example235.c:1:6: SWITCH "switch",
	// · Token2: example235.c:1:13: '(',
	// · Token3: example235.c:1:19: ')',
	// }
}

func ExampleSpecifierQualifierList() {
	fmt.Println(exampleAST(127, "\U00100001 ( _Bool ("))
	// Output:
	// &cc.SpecifierQualifierList{
	// · TypeSpecifier: &cc.TypeSpecifier{
	// · · Case: 9,
	// · · Token: example127.c:1:4: BOOL "_Bool",
	// · },
	// }
}

func ExampleSpecifierQualifierList_case1() {
	fmt.Println(exampleAST(128, "\U00100001 ( const ("))
	// Output:
	// &cc.SpecifierQualifierList{
	// · Case: 1,
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: example128.c:1:4: CONST "const",
	// · },
	// }
}

func ExampleSpecifierQualifierListOpt() {
	fmt.Println(exampleAST(129, "\U00100001 ( _Bool (") == (*SpecifierQualifierListOpt)(nil))
	// Output:
	// true
}

func ExampleSpecifierQualifierListOpt_case1() {
	fmt.Println(exampleAST(130, "\U00100001 ( _Bool _Bool ("))
	// Output:
	// &cc.SpecifierQualifierListOpt{
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: 9,
	// · · · Token: example130.c:1:10: BOOL "_Bool",
	// · · },
	// · },
	// }
}

func ExampleStatement() {
	fmt.Println(exampleAST(214, "\U00100001 ( { default : ; !"))
	// Output:
	// &cc.Statement{
	// · LabeledStatement: &cc.LabeledStatement{
	// · · Case: 2,
	// · · Statement: &cc.Statement{
	// · · · Case: 2,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Token: example214.c:1:16: ';',
	// · · · },
	// · · },
	// · · Token: example214.c:1:6: DEFAULT "default",
	// · · Token2: example214.c:1:14: ':',
	// · },
	// }
}

func ExampleStatement_case1() {
	fmt.Println(exampleAST(215, "\U00100001 ( { { } !"))
	// Output:
	// &cc.Statement{
	// · Case: 1,
	// · CompoundStatement: &cc.CompoundStatement{
	// · · Token: example215.c:1:6: '{',
	// · · Token2: example215.c:1:8: '}',
	// · },
	// }
}

func ExampleStatement_case2() {
	fmt.Println(exampleAST(216, "\U00100001 ( { ; !"))
	// Output:
	// &cc.Statement{
	// · Case: 2,
	// · ExpressionStatement: &cc.ExpressionStatement{
	// · · Token: example216.c:1:6: ';',
	// · },
	// }
}

func ExampleStatement_case3() {
	fmt.Println(exampleAST(217, "\U00100001 ( { if ( 'a' ) ; !"))
	// Output:
	// &cc.Statement{
	// · Case: 3,
	// · SelectionStatement: &cc.SelectionStatement{
	// · · ExpressionList: &cc.ExpressionList{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Expression: &cc.Expression{
	// · · · · Type: int,
	// · · · · Value: 97,
	// · · · · Case: 1,
	// · · · · Token: example217.c:1:11: CHARCONST "'a'",
	// · · · },
	// · · },
	// · · Statement: &cc.Statement{
	// · · · Case: 2,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Token: example217.c:1:17: ';',
	// · · · },
	// · · },
	// · · Token: example217.c:1:6: IF "if",
	// · · Token2: example217.c:1:9: '(',
	// · · Token3: example217.c:1:15: ')',
	// · },
	// }
}

func ExampleStatement_case4() {
	fmt.Println(exampleAST(218, "\U00100001 ( { while ( 'a' ) ; !"))
	// Output:
	// &cc.Statement{
	// · Case: 4,
	// · IterationStatement: &cc.IterationStatement{
	// · · ExpressionList: &cc.ExpressionList{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Expression: &cc.Expression{
	// · · · · Type: int,
	// · · · · Value: 97,
	// · · · · Case: 1,
	// · · · · Token: example218.c:1:14: CHARCONST "'a'",
	// · · · },
	// · · },
	// · · Statement: &cc.Statement{
	// · · · Case: 2,
	// · · · ExpressionStatement: &cc.ExpressionStatement{
	// · · · · Token: example218.c:1:20: ';',
	// · · · },
	// · · },
	// · · Token: example218.c:1:6: WHILE "while",
	// · · Token2: example218.c:1:12: '(',
	// · · Token3: example218.c:1:18: ')',
	// · },
	// }
}

func ExampleStatement_case5() {
	fmt.Println(exampleAST(219, "\U00100001 ( { break ; !"))
	// Output:
	// &cc.Statement{
	// · Case: 5,
	// · JumpStatement: &cc.JumpStatement{
	// · · Case: 2,
	// · · Token: example219.c:1:6: BREAK "break",
	// · · Token2: example219.c:1:12: ';',
	// · },
	// }
}

func ExampleStatement_case6() {
	fmt.Println(exampleAST(220, "\U00100001 ( { asm ( \"a\" ) !"))
	// Output:
	// &cc.Statement{
	// · AssemblerStatement: &cc.AssemblerStatement{
	// · · BasicAssemblerStatement: &cc.BasicAssemblerStatement{
	// · · · AssemblerInstructions: &cc.AssemblerInstructions{
	// · · · · Token: example220.c:1:12: STRINGLITERAL "\"a\"",
	// · · · },
	// · · · Token: example220.c:1:6: ASM "asm",
	// · · · Token2: example220.c:1:10: '(',
	// · · · Token3: example220.c:1:16: ')',
	// · · },
	// · },
	// · Case: 6,
	// }
}

func ExampleStaticAssertDeclaration() {
	fmt.Println(exampleAST(284, "\U00100002 _Static_assert ( 'a' , \"b\" ) ;"))
	// Output:
	// &cc.StaticAssertDeclaration{
	// · ConstantExpression: &cc.ConstantExpression{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example284.c:1:19: CHARCONST "'a'",
	// · · },
	// · },
	// · Token: example284.c:1:2: STATIC_ASSERT "_Static_assert",
	// · Token2: example284.c:1:17: '(',
	// · Token3: example284.c:1:23: ',',
	// · Token4: example284.c:1:25: STRINGLITERAL "\"b\"",
	// · Token5: example284.c:1:29: ')',
	// · Token6: example284.c:1:31: ';',
	// }
}

func ExampleStorageClassSpecifier() {
	fmt.Println(exampleAST(95, "\U00100002 typedef ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Token: example95.c:1:2: TYPEDEF "typedef",
	// }
}

func ExampleStorageClassSpecifier_case1() {
	fmt.Println(exampleAST(96, "\U00100002 extern ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 1,
	// · Token: example96.c:1:2: EXTERN "extern",
	// }
}

func ExampleStorageClassSpecifier_case2() {
	fmt.Println(exampleAST(97, "\U00100002 static ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 2,
	// · Token: example97.c:1:2: STATIC "static",
	// }
}

func ExampleStorageClassSpecifier_case3() {
	fmt.Println(exampleAST(98, "\U00100002 auto ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 3,
	// · Token: example98.c:1:2: AUTO "auto",
	// }
}

func ExampleStorageClassSpecifier_case4() {
	fmt.Println(exampleAST(99, "\U00100002 register ("))
	// Output:
	// &cc.StorageClassSpecifier{
	// · Case: 4,
	// · Token: example99.c:1:2: REGISTER "register",
	// }
}

func ExampleStructDeclaration() {
	fmt.Println(exampleAST(124, "\U00100002 struct { _Bool a ; }"))
	// Output:
	// &cc.StructDeclaration{
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: 9,
	// · · · Token: example124.c:1:11: BOOL "_Bool",
	// · · },
	// · },
	// · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · StructDeclarator: &cc.StructDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: None,
	// · · · · Type: bool,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Token: example124.c:1:17: IDENTIFIER "a",
	// · · · · },
	// · · · },
	// · · },
	// · },
	// · Token: example124.c:1:19: ';',
	// }
}

func ExampleStructDeclaration_case1() {
	fmt.Println(exampleAST(125, "\U00100002 struct { _Bool ; }"))
	// Output:
	// &cc.StructDeclaration{
	// · Case: 1,
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: 9,
	// · · · Token: example125.c:1:11: BOOL "_Bool",
	// · · },
	// · },
	// · Token: example125.c:1:17: ';',
	// }
}

func ExampleStructDeclaration_case2() {
	fmt.Println(exampleAST(126, "\U00100002 struct { _Static_assert ( 'a' , \"b\" ) ; }"))
	// Output:
	// &cc.StructDeclaration{
	// · Case: 2,
	// · StaticAssertDeclaration: &cc.StaticAssertDeclaration{
	// · · ConstantExpression: &cc.ConstantExpression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Expression: &cc.Expression{
	// · · · · Type: int,
	// · · · · Value: 97,
	// · · · · Case: 1,
	// · · · · Token: example126.c:1:28: CHARCONST "'a'",
	// · · · },
	// · · },
	// · · Token: example126.c:1:11: STATIC_ASSERT "_Static_assert",
	// · · Token2: example126.c:1:26: '(',
	// · · Token3: example126.c:1:32: ',',
	// · · Token4: example126.c:1:34: STRINGLITERAL "\"b\"",
	// · · Token5: example126.c:1:38: ')',
	// · · Token6: example126.c:1:40: ';',
	// · },
	// }
}

func ExampleStructDeclarationList() {
	fmt.Println(exampleAST(122, "\U00100002 struct { _Bool ; }"))
	// Output:
	// &cc.StructDeclarationList{
	// · StructDeclaration: &cc.StructDeclaration{
	// · · Case: 1,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: 9,
	// · · · · Token: example122.c:1:11: BOOL "_Bool",
	// · · · },
	// · · },
	// · · Token: example122.c:1:17: ';',
	// · },
	// }
}

func ExampleStructDeclarationList_case1() {
	fmt.Println(exampleAST(123, "\U00100002 struct { _Bool ; _Bool ; }"))
	// Output:
	// &cc.StructDeclarationList{
	// · StructDeclaration: &cc.StructDeclaration{
	// · · Case: 1,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: 9,
	// · · · · Token: example123.c:1:11: BOOL "_Bool",
	// · · · },
	// · · },
	// · · Token: example123.c:1:17: ';',
	// · },
	// · StructDeclarationList: &cc.StructDeclarationList{
	// · · Case: 1,
	// · · StructDeclaration: &cc.StructDeclaration{
	// · · · Case: 1,
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: 9,
	// · · · · · Token: example123.c:1:19: BOOL "_Bool",
	// · · · · },
	// · · · },
	// · · · Token: example123.c:1:25: ';',
	// · · },
	// · },
	// }
}

func ExampleStructDeclarator() {
	fmt.Println(exampleAST(133, "\U00100002 struct { _Bool a ,"))
	// Output:
	// &cc.StructDeclarator{
	// · Declarator: &cc.Declarator{
	// · · Linkage: None,
	// · · Type: bool,
	// · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · Token: example133.c:1:17: IDENTIFIER "a",
	// · · },
	// · },
	// }
}

func ExampleStructDeclarator_case1() {
	fmt.Println(exampleAST(134, "\U00100002 struct { _Bool : 'a' ,"))
	// Output:
	// &cc.StructDeclarator{
	// · Case: 1,
	// · ConstantExpression: &cc.ConstantExpression{
	// · · Type: int,
	// · · Value: 97,
	// · · Expression: &cc.Expression{
	// · · · Type: int,
	// · · · Value: 97,
	// · · · Case: 1,
	// · · · Token: example134.c:1:19: CHARCONST "'a'",
	// · · },
	// · },
	// · Token: example134.c:1:17: ':',
	// }
}

func ExampleStructDeclaratorList() {
	fmt.Println(exampleAST(131, "\U00100002 struct { _Bool a ,"))
	// Output:
	// &cc.StructDeclaratorList{
	// · StructDeclarator: &cc.StructDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: None,
	// · · · Type: bool,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Token: example131.c:1:17: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleStructDeclaratorList_case1() {
	fmt.Println(exampleAST(132, "\U00100002 struct { _Bool a , b ,"))
	// Output:
	// &cc.StructDeclaratorList{
	// · StructDeclarator: &cc.StructDeclarator{
	// · · Declarator: &cc.Declarator{
	// · · · Linkage: None,
	// · · · Type: bool,
	// · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · Token: example132.c:1:17: IDENTIFIER "a",
	// · · · },
	// · · },
	// · },
	// · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · Case: 1,
	// · · StructDeclarator: &cc.StructDeclarator{
	// · · · Declarator: &cc.Declarator{
	// · · · · Linkage: None,
	// · · · · Type: bool,
	// · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · Token: example132.c:1:21: IDENTIFIER "b",
	// · · · · },
	// · · · },
	// · · },
	// · · Token: example132.c:1:19: ',',
	// · },
	// }
}

func ExampleStructOrUnion() {
	fmt.Println(exampleAST(120, "\U00100002 struct {"))
	// Output:
	// &cc.StructOrUnion{
	// · Token: example120.c:1:2: STRUCT "struct",
	// }
}

func ExampleStructOrUnion_case1() {
	fmt.Println(exampleAST(121, "\U00100002 union {"))
	// Output:
	// &cc.StructOrUnion{
	// · Case: 1,
	// · Token: example121.c:1:2: UNION "union",
	// }
}

func ExampleStructOrUnionSpecifier() {
	fmt.Println(exampleAST(117, "\U00100002 struct { int i; } ("))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · StructDeclarationList: &cc.StructDeclarationList{
	// · · StructDeclaration: &cc.StructDeclaration{
	// · · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · · Case: 3,
	// · · · · · Token: example117.c:1:11: INT "int",
	// · · · · },
	// · · · },
	// · · · StructDeclaratorList: &cc.StructDeclaratorList{
	// · · · · StructDeclarator: &cc.StructDeclarator{
	// · · · · · Declarator: &cc.Declarator{
	// · · · · · · Linkage: None,
	// · · · · · · Type: int,
	// · · · · · · DirectDeclarator: &cc.DirectDeclarator{
	// · · · · · · · Token: example117.c:1:15: IDENTIFIER "i",
	// · · · · · · },
	// · · · · · },
	// · · · · },
	// · · · },
	// · · · Token: example117.c:1:16: ';',
	// · · },
	// · },
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Token: example117.c:1:2: STRUCT "struct",
	// · },
	// · Token: example117.c:1:9: '{',
	// · Token2: example117.c:1:18: '}',
	// }
}

func ExampleStructOrUnionSpecifier_case1() {
	fmt.Println(exampleAST(118, "\U00100002 struct a ("))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · Case: 1,
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Token: example118.c:1:2: STRUCT "struct",
	// · },
	// · Token: example118.c:1:9: IDENTIFIER "a",
	// }
}

func ExampleStructOrUnionSpecifier_case2() {
	fmt.Println(exampleAST(119, "\U00100002 struct { } ("))
	// Output:
	// &cc.StructOrUnionSpecifier{
	// · Case: 2,
	// · StructOrUnion: &cc.StructOrUnion{
	// · · Token: example119.c:1:2: STRUCT "struct",
	// · },
	// · Token: example119.c:1:9: '{',
	// · Token2: example119.c:1:11: '}',
	// }
}

func ExampleTranslationUnit() {
	fmt.Println(exampleAST(245, "\U00100002 ;"))
	// Output:
	// &cc.TranslationUnit{
	// · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · Case: 3,
	// · · Token: example245.c:1:2: ';',
	// · },
	// }
}

func ExampleTranslationUnit_case1() {
	fmt.Println(exampleAST(246, "\U00100002 ; ;"))
	// Output:
	// &cc.TranslationUnit{
	// · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · Case: 3,
	// · · Token: example246.c:1:2: ';',
	// · },
	// · TranslationUnit: &cc.TranslationUnit{
	// · · Case: 1,
	// · · ExternalDeclaration: &cc.ExternalDeclaration{
	// · · · Case: 3,
	// · · · Token: example246.c:1:4: ';',
	// · · },
	// · },
	// }
}

func ExampleTypeName() {
	fmt.Println(exampleAST(184, "\U00100001 ( _Bool )"))
	// Output:
	// &cc.TypeName{
	// · Type: bool,
	// · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · Case: 9,
	// · · · Token: example184.c:1:4: BOOL "_Bool",
	// · · },
	// · },
	// }
}

func ExampleTypeQualifier() {
	fmt.Println(exampleAST(144, "\U00100002 const !"))
	// Output:
	// &cc.TypeQualifier{
	// · Token: example144.c:1:2: CONST "const",
	// }
}

func ExampleTypeQualifier_case1() {
	fmt.Println(exampleAST(145, "\U00100002 restrict !"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: 1,
	// · Token: example145.c:1:2: RESTRICT "restrict",
	// }
}

func ExampleTypeQualifier_case2() {
	fmt.Println(exampleAST(146, "\U00100002 volatile !"))
	// Output:
	// &cc.TypeQualifier{
	// · Case: 2,
	// · Token: example146.c:1:2: VOLATILE "volatile",
	// }
}

func ExampleTypeQualifierList() {
	fmt.Println(exampleAST(165, "\U00100002 * const !"))
	// Output:
	// &cc.TypeQualifierList{
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: example165.c:1:4: CONST "const",
	// · },
	// }
}

func ExampleTypeQualifierList_case1() {
	fmt.Println(exampleAST(166, "\U00100002 * const const !"))
	// Output:
	// &cc.TypeQualifierList{
	// · TypeQualifier: &cc.TypeQualifier{
	// · · Token: example166.c:1:4: CONST "const",
	// · },
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · Case: 1,
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: example166.c:1:10: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleTypeQualifierListOpt() {
	fmt.Println(exampleAST(167, "\U00100002 * (") == (*TypeQualifierListOpt)(nil))
	// Output:
	// true
}

func ExampleTypeQualifierListOpt_case1() {
	fmt.Println(exampleAST(168, "\U00100002 * const !"))
	// Output:
	// &cc.TypeQualifierListOpt{
	// · TypeQualifierList: &cc.TypeQualifierList{
	// · · TypeQualifier: &cc.TypeQualifier{
	// · · · Token: example168.c:1:4: CONST "const",
	// · · },
	// · },
	// }
}

func ExampleTypeSpecifier() {
	fmt.Println(exampleAST(100, "\U00100002 void ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Token: example100.c:1:2: VOID "void",
	// }
}

func ExampleTypeSpecifier_case01() {
	fmt.Println(exampleAST(101, "\U00100002 char ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 1,
	// · Token: example101.c:1:2: CHAR "char",
	// }
}

func ExampleTypeSpecifier_case02() {
	fmt.Println(exampleAST(102, "\U00100002 short ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 2,
	// · Token: example102.c:1:2: SHORT "short",
	// }
}

func ExampleTypeSpecifier_case03() {
	fmt.Println(exampleAST(103, "\U00100002 int ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 3,
	// · Token: example103.c:1:2: INT "int",
	// }
}

func ExampleTypeSpecifier_case04() {
	fmt.Println(exampleAST(104, "\U00100002 long ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 4,
	// · Token: example104.c:1:2: LONG "long",
	// }
}

func ExampleTypeSpecifier_case05() {
	fmt.Println(exampleAST(105, "\U00100002 float ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 5,
	// · Token: example105.c:1:2: FLOAT "float",
	// }
}

func ExampleTypeSpecifier_case06() {
	fmt.Println(exampleAST(106, "\U00100002 double ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 6,
	// · Token: example106.c:1:2: DOUBLE "double",
	// }
}

func ExampleTypeSpecifier_case07() {
	fmt.Println(exampleAST(107, "\U00100002 signed ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 7,
	// · Token: example107.c:1:2: SIGNED "signed",
	// }
}

func ExampleTypeSpecifier_case08() {
	fmt.Println(exampleAST(108, "\U00100002 unsigned ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 8,
	// · Token: example108.c:1:2: UNSIGNED "unsigned",
	// }
}

func ExampleTypeSpecifier_case09() {
	fmt.Println(exampleAST(109, "\U00100002 _Bool ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 9,
	// · Token: example109.c:1:2: BOOL "_Bool",
	// }
}

func ExampleTypeSpecifier_case10() {
	fmt.Println(exampleAST(110, "\U00100002 _Complex ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 10,
	// · Token: example110.c:1:2: COMPLEX "_Complex",
	// }
}

func ExampleTypeSpecifier_case11() {
	fmt.Println(exampleAST(111, "\U00100002 struct a ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 11,
	// · StructOrUnionSpecifier: &cc.StructOrUnionSpecifier{
	// · · Case: 1,
	// · · StructOrUnion: &cc.StructOrUnion{
	// · · · Token: example111.c:1:2: STRUCT "struct",
	// · · },
	// · · Token: example111.c:1:9: IDENTIFIER "a",
	// · },
	// }
}

func ExampleTypeSpecifier_case12() {
	fmt.Println(exampleAST(112, "\U00100002 enum a ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 12,
	// · EnumSpecifier: &cc.EnumSpecifier{
	// · · Case: 1,
	// · · Token: example112.c:1:2: ENUM "enum",
	// · · Token2: example112.c:1:7: IDENTIFIER "a",
	// · },
	// }
}

func ExampleTypeSpecifier_case13() {
	fmt.Println(exampleAST(113, "\U00100002 typedef int i; i j;"))
	// Output:
	// &cc.TypeSpecifier{
	// · Case: 13,
	// · Token: example113.c:1:17: TYPEDEFNAME "i",
	// }
}

func ExampleTypeSpecifier_case14() {
	fmt.Println(exampleAST(114, "\U00100002 typeof ( 'a' ) ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Type: int,
	// · Case: 14,
	// · Expression: &cc.Expression{
	// · · Type: int,
	// · · Value: 97,
	// · · Case: 1,
	// · · Token: example114.c:1:11: CHARCONST "'a'",
	// · },
	// · Token: example114.c:1:2: TYPEOF "typeof",
	// · Token2: example114.c:1:9: '(',
	// · Token3: example114.c:1:15: ')',
	// }
}

func ExampleTypeSpecifier_case15() {
	fmt.Println(exampleAST(115, "\U00100002 typeof ( _Bool ) ("))
	// Output:
	// &cc.TypeSpecifier{
	// · Type: bool,
	// · Case: 15,
	// · Token: example115.c:1:2: TYPEOF "typeof",
	// · Token2: example115.c:1:9: '(',
	// · Token3: example115.c:1:17: ')',
	// · TypeName: &cc.TypeName{
	// · · Type: bool,
	// · · SpecifierQualifierList: &cc.SpecifierQualifierList{
	// · · · TypeSpecifier: &cc.TypeSpecifier{
	// · · · · Case: 9,
	// · · · · Token: example115.c:1:11: BOOL "_Bool",
	// · · · },
	// · · },
	// · },
	// }
}

func ExampleVolatileOpt() {
	fmt.Println(exampleAST(268, "\U00100002 asm (") == (*VolatileOpt)(nil))
	// Output:
	// true
}

func ExampleVolatileOpt_case1() {
	fmt.Println(exampleAST(269, "\U00100002 asm volatile ("))
	// Output:
	// &cc.VolatileOpt{
	// · Token: example269.c:1:6: VOLATILE "volatile",
	// }
}
