// Copyright 2022 The CCGO Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package ccgo // import "modernc.org/ccgo/v4/lib"

var testExecKnownFails = map[string]struct{}{
	// ==== EXEC FAIL - compiles and builds but fails when executed.

	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-9.c`:                         {}, // EXEC FAIL
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c`:                     {}, // EXEC FAIL: "assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c: panic: 544"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/return-addr.c`: {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-benchmarks/except.c`:                              {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-benchmarks/except.c: libc.go:2142:Xlongjmp: TODOTODO
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-basic.c`:                      {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-trailing-zero.c`:              {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-types-init.c`:                 {},
	`assets/github.com/vnmakarov/mir/c-tests/lacc/declaration-default-int.c`:             {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/declaration-default-int.c: : FAIL: exit status 51
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-implicit-declare.c`:           {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/function-implicit-declare.c: : FAIL: exit status 42
	`assets/github.com/vnmakarov/mir/c-tests/lacc/long-double-load.c`:                    {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/macro-paste.c`:                         {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/macro-paste.c: foo5
	`assets/github.com/vnmakarov/mir/c-tests/lacc/vararg-complex-2.c`:                    {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/whitespace.c`:                          {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/whitespace.c: Hello
	`assets/github.com/vnmakarov/mir/c-tests/new/setjmp.c`:                               {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/new/setjmp.c: libc.go:2142:Xlongjmp: TODOTODO
	`assets/github.com/vnmakarov/mir/c-tests/new/setjmp2.c`:                              {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/new/setjmp2.c: libc.go:2142:Xlongjmp: TODOTODO

	// ==== BUILD FAIL - compiles but does not build.

	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/alias-3.c`:                 {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/alias-3.c`: {}, // BUILD FAIL: "exit status 1"

	`assets/CompCert-3.6/test/c/aes.c`:                                                         {}, // BUILD FAIL: "signal: killed"
	`assets/CompCert-3.6/test/c/almabench.c`:                                                   {}, // BUILD FAIL: "signal: killed"
	`assets/CompCert-3.6/test/c/binarytrees.c`:                                                 {}, // BUILD FAIL: "signal: killed"
	`assets/CompCert-3.6/test/c/bisect.c`:                                                      {}, // BUILD FAIL: "signal: killed"
	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-4.c`:                       {}, // BUILD FAIL: exit status 1
	`assets/ccgo/bug/sqlite.c`:                                                                 {}, // BUILD FAIL: exit status 1
	`assets/ccgo/bug/union3.c`:                                                                 {}, // BUILD FAIL: exit status 1
	`assets/ccgo/bug/union4.c`:                                                                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20000112-1.c`:                        {}, // BUILD FAIL: "exit status 2"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020103-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030128-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041114-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920728-1.c`:                          {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/950221-1.c`:                          {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:                          {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:                          {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991112-1.c`:                          {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:                        {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/anon-1.c`:                            {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:                  {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:                              {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:                     {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20010114-2.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:                   {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`:                 {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:                     {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:                     {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:                     {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr36332.c`:                      {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:                      {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/loop-2f.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr19449.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr58387.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr66556.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71631.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89195.c`:                           {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:                          {}, // BUILD FAIL: exit status 1
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:                     {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030128-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920728-1.c`:          {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/950221-1.c`:          {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:          {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:          {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991112-1.c`:          {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:        {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/anon-1.c`:            {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:  {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:              {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:     {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20010114-2.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:   {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`: {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:     {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:    {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:    {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:     {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:     {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:    {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:    {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr36332.c`:      {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:      {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr19449.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr41750.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr58640.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr64242.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr66556.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71631.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84521.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89195.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93249.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93494.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94134.c`:           {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:          {}, // BUILD FAIL: exit status 1
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:     {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0010-goto1.c`:                    {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0011-switch1.c`:                  {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0028-inits14.c`:                  {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/andrewchambers_c/0028-inits15.c`:                  {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/lacc/goto.c`:                                      {}, // BUILD FAIL: exit status 1
	`assets/github.com/vnmakarov/mir/c-tests/new/var-size-in-var-initializer.c`:                {}, // BUILD FAIL: exit status 1
	`assets/tcc-0.9.27/tests/tests2/81_types.c`:                                                {}, // BUILD FAIL: exit status 1

	// ==== COMPILE FAIL - does not compile.

	`assets/benchmarksgame-team.pages.debian.net/fasta-4.c`:                                             {}, // COMPILE FAIL: fasta-4.o.go:661:3: undefined: "fwrite_unlocked" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:)
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-8.c`:                                        {}, // COMPILE FAIL: mandelbrot-8.c:16:30: unsupported vector type: Vec (expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1682:unaryExpression: type.go:422:isValidType: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000211-1.c`:                                 {}, // COMPILE FAIL: TODO (compile.go:433:compile: decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:745:initDeclarator: type.go:18:typedef: type.go:325:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000326-2.c`:                                 {}, // COMPILE FAIL: 20000326-2.c:7:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000405-3.c`:                                 {}, // COMPILE FAIL: 20000405-3.c:1:1: unsupported alignment 32 of struct foo {entry array of 40 pointer to void} (decl.go:296:externalDeclaration: decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000518-1.c`:                                 {}, // COMPILE FAIL: 20000518-1.c:7:2: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010202-1.c`:                                 {}, // COMPILE FAIL: 20010202-1.c:3:5: incomplete type: array of array of char (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010226-1.c`:                                 {}, // COMPILE FAIL: 20010226-1.c:16:12: nested functions not supported (stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:392:selectionStatement: stmt.go:536:bracedStatement: stmt.go:545:unbracedStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010605-1.c`:                                 {}, // COMPILE FAIL: 20010605-1.c:9:9: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010903-2.c`:                                 {}, // COMPILE FAIL: 20010903-2.c:9:14: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20011023-1.c`:                                 {}, // COMPILE FAIL: 20011023-1.c:8:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20020309-1.c`:                                 {}, // COMPILE FAIL: 20020309-1.c:8:5: nested functions not supported (decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021108-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:1178:additiveExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021204-1.c`:                                 {}, // COMPILE FAIL: 20021204-1.c:8:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030224-1.c`:                                 {}, // COMPILE FAIL: 20030224-1.c:6:25: invalid type size: -1 (decl.go:383:functionDefinition0: stmt.go:261:compoundStatement: decl.go:235:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:493:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030418-1.c`:                                 {}, // COMPILE FAIL: 20030418-1.c:13:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030716-1.c`:                                 {}, // COMPILE FAIL: 20030716-1.c:3:6: incomplete type: array of int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030903-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030910-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3444:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20031011-1.c`:                                 {}, // COMPILE FAIL: 20031011-1.c:15:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040310-1.c`:                                 {}, // COMPILE FAIL: 20040310-1.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-1.c`:                                 {}, // COMPILE FAIL: 20040317-1.c:1:5: incomplete type: array of array of char (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-3.c`:                                 {}, // COMPILE FAIL: 20040317-3.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040323-1.c`:                                 {}, // COMPILE FAIL: 20040323-1.c:10:16: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040614-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050113-1.c`:                                 {}, // COMPILE FAIL: "\"20050113-1.c:11:20: unsupported vector type: V2SF (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050119-1.c`:                                 {}, // COMPILE FAIL: 20050119-1.c:7:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050122-2.c`:                                 {}, // COMPILE FAIL: 20050122-2.c:10:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050510-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:1161:additiveExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-2.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:1161:additiveExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070919-1.c`:                                 {}, // COMPILE FAIL: TODO exprUintptr (expr.go:101:expr: expr.go:530:expr0: expr.go:1605:unaryExpression: expr.go:101:expr: expr.go:522:expr0: expr.go:2096:postfixExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20090907-1.c`:                                 {}, // COMPILE FAIL: TODO (decl.go:296:externalDeclaration: decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:325:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20110131-1.c`:                                 {}, // COMPILE FAIL: -: TODO (expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20121107-1.c`:                                 {}, // COMPILE FAIL: -: TODO (expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920301-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (init.go:263:initializerArray: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920415-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920428-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (init.go:263:initializerArray: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-7.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920502-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920826-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920831-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930118-1.c`:                                   {}, // COMPILE FAIL: 930118-1.c:3:1: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930506-2.c`:                                   {}, // COMPILE FAIL: 930506-2.c:5:9: nested functions not supported (decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/941014-4.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (init.go:32:initializerOuter: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950610-1.c`:                                   {}, // COMPILE FAIL: 950610-1.c:1:1: incomplete type: array of array of int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950613-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950919-1.c`:                                   {}, // COMPILE FAIL: 950919-1.c:2:10: assertions are a deprecated extension
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/951116-1.c`:                                   {}, // COMPILE FAIL: 951116-1.c:7:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981001-4.c`:                                   {}, // COMPILE FAIL: -: TODO (expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981006-1.c`:                                   {}, // COMPILE FAIL: 981006-1.c:14:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981223-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:1266:equalityExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:70:topExpr: expr.go:101:expr: expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:530:expr0: expr.go:1715:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-1.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:70:topExpr: expr.go:115:expr: expr.go:169:convert: expr.go:331:convertType: type.go:30:helper: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-2.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1715:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-3.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:1161:additiveExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1715:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-4.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-5.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-6.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/ex.c`:                                         {}, // COMPILE FAIL: ex.c:12:19: too few arguments to function 'foo', type 'function(int, int) returning int' in 'foo ()' (expr.go:3178:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3134:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/icfmatch.c`:                                   {}, // COMPILE FAIL: "\"icfmatch.c:4:14: unsupported vector type: v4qi (expr.go:101:expr: expr.go:537:expr0: expr.go:3811:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (init.go:32:initializerOuter: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-2.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (init.go:398:initializerStruct: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-1.c`:                                   {}, // COMPILE FAIL: nested-1.c:15:24: incomplete type: array of char (expr.go:101:expr: expr.go:530:expr0: expr.go:1658:unaryExpression: type.go:410:isValidType: type.go:422:isValidType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-2.c`:                                   {}, // COMPILE FAIL: nested-2.c:9:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-3.c`:                                   {}, // COMPILE FAIL: nested-3.c:13:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pass.c`:                                       {}, // COMPILE FAIL: pass.c:13:10: too many arguments to function 'foo', type 'function(int, int, int) returning int' in 'foo ((int) & q, q, w, e, q, (int) &w)' (stmt.go:841:jumpStatement: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3139:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pc44485.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr17913.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr18903.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (stmt.go:360:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21356.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21728.c`:                                    {}, // COMPILE FAIL: pr21728.c:5:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr22422.c`:                                    {}, // COMPILE FAIL: TODO pr22422.c:27:3: from pointer to int, exprUintptr to pointer to int exprVoid, src '&d->c [d->n]', buf '((((aad))+4)+(((ppuintptr(((*tsD)(iqunsafe.ppPointer((aad))).fdn))))*4))' (stmt.go:360:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:115:expr: expr.go:165:convert: expr.go:298:convertMode:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr25224.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27341-1.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionImag (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1715:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27863.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27889.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:381:functionDefinition0: decl.go:570:signature: type.go:48:typ2: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr28489.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr29128.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr30984.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr32919.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33382.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33617.c`:                                    {}, // COMPILE FAIL: "\".: unsupported vector type: V8SF (asm_riscv64.s:512:goexit: asm_riscv64.s:512:goexit: compile.go:481:compile: decl.go:532:signature: type.go:383:isValidParamType: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34334.c`:                                    {}, // COMPILE FAIL: TODO (compile.go:433:compile: decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:745:initDeclarator: type.go:18:typedef: type.go:325:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34856.c`:                                    {}, // COMPILE FAIL: "\"pr34856.c:11:16: unsupported vector type: VU32 (expr.go:115:expr: expr.go:169:convert: expr.go:329:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35006.c`:                                    {}, // COMPILE FAIL: pr35006.c:9:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35431.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38360.c`:                                    {}, // COMPILE FAIL: pr38360.c:7:3: too few arguments to function 'fputs', type 'function(pointer to char, pointer to void) returning int' in 'fputs ("")' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3134:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38771.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr40233.c`:                                    {}, // COMPILE FAIL: pr40233.c:2:1: unsupported alignment 64 of struct Frame {i aligned} (decl.go:296:externalDeclaration: decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr41987.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex char _Complex char (expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-1.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:598:declaration: type.go:593:defineUnionType: type.go:503:unionLiteral: type.go:322:typ0: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-2.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:598:declaration: type.go:593:defineUnionType: type.go:503:unionLiteral: type.go:338:typ0: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-3.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:598:declaration: type.go:593:defineUnionType: type.go:503:unionLiteral: type.go:338:typ0: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42559.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (init.go:32:initializerOuter: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42716.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42717.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr44119.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr46107.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr47428.c`:                                    {}, // COMPILE FAIL: pr47428.c:24:3: too few arguments to function 'fn', type 'function(int, int) returning int' in 'fn (0)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3134:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr48641.c`:                                    {}, // COMPILE FAIL: TODO "(X__builtin_modfl(cgtls, (iqlibc.ppFloat64FromFloat64(1.5)), cgbp) != (*(*ppfloat64)(iqunsafe.ppPointer(cgbp))))" int exprBool -> long double exprDefault (expr.go:508:expr0: expr.go:1269:equalityExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:115:expr: expr.go:186:convert:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51354.c`:                                    {}, // COMPILE FAIL: pr51354.c:15:6: unsupported alignment 32 of ai (decl.go:383:functionDefinition0: stmt.go:261:compoundStatement: decl.go:226:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51495.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51694.c`:                                    {}, // COMPILE FAIL: pr51694.c:14:3: too few arguments to function 'foo', type 'function(int, pointer to function())' in 'foo (x)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3134:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr52750.c`:                                    {}, // COMPILE FAIL: "\"pr52750.c:8:11: unsupported vector type: V (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53410-2.c`:                                  {}, // COMPILE FAIL: "\"pr53410-2.c:9:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53748.c`:                                    {}, // COMPILE FAIL: "\"pr53748.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-1.c`:                                  {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-2.c`:                                  {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-3.c`:                                  {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr56571.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr58164.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr60502.c`:                                    {}, // COMPILE FAIL: "\"pr60502.c:9:16: unsupported vector type: v16i8 (expr.go:115:expr: expr.go:169:convert: expr.go:329:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70190.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70199.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70355.c`:                                    {}, // COMPILE FAIL: "\"TODO vector (compile.go:433:compile: decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:745:initDeclarator: type.go:18:typedef: type.go:89:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70633.c`:                                    {}, // COMPILE FAIL: "\"pr70633.c:10:5: unsupported vector type: V (decl.go:384:functionDefinition0: stmt.go:261:compoundStatement: decl.go:227:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70916.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:3444:assignmentExpression: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr71109.c`:                                    {}, // COMPILE FAIL: pr71109.c:15:7: too few arguments to function 'foo', type 'function(int, struct S, struct T)' in 'foo (bar, a)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3134:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-1.c`:                                  {}, // COMPILE FAIL: pr77754-1.c:5:13: incomplete type: array of array of int (asm_riscv64.s:512:goexit: asm_riscv64.s:512:goexit: compile.go:481:compile: decl.go:531:signature: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-2.c`:                                  {}, // COMPILE FAIL: pr77754-2.c:5:6: incomplete type: array of array of int (type.go:673:defineType0: type.go:673:defineType0: type.go:661:defineType0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-3.c`:                                  {}, // COMPILE FAIL: pr77754-3.c:5:14: incomplete type: array of array of int (type.go:657:defineType: type.go:673:defineType0: type.go:661:defineType0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-4.c`:                                  {}, // COMPILE FAIL: pr77754-4.c:5:14: incomplete type: array of array of int (type.go:657:defineType: type.go:673:defineType0: type.go:661:defineType0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-5.c`:                                  {}, // COMPILE FAIL: pr77754-5.c:6:6: incomplete type: array of array of int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82052.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82564.c`:                                    {}, // COMPILE FAIL: pr82564.c:9:5: invalid type size: -1 (decl.go:383:functionDefinition0: stmt.go:261:compoundStatement: decl.go:235:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:493:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84136.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:494:expr0: expr.go:3398:assignmentExpression: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84305.c`:                                    {}, // COMPILE FAIL: pr84305.c:3:34: TODO (expr.go:1873:postfixExpressionIndex: expr.go:101:expr: expr.go:522:expr0: expr.go:1956:postfixExpression: expr.go:1789:postfixExpressionIndex: expr.go:1739:mul:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84960.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85704.c`:                                    {}, // COMPILE FAIL: pr85704.c:9:26: TODO "tsC{}" struct C {c struct {}}, 0 exprDefault -> struct D {d int; e struct C; f int}, 8 exprDefault (pr85704.c:9:26:) (expr.go:522:expr0: expr.go:2206:postfixExpression: init.go:113:initializer: expr.go:115:expr: expr.go:169:convert: expr.go:341:convertType:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85945.c`:                                    {}, // COMPILE FAIL: pr85945.c:4:1: unsupported vector type: V (decl.go:598:declaration: type.go:593:defineUnionType: type.go:503:unionLiteral: type.go:338:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86122.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86123.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex unsigned _Complex unsigned (expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr89655.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr90139.c`:                                    {}, // COMPILE FAIL: "\"pr90139.c:10:5: unsupported vector type: V (decl.go:384:functionDefinition0: stmt.go:261:compoundStatement: decl.go:236:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-1.c`:                                     {}, // COMPILE FAIL: "\"simd-1.c:5:16: unsupported vector type: v2si (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-2.c`:                                     {}, // COMPILE FAIL: "\"simd-2.c:14:9: unsupported vector type: floatvect2 (expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2623:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-3.c`:                                     {}, // COMPILE FAIL: "\"simd-3.c:19:9: unsupported vector type: floatvect2 (expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2623:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-4.c`:                                     {}, // COMPILE FAIL: "\"simd-4.c:11:26: unsupported vector type: floatvect2 (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-5.c`:                                     {}, // COMPILE FAIL: simd-5.c:6:19: unsupported vector type: int (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4235:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-6.c`:                                     {}, // COMPILE FAIL: simd-6.c:5:11: unsupported vector type: vec (init.go:110:initializer: init.go:193:initializerArray: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/sra-1.c`:                                      {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:1295:relationExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-2.c`:                          {}, // COMPILE FAIL: TODO assertion failed (expr.go:101:expr: expr.go:522:expr0: expr.go:2028:postfixExpression: expr.go:2682:postfixExpressionSelect: expr.go:115:expr: expr.go:131:convert:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-3.c`:                          {}, // COMPILE FAIL: TODO exprUintptr (expr.go:2682:postfixExpressionSelect: expr.go:101:expr: expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:494:expr0: expr.go:3449:assignmentExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/uuarg.c`:                                      {}, // COMPILE FAIL: uuarg.c:4:10: too few arguments to function 'foo', type 'function(int, int, int, int, int, int, int, int, int) returning int' in 'foo ()' (expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3134:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-1.c`:                                   {}, // COMPILE FAIL: vector-1.c:3:1: unsupported vector type: float (decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-2.c`:                                   {}, // COMPILE FAIL: vector-2.c:3:1: unsupported vector type: float (decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-4.c`:                                   {}, // COMPILE FAIL: vector-4.c:7:47: unsupported vector type: signed char (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-align-1.c`:                             {}, // COMPILE FAIL: vector-align-1.c:11:6: unsupported alignment 128 of char (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:                                 {}, // COMPILE FAIL: 20000822-1.c:12:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:                                 {}, // COMPILE FAIL: 20010209-1.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:                                 {}, // COMPILE FAIL: 20010605-1.c:5:14: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-1.c`:                                 {}, // COMPILE FAIL: 20010904-1.c:12:3: unsupported alignment 32 of Y (decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`:                                 {}, // COMPILE FAIL: 20010904-2.c:12:3: unsupported alignment 32 of Y (decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:                                 {}, // COMPILE FAIL: 20020412-1.c:31:7: invalid type size: -1 (expr.go:3834:primaryExpression: expr.go:530:expr0: expr.go:1586:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:493:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                                 {}, // COMPILE FAIL: 20030330-1.o.go:26:4: undefined: "link_error" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:                                 {}, // COMPILE FAIL: 20030501-1.c:7:9: nested functions not supported (decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:1557:unaryExpression: expr.go:101:expr: expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:                                 {}, // COMPILE FAIL: 20040423-1.c:13:22: incomplete type: array of int (expr.go:101:expr: expr.go:530:expr0: expr.go:1682:unaryExpression: type.go:410:isValidType: type.go:422:isValidType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:                                 {}, // COMPILE FAIL: 20040520-1.c:6:13: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:                                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (decl.go:296:externalDeclaration: decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex char _Complex char (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:745:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:                                 {}, // COMPILE FAIL: 20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:530:expr0: expr.go:1682:unaryExpression: type.go:410:isValidType: type.go:422:isValidType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                                 {}, // COMPILE FAIL: 20050316-1.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                                 {}, // COMPILE FAIL: 20050316-2.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                                 {}, // COMPILE FAIL: 20050316-3.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                                 {}, // COMPILE FAIL: 20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:338:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                                 {}, // COMPILE FAIL: 20050607-1.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                                 {}, // COMPILE FAIL: 20060420-1.o.go:26:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:                                 {}, // COMPILE FAIL: 20070919-1.c:31:7: invalid type size: -1 (expr.go:524:expr0: expr.go:3847:primaryExpression: decl.go:171:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:493:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:                                 {}, // COMPILE FAIL: 20090219-1.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:                                 {}, // COMPILE FAIL: 20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:                                   {}, // COMPILE FAIL: 920428-2.c:4:14: label declarations not supported (stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:392:selectionStatement: stmt.go:536:bracedStatement: stmt.go:545:unbracedStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:                                   {}, // COMPILE FAIL: 920501-7.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:                                   {}, // COMPILE FAIL: 920612-2.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:                                   {}, // COMPILE FAIL: 921017-1.c:7:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:                                   {}, // COMPILE FAIL: 921215-1.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:                                   {}, // COMPILE FAIL: TODO *cc.LabelDeclaration (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:                                   {}, // COMPILE FAIL: 931002-1.c:10:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:                                   {}, // COMPILE FAIL: 960416-1.c:57:23: helper: unsupported type: t_be (expr.go:1096:castExpression: expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:28:helper:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:                                   {}, // COMPILE FAIL: 970217-1.c:1:1: incomplete type: array of int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:                                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:                                   {}, // COMPILE FAIL: TODO 980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (stmt.go:360:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:115:expr: expr.go:165:convert: expr.go:298:convertMode:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:                                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:101:expr: expr.go:494:expr0: expr.go:3444:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/990326-1.c`:                                   {}, // COMPILE FAIL: "715.go: gofmt: signal: segmentation fault (core dumped)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                                    {}, // COMPILE FAIL: align-3.c:5:6: unsupported alignment 256 of function(void) (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-prefetch-3.c`:                         {}, // COMPILE FAIL: TODO exprUintptr (expr.go:530:expr0: expr.go:1557:unaryExpression: expr.go:101:expr: expr.go:522:expr0: expr.go:2028:postfixExpression: expr.go:2663:postfixExpressionSelect:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`:                 {}, // COMPILE FAIL: TODO *cc.InvalidType (expr.go:633:nonConstBool: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3083:postfixExpressionCall:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                                {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:                                {}, // COMPILE FAIL: comp-goto-2.c:15:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:                                  {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:2025:postfixExpression: expr.go:3178:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:381:functionDefinition0: decl.go:549:signature: type.go:48:typ2: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                                  {}, // COMPILE FAIL: TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:524:expr0: expr.go:3817:primaryExpression: expr.go:4290:primaryExpressionFloatConst:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:                                  {}, // COMPILE FAIL: fprintf-2.o.go:584:15: undefined: "tmpnam" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/mzero4.c`:                                {}, // COMPILE FAIL: mzero4.o.go:51:18: undefined: "tanf" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:                             {}, // COMPILE FAIL: pr72824-2.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:                                    {}, // COMPILE FAIL: medce-1.o.go:38:2: undefined: "link_error" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:                               {}, // COMPILE FAIL: nest-align-1.c:25:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:                               {}, // COMPILE FAIL: nest-stdar-1.c:5:10: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:                                 {}, // COMPILE FAIL: nestfunc-1.c:15:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:                                 {}, // COMPILE FAIL: nestfunc-2.c:13:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:                                 {}, // COMPILE FAIL: nestfunc-3.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:                                 {}, // COMPILE FAIL: nestfunc-5.c:8:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:                                 {}, // COMPILE FAIL: nestfunc-6.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:                                 {}, // COMPILE FAIL: nestfunc-7.c:15:12: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:                                  {}, // COMPILE FAIL: pr22061-1.c:4:6: incomplete type: array of array of char (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:                                  {}, // COMPILE FAIL: pr22061-2.c:2:13: incomplete type: array of array of char (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:                                  {}, // COMPILE FAIL: pr22061-3.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:                                  {}, // COMPILE FAIL: pr22061-4.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                                    {}, // COMPILE FAIL: pr23135.c:19:14: unsupported vector type: vecint (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4235:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                                    {}, // COMPILE FAIL: TODO (decl.go:830:initDeclarator: type.go:657:defineType: type.go:671:defineType0: type.go:593:defineUnionType: type.go:503:unionLiteral: type.go:325:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23467.c`:                                    {}, // COMPILE FAIL: pr23467.c:3:1: unsupported alignment 8 of int (decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:                                    {}, // COMPILE FAIL: pr24135.c:7:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                                    {}, // COMPILE FAIL: TODO SelectionStatementSwitch (decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:444:selectionStatement: stmt.go:512:selectionStatementFlat:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:                                    {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:                                    {}, // COMPILE FAIL: pr41935.c:10:10: TODO (expr.go:1905:postfixExpressionIndex: expr.go:101:expr: expr.go:522:expr0: expr.go:1956:postfixExpression: expr.go:1789:postfixExpressionIndex: expr.go:1739:mul:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:                                    {}, // COMPILE FAIL: pr49218.c:11:9: unsupported alignment 16 of L (expr.go:101:expr: expr.go:524:expr0: expr.go:3726:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:                                    {}, // COMPILE FAIL: pr51447.c:16:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                                  {}, // COMPILE FAIL: pr53645-2.c:44:3: unsupported vector type: UV (init.go:110:initializer: init.go:193:initializerArray: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                                    {}, // COMPILE FAIL: pr53645.c:44:3: unsupported vector type: UV (init.go:110:initializer: init.go:193:initializerArray: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:                                    {}, // COMPILE FAIL: pr54471.c:13:1: unsupported alignment 16 of unsigned __int128 (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:469:isValidType1: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:352:typ0: type.go:159:typ0:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                                    {}, // COMPILE FAIL: pr60960.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:                                    {}, // COMPILE FAIL: pr61375.c:15:1: unsupported alignment 16 of unsigned __int128 (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:                                    {}, // COMPILE FAIL: pr63302.c:14:1: unsupported alignment 16 of __int128 (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:                                    {}, // COMPILE FAIL: pr65170.c:12:1: unsupported alignment 16 of V (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                                    {}, // COMPILE FAIL: pr65427.c:4:3: unsupported vector type: V (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                                    {}, // COMPILE FAIL: -: TODO (expr.go:3444:assignmentExpression: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                                    {}, // COMPILE FAIL: TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:391:selectionStatement: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                                    {}, // COMPILE FAIL: pr70903.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:                                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                                    {}, // COMPILE FAIL: TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:391:selectionStatement: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                                  {}, // COMPILE FAIL: pr71626-1.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                                  {}, // COMPILE FAIL: pr71626-2.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                                    {}, // COMPILE FAIL: pr77767.c:4:1: incomplete type: array of int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:                                    {}, // COMPILE FAIL: pr82210.c:14:5: unsupported alignment 16 of struct T {c short} (expr.go:522:expr0: expr.go:1956:postfixExpression: expr.go:1873:postfixExpressionIndex: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                                    {}, // COMPILE FAIL: pr84169.c:9:3: unsupported alignment 16 of T (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:                                    {}, // COMPILE FAIL: pr84748.c:6:6: unsupported alignment 16 of u128 (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                                    {}, // COMPILE FAIL: pr85169.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:                                    {}, // COMPILE FAIL: pr85331.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:                                  {}, // COMPILE FAIL: pr85582-2.c:12:1: unsupported alignment 16 of S (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:469:isValidType1: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:                                  {}, // COMPILE FAIL: pr85582-3.c:12:1: unsupported alignment 16 of U (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:469:isValidType1: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:                                    {}, // COMPILE FAIL: TODO exprUintptr (expr.go:2028:postfixExpression: expr.go:2564:postfixExpressionSelect: expr.go:101:expr: expr.go:522:expr0: expr.go:2028:postfixExpression: expr.go:2663:postfixExpressionSelect:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                                    {}, // COMPILE FAIL: TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:                                   {}, // COMPILE FAIL: printf-2.o.go:597:15: undefined: "tmpnam" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:                               {}, // COMPILE FAIL: scal-to-vec1.c:34:28: unsupported vector type: short (expr.go:115:expr: expr.go:169:convert: expr.go:329:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:                               {}, // COMPILE FAIL: scal-to-vec2.c:35:28: unsupported vector type: char (expr.go:101:expr: expr.go:524:expr0: expr.go:3726:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:                               {}, // COMPILE FAIL: scal-to-vec3.c:20:28: unsupported vector type: float (expr.go:524:expr0: expr.go:3817:primaryExpression: expr.go:4273:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-1.c`:                                     {}, // COMPILE FAIL: simd-1.c:10:14: unsupported vector type: vecint (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-2.c`:                                     {}, // COMPILE FAIL: simd-2.c:8:14: unsupported vector type: vecint (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-4.c`:                                     {}, // COMPILE FAIL: simd-4.o.go:225:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-5.c`:                                     {}, // COMPILE FAIL: simd-5.c:5:9: unsupported vector type: Q (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4235:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                                     {}, // COMPILE FAIL: simd-6.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:                              {}, // COMPILE FAIL: string-opt-18.o.go:27:5: undefined: "mempcpy" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:                                {}, // COMPILE FAIL: user-printf.o.go:593:15: undefined: "tmpnam" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:)
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:                              {}, // COMPILE FAIL: zero-struct-2.c:15:48: TODO "Xone_raw_spinlock(cgtls)" raw_spinlock_t, 0 exprDefault -> spinlock_t, 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:522:expr0: expr.go:2206:postfixExpression: init.go:113:initializer: expr.go:115:expr: expr.go:169:convert: expr.go:341:convertType:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:                 {}, // COMPILE FAIL: 20000822-1.c:12:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:                 {}, // COMPILE FAIL: 20010209-1.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:                 {}, // COMPILE FAIL: 20010605-1.c:5:14: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-1.c`:                 {}, // COMPILE FAIL: 20010904-1.c:12:3: unsupported alignment 32 of Y (decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`:                 {}, // COMPILE FAIL: 20010904-2.c:12:3: unsupported alignment 32 of Y (decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:                 {}, // COMPILE FAIL: 20020412-1.c:31:7: invalid type size: -1 (expr.go:3834:primaryExpression: expr.go:530:expr0: expr.go:1586:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:493:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                 {}, // COMPILE FAIL: 20030330-1.o.go:26:4: undefined: "link_error" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:                 {}, // COMPILE FAIL: 20030501-1.c:7:9: nested functions not supported (decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:1557:unaryExpression: expr.go:101:expr: expr.go:524:expr0: expr.go:3834:primaryExpression: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:                 {}, // COMPILE FAIL: 20040423-1.c:13:22: incomplete type: array of int (expr.go:101:expr: expr.go:530:expr0: expr.go:1682:unaryExpression: type.go:410:isValidType: type.go:422:isValidType: type.go:486:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:                 {}, // COMPILE FAIL: 20040520-1.c:6:13: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (decl.go:296:externalDeclaration: decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:159:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                 {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex char _Complex char (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:745:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:                 {}, // COMPILE FAIL: 20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:530:expr0: expr.go:1682:unaryExpression: type.go:410:isValidType: type.go:422:isValidType: type.go:486:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                 {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                 {}, // COMPILE FAIL: 20050316-1.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                 {}, // COMPILE FAIL: 20050316-2.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                 {}, // COMPILE FAIL: 20050316-3.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                 {}, // COMPILE FAIL: 20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:338:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                 {}, // COMPILE FAIL: 20050607-1.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                 {}, // COMPILE FAIL: 20060420-1.o.go:26:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:                 {}, // COMPILE FAIL: 20070919-1.c:31:7: invalid type size: -1 (expr.go:524:expr0: expr.go:3847:primaryExpression: decl.go:171:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:493:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                 {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:                 {}, // COMPILE FAIL: 20090219-1.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:                 {}, // COMPILE FAIL: 20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:                   {}, // COMPILE FAIL: 920428-2.c:4:14: label declarations not supported (stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:392:selectionStatement: stmt.go:536:bracedStatement: stmt.go:545:unbracedStatement: stmt.go:358:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:                   {}, // COMPILE FAIL: 920501-7.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:                   {}, // COMPILE FAIL: 920612-2.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:                   {}, // COMPILE FAIL: 921017-1.c:7:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:                   {}, // COMPILE FAIL: 921215-1.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:                   {}, // COMPILE FAIL: TODO *cc.LabelDeclaration (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:                   {}, // COMPILE FAIL: 931002-1.c:10:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:                   {}, // COMPILE FAIL: gcc.c-torture/execute/960416-1.c:57:23: helper: unsupported type: t_be (expr.go:1096:castExpression: expr.go:101:expr: expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:28:helper:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:                   {}, // COMPILE FAIL: 970217-1.c:1:1: incomplete type: array of int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:                   {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:                   {}, // COMPILE FAIL: TODO 980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (stmt.go:360:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:115:expr: expr.go:165:convert: expr.go:298:convertMode:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:                   {}, // COMPILE FAIL: TODO UnaryExpressionLabelAddr (expr.go:101:expr: expr.go:494:expr0: expr.go:3444:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1691:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                    {}, // COMPILE FAIL: align-3.c:5:6: unsupported alignment 256 of function(void) (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-prefetch-3.c`:         {}, // COMPILE FAIL: TODO exprUintptr (expr.go:530:expr0: expr.go:1557:unaryExpression: expr.go:101:expr: expr.go:522:expr0: expr.go:2028:postfixExpression: expr.go:2663:postfixExpressionSelect:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`: {}, // COMPILE FAIL: TODO *cc.InvalidType (expr.go:633:nonConstBool: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3083:postfixExpressionCall:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:                {}, // COMPILE FAIL: comp-goto-2.c:15:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:                  {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:2025:postfixExpression: expr.go:3178:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                  {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:381:functionDefinition0: decl.go:549:signature: type.go:48:typ2: type.go:159:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                  {}, // COMPILE FAIL: TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:524:expr0: expr.go:3817:primaryExpression: expr.go:4290:primaryExpressionFloatConst:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:                  {}, // COMPILE FAIL: fprintf-2.o.go:584:15: undefined: "tmpnam" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/mzero4.c`:                {}, // COMPILE FAIL: mzero4.o.go:51:18: undefined: "tanf" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/mzero5.c`:                {}, // COMPILE FAIL: "889.go: gofmt: signal: segmentation fault (core dumped) (all_test.go:447:1: all_test.go:538:testExec1: ccgo.go:192:Main: ccgo.go:581:main: link.go:302:link: link.go:1080:link:)"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:             {}, // COMPILE FAIL: pr72824-2.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:                    {}, // COMPILE FAIL: medce-1.o.go:38:2: undefined: "link_error" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:               {}, // COMPILE FAIL: nest-align-1.c:25:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:               {}, // COMPILE FAIL: nest-stdar-1.c:5:10: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:                 {}, // COMPILE FAIL: nestfunc-1.c:15:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:                 {}, // COMPILE FAIL: nestfunc-2.c:13:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:                 {}, // COMPILE FAIL: nestfunc-3.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:                 {}, // COMPILE FAIL: nestfunc-5.c:8:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:                 {}, // COMPILE FAIL: nestfunc-6.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:                 {}, // COMPILE FAIL: nestfunc-7.c:15:12: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:                  {}, // COMPILE FAIL: pr22061-1.c:4:6: incomplete type: array of array of char (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:                  {}, // COMPILE FAIL: pr22061-2.c:2:13: incomplete type: array of array of char (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:                  {}, // COMPILE FAIL: pr22061-3.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:                  {}, // COMPILE FAIL: pr22061-4.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:383:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:363:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                    {}, // COMPILE FAIL: pr23135.c:19:14: unsupported vector type: vecint (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4235:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                    {}, // COMPILE FAIL: TODO (decl.go:830:initDeclarator: type.go:657:defineType: type.go:671:defineType0: type.go:593:defineUnionType: type.go:503:unionLiteral: type.go:325:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23467.c`:                    {}, // COMPILE FAIL: pr23467.c:3:1: unsupported alignment 8 of int (decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:                    {}, // COMPILE FAIL: pr24135.c:7:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                    {}, // COMPILE FAIL: TODO SelectionStatementSwitch (decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:444:selectionStatement: stmt.go:512:selectionStatementFlat:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:596:declaration: type.go:574:defineStructType: type.go:509:structLiteral: type.go:263:typ0: type.go:159:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:                    {}, // COMPILE FAIL: TODO UnaryExpressionReal (expr.go:101:expr: expr.go:494:expr0: expr.go:3439:assignmentExpression: expr.go:101:expr: expr.go:530:expr0: expr.go:1717:unaryExpression:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:                    {}, // COMPILE FAIL: pr41935.c:10:10: TODO (expr.go:1905:postfixExpressionIndex: expr.go:101:expr: expr.go:522:expr0: expr.go:1956:postfixExpression: expr.go:1789:postfixExpressionIndex: expr.go:1739:mul:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:                    {}, // COMPILE FAIL: pr49218.c:11:9: unsupported alignment 16 of L (expr.go:101:expr: expr.go:524:expr0: expr.go:3726:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:                    {}, // COMPILE FAIL: pr51447.c:16:3: label declarations not supported (compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:352:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:358:blockItem:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                  {}, // COMPILE FAIL: pr53645-2.c:44:3: unsupported vector type: UV (init.go:110:initializer: init.go:193:initializerArray: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                    {}, // COMPILE FAIL: pr53645.c:44:3: unsupported vector type: UV (init.go:110:initializer: init.go:193:initializerArray: type.go:42:typ: type.go:352:typ0: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:                    {}, // COMPILE FAIL: pr54471.c:13:1: unsupported alignment 16 of unsigned __int128 (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:469:isValidType1: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                    {}, // COMPILE FAIL: TODO *cc.PredefinedType _Complex int _Complex int (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:352:typ0: type.go:159:typ0:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                    {}, // COMPILE FAIL: pr60960.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:                    {}, // COMPILE FAIL: pr61375.c:15:1: unsupported alignment 16 of unsigned __int128 (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:                    {}, // COMPILE FAIL: pr63302.c:14:1: unsupported alignment 16 of __int128 (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:                    {}, // COMPILE FAIL: pr65170.c:12:1: unsupported alignment 16 of V (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                    {}, // COMPILE FAIL: pr65427.c:4:3: unsupported vector type: V (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                    {}, // COMPILE FAIL: -: TODO (expr.go:3444:assignmentExpression: expr.go:101:expr: expr.go:506:expr0: expr.go:914:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                    {}, // COMPILE FAIL: TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:391:selectionStatement: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                    {}, // COMPILE FAIL: pr70903.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:                    {}, // COMPILE FAIL: TODO <nil> (asm_riscv64.s:512:goexit: compile.go:433:compile: decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:344:functionDefinition0: decl.go:101:newFnCtx:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                    {}, // COMPILE FAIL: TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:391:selectionStatement: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                  {}, // COMPILE FAIL: pr71626-1.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                  {}, // COMPILE FAIL: pr71626-2.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                    {}, // COMPILE FAIL: pr77767.c:4:1: incomplete type: array of int (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:474:isValidType1: type.go:398:isValidParamType: type.go:486:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:                    {}, // COMPILE FAIL: pr82210.c:14:5: unsupported alignment 16 of struct T {c short} (expr.go:522:expr0: expr.go:1956:postfixExpression: expr.go:1873:postfixExpressionIndex: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                    {}, // COMPILE FAIL: pr84169.c:9:3: unsupported alignment 16 of T (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:                    {}, // COMPILE FAIL: pr84748.c:6:6: unsupported alignment 16 of u128 (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                    {}, // COMPILE FAIL: pr85169.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:                    {}, // COMPILE FAIL: pr85331.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:                  {}, // COMPILE FAIL: pr85582-2.c:12:1: unsupported alignment 16 of S (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:469:isValidType1: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:                  {}, // COMPILE FAIL: pr85582-3.c:12:1: unsupported alignment 16 of U (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:469:isValidType1: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:                    {}, // COMPILE FAIL: TODO exprUintptr (expr.go:2028:postfixExpression: expr.go:2564:postfixExpressionSelect: expr.go:101:expr: expr.go:522:expr0: expr.go:2028:postfixExpression: expr.go:2663:postfixExpressionSelect:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                    {}, // COMPILE FAIL: TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr90311.c`:                    {}, // COMPILE FAIL: TODO unsigned char + int -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2009:postfixExpression: expr.go:2296:addOverflow:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-1.c`:                  {}, // COMPILE FAIL: TODO int * int -> unsigned long long (expr.go:1638:unaryExpression: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-2.c`:                  {}, // COMPILE FAIL: TODO int * int -> unsigned long long (stmt.go:42:statement: stmt.go:391:selectionStatement: expr.go:101:expr: expr.go:522:expr0: expr.go:2007:postfixExpression: expr.go:2245:mulOverflow:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91635.c`:                    {}, // COMPILE FAIL: TODO int + int -> unsigned short (expr.go:494:expr0: expr.go:3559:assignmentExpression: expr.go:101:expr: expr.go:522:expr0: expr.go:2009:postfixExpression: expr.go:2296:addOverflow:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92618.c`:                    {}, // COMPILE FAIL: pr92618.o.go:31:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92904.c`:                    {}, // COMPILE FAIL: pr92904.c:12:10: unsupported alignment 16 of __int128 (decl.go:296:externalDeclaration: decl.go:606:declaration: decl.go:775:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93213.c`:                    {}, // COMPILE FAIL: pr93213.c:11:1: unsupported alignment 16 of u128 (decl.go:294:externalDeclaration: decl.go:322:functionDefinition: decl.go:342:functionDefinition0: type.go:469:isValidType1: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93434.c`:                    {}, // COMPILE FAIL: TODO "(!(((aai) != 0)))" int exprBool -> double exprDefault (expr.go:508:expr0: expr.go:1269:equalityExpression: expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:115:expr: expr.go:186:convert:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94412.c`:                    {}, // COMPILE FAIL: pr94412.o.go:19:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-1.c`:                  {}, // COMPILE FAIL: pr94524-1.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-2.c`:                  {}, // COMPILE FAIL: pr94524-2.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94591.c`:                    {}, // COMPILE FAIL: pr94591.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr98474.c`:                    {}, // COMPILE FAIL: pr98474.c:14:3: unsupported alignment 16 of T (expr.go:101:expr: expr.go:494:expr0: expr.go:3576:assignmentExpression: type.go:42:typ: type.go:65:typ0: type.go:441:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:                   {}, // COMPILE FAIL: printf-2.o.go:597:15: undefined: "tmpnam" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:               {}, // COMPILE FAIL: scal-to-vec1.c:34:28: unsupported vector type: short (expr.go:115:expr: expr.go:169:convert: expr.go:329:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:               {}, // COMPILE FAIL: scal-to-vec2.c:35:28: unsupported vector type: char (expr.go:101:expr: expr.go:524:expr0: expr.go:3726:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:               {}, // COMPILE FAIL: scal-to-vec3.c:20:28: unsupported vector type: float (expr.go:524:expr0: expr.go:3817:primaryExpression: expr.go:4273:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-1.c`:                     {}, // COMPILE FAIL: simd-1.c:10:14: unsupported vector type: vecint (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-2.c`:                     {}, // COMPILE FAIL: simd-2.c:8:14: unsupported vector type: vecint (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4252:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-4.c`:                     {}, // COMPILE FAIL: simd-4.o.go:225:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-5.c`:                     {}, // COMPILE FAIL: simd-5.c:5:9: unsupported vector type: Q (expr.go:524:expr0: expr.go:3815:primaryExpression: expr.go:4235:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:455:isValidType1:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                     {}, // COMPILE FAIL: simd-6.o.go:17:17: undefined: "main" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:              {}, // COMPILE FAIL: string-opt-18.o.go:27:5: undefined: "mempcpy" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:                {}, // COMPILE FAIL: user-printf.o.go:593:15: undefined: "tmpnam" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:              {}, // COMPILE FAIL: zero-struct-2.c:15:48: TODO "Xone_raw_spinlock(cgtls)" raw_spinlock_t, 0 exprDefault -> spinlock_t, 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:522:expr0: expr.go:2206:postfixExpression: init.go:113:initializer: expr.go:115:expr: expr.go:169:convert: expr.go:341:convertType:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/deref-compare-float.c`:                                {}, // COMPILE FAIL: TODO "((iqlibc.ppFloat64FromFloat64(0)) > (ppfloat64((*(*ppint32)(iqunsafe.ppPointer((Xi)))))))" int exprBool -> float exprDefault (expr.go:70:topExpr: expr.go:101:expr: expr.go:494:expr0: expr.go:3444:assignmentExpression: expr.go:115:expr: expr.go:186:convert:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/float-compare-equal.c`:                                {}, // COMPILE FAIL: TODO "((ppfloat32((ppfloat32(Xi)))) == (*(*ppfloat32)(iqunsafe.ppPointer((Xf)))))" int exprBool -> float exprDefault (expr.go:70:topExpr: expr.go:101:expr: expr.go:494:expr0: expr.go:3444:assignmentExpression: expr.go:115:expr: expr.go:186:convert:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-incomplete.c`:                                {}, // COMPILE FAIL: function-incomplete.c:6:9: too few arguments to function 'foo', type 'function(pointer to char) returning int' in 'foo()' (expr.go:1193:binopArgs: expr.go:1198:checkVolatileExpr: expr.go:101:expr: expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3134:postfixExpressionCall:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/identifier.c`:                                         {}, // COMPILE FAIL: invalid object file: multiple defintions of c (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:260:link: link.go:520:getFileSymbols:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-call.c`:                                    {}, // COMPILE FAIL: initialize-call.c:25:9: TODO "sigetobj(cgtls, (ppint32(2)), (ppint32(8)), (ppint32(1)))" struct obj {s array of 3 short}, 6 exprDefault -> struct {t struct obj}, 6 exprDefault (initialize-call.c:25:9:) (decl.go:898:initDeclarator: init.go:32:initializerOuter: init.go:113:initializer: expr.go:115:expr: expr.go:169:convert: expr.go:341:convertType:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-string.c`:                                  {}, // COMPILE FAIL: initialize-string.c:14:14: TODO "\"wat\\x00\"" pointer to char, 8 exprDefault -> array of 7 char, 7 exprDefault (initialize-string.c:14:14:) (decl.go:898:initDeclarator: init.go:32:initializerOuter: init.go:107:initializer: expr.go:115:expr: expr.go:169:convert: expr.go:341:convertType:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/string-addr.c`:                                        {}, // COMPILE FAIL: string-addr.c:4:16: TODO array of 6 char pointer to array of 6 char pointer to array of 6 char "Hello\x00" (expr.go:530:expr0: expr.go:1557:unaryExpression: expr.go:101:expr: expr.go:524:expr0: expr.go:3823:primaryExpression: expr.go:3980:primaryExpressionStringConst:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/stringify.c`:                                          {}, // COMPILE FAIL: TODO `'\xA'` -> invalid syntax (expr.go:3557:assignmentExpression: expr.go:70:topExpr: expr.go:101:expr: expr.go:524:expr0: expr.go:3819:primaryExpression: expr.go:4088:primaryExpressionCharConst:)
	`assets/tcc-0.9.27/tests/tests2/76_dollars_in_identifiers.c`:                                        {}, // COMPILE FAIL: 76_dollars_in_identifiers.c: gofmt: exit status 2 (.:0:: asm_riscv64.s:512:goexit: asm_riscv64.s:512:goexit: asm_riscv64.s:512:goexit: compile.go:495:compile: compile.go:495:compile:)
	`assets/tcc-0.9.27/tests/tests2/85_asm-outside-function.c`:                                          {}, // COMPILE FAIL: 85_asm-outside-function.o.go:18:2: undefined: "vide" external (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:814:link:) (all_test.go:440:1: all_test.go:526:testExec1: ccgo.go:189:Main: ccgo.go:573:main: link.go:302:link: link.go:817:link:)
	`assets/tcc-0.9.27/tests/tests2/87_dead_code.c`:                                                     {}, // COMPILE FAIL: 87_dead_code.c: gofmt: exit status 2 (.:0:: asm_riscv64.s:512:goexit: asm_riscv64.s:512:goexit: asm_riscv64.s:512:goexit: compile.go:495:compile: compile.go:495:compile:)
	`assets/tcc-0.9.27/tests/tests2/94_generic.c`:                                                       {}, // COMPILE FAIL: TODO PrimaryExpressionGeneric (expr.go:522:expr0: expr.go:2025:postfixExpression: expr.go:3236:postfixExpressionCall: expr.go:101:expr: expr.go:524:expr0: expr.go:3854:primaryExpression:)
	`assets/tcc-0.9.27/tests/tests2/95_bitfields.c`:                                                     {}, // COMPILE FAIL: 95_bitfields.c:27:5: unsupported alignment 16 of char (expr.go:101:expr: expr.go:530:expr0: expr.go:1658:unaryExpression: type.go:410:isValidType: type.go:422:isValidType: type.go:441:isValidType1:)
	`assets/tcc-0.9.27/tests/tests2/95_bitfields_ms.c`:                                                  {}, // COMPILE FAIL: 95_bitfields.c:27:5: unsupported alignment 16 of char (expr.go:101:expr: expr.go:530:expr0: expr.go:1658:unaryExpression: type.go:410:isValidType: type.go:422:isValidType: type.go:441:isValidType1:)
}
