<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw s2s-vpn`
This API allows you to manage your Site-to-Site VPN.
  
- [A connection represents the IPsec tunnel between VPN gateway and customer gateway.](#a-connection-represents-the-ipsec-tunnel-between-vpn-gateway-and-customer-gateway.)
  - [Create a connection](#create-a-connection)
  - [Delete a connection](#delete-a-connection)
  - [Detach a routing policy](#detach-a-routing-policy)
  - [Disable route propagation](#disable-route-propagation)
  - [Enable route propagation](#enable-route-propagation)
  - [Get a connection](#get-a-connection)
  - [List connections](#list-connections)
  - [Renew pre-shared key](#renew-pre-shared-key)
  - [Set a new routing policy](#set-a-new-routing-policy)
  - [Update a connection](#update-a-connection)
- [A customer gateway represents a Scaleway client's device that communicates with a VPN gateway.](#a-customer-gateway-represents-a-scaleway-client's-device-that-communicates-with-a-vpn-gateway.)
  - [Create a customer gateway](#create-a-customer-gateway)
  - [Delete a customer gateway](#delete-a-customer-gateway)
  - [Get a customer gateway](#get-a-customer-gateway)
  - [List customer gateways](#list-customer-gateways)
  - [Update a customer gateway](#update-a-customer-gateway)
- [By default, all routes across the Site-to-Site VPN (between VPN gateway and customer gateway) are blocked. Routing policies allow you to set filters to define the IP prefixes to allow.](#by-default,-all-routes-across-the-site-to-site-vpn-(between-vpn-gateway-and-customer-gateway)-are-blocked.-routing-policies-allow-you-to-set-filters-to-define-the-ip-prefixes-to-allow.)
  - [Create a routing policy](#create-a-routing-policy)
  - [Delete a routing policy](#delete-a-routing-policy)
  - [Get routing policy](#get-routing-policy)
  - [List routing policies](#list-routing-policies)
  - [Update a routing policy](#update-a-routing-policy)
- [A VPN gateway is an IPsec peer managed by Scaleway. It can support multiple connections to customer gateways.](#a-vpn-gateway-is-an-ipsec-peer-managed-by-scaleway.-it-can-support-multiple-connections-to-customer-gateways.)
  - [Create VPN gateway](#create-vpn-gateway)
  - [Delete a VPN gateway](#delete-a-vpn-gateway)
  - [Get a VPN gateway](#get-a-vpn-gateway)
  - [List VPN gateways](#list-vpn-gateways)
  - [Update a VPN gateway](#update-a-vpn-gateway)
- [VPN gateways come in various shapes, sizes and prices, which are  described by VPN gateway types. They represent the different commercial  offer types for VPN gateways available at Scaleway.](#vpn-gateways-come-in-various-shapes,-sizes-and-prices,-which-are--described-by-vpn-gateway-types.-they-represent-the-different-commercial--offer-types-for-vpn-gateways-available-at-scaleway.)
  - [List VPN gateway types](#list-vpn-gateway-types)

  
## A connection represents the IPsec tunnel between VPN gateway and customer gateway.

A connection represents the IPsec tunnel between VPN gateway and customer gateway.


### Create a connection

Create a connection.

**Usage:**

```
scw s2s-vpn connection create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the connection |
| tags.{index} |  | List of tags to apply to the connection |
| is-ipv6 |  | Defines IP version of the IPSec Tunnel |
| initiation-policy | Required<br />One of: `unknown_initiation_policy`, `vpn_gateway`, `customer_gateway` | Who initiates the IPsec tunnel |
| ikev2-ciphers.{index}.encryption | One of: `unknown_encryption`, `aes128`, `aes192`, `aes256`, `aes128gcm`, `aes192gcm`, `aes256gcm`, `aes128ccm`, `aes256ccm`, `chacha20poly1305` |  |
| ikev2-ciphers.{index}.integrity | One of: `unknown_integrity`, `sha256`, `sha384`, `sha512` |  |
| ikev2-ciphers.{index}.dh-group | One of: `unknown_dhgroup`, `modp2048`, `modp3072`, `modp4096`, `ecp256`, `ecp384`, `ecp521`, `curve25519` |  |
| esp-ciphers.{index}.encryption | One of: `unknown_encryption`, `aes128`, `aes192`, `aes256`, `aes128gcm`, `aes192gcm`, `aes256gcm`, `aes128ccm`, `aes256ccm`, `chacha20poly1305` |  |
| esp-ciphers.{index}.integrity | One of: `unknown_integrity`, `sha256`, `sha384`, `sha512` |  |
| esp-ciphers.{index}.dh-group | One of: `unknown_dhgroup`, `modp2048`, `modp3072`, `modp4096`, `ecp256`, `ecp384`, `ecp521`, `curve25519` |  |
| enable-route-propagation |  | Defines whether route propagation is enabled or not. |
| vpn-gateway-id | Required | ID of the VPN gateway to attach to the connection |
| customer-gateway-id | Required | ID of the customer gateway to attach to the connection |
| bgp-config-ipv4.routing-policy-id |  |  |
| bgp-config-ipv4.private-ip |  |  |
| bgp-config-ipv4.peer-private-ip |  |  |
| bgp-config-ipv6.routing-policy-id |  |  |
| bgp-config-ipv6.private-ip |  |  |
| bgp-config-ipv6.peer-private-ip |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a connection

Delete an existing connection, specified by its connection ID.

**Usage:**

```
scw s2s-vpn connection delete <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the connection to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Detach a routing policy

Detach an existing routing policy from a connection, specified by its connection ID.

**Usage:**

```
scw s2s-vpn connection detach-routing-policy <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the connection from which routing policy is being detached |
| routing-policy-v4 |  | ID of the routing policy to detach from the BGP IPv4 session |
| routing-policy-v6 |  | ID of the routing policy to detach from the BGP IPv6 session |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Disable route propagation

Prevent any prefixes from being announced in the BGP session. Traffic will not be able to flow over the VPN Gateway until route propagation is re-enabled.

**Usage:**

```
scw s2s-vpn connection disable-route-propagation <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the connection on which to disable route propagation |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Enable route propagation

Enable all allowed prefixes (defined in a routing policy) to be announced in the BGP session. This allows traffic to flow between the attached VPC and the on-premises infrastructure along the announced routes. Note that by default, even when route propagation is enabled, all routes are blocked. It is essential to attach a routing policy to define the ranges of routes to announce.

**Usage:**

```
scw s2s-vpn connection enable-route-propagation <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the connection on which to enable route propagation |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a connection

Get a connection for the given connection ID. The response object includes information about the connection's various configuration details.

**Usage:**

```
scw s2s-vpn connection get <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the requested connection |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List connections

List all your connections. A number of filters are available, including Project ID, name, tags and status.

**Usage:**

```
scw s2s-vpn connection list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `status_asc`, `status_desc` | Order in which to return results |
| project-id |  | Project ID to filter for |
| name |  | Connection name to filter for |
| tags.{index} |  | Tags to filter for |
| statuses.{index} | One of: `unknown_status`, `active`, `limited_connectivity`, `down`, `locked` | Connection statuses to filter for |
| is-ipv6 |  | Filter connections with IP version of IPSec tunnel |
| routing-policy-ids.{index} |  | Filter for connections using these routing policies |
| route-propagation-enabled |  | Filter for connections with route propagation enabled |
| vpn-gateway-ids.{index} |  | Filter for connections attached to these VPN gateways |
| customer-gateway-ids.{index} |  | Filter for connections attached to these customer gateways |
| organization-id |  | Organization ID to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Renew pre-shared key

Renew pre-shared key for a given connection.

**Usage:**

```
scw s2s-vpn connection renew-psk <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the connection to renew the PSK |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Set a new routing policy

Set a new routing policy on a connection, overriding the existing one if present, specified by its connection ID.

**Usage:**

```
scw s2s-vpn connection set-routing-policy <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the connection whose routing policy is being updated |
| routing-policy-v4 |  | ID of the routing policy to set for the BGP IPv4 session |
| routing-policy-v6 |  | ID of the routing policy to set for the BGP IPv6 session |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Update a connection

Update an existing connection, specified by its connection ID.

**Usage:**

```
scw s2s-vpn connection update <connection-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| connection-id | Required | ID of the connection to update |
| name |  | Name of the connection |
| tags.{index} |  | List of tags to apply to the connection |
| initiation-policy | One of: `unknown_initiation_policy`, `vpn_gateway`, `customer_gateway` | Who initiates the IPsec tunnel |
| ikev2-ciphers.{index}.encryption | One of: `unknown_encryption`, `aes128`, `aes192`, `aes256`, `aes128gcm`, `aes192gcm`, `aes256gcm`, `aes128ccm`, `aes256ccm`, `chacha20poly1305` |  |
| ikev2-ciphers.{index}.integrity | One of: `unknown_integrity`, `sha256`, `sha384`, `sha512` |  |
| ikev2-ciphers.{index}.dh-group | One of: `unknown_dhgroup`, `modp2048`, `modp3072`, `modp4096`, `ecp256`, `ecp384`, `ecp521`, `curve25519` |  |
| esp-ciphers.{index}.encryption | One of: `unknown_encryption`, `aes128`, `aes192`, `aes256`, `aes128gcm`, `aes192gcm`, `aes256gcm`, `aes128ccm`, `aes256ccm`, `chacha20poly1305` |  |
| esp-ciphers.{index}.integrity | One of: `unknown_integrity`, `sha256`, `sha384`, `sha512` |  |
| esp-ciphers.{index}.dh-group | One of: `unknown_dhgroup`, `modp2048`, `modp3072`, `modp4096`, `ecp256`, `ecp384`, `ecp521`, `curve25519` |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## A customer gateway represents a Scaleway client's device that communicates with a VPN gateway.

A customer gateway represents a Scaleway client's device that communicates with a VPN gateway.


### Create a customer gateway

Create a customer gateway.

**Usage:**

```
scw s2s-vpn customer-gateway create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the customer gateway |
| tags.{index} |  | List of tags to apply to the customer gateway |
| ipv4-public |  | Public IPv4 address of the customer gateway |
| ipv6-public |  | Public IPv6 address of the customer gateway |
| asn | Required | AS Number of the customer gateway |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a customer gateway

Delete an existing customer gateway, specified by its customer gateway ID.

**Usage:**

```
scw s2s-vpn customer-gateway delete <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the customer gateway to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a customer gateway

Get a customer gateway for the given customer gateway ID.

**Usage:**

```
scw s2s-vpn customer-gateway get <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the requested customer gateway |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List customer gateways

List all your customer gateways. A number of filters are available, including Project ID, name, and tags.

**Usage:**

```
scw s2s-vpn customer-gateway list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Order in which to return results |
| project-id |  | Project ID to filter for |
| name |  | Customer gateway name to filter for |
| tags.{index} |  | Tags to filter for |
| organization-id |  | Organization ID to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a customer gateway

Update an existing customer gateway, specified by its customer gateway ID. You can update its name, tags, public IPv4 & IPv6 address and AS Number.

**Usage:**

```
scw s2s-vpn customer-gateway update <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the customer gateway to update |
| name |  | Name of the customer gateway |
| tags.{index} |  | List of tags to apply to the customer gateway |
| ipv4-public |  | Public IPv4 address of the customer gateway |
| ipv6-public |  | Public IPv6 address of the customer gateway |
| asn |  | AS Number of the customer gateway |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## By default, all routes across the Site-to-Site VPN (between VPN gateway and customer gateway) are blocked. Routing policies allow you to set filters to define the IP prefixes to allow.

By default, all routes across the Site-to-Site VPN (between VPN gateway and customer gateway) are blocked. Routing policies allow you to set filters to define the IP prefixes to allow.


### Create a routing policy

Create a routing policy. Routing policies allow you to set IP prefix filters to define the incoming route announcements to accept from the customer gateway, and the outgoing routes to announce to the customer gateway.

**Usage:**

```
scw s2s-vpn routing-policy create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the routing policy |
| tags.{index} |  | List of tags to apply to the routing policy |
| is-ipv6 |  | IP prefixes version of the routing policy |
| prefix-filter-in.{index} |  | IP prefixes to accept from the peer (ranges of route announcements to accept) |
| prefix-filter-out.{index} |  | IP prefix filters to advertise to the peer (ranges of routes to advertise) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a routing policy

Delete an existing routing policy, specified by its routing policy ID.

**Usage:**

```
scw s2s-vpn routing-policy delete <routing-policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| routing-policy-id | Required | ID of the routing policy to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get routing policy

Get a routing policy for the given routing policy ID. The response object gives information including the policy's name, tags and prefix filters.

**Usage:**

```
scw s2s-vpn routing-policy get <routing-policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| routing-policy-id | Required | ID of the routing policy to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List routing policies

List all routing policies in a given region. A routing policy can be attached to one or multiple connections (S2S VPN connections).

**Usage:**

```
scw s2s-vpn routing-policy list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Order in which to return results |
| project-id |  | Project ID to filter for |
| name |  | Routing policy name to filter for |
| tags.{index} |  | Tags to filter for |
| ipv6 |  | Filter for the routing policies based on IP prefixes version |
| organization-id |  | Organization ID to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a routing policy

Update an existing routing policy, specified by its routing policy ID. Its name, tags and incoming/outgoing prefix filters can be updated.

**Usage:**

```
scw s2s-vpn routing-policy update <routing-policy-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| routing-policy-id | Required | ID of the routing policy to update |
| name |  | Name of the routing policy |
| tags.{index} |  | List of tags to apply to the routing policy |
| prefix-filter-in.{index} |  | IP prefixes to accept from the peer (ranges of route announcements to accept) |
| prefix-filter-out.{index} |  | IP prefix filters for routes to advertise to the peer (ranges of routes to advertise) |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## A VPN gateway is an IPsec peer managed by Scaleway. It can support multiple connections to customer gateways.

A VPN gateway is an IPsec peer managed by Scaleway. It can support multiple connections to customer gateways.


### Create VPN gateway

Create VPN gateway.

**Usage:**

```
scw s2s-vpn vpn-gateway create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Required | Name of the VPN gateway |
| tags.{index} |  | List of tags to apply to the VPN gateway |
| gateway-type | Required | VPN gateway type (commercial offer type) |
| public-config.ipam-ipv4-id |  |  |
| public-config.ipam-ipv6-id |  |  |
| private-network-id | Required | ID of the Private Network to attach to the VPN gateway |
| ipam-private-ipv4-id |  | ID of the IPAM private IPv4 address to attach to the VPN gateway |
| ipam-private-ipv6-id |  | ID of the IPAM private IPv6 address to attach to the VPN gateway |
| zone |  | Availability Zone where the VPN gateway should be provisioned. If no zone is specified, the VPN gateway will be automatically placed. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a VPN gateway

Delete an existing VPN gateway, specified by its VPN gateway ID.

**Usage:**

```
scw s2s-vpn vpn-gateway delete <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the VPN gateway to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a VPN gateway

Get a VPN gateway for the given VPN gateway ID.

**Usage:**

```
scw s2s-vpn vpn-gateway get <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the requested VPN gateway |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List VPN gateways

List all your VPN gateways. A number of filters are available, including Project ID, name, tags and status.

**Usage:**

```
scw s2s-vpn vpn-gateway list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc`, `type_asc`, `type_desc`, `status_asc`, `status_desc` | Order in which to return results |
| project-id |  | Project ID to filter for |
| name |  | VPN gateway name to filter for |
| tags.{index} |  | Tags to filter for |
| statuses.{index} | One of: `unknown_status`, `configuring`, `failed`, `provisioning`, `active`, `deprovisioning`, `locked` | VPN gateway statuses to filter for |
| gateway-types.{index} |  | Filter for VPN gateways of these types |
| private-network-ids.{index} |  | Filter for VPN gateways attached to these private networks |
| organization-id |  | Organization ID to filter for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a VPN gateway

Update an existing VPN gateway, specified by its VPN gateway ID. Only its name and tags can be updated.

**Usage:**

```
scw s2s-vpn vpn-gateway update <gateway-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| gateway-id | Required | ID of the VPN gateway to update |
| name |  | Name of the VPN gateway |
| tags.{index} |  | List of tags to apply to the VPN Gateway |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## VPN gateways come in various shapes, sizes and prices, which are  described by VPN gateway types. They represent the different commercial  offer types for VPN gateways available at Scaleway.

VPN gateways come in various shapes, sizes and prices, which are  described by VPN gateway types. They represent the different commercial  offer types for VPN gateways available at Scaleway.


### List VPN gateway types

List the different VPN gateway commercial offer types available at Scaleway. The response is an array of objects describing the name and technical details of each available VPN gateway type.

**Usage:**

```
scw s2s-vpn vpn-gateway-type list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



