// Code generated by 'go generate'; DO NOT EDIT.

package tshttpproxy

import (
	"syscall"
	"unsafe"

	"golang.org/x/sys/windows"
)

var _ unsafe.Pointer

// Do the interface allocations only once for common
// Errno values.
const (
	errnoERROR_IO_PENDING = 997
)

var (
	errERROR_IO_PENDING error = syscall.Errno(errnoERROR_IO_PENDING)
	errERROR_EINVAL     error = syscall.EINVAL
)

// errnoErr returns common boxed Errno values, to prevent
// allocations at runtime.
func errnoErr(e syscall.Errno) error {
	switch e {
	case 0:
		return errERROR_EINVAL
	case errnoERROR_IO_PENDING:
		return errERROR_IO_PENDING
	}
	// TODO: add more here, after collecting data on the common
	// error values see on Windows. (perhaps when running
	// all.bat?)
	return e
}

var (
	modkernel32 = windows.NewLazySystemDLL("kernel32.dll")
	modwinhttp  = windows.NewLazySystemDLL("winhttp.dll")

	procGlobalFree            = modkernel32.NewProc("GlobalFree")
	procWinHttpCloseHandle    = modwinhttp.NewProc("WinHttpCloseHandle")
	procWinHttpGetProxyForUrl = modwinhttp.NewProc("WinHttpGetProxyForUrl")
	procWinHttpOpen           = modwinhttp.NewProc("WinHttpOpen")
)

func globalFree(hglobal winHGlobal) (err error) {
	r1, _, e1 := syscall.SyscallN(procGlobalFree.Addr(), uintptr(hglobal))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func winHTTPCloseHandle(whi winHTTPInternet) (err error) {
	r1, _, e1 := syscall.SyscallN(procWinHttpCloseHandle.Addr(), uintptr(whi))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func winHTTPGetProxyForURL(whi winHTTPInternet, url *uint16, options *winHTTPAutoProxyOptions, proxyInfo *winHTTPProxyInfo) (err error) {
	r1, _, e1 := syscall.SyscallN(procWinHttpGetProxyForUrl.Addr(), uintptr(whi), uintptr(unsafe.Pointer(url)), uintptr(unsafe.Pointer(options)), uintptr(unsafe.Pointer(proxyInfo)))
	if r1 == 0 {
		err = errnoErr(e1)
	}
	return
}

func winHTTPOpen(agent *uint16, accessType uint32, proxy *uint16, proxyBypass *uint16, flags uint32) (whi winHTTPInternet, err error) {
	r0, _, e1 := syscall.SyscallN(procWinHttpOpen.Addr(), uintptr(unsafe.Pointer(agent)), uintptr(accessType), uintptr(unsafe.Pointer(proxy)), uintptr(unsafe.Pointer(proxyBypass)), uintptr(flags))
	whi = winHTTPInternet(r0)
	if whi == 0 {
		err = errnoErr(e1)
	}
	return
}
