"""Generated client library for externalexposure version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.externalexposure.v1alpha import externalexposure_v1alpha_messages as messages


class ExternalexposureV1alpha(base_api.BaseApiClient):
  """Generated client library for service externalexposure version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://externalexposure.googleapis.com/'
  MTLS_BASE_URL = 'https://externalexposure.mtls.googleapis.com/'

  _PACKAGE = 'externalexposure'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ExternalexposureV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new externalexposure handle."""
    url = url or self.BASE_URL
    super(ExternalexposureV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.folders_locations = self.FoldersLocationsService(self)
    self.folders = self.FoldersService(self)
    self.organizations_locations = self.OrganizationsLocationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_locations_internetExposedEndpoints = self.ProjectsLocationsInternetExposedEndpointsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_publicExposures = self.ProjectsLocationsPublicExposuresService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class FoldersLocationsService(base_api.BaseApiService):
    """Service class for the folders_locations resource."""

    _NAME = 'folders_locations'

    def __init__(self, client):
      super(ExternalexposureV1alpha.FoldersLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetScanMetrics(self, request, global_params=None):
      r"""Gets the latest scan metrics for a given scope. When called for a folder or organization, the metrics returned are an aggregation of metrics from all projects within the scope. This is a singleton resource.

      Args:
        request: (ExternalexposureFoldersLocationsGetScanMetricsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScanMetrics) The response message.
      """
      config = self.GetMethodConfig('GetScanMetrics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetScanMetrics.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/folders/{foldersId}/locations/{locationsId}/scanMetrics',
        http_method='GET',
        method_id='externalexposure.folders.locations.getScanMetrics',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureFoldersLocationsGetScanMetricsRequest',
        response_type_name='ScanMetrics',
        supports_download=False,
    )

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(ExternalexposureV1alpha.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsLocationsService(base_api.BaseApiService):
    """Service class for the organizations_locations resource."""

    _NAME = 'organizations_locations'

    def __init__(self, client):
      super(ExternalexposureV1alpha.OrganizationsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetScanMetrics(self, request, global_params=None):
      r"""Gets the latest scan metrics for a given scope. When called for a folder or organization, the metrics returned are an aggregation of metrics from all projects within the scope. This is a singleton resource.

      Args:
        request: (ExternalexposureOrganizationsLocationsGetScanMetricsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScanMetrics) The response message.
      """
      config = self.GetMethodConfig('GetScanMetrics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetScanMetrics.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/organizations/{organizationsId}/locations/{locationsId}/scanMetrics',
        http_method='GET',
        method_id='externalexposure.organizations.locations.getScanMetrics',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureOrganizationsLocationsGetScanMetricsRequest',
        response_type_name='ScanMetrics',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(ExternalexposureV1alpha.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsLocationsInternetExposedEndpointsService(base_api.BaseApiService):
    """Service class for the projects_locations_internetExposedEndpoints resource."""

    _NAME = 'projects_locations_internetExposedEndpoints'

    def __init__(self, client):
      super(ExternalexposureV1alpha.ProjectsLocationsInternetExposedEndpointsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new InternetExposedEndpoint in a given project and location.

      Args:
        request: (ExternalexposureProjectsLocationsInternetExposedEndpointsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/internetExposedEndpoints',
        http_method='POST',
        method_id='externalexposure.projects.locations.internetExposedEndpoints.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['internetExposedEndpointId', 'requestId'],
        relative_path='v1alpha/{+parent}/internetExposedEndpoints',
        request_field='internetExposedEndpoint',
        request_type_name='ExternalexposureProjectsLocationsInternetExposedEndpointsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single InternetExposedEndpoint.

      Args:
        request: (ExternalexposureProjectsLocationsInternetExposedEndpointsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/internetExposedEndpoints/{internetExposedEndpointsId}',
        http_method='DELETE',
        method_id='externalexposure.projects.locations.internetExposedEndpoints.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsInternetExposedEndpointsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single InternetExposedEndpoint.

      Args:
        request: (ExternalexposureProjectsLocationsInternetExposedEndpointsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InternetExposedEndpoint) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/internetExposedEndpoints/{internetExposedEndpointsId}',
        http_method='GET',
        method_id='externalexposure.projects.locations.internetExposedEndpoints.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsInternetExposedEndpointsGetRequest',
        response_type_name='InternetExposedEndpoint',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists InternetExposedEndpoints in a given project and location.

      Args:
        request: (ExternalexposureProjectsLocationsInternetExposedEndpointsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInternetExposedEndpointsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/internetExposedEndpoints',
        http_method='GET',
        method_id='externalexposure.projects.locations.internetExposedEndpoints.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/internetExposedEndpoints',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsInternetExposedEndpointsListRequest',
        response_type_name='ListInternetExposedEndpointsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single InternetExposedEndpoint.

      Args:
        request: (ExternalexposureProjectsLocationsInternetExposedEndpointsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/internetExposedEndpoints/{internetExposedEndpointsId}',
        http_method='PATCH',
        method_id='externalexposure.projects.locations.internetExposedEndpoints.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='internetExposedEndpoint',
        request_type_name='ExternalexposureProjectsLocationsInternetExposedEndpointsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(ExternalexposureV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (ExternalexposureProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='externalexposure.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='ExternalexposureProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (ExternalexposureProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='externalexposure.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ExternalexposureProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='externalexposure.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (ExternalexposureProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='externalexposure.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsPublicExposuresService(base_api.BaseApiService):
    """Service class for the projects_locations_publicExposures resource."""

    _NAME = 'projects_locations_publicExposures'

    def __init__(self, client):
      super(ExternalexposureV1alpha.ProjectsLocationsPublicExposuresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new PublicExposure in a given project and location.

      Args:
        request: (ExternalexposureProjectsLocationsPublicExposuresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/publicExposures',
        http_method='POST',
        method_id='externalexposure.projects.locations.publicExposures.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['publicExposureId', 'requestId'],
        relative_path='v1alpha/{+parent}/publicExposures',
        request_field='publicExposure',
        request_type_name='ExternalexposureProjectsLocationsPublicExposuresCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single PublicExposure.

      Args:
        request: (ExternalexposureProjectsLocationsPublicExposuresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/publicExposures/{publicExposuresId}',
        http_method='DELETE',
        method_id='externalexposure.projects.locations.publicExposures.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsPublicExposuresDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single PublicExposure.

      Args:
        request: (ExternalexposureProjectsLocationsPublicExposuresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicExposure) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/publicExposures/{publicExposuresId}',
        http_method='GET',
        method_id='externalexposure.projects.locations.publicExposures.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsPublicExposuresGetRequest',
        response_type_name='PublicExposure',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists PublicExposures in a given project and location.

      Args:
        request: (ExternalexposureProjectsLocationsPublicExposuresListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPublicExposuresResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/publicExposures',
        http_method='GET',
        method_id='externalexposure.projects.locations.publicExposures.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/publicExposures',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsPublicExposuresListRequest',
        response_type_name='ListPublicExposuresResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single PublicExposure.

      Args:
        request: (ExternalexposureProjectsLocationsPublicExposuresPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/publicExposures/{publicExposuresId}',
        http_method='PATCH',
        method_id='externalexposure.projects.locations.publicExposures.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='publicExposure',
        request_type_name='ExternalexposureProjectsLocationsPublicExposuresPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(ExternalexposureV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (ExternalexposureProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='externalexposure.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def GetScanMetrics(self, request, global_params=None):
      r"""Gets the latest scan metrics for a given scope. When called for a folder or organization, the metrics returned are an aggregation of metrics from all projects within the scope. This is a singleton resource.

      Args:
        request: (ExternalexposureProjectsLocationsGetScanMetricsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ScanMetrics) The response message.
      """
      config = self.GetMethodConfig('GetScanMetrics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetScanMetrics.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/scanMetrics',
        http_method='GET',
        method_id='externalexposure.projects.locations.getScanMetrics',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsGetScanMetricsRequest',
        response_type_name='ScanMetrics',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (ExternalexposureProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='externalexposure.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='ExternalexposureProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ExternalexposureV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
