/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jacoco;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.internal.Cast;
import org.gradle.internal.jacoco.JacocoCoverageParameters;
import org.gradle.testing.jacoco.tasks.rules.JacocoLimit;
import org.gradle.testing.jacoco.tasks.rules.JacocoViolationRule;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.Nullable;

public class AntJacocoCheck
implements Action<AntBuilderDelegate> {
    private static final String VIOLATIONS_ANT_PROPERTY = "jacocoViolations";
    private static final Predicate<JacocoViolationRule> RULE_ENABLED_PREDICATE = new Predicate<JacocoViolationRule>(){

        public boolean apply(JacocoViolationRule rule) {
            return rule.isEnabled();
        }
    };
    private final JacocoCoverageParameters params;

    public AntJacocoCheck(JacocoCoverageParameters params) {
        this.params = params;
    }

    public void execute(final AntBuilderDelegate antBuilder) {
        antBuilder.invokeMethod("taskdef", (Object)ImmutableMap.of((Object)"name", (Object)"jacocoReport", (Object)"classname", (Object)"org.jacoco.ant.ReportTask"));
        final Map emptyArgs = Collections.emptyMap();
        try {
            antBuilder.invokeMethod("jacocoReport", (Object)new Object[]{Collections.emptyMap(), new Closure<Object>((Object)this, (Object)this){

                public Object doCall(Object ignore) {
                    antBuilder.invokeMethod("executiondata", (Object)new Object[]{emptyArgs, new Closure<Object>((Object)this, (Object)this){

                        public Object doCall(Object ignore) {
                            AntJacocoCheck.this.params.getExecutionData().filter(File::exists).addToAntBuilder((Object)antBuilder, "resources");
                            return Void.class;
                        }
                    }});
                    ImmutableMap structureArgs = ImmutableMap.of((Object)"name", (Object)AntJacocoCheck.this.params.getProjectName().get());
                    antBuilder.invokeMethod("structure", (Object)new Object[]{structureArgs, new Closure<Object>((Object)this, (Object)this){

                        public Object doCall(Object ignore) {
                            antBuilder.invokeMethod("classfiles", (Object)new Object[]{emptyArgs, new Closure<Object>((Object)this, (Object)this){

                                public Object doCall(Object ignore) {
                                    AntJacocoCheck.this.params.getAllClassesDirs().filter(File::exists).addToAntBuilder((Object)antBuilder, "resources");
                                    return Void.class;
                                }
                            }});
                            String encoding = (String)AntJacocoCheck.this.params.getEncoding().getOrNull();
                            Map<String, String> sourcefilesArgs = encoding == null ? emptyArgs : Collections.singletonMap("encoding", encoding);
                            antBuilder.invokeMethod("sourcefiles", (Object)new Object[]{sourcefilesArgs, new Closure<Object>((Object)this, (Object)this){

                                public Object doCall(Object ignore) {
                                    AntJacocoCheck.this.params.getAllSourcesDirs().filter(File::exists).addToAntBuilder((Object)antBuilder, "resources");
                                    return Void.class;
                                }
                            }});
                            return Void.class;
                        }
                    }});
                    final Set rules = Sets.filter((Set)((Set)AntJacocoCheck.this.params.getRules().get()), (Predicate)RULE_ENABLED_PREDICATE);
                    if (!rules.isEmpty()) {
                        ImmutableMap checkArgs = ImmutableMap.of((Object)"failonviolation", (Object)AntJacocoCheck.this.params.getFailOnViolation().get(), (Object)"violationsproperty", (Object)AntJacocoCheck.VIOLATIONS_ANT_PROPERTY);
                        antBuilder.invokeMethod("check", (Object)new Object[]{checkArgs, new Closure<Object>((Object)this, (Object)this){

                            public Object doCall(Object ignore) {
                                for (final JacocoViolationRule rule : rules) {
                                    ImmutableMap ruleArgs = ImmutableMap.of((Object)"element", (Object)rule.getElement(), (Object)"includes", (Object)Joiner.on((char)':').join(rule.getIncludes()), (Object)"excludes", (Object)Joiner.on((char)':').join(rule.getExcludes()));
                                    antBuilder.invokeMethod("rule", (Object)new Object[]{ruleArgs, new Closure<Object>((Object)this, (Object)this){

                                        public Object doCall(Object ignore) {
                                            for (JacocoLimit limit : rule.getLimits()) {
                                                HashMap<String, Object> limitArgs = new HashMap<String, Object>();
                                                limitArgs.put("counter", limit.getCounter());
                                                limitArgs.put("value", limit.getValue());
                                                if (limit.getMinimum() != null) {
                                                    limitArgs.put("minimum", limit.getMinimum());
                                                }
                                                if (limit.getMaximum() != null) {
                                                    limitArgs.put("maximum", limit.getMaximum());
                                                }
                                                antBuilder.invokeMethod("limit", (Object)new Object[]{ImmutableMap.copyOf(limitArgs)});
                                            }
                                            return Void.class;
                                        }
                                    }});
                                }
                                return Void.class;
                            }
                        }});
                    }
                    return Void.class;
                }
            }});
        }
        catch (Exception e) {
            String violations = this.getViolations(antBuilder);
            throw new GradleException(violations == null ? e.getMessage() : violations);
        }
        GFileUtils.touch((File)((RegularFile)this.params.getDummyOutputFile().get()).getAsFile());
    }

    private @Nullable String getViolations(AntBuilderDelegate antBuilder) {
        return (String)Cast.uncheckedCast(antBuilder.getProjectProperties().get(VIOLATIONS_ANT_PROPERTY));
    }
}

