/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.serialize.Serializer;

public class TestInMemoryIndexedCache<K, V>
implements IndexedCache<K, V> {
    private final Map<Object, byte[]> entries = new ConcurrentHashMap<Object, byte[]>();
    private final ProducerGuard<K> producerGuard = ProducerGuard.serial();
    private final Serializer<V> valueSerializer;

    public TestInMemoryIndexedCache(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public V getIfPresent(K key) {
        byte[] serialised = this.entries.get(key);
        if (serialised == null) {
            return null;
        }
        try {
            ByteArrayInputStream instr = new ByteArrayInputStream(serialised);
            InputStreamBackedDecoder decoder = new InputStreamBackedDecoder((InputStream)instr);
            return (V)this.valueSerializer.read((Decoder)decoder);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public V get(K key, Function<? super K, ? extends V> producer) {
        return (V)this.producerGuard.guardByKey(key, () -> {
            if (!this.entries.containsKey(key)) {
                this.put(key, producer.apply((K)key));
            }
            return this.getIfPresent(key);
        });
    }

    public void put(K key, V value) {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder((OutputStream)outstr);
        try {
            this.valueSerializer.write((Encoder)encoder, value);
            encoder.flush();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.entries.put(key, outstr.toByteArray());
    }

    public void remove(K key) {
        this.entries.remove(key);
    }

    public Set<K> keySet() {
        return this.entries.keySet();
    }
}

