/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.ssh;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.SftpUploader;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.ssh.SshUtils;

public class SftpArtifactUploader
extends AbstractArtifactUploader<org.jreleaser.model.api.upload.SftpUploader, SftpUploader> {
    private SftpUploader uploader;

    public SftpArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public SftpUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(SftpUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "sftp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upload(String name) throws UploadException {
        Set artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        SSHClient ssh = SshUtils.createSSHClient(this.context, this.uploader);
        SFTPClient sftp = SshUtils.createSFTPClient(this.uploader, ssh);
        try {
            for (Artifact artifact : artifacts) {
                Path path = artifact.getEffectivePath(this.context);
                this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
                if (this.context.isDryrun()) continue;
                try {
                    String uploadPath = this.uploader.getResolvedPath(this.context, artifact);
                    this.context.getLogger().debug("   " + RB.$((String)"uploader.uploading.to", (Object[])new Object[]{uploadPath}));
                    SshUtils.createDirectories(this.context, this.uploader, ssh, Paths.get(uploadPath, new String[0]).getParent());
                    sftp.put(path.toAbsolutePath().toString(), uploadPath);
                }
                catch (IOException e) {
                    this.context.getLogger().trace((Throwable)e);
                    throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
                    return;
                }
            }
        }
        finally {
            SshUtils.close(this.uploader, sftp);
            SshUtils.disconnect(this.uploader, ssh);
        }
    }
}

