/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.JibConfiguration;
import org.jreleaser.model.internal.packagers.JibPackager;
import org.jreleaser.model.internal.packagers.JibSpec;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.tool.Jib;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class JibPackagerProcessor
extends AbstractRepositoryPackagerProcessor<JibPackager> {
    private static final String ROOT = "ROOT";

    public JibPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, TemplateContext props, String distributionName, Path prepareDirectory, String templateDirectory, String packagerName, boolean copyLicense) throws IOException, PackagerProcessingException {
        if (((JibPackager)this.packager).getActiveSpecs().isEmpty()) {
            super.doPrepareDistribution(distribution, props, distributionName, prepareDirectory, templateDirectory, packagerName, true);
            return;
        }
        String rootTemplateDirectory = ((JibPackager)this.getPackager()).getTemplateDirectory() + File.separator + ROOT;
        super.doPrepareDistribution(distribution, props, distributionName, prepareDirectory.resolve(ROOT), rootTemplateDirectory, ((JibPackager)this.packager).getType(), false);
        Files.deleteIfExists(prepareDirectory.resolve(ROOT).resolve("build.yml"));
        for (JibSpec spec : ((JibPackager)this.packager).getActiveSpecs()) {
            this.prepareSpec(distribution, props, distributionName, prepareDirectory, spec);
        }
    }

    private void prepareSpec(Distribution distribution, TemplateContext props, String distributionName, Path prepareDirectory, JibSpec spec) throws IOException, PackagerProcessingException {
        TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
        this.context.getLogger().debug(RB.$((String)"distributions.action.preparing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
        super.doPrepareDistribution(distribution, newProps, distributionName, prepareDirectory.resolve(spec.getName()), spec.getTemplateDirectory(), spec.getName() + "/" + ((JibPackager)this.packager).getType(), false);
    }

    private TemplateContext fillSpecProps(Distribution distribution, TemplateContext props, JibSpec spec) {
        List<Artifact> artifacts = Collections.singletonList(spec.getArtifact());
        TemplateContext newProps = this.fillProps(distribution, props);
        newProps.set("jibSpecName", (Object)spec.getName());
        this.fillJibProperties(newProps, (JibConfiguration)spec);
        this.verifyAndAddArtifacts(newProps, distribution, artifacts);
        Path prepareDirectory = (Path)newProps.get("distributionPrepareDirectory");
        newProps.set("distributionPrepareDirectory", (Object)prepareDirectory.resolve(spec.getName()));
        Path packageDirectory = (Path)newProps.get("distributionPackageDirectory");
        newProps.set("distributionPackageDirectory", (Object)packageDirectory.resolve(spec.getName()));
        return newProps;
    }

    @Override
    protected boolean verifyAndAddArtifacts(TemplateContext props, Distribution distribution) {
        if (((JibPackager)this.packager).getActiveSpecs().isEmpty()) {
            return super.verifyAndAddArtifacts(props, distribution);
        }
        return true;
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        if (((JibPackager)this.packager).getActiveSpecs().isEmpty()) {
            List artifacts = ((JibPackager)this.packager).resolveArtifacts(this.context, distribution);
            this.packageJib(distribution, props, packageDirectory, artifacts);
            return;
        }
        Path rootPrepareDirectory = this.getPrepareDirectory(props).resolve(ROOT);
        Path rootPackageDirectory = this.getPackageDirectory(props).resolve(ROOT);
        this.copyFiles(rootPrepareDirectory, rootPackageDirectory);
        for (JibSpec spec : ((JibPackager)this.packager).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.packaging", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
            this.packageJib(distribution, newProps, packageDirectory.resolve(spec.getName()), Collections.singletonList(spec.getArtifact()));
        }
    }

    protected void packageJib(Distribution distribution, TemplateContext props, Path packageDirectory, List<Artifact> artifacts) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        try {
            this.copyPreparedFiles(props);
            Path assemblyDirectory = packageDirectory.resolve("assembly");
            Files.createDirectories(assemblyDirectory, new FileAttribute[0]);
            for (Artifact artifact : artifacts) {
                Path artifactPath = artifact.getEffectivePath(this.context, distribution);
                if (distribution.getType() == Distribution.DistributionType.FLAT_BINARY) {
                    Files.copy(artifactPath, assemblyDirectory.resolve(artifactPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                FileUtils.unpackArchive((Path)artifactPath, (Path)assemblyDirectory);
            }
        }
        catch (IOException e) {
            throw new PackagerProcessingException((Throwable)e);
        }
    }

    @Override
    public void publishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        if (((JibPackager)this.packager).getActiveSpecs().isEmpty()) {
            this.publishToRepository(distribution, props);
            super.publishDistribution(distribution, props);
            return;
        }
        this.publishToRepository(distribution, props);
        for (JibSpec spec : ((JibPackager)this.packager).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.publishing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
            this.publishJib(newProps, (JibConfiguration)spec);
        }
    }

    private void publishToRepository(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        super.doPublishDistribution(distribution, this.fillProps(distribution, props));
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        this.publishJib(props, (JibConfiguration)this.getPackager());
    }

    protected void publishJib(TemplateContext props, JibConfiguration jibc) throws PackagerProcessingException {
        if (this.context.isDryrun()) {
            for (JibConfiguration.Registry registry : jibc.getRegistries()) {
                for (String imageName : jibc.getImageNames()) {
                    imageName = registry.getServer() + "/" + Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)imageName, (TemplateContext)props);
                    this.context.getLogger().info(" - {}", new Object[]{imageName});
                }
            }
            return;
        }
        if (((JibPackager)this.packager).isSkipPublishing()) {
            this.context.getLogger().info(RB.$((String)"packager.skip.publishing", (Object[])new Object[0]));
            return;
        }
        Jib jib = new Jib(this.context.asImmutable(), ((JibPackager)this.packager).getVersion());
        try {
            if (!jib.setup()) {
                throw new PackagerProcessingException(RB.$((String)"tool_unavailable", (Object[])new Object[]{"jib"}));
            }
        }
        catch (ToolException e) {
            throw new PackagerProcessingException(RB.$((String)"tool_unavailable", (Object[])new Object[]{"jib"}));
        }
        Path packageDirectory = this.getPackageDirectory(props);
        for (JibConfiguration.Registry registry : jibc.getRegistries()) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("build");
            args.add("--console");
            args.add("plain");
            args.add("--verbosity");
            args.add("error");
            args.add("-c");
            args.add(packageDirectory.toAbsolutePath().toString());
            args.add("-b");
            args.add(packageDirectory.resolve("build.yml").toAbsolutePath().toString());
            if (StringUtils.isNotBlank((String)registry.getUsername())) {
                args.add("--username=" + registry.getUsername());
            }
            if (StringUtils.isNotBlank((String)registry.getFromUsername())) {
                args.add("--from-username=" + registry.getFromUsername());
            }
            if (StringUtils.isNotBlank((String)registry.getToUsername())) {
                args.add("--to-username=" + registry.getToUsername());
            }
            if (StringUtils.isNotBlank((String)registry.getPassword())) {
                args.add("--password=" + registry.getPassword());
            }
            if (StringUtils.isNotBlank((String)registry.getFromPassword())) {
                args.add("--from-password=" + registry.getFromPassword());
            }
            if (StringUtils.isNotBlank((String)registry.getToPassword())) {
                args.add("--to-password=" + registry.getToPassword());
            }
            for (String imageName : jibc.getImageNames()) {
                imageName = registry.getServer() + "/" + Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)imageName, (TemplateContext)props);
                ArrayList<String> argsCopy = new ArrayList<String>(args);
                argsCopy.add("-t");
                argsCopy.add(imageName);
                try {
                    this.context.getLogger().info(" - {}", new Object[]{imageName});
                    jib.invoke(this.context.getBasedir(), argsCopy);
                }
                catch (CommandException e) {
                    throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.setOrEmpty("distributionJavaMainClass", distribution.getJava().getMainClass());
        props.setOrEmpty("distributionJavaMainModule", distribution.getJava().getMainModule());
        this.fillJibProperties(props, (JibConfiguration)this.getPackager());
    }

    protected void fillJibProperties(TemplateContext props, JibConfiguration jib) {
        props.set("jibBaseImage", (Object)jib.getBaseImage());
        props.set("jibCreationTime", (Object)jib.getCreationTime());
        props.set("jibFormat", (Object)jib.getFormat().formatted());
        props.set("jibUser", (Object)jib.getUser());
        props.set("jibWorkingDirectory", (Object)jib.getWorkingDirectory());
        props.set("jibHasVolumes", (Object)(!jib.getVolumes().isEmpty() ? 1 : 0));
        props.set("jibVolumes", (Object)jib.getVolumes());
        props.set("jibHasExposedPorts", (Object)(!jib.getExposedPorts().isEmpty() ? 1 : 0));
        props.set("jibExposedPorts", (Object)jib.getExposedPorts());
        props.set("jibHasEnvironment", (Object)(!jib.getEnvironment().isEmpty() ? 1 : 0));
        TreeSet env = new TreeSet();
        jib.getEnvironment().forEach((key, value) -> env.add(MustacheUtils.passThrough((String)("\"" + key + "\": \"" + Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)value, (TemplateContext)props) + "\""))));
        props.set("jibEnvironment", env);
        TreeSet labels = new TreeSet();
        jib.getLabels().forEach((key, value) -> labels.add(MustacheUtils.passThrough((String)("\"" + key + "\": \"" + Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)value, (TemplateContext)props) + "\""))));
        props.set("jibLabels", labels);
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "executable".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("assembly").resolve(distribution.getExecutable().getName()) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected void prepareWorkingCopy(TemplateContext props, Path directory, Distribution distribution) throws IOException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        List activeSpecs = ((JibPackager)this.packager).getActiveSpecs();
        if (activeSpecs.isEmpty()) {
            for (String imageName : ((JibPackager)this.packager).getImageNames()) {
                this.copyJibfiles(packageDirectory, Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)imageName, (TemplateContext)props), directory, false);
            }
        } else {
            this.prepareWorkingCopy(packageDirectory.resolve(ROOT), directory);
            for (JibSpec spec : activeSpecs) {
                TemplateContext newProps = this.fillSpecProps(distribution, props, spec);
                for (String imageName : spec.getImageNames()) {
                    this.copyJibfiles(packageDirectory.resolve(spec.getName()), Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)imageName, (TemplateContext)newProps), directory, true);
                }
            }
        }
    }

    private void copyJibfiles(Path source, String imageName, Path directory, boolean isSpec) throws IOException {
        Path destination = directory;
        String[] parts = imageName.split("/");
        parts = parts[parts.length - 1].split(":");
        if (isSpec) {
            destination = directory.resolve(parts[0]);
        }
        if (((JibPackager)this.packager).getPackagerRepository().isVersionedSubfolders()) {
            destination = directory.resolve(parts[1]);
        }
        Path assembly = destination.resolve("assembly");
        FileUtils.deleteFiles((Path)assembly);
        Files.createDirectories(destination, new FileAttribute[0]);
        this.prepareWorkingCopy(source, destination, (Path path) -> "assembly".equals(path.getFileName().toString()));
    }
}

