/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.v1;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import twitter4j.v1.GeoLocation;

public final class StatusUpdate
implements Serializable {
    private static final long serialVersionUID = 7422094739799350035L;
    public final String status;
    public final long inReplyToStatusId;
    public final GeoLocation location;
    public final String placeId;
    public final boolean displayCoordinates;
    public final boolean possiblySensitive;
    public final String mediaName;
    public final transient InputStream mediaBody;
    public final File mediaFile;
    public final long[] mediaIds;
    public final boolean autoPopulateReplyMetadata;
    public final String attachmentUrl;

    public static StatusUpdate of(String tweetText) {
        return new StatusUpdate(tweetText, -1L, null, null, false, false, null, null, null, null, false, null);
    }

    private StatusUpdate(String status, long inReplyToStatusId, GeoLocation location, String placeId, boolean displayCoordinates, boolean possiblySensitive, String mediaName, InputStream mediaBody, File mediaFile, long[] mediaIds, boolean autoPopulateReplyMetadata, String attachmentUrl) {
        this.status = status;
        this.inReplyToStatusId = inReplyToStatusId;
        this.location = location;
        this.placeId = placeId;
        this.displayCoordinates = displayCoordinates;
        this.possiblySensitive = possiblySensitive;
        this.mediaName = mediaName;
        this.mediaBody = mediaBody;
        this.mediaFile = mediaFile;
        this.mediaIds = mediaIds;
        this.autoPopulateReplyMetadata = autoPopulateReplyMetadata;
        this.attachmentUrl = attachmentUrl;
    }

    public StatusUpdate inReplyToStatusId(long inReplyToStatusId) {
        return new StatusUpdate(this.status, inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate location(double latitude, double longitude) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, GeoLocation.of(latitude, longitude), this.placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate placeId(String placeId) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate displayCoordinates(boolean displayCoordinates) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, this.placeId, displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate media(File mediaFile) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate mediaIds(long ... mediaIds) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate attachmentUrl(String attachmentUrl) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, attachmentUrl);
    }

    public StatusUpdate media(String mediaName, InputStream mediaBody) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, this.possiblySensitive, mediaName, mediaBody, this.mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate possiblySensitive(boolean possiblySensitive) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.mediaIds, this.autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public StatusUpdate autoPopulateReplyMetadata(boolean autoPopulateReplyMetadata) {
        return new StatusUpdate(this.status, this.inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.mediaIds, autoPopulateReplyMetadata, this.attachmentUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusUpdate that = (StatusUpdate)o;
        return this.inReplyToStatusId == that.inReplyToStatusId && this.displayCoordinates == that.displayCoordinates && this.possiblySensitive == that.possiblySensitive && this.autoPopulateReplyMetadata == that.autoPopulateReplyMetadata && Objects.equals(this.status, that.status) && Objects.equals(this.location, that.location) && Objects.equals(this.placeId, that.placeId) && Objects.equals(this.mediaName, that.mediaName) && Objects.equals(this.mediaBody, that.mediaBody) && Objects.equals(this.mediaFile, that.mediaFile) && Arrays.equals(this.mediaIds, that.mediaIds) && Objects.equals(this.attachmentUrl, that.attachmentUrl);
    }

    public int hashCode() {
        int result = Objects.hash(this.status, this.inReplyToStatusId, this.location, this.placeId, this.displayCoordinates, this.possiblySensitive, this.mediaName, this.mediaBody, this.mediaFile, this.autoPopulateReplyMetadata, this.attachmentUrl);
        result = 31 * result + Arrays.hashCode(this.mediaIds);
        return result;
    }

    public String toString() {
        return "StatusUpdate{status='" + this.status + '\'' + ", inReplyToStatusId=" + this.inReplyToStatusId + ", location=" + this.location + ", placeId='" + this.placeId + '\'' + ", displayCoordinates=" + this.displayCoordinates + ", possiblySensitive=" + this.possiblySensitive + ", mediaName='" + this.mediaName + '\'' + ", mediaBody=" + this.mediaBody + ", mediaFile=" + this.mediaFile + ", mediaIds=" + Arrays.toString(this.mediaIds) + ", autoPopulateReplyMetadata=" + this.autoPopulateReplyMetadata + ", attachmentUrl='" + this.attachmentUrl + '\'' + '}';
    }
}

