# psasim

PSASIM holds necessary C source and header files which allows to test Mbed TLS in a "pure crypto client" scenario, i.e `MBEDTLS_PSA_CRYPTO_CLIENT && !MBEDTLS_PSA_CRYPTO_C`.
In practical terms it means that this allow to build PSASIM with Mbed TLS sources and get 2 Linux applications, a client and a server, which are connected through Linux's shared memeory, and in which the client relies on the server to perform all PSA Crypto operations.

The goal of PSASIM is _not_ to provide a ready-to-use solution for anyone looking to implement the pure crypto client structure (see [Limitations](#limitations) for details), but to provide an example of TF-PSA-Crypto RPC (Remote Procedure Call) implementation using Mbed TLS.
## Limitations

In the current implementation:

- Only Linux PC is supported.
- There can be only 1 client connected to 1 server.
- Shared memory is the only communication medium allowed. Others can be implemented (ex: net sockets), but in terms of simulation speed shared memory proved to be the fastest.
- Server is not secure at all: keys and operation structs are stored on the RAM, so they can easily be dumped.

## Testing

Please refer to `tests/scripts/components-psasim.sh` for guidance on how to build & test PSASIM:

- `component_test_psasim()`: builds the server and a couple of test clients which are used to evaluate some basic PSA Crypto API commands.
- `component_test_suite_with_psasim()`: builds the server and _all_ the usual test suites (those found under the `<mbedtls-root>/tests/suites/*` folder) which are used by the CI and runs them. A small subset of test suites (`test_suite_constant_time_hmac`,`test_suite_lmots`,`test_suite_lms`) are being skipped, for CI turnover time optimization. They can be run locally if required.

## How to update automatically generated files

A significant portion of the intermediate code of PSASIM is auto-generated using Perl. In particular:

- `psa_sim_serialise.[c|h]`:
    - Generated by `psa_sim_serialise.pl`.
    - These files provide the serialisation/deserialisation support that is required to pass functions' parameters between client and server.
- `psa_sim_crypto_[client|server].c` and `psa_functions_codes.h`:
    - Generated by `psa_sim_generate.pl`.
    - `psa_sim_crypto_[client|server].c` provide interfaces for PSA Crypto APIs on client and server sides, while `psa_functions_codes.h` simply enumerates all PSA Crypto APIs.

These files need to be regenerated whenever some PSA Crypto API is added/deleted/modified. The procedure is as follows:

- `psa_sim_serialise.[c|h]`:
    - go to `<mbedtls-root>/tests/psa-client-server/psasim/src/`
    - run `./psa_sim_serialise.pl h > psa_sim_serialise.h`
    - run `./psa_sim_serialise.pl c > psa_sim_serialise.c`
- `psa_sim_crypto_[client|server].c` and `psa_functions_codes.h`:
    - go to Mbed TLS' root folder
    - run `./tests/psa-client-server/psasim/src/psa_sim_generate.pl`
