/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.transport.http;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractorStrategy;

@Singleton
@Named(value="nx2")
public final class Nx2ChecksumExtractor
extends ChecksumExtractorStrategy {
    public static final String NAME = "nx2";

    public Map<String, String> extractChecksums(Function<String, String> headerGetter) {
        String etag = headerGetter.apply("ETag");
        if (etag != null) {
            int start = etag.indexOf("SHA1{");
            int end = etag.indexOf("}", start + 5);
            if (start >= 0 && end > start) {
                return Collections.singletonMap("SHA-1", etag.substring(start + 5, end));
            }
        }
        return null;
    }
}

