/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cling.invoker.mvn.CommonsCliMavenOptions;
import org.apache.maven.jline.MessageUtils;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.OptionType;

public class CommonsCliDaemonMavenOptions
extends CommonsCliMavenOptions {
    public static CommonsCliDaemonMavenOptions parse(String source, String[] args) throws ParseException {
        CLIManager cliManager = new CLIManager();
        return new CommonsCliDaemonMavenOptions(source, cliManager, cliManager.parse(args));
    }

    protected CommonsCliDaemonMavenOptions(String source, CLIManager cliManager, CommandLine commandLine) {
        super(source, (CommonsCliMavenOptions.CLIManager)cliManager, commandLine);
    }

    protected static class CLIManager
    extends CommonsCliMavenOptions.CLIManager {
        private static final Pattern HTML_TAGS_PATTERN = Pattern.compile("<[^>]*>");
        private static final Pattern COLUMNS_DETECTOR_PATTERN = Pattern.compile("^[ ]+[^s]");
        private static final Pattern WS_PATTERN = Pattern.compile("\\s+");

        protected CLIManager() {
        }

        static String toPlainText(String javadocText) {
            return HTML_TAGS_PATTERN.matcher(javadocText).replaceAll("");
        }

        public void displayHelp(String command, Consumer<String> pw) {
            ArrayList mvnHelp = new ArrayList();
            super.displayHelp(command, mvnHelp::add);
            Matcher m = COLUMNS_DETECTOR_PATTERN.matcher(String.join((CharSequence)"\n", mvnHelp));
            String indent = m.find() ? m.group() : "                                        ";
            int terminalWidth = CLIManager.getTerminalWidth() <= 0 ? 74 : CLIManager.getTerminalWidth();
            String lineSeparator = System.lineSeparator();
            StringBuilder help = new StringBuilder().append(lineSeparator).append("mvnd specific options:");
            Environment.documentedEntries().forEach(entry -> {
                Set opts;
                Environment env = (Environment)entry.getEntry();
                help.append(lineSeparator);
                int indentPos = help.length() + indent.length();
                int lineEnd = help.length() + terminalWidth;
                CLIManager.spaces(help, 1);
                String property = env.getProperty();
                if (property != null) {
                    help.append("-D").append(property);
                    if (env.getType() != OptionType.VOID) {
                        help.append("=<").append(env.getType().name().toLowerCase(Locale.ROOT)).append('>');
                    }
                }
                if (!(opts = env.getOptions()).isEmpty()) {
                    if (property != null) {
                        help.append(';');
                    }
                    boolean first = true;
                    for (String opt : opts) {
                        if (first) {
                            first = false;
                        } else {
                            help.append(',');
                        }
                        help.append(opt);
                    }
                    if (env.getType() != OptionType.VOID) {
                        help.append(" <").append(env.getType().name().toLowerCase(Locale.ROOT)).append('>');
                    }
                }
                help.append(' ');
                CLIManager.spaces(help, indentPos - help.length());
                CLIManager.wrap(help, CLIManager.toPlainText(entry.getJavaDoc()), terminalWidth, lineEnd, indent);
                if (env.isDocumentedAsDiscriminating()) {
                    CLIManager.indentedLine(help, terminalWidth, "This is a discriminating start parameter.", indent);
                }
                if (env.getDefault() != null) {
                    CLIManager.indentedLine(help, terminalWidth, "Default: " + env.getDefault(), indent);
                }
                if (env.getEnvironmentVariable() != null) {
                    CLIManager.indentedLine(help, terminalWidth, "Env. variable: " + env.getEnvironmentVariable(), indent);
                }
            });
            help.append(lineSeparator).append(lineSeparator).append("mvnd value types:");
            OptionType.documentedEntries().forEach(entry -> {
                OptionType type = (OptionType)entry.getEntry();
                help.append(lineSeparator);
                int indentPos = help.length() + indent.length();
                int lineEnd = help.length() + terminalWidth;
                CLIManager.spaces(help, 1);
                help.append(type.name().toLowerCase(Locale.ROOT));
                CLIManager.spaces(help, indentPos - help.length());
                CLIManager.wrap(help, CLIManager.toPlainText(entry.getJavaDoc()), terminalWidth, lineEnd, indent);
            });
            Stream.concat(mvnHelp.stream(), Stream.of(help.toString().split(lineSeparator))).forEach(pw);
        }

        private static int getTerminalWidth() {
            int terminalWidth = MessageUtils.getTerminalWidth();
            if (terminalWidth <= 0) {
                terminalWidth = 74;
            }
            return terminalWidth;
        }

        private static void indentedLine(StringBuilder stringBuilder, int terminalWidth, String text, String indent) {
            int lineEnd = stringBuilder.length() + terminalWidth;
            stringBuilder.append(System.lineSeparator()).append(indent);
            CLIManager.wrap(stringBuilder, text, terminalWidth, lineEnd, indent);
        }

        static void wrap(StringBuilder stringBuilder, String text, int lineLength, int nextLineEnd, String indent) {
            StringTokenizer st = new StringTokenizer(text, " \t\n\r", true);
            String lastWs = null;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (WS_PATTERN.matcher(token).matches()) {
                    lastWs = token;
                    continue;
                }
                if (stringBuilder.length() + token.length() + (lastWs != null ? lastWs.length() : 0) < nextLineEnd) {
                    if (lastWs != null) {
                        stringBuilder.append(lastWs);
                    }
                    stringBuilder.append(token);
                } else {
                    nextLineEnd = stringBuilder.length() + lineLength;
                    stringBuilder.append(System.lineSeparator()).append(indent).append(token);
                }
                lastWs = null;
            }
        }

        static void spaces(StringBuilder stringBuilder, int count) {
            stringBuilder.append(" ".repeat(Math.max(0, count)));
        }
    }
}

