/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ProblemCollector;

@Experimental
public class ModelBuilderException
extends MavenException {
    private static final long serialVersionUID = -1865447022070650896L;
    private final ModelBuilderResult result;

    public ModelBuilderException(ModelBuilderResult result) {
        super(result.toString());
        this.result = result;
    }

    public ModelBuilderResult getResult() {
        return this.result;
    }

    public String getModelId() {
        if (this.result == null) {
            return "";
        }
        if (this.result.getEffectiveModel() != null) {
            return this.result.getEffectiveModel().getId();
        }
        if (this.result.getRawModel() != null) {
            return this.result.getRawModel().getId();
        }
        if (this.result.getFileModel() != null) {
            return this.result.getFileModel().getId();
        }
        return "";
    }

    public ProblemCollector<ModelProblem> getProblemCollector() {
        if (this.result == null) {
            return ProblemCollector.empty();
        }
        return this.result.getProblemCollector();
    }
}

