var ml_kem_vectors = {};

// ML-KEM-512 test vectors
ml_kem_vectors['ML-KEM-512'] = {
  // 800-byte publicKey
  publicKey: new Uint8Array([
    0xce, 0xcb, 0x75, 0x1f, 0x32, 0x67, 0x09, 0xb4, 0x9e, 0x14, 0xca, 0xa4,
    0xbe, 0x30, 0x95, 0xee, 0xe9, 0x85, 0x58, 0x86, 0x2b, 0x83, 0xb9, 0x33,
    0x56, 0x86, 0x4e, 0xad, 0x05, 0xcb, 0x38, 0x26, 0x95, 0x4c, 0xdb, 0xb2,
    0x1d, 0xc4, 0x52, 0x44, 0x60, 0x36, 0xdd, 0x77, 0x82, 0x30, 0x09, 0x4f,
    0xe3, 0xb8, 0x14, 0xc7, 0x99, 0x8f, 0x94, 0x45, 0x82, 0xd3, 0x89, 0xcc,
    0xc7, 0x38, 0x97, 0x4e, 0x39, 0x49, 0x6d, 0xb5, 0x34, 0xd4, 0xdb, 0x78,
    0x4b, 0x65, 0x44, 0x6e, 0xa9, 0xbc, 0x59, 0xe8, 0x96, 0xa3, 0x39, 0xbe,
    0x6c, 0x13, 0x46, 0x3a, 0xb7, 0x4a, 0xe2, 0x02, 0x8a, 0x12, 0x69, 0x5c,
    0x5b, 0x12, 0xc1, 0xc9, 0xd5, 0x70, 0x06, 0x58, 0x19, 0xf6, 0x82, 0x3b,
    0x53, 0x3b, 0x29, 0xbb, 0xc8, 0x93, 0x8b, 0xc0, 0xaa, 0x74, 0x52, 0x77,
    0xe7, 0x33, 0x57, 0xd9, 0x52, 0x5c, 0xec, 0x0c, 0xaf, 0xe1, 0xf0, 0x8a,
    0x1b, 0x9b, 0x11, 0xa2, 0xf8, 0xaa, 0xc1, 0xf5, 0xab, 0xb2, 0xa6, 0xb4,
    0x5f, 0x10, 0x95, 0x69, 0xb2, 0x0c, 0xfe, 0xba, 0xaf, 0x32, 0xb4, 0x90,
    0x64, 0x4c, 0x18, 0x84, 0xd7, 0x7f, 0xe3, 0x88, 0xa1, 0x20, 0xb0, 0x85,
    0x14, 0xc9, 0x6e, 0xeb, 0xb3, 0xbc, 0x0c, 0xd9, 0x77, 0x06, 0x76, 0x9f,
    0x70, 0xf0, 0x48, 0x47, 0x09, 0x8a, 0xbf, 0x62, 0x82, 0xac, 0x00, 0x2f,
    0xa0, 0x15, 0x84, 0xab, 0x96, 0x76, 0x0b, 0xdc, 0x46, 0x57, 0x09, 0x3b,
    0xb6, 0x97, 0x9e, 0x0a, 0xf8, 0x54, 0x0b, 0xb7, 0x20, 0x72, 0x2a, 0x6c,
    0xbb, 0xb8, 0x48, 0x1f, 0xd0, 0x36, 0xf5, 0xd3, 0x64, 0xc5, 0x64, 0xc9,
    0x6f, 0x4a, 0xa6, 0xbe, 0xb2, 0x40, 0x86, 0xb3, 0xb1, 0x04, 0xe0, 0xaf,
    0x59, 0x10, 0x63, 0x8b, 0x66, 0x7d, 0x7d, 0x29, 0xb3, 0x2e, 0x93, 0xad,
    0xdb, 0xa0, 0x54, 0x37, 0x82, 0x38, 0x58, 0xf7, 0xcf, 0xc6, 0x9a, 0xcd,
    0xaa, 0x94, 0xba, 0x74, 0x90, 0x29, 0x73, 0xb8, 0x8a, 0x9b, 0x08, 0xce,
    0x2f, 0xb1, 0x09, 0xb2, 0xa1, 0x6d, 0x31, 0xf1, 0x0d, 0x8b, 0xb4, 0x52,
    0xa0, 0x89, 0x96, 0xb9, 0x54, 0x78, 0x49, 0x90, 0x8a, 0x61, 0xba, 0x0d,
    0x92, 0xf3, 0x6f, 0x46, 0x7a, 0xa5, 0x22, 0x4c, 0xb9, 0x2c, 0xaa, 0x17,
    0xab, 0xc9, 0x37, 0x84, 0x2a, 0x4f, 0xac, 0xf6, 0x4a, 0xf4, 0xe2, 0x81,
    0x12, 0x78, 0x49, 0x6d, 0xac, 0xa6, 0xe1, 0xa9, 0x89, 0x8a, 0x5c, 0x02,
    0x8e, 0xa4, 0x6a, 0x64, 0xe5, 0x67, 0x84, 0xc5, 0xbe, 0x7e, 0xf9, 0x39,
    0x60, 0xa9, 0x10, 0xd7, 0x01, 0x1e, 0x03, 0xb1, 0x7c, 0xaf, 0x42, 0xce,
    0x3e, 0xc2, 0x13, 0x75, 0x96, 0x93, 0x32, 0x0b, 0x2c, 0x96, 0xb2, 0x2a,
    0xef, 0x80, 0x10, 0xa3, 0x82, 0x5d, 0x60, 0xbc, 0xc0, 0xe9, 0x15, 0x1a,
    0x0f, 0xa4, 0x3d, 0xf1, 0x0c, 0xa3, 0xa3, 0xcc, 0x6b, 0x6d, 0x6b, 0xb6,
    0xa2, 0xf6, 0x03, 0x5f, 0xe3, 0xc0, 0x23, 0x62, 0xae, 0x07, 0xe5, 0xa9,
    0x79, 0x28, 0x69, 0x24, 0xd0, 0x5a, 0x54, 0xc5, 0x13, 0x7b, 0x46, 0xb3,
    0x99, 0x85, 0x74, 0xa7, 0x3c, 0xc0, 0x09, 0x87, 0x5d, 0xd5, 0x66, 0xbe,
    0xae, 0x6b, 0x4d, 0x47, 0xa2, 0x79, 0xf5, 0x85, 0xaf, 0x8e, 0xc5, 0x7c,
    0xfc, 0xa2, 0x81, 0x16, 0xa9, 0x54, 0x03, 0xfa, 0x6e, 0x49, 0xe7, 0xa4,
    0x11, 0x16, 0x89, 0xf2, 0x34, 0x0f, 0xe9, 0x08, 0x8e, 0x07, 0x43, 0xa2,
    0x6e, 0x06, 0xbc, 0x6c, 0x54, 0xb0, 0x12, 0x61, 0x76, 0x69, 0x05, 0xcf,
    0xb2, 0x78, 0x5e, 0xf5, 0xd5, 0xc9, 0x86, 0xec, 0xc9, 0xd7, 0x4c, 0x66,
    0xef, 0xec, 0x57, 0x69, 0xa9, 0x2c, 0x8a, 0x03, 0x48, 0x90, 0x30, 0x0f,
    0x2b, 0x7c, 0x7d, 0x20, 0xa8, 0x0f, 0xfb, 0x73, 0x1c, 0xe4, 0x19, 0x2c,
    0xec, 0x02, 0x1a, 0xd9, 0xb9, 0xac, 0x25, 0xdc, 0x99, 0x46, 0x00, 0x4c,
    0xcd, 0xcc, 0xa5, 0xf4, 0xb2, 0x95, 0x81, 0xf2, 0x7e, 0xb3, 0xe7, 0x24,
    0x50, 0x4a, 0xc3, 0x6e, 0x95, 0xae, 0xb7, 0xbc, 0x49, 0xc6, 0x5a, 0x78,
    0x3a, 0xb8, 0xc2, 0xd1, 0x69, 0xcc, 0xc0, 0x11, 0x3b, 0x18, 0x26, 0x30,
    0x7e, 0x51, 0xb3, 0xc5, 0x73, 0x07, 0xa6, 0x8a, 0xc3, 0xe6, 0x18, 0xba,
    0x22, 0x39, 0x28, 0xd6, 0x33, 0x61, 0x51, 0x28, 0x92, 0xbf, 0x93, 0xb1,
    0x52, 0x68, 0xae, 0x54, 0xea, 0xc4, 0x4f, 0x62, 0x1d, 0x82, 0x94, 0x39,
    0xe2, 0x98, 0x7c, 0x1b, 0xea, 0x13, 0x26, 0x92, 0x6a, 0xb1, 0x1c, 0x59,
    0x11, 0x47, 0x7c, 0x7b, 0xeb, 0x28, 0x2a, 0xe8, 0x81, 0x0b, 0x55, 0x14,
    0x53, 0x80, 0x28, 0xb8, 0x58, 0x8b, 0x1c, 0xa5, 0x91, 0x4e, 0x55, 0x9e,
    0x68, 0x32, 0x5d, 0x5f, 0x94, 0x87, 0x83, 0x73, 0x3f, 0xfc, 0x8b, 0xb4,
    0x8c, 0xd9, 0x52, 0xf8, 0x74, 0x5f, 0x76, 0xc2, 0x63, 0x9a, 0x87, 0x54,
    0x10, 0x47, 0x1e, 0x83, 0x82, 0x31, 0x6d, 0x22, 0x26, 0x16, 0x32, 0xb1,
    0xa1, 0x78, 0x09, 0xd5, 0x8b, 0xbb, 0x75, 0xd7, 0x8b, 0xa2, 0x99, 0xcf,
    0xde, 0x2a, 0x73, 0x0f, 0x80, 0x91, 0xdc, 0x44, 0xb8, 0xaa, 0x73, 0x69,
    0x55, 0xfa, 0x23, 0xb8, 0x16, 0xb1, 0xd7, 0x78, 0x4d, 0x97, 0xab, 0xcb,
    0x0c, 0xf4, 0xcb, 0xb7, 0xc8, 0x36, 0x4e, 0xf1, 0x2a, 0x82, 0xb0, 0x09,
    0x10, 0x3c, 0x8f, 0x7a, 0x76, 0xc6, 0xac, 0x08, 0x6a, 0xe1, 0x0a, 0x3e,
    0x6b, 0x06, 0x39, 0xcb, 0x35, 0xce, 0x10, 0xc3, 0x1f, 0xaa, 0xaa, 0x26,
    0xfc, 0x22, 0xb9, 0xd5, 0x12, 0xcc, 0xa8, 0x48, 0x0a, 0x61, 0xac, 0x3a,
    0xa1, 0x87, 0xbf, 0xea, 0x79, 0x11, 0x7d, 0xfb, 0xc4, 0xfe, 0x0b, 0x4f,
    0x94, 0x57, 0xd8, 0x7b, 0xa4, 0x91, 0x4e, 0xe5, 0x5a, 0x4b, 0xaa, 0x94,
    0x6e, 0x91, 0x55, 0xe9, 0x9b, 0xae, 0xac, 0xe9, 0x52, 0x2c, 0xc6, 0x4b,
    0xee, 0x7b, 0xd7, 0xfa, 0x45, 0xeb, 0x2f, 0x6b,
  ]),
  // 64-byte privateSeed
  privateSeed: new Uint8Array([
    0x3e, 0x42, 0x62, 0xca, 0xd1, 0x44, 0x02, 0x6d, 0xe9, 0xbd, 0x35, 0xbf,
    0x20, 0x3f, 0xfb, 0x40, 0x26, 0x3c, 0x8c, 0x76, 0x5d, 0x05, 0xd2, 0xa4,
    0xd0, 0x0a, 0x8a, 0xe9, 0x25, 0x07, 0xd2, 0xd2, 0xc5, 0x60, 0xb8, 0x43,
    0x5a, 0x05, 0x4d, 0x81, 0x6e, 0x5f, 0x25, 0x35, 0xa3, 0xdf, 0x91, 0x83,
    0x3c, 0xca, 0xd2, 0x63, 0xe5, 0x8e, 0x3c, 0x34, 0x55, 0x5c, 0xd8, 0xc5,
    0x73, 0x25, 0xad, 0x9d,
  ]),
  // 768-byte sampleCiphertext
  sampleCiphertext: new Uint8Array([
    0x0e, 0x48, 0x87, 0x58, 0xdc, 0xd4, 0x55, 0x52, 0x56, 0x5b, 0xec, 0xe5,
    0xb8, 0xbd, 0xa4, 0x52, 0x35, 0x44, 0xde, 0x14, 0xee, 0xd1, 0x3f, 0xec,
    0x29, 0xcf, 0x92, 0x60, 0x16, 0x15, 0x89, 0x13, 0x14, 0x32, 0x24, 0xdb,
    0x55, 0x5a, 0x2d, 0x6d, 0x42, 0xc2, 0xce, 0x30, 0xf6, 0x3b, 0x72, 0x34,
    0xb8, 0x25, 0xab, 0x11, 0xb6, 0xb1, 0x0b, 0xba, 0xc1, 0x98, 0x35, 0xc2,
    0x3c, 0xac, 0x07, 0xe3, 0xb3, 0x7f, 0xed, 0x08, 0xa1, 0xeb, 0x88, 0x61,
    0x99, 0xee, 0x2d, 0xb9, 0x5e, 0x01, 0x35, 0xaf, 0x1c, 0x21, 0xd3, 0x75,
    0xed, 0xd0, 0xc1, 0x34, 0x66, 0x17, 0xb6, 0x6c, 0xfc, 0xd9, 0xcd, 0xa8,
    0x5a, 0x80, 0x28, 0xda, 0x74, 0x5d, 0x9d, 0x36, 0x53, 0xfc, 0x5b, 0x80,
    0xc6, 0xd2, 0x9b, 0x4c, 0xd9, 0xb0, 0x2d, 0x6c, 0x5a, 0xc8, 0xe7, 0xc0,
    0x27, 0xa7, 0x02, 0x58, 0x57, 0x31, 0x98, 0xbc, 0x72, 0x40, 0x4a, 0x31,
    0xde, 0x1f, 0x44, 0x38, 0x54, 0xe7, 0xbe, 0xcb, 0x3b, 0xcf, 0x39, 0x0a,
    0x6f, 0xe7, 0xc8, 0x6c, 0x3a, 0x0b, 0x14, 0x9e, 0x51, 0xa5, 0x10, 0x3b,
    0x2d, 0xd8, 0x4b, 0x96, 0xd2, 0x0d, 0x1f, 0x3b, 0x1a, 0x53, 0x08, 0xdd,
    0x94, 0x11, 0xfa, 0x87, 0x75, 0x4d, 0x7d, 0x85, 0x72, 0xad, 0x58, 0x36,
    0x27, 0xdb, 0x9a, 0xa9, 0x8d, 0x2f, 0xe0, 0x9b, 0x6f, 0xdd, 0xca, 0x3c,
    0xa8, 0xf9, 0x4e, 0x64, 0x3b, 0x56, 0xd9, 0x2b, 0xab, 0xaf, 0x10, 0x5e,
    0x52, 0xba, 0x70, 0x82, 0xe3, 0x34, 0xf7, 0xb8, 0xe4, 0x86, 0x6f, 0x45,
    0xf4, 0x15, 0xa1, 0xd4, 0x69, 0x01, 0xba, 0x93, 0x2c, 0x29, 0x8d, 0xcd,
    0xb0, 0xe9, 0x64, 0xd1, 0x8a, 0x0b, 0x72, 0x5a, 0xd0, 0x58, 0xc2, 0xd5,
    0xea, 0x72, 0x13, 0xff, 0x7f, 0x44, 0xaf, 0xea, 0xcf, 0x1b, 0x6a, 0x10,
    0x29, 0xfd, 0x93, 0xce, 0x50, 0xa6, 0xb3, 0x4b, 0xf5, 0x1e, 0x83, 0x23,
    0xc7, 0xda, 0x58, 0x60, 0x06, 0xd3, 0xc1, 0xf7, 0x8c, 0x98, 0xca, 0x79,
    0xcc, 0xbc, 0xff, 0x1c, 0x14, 0xa0, 0x30, 0x94, 0x96, 0xbf, 0xb4, 0xf4,
    0xbc, 0x24, 0x40, 0x2a, 0x47, 0x91, 0x2f, 0x98, 0x00, 0x5d, 0xef, 0xbc,
    0x08, 0x2b, 0x96, 0xc2, 0x06, 0xdc, 0xa0, 0x2c, 0x93, 0x27, 0xd7, 0xa4,
    0x16, 0x6b, 0x9c, 0xcf, 0xea, 0x2c, 0x45, 0x32, 0x6a, 0x98, 0xa1, 0xab,
    0x84, 0xdc, 0xac, 0x0e, 0xa3, 0x5a, 0x2b, 0x1a, 0x2c, 0x40, 0x1b, 0x91,
    0x1c, 0xdf, 0x27, 0x65, 0x23, 0x38, 0xe7, 0x4b, 0xea, 0xfa, 0xb4, 0xd9,
    0x45, 0xc3, 0xf1, 0x3c, 0xa2, 0x96, 0x50, 0x7c, 0x87, 0xf7, 0x3e, 0x34,
    0x8b, 0xb4, 0x43, 0xb7, 0xfa, 0x7e, 0xc0, 0x5f, 0xa0, 0xe3, 0x5b, 0x9f,
    0x19, 0x1e, 0xc8, 0xba, 0xde, 0x96, 0x60, 0x92, 0x74, 0x8c, 0xda, 0x72,
    0x9e, 0x25, 0xa4, 0xcf, 0x8d, 0x9f, 0x8f, 0xc0, 0x6d, 0xaf, 0x4a, 0x60,
    0xf3, 0xb9, 0x85, 0x30, 0x28, 0x2e, 0xab, 0xbf, 0x57, 0x67, 0x4d, 0x34,
    0xf9, 0x6c, 0xf5, 0x37, 0x63, 0x96, 0x95, 0x35, 0x78, 0x25, 0x11, 0x1e,
    0x0c, 0xa9, 0xaf, 0xc0, 0x4a, 0x78, 0x9d, 0xf2, 0x83, 0xb1, 0x25, 0xd9,
    0xf9, 0xf1, 0xb5, 0x59, 0x27, 0xc9, 0x3b, 0xd4, 0x8e, 0x1b, 0xcc, 0x62,
    0xf3, 0x6e, 0x76, 0x28, 0xea, 0x8b, 0xdd, 0xf4, 0x48, 0xae, 0x0c, 0xe2,
    0x98, 0x44, 0x2f, 0x1a, 0x8c, 0x8d, 0x31, 0xdc, 0x23, 0xb9, 0x68, 0x32,
    0x60, 0x3c, 0xf2, 0x03, 0x6f, 0xba, 0xe9, 0x6f, 0xc0, 0xfb, 0xd2, 0x57,
    0x0a, 0xa5, 0xd6, 0x51, 0x7c, 0xc3, 0x52, 0xdd, 0xdf, 0xa9, 0x44, 0x52,
    0x4a, 0x4c, 0xa6, 0xc5, 0xc7, 0x6d, 0xb9, 0x8c, 0xc7, 0x96, 0xc8, 0xf9,
    0xcf, 0xe3, 0x92, 0x74, 0x8c, 0xb3, 0xb2, 0x2e, 0xaf, 0x58, 0x43, 0x45,
    0x77, 0x29, 0xa7, 0xb6, 0xa8, 0x01, 0xca, 0x0c, 0xa9, 0xb4, 0x65, 0x6a,
    0xbc, 0x9d, 0xf0, 0x91, 0x1a, 0x3d, 0x1a, 0x11, 0xc8, 0x5b, 0xe1, 0xf4,
    0x13, 0x60, 0xe8, 0x5a, 0x47, 0xe7, 0x66, 0xdc, 0xd9, 0x9c, 0xd0, 0xa3,
    0x5f, 0x1f, 0xa6, 0xc0, 0x94, 0x58, 0x05, 0xc8, 0x46, 0xd2, 0xa0, 0x86,
    0x55, 0x36, 0x34, 0x01, 0xae, 0x98, 0x86, 0xd4, 0x26, 0xc3, 0xa1, 0x5a,
    0xef, 0xd0, 0x98, 0x4d, 0x5a, 0x12, 0x8c, 0x03, 0x18, 0xf1, 0x81, 0x8d,
    0x73, 0x4f, 0x62, 0x4b, 0xc6, 0xe7, 0x3a, 0x5d, 0x42, 0xf8, 0x13, 0x29,
    0x76, 0x4c, 0x3b, 0x51, 0x86, 0xe7, 0xd6, 0x87, 0x2e, 0x9e, 0x3e, 0x22,
    0xde, 0x4f, 0xae, 0xf9, 0x6a, 0xe1, 0xa7, 0x72, 0xfa, 0x1e, 0x8f, 0xc1,
    0x95, 0xe8, 0x60, 0x1d, 0xd5, 0x46, 0x8a, 0xcb, 0x80, 0x61, 0x9c, 0x65,
    0x8e, 0x06, 0xe7, 0x89, 0xfa, 0xb5, 0xfd, 0x68, 0x8f, 0x8c, 0x08, 0xc3,
    0x6a, 0xc8, 0x84, 0x13, 0x52, 0x32, 0xce, 0x83, 0x2e, 0x68, 0xa0, 0xc1,
    0x5f, 0x01, 0x65, 0xb8, 0x4c, 0x38, 0x82, 0xaf, 0xac, 0x0b, 0xbe, 0x4e,
    0xef, 0x7a, 0x42, 0xde, 0x92, 0x17, 0x4a, 0xf0, 0xf6, 0x85, 0xfe, 0x47,
    0xba, 0xf2, 0xbc, 0x79, 0x7c, 0xed, 0x19, 0xdf, 0x18, 0x08, 0x72, 0x8a,
    0xce, 0x57, 0x86, 0xcf, 0xc5, 0x54, 0x17, 0x19, 0xab, 0x0c, 0xeb, 0xa5,
    0x44, 0x33, 0x5c, 0x1f, 0x02, 0xec, 0x8b, 0x80, 0xdd, 0xe7, 0x50, 0x74,
    0x97, 0x43, 0xa8, 0xa3, 0xb9, 0x1a, 0x8e, 0x1d, 0x21, 0x97, 0x95, 0x6c,
    0x96, 0xa0, 0x2d, 0xc5, 0x1b, 0xad, 0xed, 0x9d, 0x88, 0x46, 0x89, 0x9d,
    0xbd, 0x4a, 0xc5, 0x57, 0xa7, 0x4c, 0x4e, 0x78, 0x43, 0xa4, 0xc3, 0x43,
    0x11, 0x32, 0xde, 0xaf, 0xa3, 0xf4, 0x18, 0xd7, 0xc3, 0x9d, 0x52, 0x76,
  ]),
  // 32-byte expectedSharedSecret
  expectedSharedSecret: new Uint8Array([
    0x6b, 0x15, 0xad, 0xd5, 0xb3, 0x66, 0xb2, 0x2c, 0x66, 0x8a, 0x1d, 0x81,
    0x90, 0x1d, 0x2e, 0xe2, 0x11, 0x33, 0x03, 0xb6, 0xaf, 0xa8, 0x2e, 0xaf,
    0x67, 0x64, 0xdb, 0xea, 0xd7, 0x66, 0xb8, 0xfc,
  ]),
};

// ML-KEM-768 test vectors
ml_kem_vectors['ML-KEM-768'] = {
  // 1184-byte publicKey
  publicKey: new Uint8Array([
    0x0f, 0x61, 0x02, 0x18, 0x60, 0x7b, 0xac, 0x16, 0x36, 0xd1, 0x2a, 0x24,
    0x50, 0x79, 0x65, 0xbc, 0x4b, 0x6f, 0x39, 0x75, 0x69, 0x9e, 0x24, 0xba,
    0x48, 0x9a, 0xb0, 0x0e, 0xb8, 0xbb, 0x94, 0xc4, 0x16, 0xe0, 0x9b, 0x5b,
    0x3c, 0x22, 0x05, 0xda, 0x71, 0xa4, 0x0a, 0xf3, 0x8b, 0x10, 0x95, 0xb9,
    0x98, 0xb7, 0x34, 0x46, 0x2a, 0x0c, 0xdf, 0x33, 0x7b, 0xe7, 0x85, 0x25,
    0xfb, 0xd9, 0x84, 0x54, 0x7a, 0x98, 0x1e, 0x11, 0x9a, 0x10, 0xa1, 0x9b,
    0xb6, 0x22, 0x21, 0xf7, 0x17, 0x60, 0xf4, 0x71, 0x1b, 0x3d, 0x88, 0x31,
    0x7e, 0xf7, 0x83, 0x84, 0xd5, 0x20, 0x28, 0xa9, 0x49, 0x77, 0xa7, 0x59,
    0x96, 0x10, 0xb3, 0x4b, 0xc3, 0x39, 0x4b, 0x90, 0x9c, 0xcc, 0x3a, 0xbf,
    0x62, 0xfb, 0xc2, 0xcc, 0x66, 0xae, 0xc6, 0x17, 0xcd, 0xc9, 0x09, 0x17,
    0xc1, 0x80, 0xba, 0x14, 0x81, 0x68, 0x64, 0xf5, 0x41, 0xc4, 0x3a, 0x1f,
    0x29, 0x98, 0x77, 0xfa, 0x28, 0x4a, 0xca, 0x65, 0x5b, 0xd5, 0xa7, 0xb5,
    0xda, 0x3b, 0x77, 0xe4, 0x86, 0x96, 0xbf, 0xf7, 0x25, 0x25, 0x10, 0x59,
    0x34, 0x26, 0x9f, 0xef, 0x4c, 0x0b, 0xb4, 0x83, 0xce, 0x3d, 0x8c, 0x12,
    0x6f, 0xa4, 0xc0, 0xe4, 0x4a, 0x18, 0x1f, 0x97, 0x31, 0xbe, 0x18, 0x39,
    0xad, 0x08, 0x95, 0xe2, 0x7b, 0x1b, 0xf2, 0xe5, 0x89, 0xf3, 0x08, 0x60,
    0x6c, 0x50, 0xc5, 0x2d, 0x2c, 0x0c, 0x15, 0x78, 0x58, 0x88, 0x65, 0x5e,
    0x72, 0x18, 0x25, 0xd1, 0xa4, 0xb5, 0x25, 0x65, 0x51, 0x85, 0x59, 0xc3,
    0xf2, 0xa7, 0xb4, 0xb5, 0x86, 0x18, 0xe6, 0xe6, 0x91, 0x49, 0xb0, 0x29,
    0x62, 0x21, 0x73, 0x96, 0x89, 0x7e, 0xb7, 0x42, 0x12, 0xb1, 0x07, 0x0d,
    0x9f, 0xb0, 0x9d, 0x0c, 0xf3, 0x93, 0x75, 0x08, 0x9b, 0xf3, 0x25, 0x1e,
    0xf9, 0x92, 0xb2, 0x55, 0xb1, 0x5b, 0x83, 0xc9, 0xb4, 0x75, 0x15, 0x1b,
    0x93, 0x22, 0x83, 0xfc, 0xd9, 0x43, 0xee, 0x7a, 0x2e, 0x7c, 0xb2, 0x48,
    0xdf, 0xb8, 0x32, 0x5d, 0xc0, 0xc7, 0x0d, 0x55, 0x71, 0x31, 0xcc, 0x69,
    0x66, 0x46, 0xa2, 0x31, 0x75, 0x5b, 0xe2, 0x0a, 0x9c, 0xee, 0x44, 0x15,
    0xde, 0x08, 0x5d, 0xf3, 0xa4, 0x16, 0x65, 0x56, 0x0a, 0x59, 0xc1, 0x5a,
    0x95, 0x60, 0x87, 0x96, 0x96, 0xc0, 0xbb, 0x34, 0x4a, 0x27, 0x87, 0x91,
    0x6c, 0xb7, 0x77, 0x3a, 0xf0, 0x5c, 0x65, 0xbb, 0x79, 0xcd, 0xf9, 0x24,
    0x75, 0x1b, 0xcb, 0x4d, 0x8a, 0x20, 0xae, 0x59, 0xa6, 0x09, 0xc1, 0x58,
    0xb1, 0x41, 0x9c, 0x83, 0x64, 0x9a, 0x74, 0xe1, 0x7e, 0x69, 0x76, 0x5a,
    0xd4, 0xf5, 0x28, 0xac, 0x66, 0xc9, 0x81, 0x19, 0xc6, 0x20, 0xa3, 0x18,
    0xc8, 0x17, 0x98, 0x14, 0xc2, 0x57, 0x58, 0x43, 0x2a, 0x5c, 0xb6, 0x73,
    0x4e, 0x31, 0xa0, 0x2a, 0xa9, 0xc8, 0xba, 0x14, 0x88, 0xa1, 0x1a, 0x9c,
    0xf3, 0x69, 0x29, 0xe2, 0x12, 0x8d, 0xb8, 0x76, 0x6d, 0x95, 0xb2, 0xab,
    0x22, 0xb1, 0x15, 0x5a, 0x22, 0x53, 0xe4, 0x27, 0x7d, 0xc7, 0x80, 0xb0,
    0x10, 0xe5, 0x9a, 0x42, 0xea, 0x95, 0xc6, 0xa9, 0xa0, 0xd6, 0xf9, 0x45,
    0xd5, 0x73, 0x45, 0xe5, 0x55, 0xc9, 0xf3, 0x39, 0x80, 0x8a, 0xe0, 0x0a,
    0xa5, 0x47, 0x5e, 0xc6, 0xc4, 0x52, 0x6b, 0xb0, 0x10, 0xfc, 0xac, 0x24,
    0x47, 0x5a, 0x21, 0x8a, 0x75, 0x8e, 0x62, 0xf9, 0x20, 0x56, 0x77, 0x11,
    0xc0, 0x38, 0x19, 0x6c, 0xd0, 0x37, 0xab, 0xb5, 0x7a, 0xd1, 0x32, 0xad,
    0x62, 0x2a, 0x2e, 0x3e, 0x39, 0x61, 0x7c, 0xf3, 0x66, 0xa3, 0x98, 0x56,
    0x4f, 0x31, 0xad, 0xb5, 0x40, 0x5f, 0xf6, 0xa9, 0x20, 0xc5, 0x32, 0x6e,
    0xc7, 0x26, 0xa3, 0x97, 0xfc, 0x11, 0xcf, 0x79, 0x25, 0x9e, 0x48, 0x62,
    0xe6, 0xd3, 0x39, 0x48, 0x29, 0x9e, 0x55, 0xf5, 0x68, 0x93, 0xea, 0xcd,
    0x10, 0xdc, 0x9f, 0x89, 0x98, 0x47, 0xac, 0x12, 0x7c, 0xb8, 0xb5, 0x52,
    0x7c, 0xaa, 0x9e, 0x8c, 0xf4, 0xaf, 0x1b, 0xf5, 0xc5, 0x06, 0x01, 0x4c,
    0x76, 0x05, 0x8b, 0x1e, 0xd1, 0x0f, 0xa0, 0xf6, 0x09, 0xb7, 0x78, 0xaa,
    0x26, 0xca, 0xcc, 0x3b, 0xb0, 0x3e, 0x04, 0xb4, 0x9e, 0x99, 0xfa, 0x7a,
    0xc0, 0x33, 0x0e, 0xf2, 0x92, 0x55, 0x38, 0x80, 0x4e, 0xbc, 0x24, 0x53,
    0x00, 0x03, 0xcf, 0x08, 0x17, 0x3a, 0x4b, 0x5a, 0x78, 0x7b, 0xcb, 0x3b,
    0xb0, 0x6b, 0x6b, 0x7d, 0xe1, 0x7a, 0x7a, 0xd7, 0x4b, 0xc3, 0x12, 0x5b,
    0x9f, 0xa0, 0xcb, 0x46, 0x55, 0x0c, 0xfd, 0xc9, 0xa9, 0xa8, 0x40, 0x0a,
    0x8f, 0xe5, 0x1f, 0x9f, 0x39, 0xa2, 0x8a, 0xa2, 0xa7, 0x52, 0xc1, 0x61,
    0x19, 0xf9, 0x25, 0xe4, 0xdb, 0x6a, 0x4a, 0x37, 0xb2, 0x6e, 0x85, 0xc7,
    0x80, 0x22, 0xb8, 0x95, 0x2b, 0x30, 0x59, 0x98, 0x33, 0xbf, 0x18, 0x96,
    0xba, 0x1a, 0x16, 0xfd, 0xb7, 0x1e, 0x4a, 0x30, 0x31, 0x05, 0x85, 0x00,
    0xc8, 0x5a, 0x05, 0xfd, 0x36, 0xb9, 0x97, 0x41, 0xca, 0xc7, 0x90, 0x24,
    0x3a, 0xf9, 0x4c, 0xfb, 0xe2, 0x5d, 0xec, 0x58, 0x08, 0xfa, 0x43, 0xcf,
    0xc7, 0x92, 0xa9, 0xfc, 0xc1, 0xad, 0xf9, 0x62, 0x07, 0x98, 0x32, 0x89,
    0x70, 0x49, 0xb9, 0x99, 0x9a, 0x71, 0x85, 0x72, 0x88, 0xa0, 0xea, 0x84,
    0x23, 0xe1, 0x7e, 0x1d, 0x50, 0xc8, 0xa5, 0x6a, 0x97, 0xfb, 0xfc, 0x0c,
    0xa4, 0x19, 0x5f, 0xc9, 0xd2, 0x0d, 0x6b, 0x7b, 0xbf, 0x62, 0x55, 0x91,
    0xa6, 0x85, 0x8f, 0x75, 0xca, 0x79, 0x1b, 0x65, 0x57, 0x58, 0x5b, 0x4f,
    0x23, 0x86, 0x8a, 0x38, 0x7a, 0xbd, 0x20, 0x08, 0x51, 0x1c, 0xbb, 0x4b,
    0x68, 0x1c, 0x3f, 0x90, 0x49, 0x9c, 0x53, 0xc1, 0x6e, 0x8a, 0x35, 0x22,
    0x49, 0x58, 0x48, 0xc5, 0x0a, 0x0e, 0x37, 0x92, 0x67, 0xd0, 0xb9, 0xbc,
    0xce, 0x9b, 0x84, 0x6b, 0x34, 0x15, 0xbe, 0x0b, 0xa2, 0xa9, 0x52, 0xc3,
    0x7d, 0xfc, 0x68, 0x10, 0xc4, 0x72, 0x6d, 0x01, 0x97, 0x4e, 0xba, 0x5d,
    0x4c, 0x8a, 0xb5, 0x9a, 0x99, 0xb7, 0x5b, 0x7b, 0x9c, 0x6b, 0x86, 0x6d,
    0xe4, 0xc3, 0x87, 0xed, 0x58, 0x4b, 0xf3, 0x91, 0xb7, 0x0c, 0xa8, 0x7a,
    0x37, 0x47, 0x85, 0x44, 0x03, 0x2e, 0x00, 0xcb, 0xbf, 0xf4, 0xd7, 0x4a,
    0x1b, 0x42, 0x99, 0x1e, 0x72, 0x9c, 0x8c, 0x4b, 0xcb, 0x98, 0x0a, 0x48,
    0x7c, 0x55, 0x4b, 0xb7, 0x55, 0x6a, 0x24, 0x23, 0x83, 0xca, 0xb9, 0x36,
    0x36, 0x63, 0x44, 0xe7, 0xe3, 0x3c, 0x8c, 0x91, 0x6d, 0x64, 0xb4, 0x6e,
    0xc2, 0x99, 0x35, 0xbc, 0xa6, 0x5c, 0x8e, 0xda, 0x3f, 0x67, 0x55, 0x9e,
    0xda, 0xda, 0x07, 0x30, 0x16, 0x44, 0xfb, 0xc4, 0x64, 0x3f, 0x9c, 0x2f,
    0xea, 0x45, 0x19, 0x5d, 0x8c, 0x67, 0xce, 0x56, 0x87, 0xff, 0xd0, 0x64,
    0xd2, 0x82, 0xca, 0x82, 0x3b, 0x44, 0x9f, 0x9b, 0x2e, 0xe5, 0x96, 0x29,
    0x7f, 0xf6, 0xa3, 0x4d, 0x38, 0x54, 0xb5, 0x87, 0xc5, 0x96, 0xe3, 0xbc,
    0x2f, 0x7c, 0x4e, 0x91, 0x33, 0x39, 0xbe, 0xc8, 0x54, 0x35, 0xb7, 0x83,
    0x21, 0xb1, 0x23, 0xa8, 0x93, 0x56, 0x44, 0x41, 0xc5, 0x15, 0xa2, 0x80,
    0x56, 0x31, 0x50, 0xd3, 0xf8, 0x0f, 0xfc, 0x68, 0x86, 0x74, 0x34, 0x61,
    0x59, 0x46, 0x1d, 0x17, 0x6c, 0x77, 0xa4, 0xcc, 0xc0, 0x52, 0x73, 0x57,
    0xc9, 0xd0, 0x0d, 0x17, 0x23, 0x73, 0x4e, 0x78, 0xb5, 0xb3, 0x74, 0xb2,
    0xd8, 0x95, 0xb0, 0xe0, 0x8b, 0x33, 0xe9, 0x7b, 0x2d, 0x73, 0xa6, 0xb9,
    0x94, 0xf9, 0x0e, 0x89, 0xbc, 0xab, 0xea, 0xc2, 0xbe, 0xe4, 0x98, 0xbb,
    0x09, 0xc4, 0xbc, 0x03, 0xca, 0x2c, 0x8e, 0x00, 0xce, 0x99, 0xfa, 0x04,
    0xfb, 0x04, 0x8d, 0x86, 0x4c, 0x3b, 0xb6, 0xe1, 0x23, 0x6e, 0x5c, 0xac,
    0x3d, 0xe3, 0x04, 0x07, 0xc3, 0x28, 0x4b, 0x2c, 0x64, 0x3f, 0xe0, 0x2c,
    0x6e, 0xfa, 0x02, 0x4d, 0x96, 0x40, 0x1f, 0x1b, 0xc4, 0x63, 0xe5, 0xbb,
    0xd9, 0xc0, 0x8c, 0x81, 0x79, 0x2d, 0xba, 0xe5, 0x10, 0xf1, 0xb7, 0x27,
    0xf3, 0xa1, 0xb5, 0x30, 0x40, 0x2b, 0x47, 0xc6, 0xb6, 0xdb, 0xd5, 0x14,
    0x75, 0x79, 0x93, 0x8f, 0xa9, 0x72, 0xaf, 0xc4, 0x6e, 0x74, 0x26, 0x78,
    0x2e, 0x26, 0xa9, 0xc8, 0xe2, 0xc5, 0x70, 0x45, 0x48, 0x2a, 0xdc, 0x10,
    0x03, 0x17, 0x17, 0x3e, 0xe5, 0x1d, 0x03, 0xf3, 0x19, 0x7a, 0x10, 0x2c,
    0x9f, 0xd7, 0xb6, 0x07, 0x35, 0x1b, 0x4a, 0xd5, 0xb6, 0xbd, 0xe4, 0x51,
    0x13, 0xd6, 0x37, 0x33, 0x2a, 0x28, 0x8e, 0x4f, 0x6b, 0xb6, 0x7e, 0x44,
    0x4c, 0x32, 0x3e, 0xe8, 0x21, 0x8b, 0x5c, 0x1d, 0x15, 0x99, 0xb5, 0x8d,
    0xde, 0x35, 0x2f, 0xd6, 0xcd, 0x64, 0x7a, 0x52,
  ]),
  // 64-byte privateSeed
  privateSeed: new Uint8Array([
    0x46, 0x97, 0x3b, 0x12, 0xa0, 0x54, 0xa8, 0x9f, 0x47, 0xd5, 0x3a, 0xf5,
    0x83, 0xad, 0x94, 0x67, 0x6b, 0xbe, 0x8a, 0xc1, 0x04, 0x6b, 0x07, 0x1d,
    0x66, 0x6f, 0x55, 0x81, 0x3b, 0x68, 0x98, 0xaa, 0xaa, 0xcb, 0x55, 0x59,
    0xd0, 0x07, 0xea, 0x68, 0x14, 0x68, 0x3b, 0x49, 0x9d, 0x8b, 0xe1, 0xa0,
    0xf5, 0xbd, 0xf0, 0x52, 0x7a, 0xd9, 0xdf, 0xa8, 0x66, 0x90, 0x38, 0xfb,
    0x33, 0xbe, 0x26, 0xc5,
  ]),
  // 1088-byte sampleCiphertext
  sampleCiphertext: new Uint8Array([
    0x1a, 0xd4, 0x01, 0xa3, 0xc4, 0x3e, 0x18, 0xa5, 0x80, 0x8d, 0x49, 0xbc,
    0xfa, 0x19, 0x13, 0x2e, 0x0a, 0x3c, 0x0a, 0x55, 0x13, 0x79, 0x16, 0x9c,
    0x07, 0x70, 0x37, 0x6a, 0x12, 0xd2, 0xdd, 0x49, 0x9e, 0xfb, 0xc8, 0x60,
    0xe5, 0x06, 0x77, 0x07, 0xde, 0x7b, 0xe9, 0xb1, 0x64, 0x18, 0x5a, 0x46,
    0x12, 0xdc, 0x88, 0xef, 0x8c, 0xc7, 0x55, 0xf2, 0x53, 0xfe, 0x90, 0x81,
    0xb9, 0xfb, 0x25, 0x82, 0x7f, 0x2e, 0x31, 0x6a, 0x09, 0xae, 0x62, 0xeb,
    0xf8, 0x5d, 0x97, 0x45, 0x46, 0x93, 0xfb, 0x22, 0x04, 0x22, 0xee, 0xc6,
    0xd3, 0xa1, 0x78, 0x21, 0x84, 0x97, 0x7f, 0xce, 0xd1, 0x95, 0x1a, 0xd0,
    0xa8, 0xb7, 0xea, 0xc8, 0x97, 0xf4, 0xe8, 0xe3, 0xbb, 0x7d, 0x15, 0xfd,
    0x3f, 0x78, 0xed, 0x8d, 0x37, 0xea, 0xd1, 0xa5, 0x4e, 0xbf, 0xa2, 0x30,
    0xaf, 0x95, 0xf3, 0x32, 0x6f, 0xbb, 0x05, 0x57, 0xbc, 0x55, 0x8a, 0x8b,
    0x19, 0x50, 0xd9, 0xe5, 0x46, 0x3a, 0x4d, 0x2c, 0xea, 0xaa, 0x1f, 0x7a,
    0x67, 0xf8, 0xd6, 0x25, 0xc9, 0x86, 0x40, 0xa8, 0x9e, 0xd4, 0xee, 0xc2,
    0xe6, 0x3d, 0x34, 0xc0, 0x6d, 0x7b, 0x31, 0xff, 0xe8, 0x3f, 0x86, 0x1a,
    0x3a, 0x7e, 0x50, 0xfe, 0x64, 0x4b, 0x6b, 0xc7, 0x2e, 0x78, 0xce, 0xb7,
    0x73, 0x83, 0x1d, 0x1d, 0x90, 0x5f, 0x7a, 0x34, 0x08, 0xac, 0xb0, 0x73,
    0xac, 0x81, 0xbf, 0x40, 0xed, 0x37, 0x66, 0xf2, 0x83, 0xa5, 0xbc, 0x07,
    0xd2, 0x06, 0xa8, 0x26, 0x4a, 0xfd, 0xef, 0x77, 0x1a, 0xdc, 0xe3, 0x87,
    0x8f, 0x8d, 0x1d, 0x34, 0x6f, 0x92, 0x92, 0xd6, 0xbb, 0xb8, 0xb9, 0xc6,
    0xcb, 0x8e, 0x85, 0x7e, 0xd0, 0x47, 0x98, 0x52, 0x82, 0x89, 0x35, 0xbb,
    0x68, 0xaa, 0x04, 0x69, 0x82, 0x84, 0x34, 0x06, 0x2a, 0xa5, 0xea, 0x49,
    0x30, 0x7a, 0x80, 0xf1, 0x10, 0xff, 0xc1, 0x43, 0xac, 0x86, 0x44, 0xe5,
    0xaa, 0x3a, 0x74, 0xe5, 0x85, 0x39, 0x86, 0xce, 0x97, 0xa2, 0xe6, 0x99,
    0xad, 0xd9, 0xcb, 0x77, 0x53, 0xa1, 0x98, 0x3d, 0x08, 0xd2, 0x53, 0xfd,
    0x5e, 0x25, 0xef, 0xc8, 0xd9, 0xf1, 0x10, 0xe2, 0xbb, 0xf8, 0x9b, 0x31,
    0x95, 0x7f, 0xe0, 0xd3, 0xcd, 0xf5, 0xb1, 0xf6, 0x25, 0x6f, 0xf8, 0x8d,
    0x7a, 0xa4, 0xec, 0xb6, 0xb5, 0xf9, 0x1d, 0x66, 0x20, 0xe2, 0xc8, 0x61,
    0xdc, 0x87, 0x0a, 0x90, 0x38, 0x34, 0xb4, 0xf1, 0xb6, 0x08, 0xac, 0x90,
    0x40, 0x43, 0xea, 0x5c, 0x5c, 0x0a, 0x1f, 0x8e, 0xc4, 0x4f, 0x91, 0xc5,
    0x1c, 0x9a, 0x2e, 0x5f, 0xb8, 0x79, 0xd7, 0xdb, 0xfb, 0x9f, 0x94, 0x8c,
    0x19, 0x17, 0xca, 0x60, 0x7c, 0xa1, 0x03, 0xa1, 0xbf, 0xea, 0xcc, 0xfa,
    0xd2, 0xef, 0x34, 0xa8, 0x79, 0x9f, 0x39, 0x26, 0x13, 0x04, 0xd6, 0x77,
    0x29, 0x38, 0xb5, 0x82, 0xa2, 0xea, 0x94, 0x8a, 0x28, 0x39, 0xff, 0xb4,
    0x3d, 0xc3, 0x15, 0xd0, 0xae, 0x31, 0x1f, 0x1e, 0x54, 0x29, 0x4c, 0xb6,
    0xdb, 0xc1, 0xef, 0xa9, 0x04, 0xa6, 0x66, 0xb0, 0xa3, 0x81, 0xc8, 0xb5,
    0x28, 0xd1, 0x0a, 0x56, 0x26, 0x41, 0xea, 0xd9, 0x52, 0x93, 0xb7, 0x4e,
    0xcc, 0x78, 0xc2, 0xe6, 0x4a, 0xf9, 0x8b, 0xa6, 0x38, 0x82, 0x78, 0xb5,
    0x09, 0x1e, 0xf2, 0x9f, 0x8b, 0x50, 0x6e, 0x7e, 0xa4, 0xe2, 0xb8, 0x59,
    0x1c, 0xca, 0x61, 0x45, 0x20, 0x5e, 0xfc, 0x91, 0xf9, 0xde, 0x7e, 0x28,
    0x60, 0xd7, 0xe2, 0x89, 0x3c, 0x88, 0x88, 0x07, 0xbe, 0x0b, 0x76, 0x5a,
    0x12, 0xa8, 0x56, 0x3c, 0xe0, 0x4f, 0xcb, 0x99, 0xd6, 0x85, 0x10, 0x31,
    0x2f, 0x77, 0x4f, 0xcc, 0xcd, 0x4c, 0x5d, 0x0f, 0x87, 0x64, 0xcf, 0xb9,
    0xff, 0xff, 0xfd, 0x67, 0xb2, 0xdc, 0x3f, 0xf5, 0xb4, 0xb4, 0x7d, 0xa0,
    0x66, 0x54, 0x09, 0xd3, 0xdc, 0x4e, 0xc4, 0xda, 0x3e, 0x36, 0xb9, 0x91,
    0xf9, 0xf3, 0xea, 0x2c, 0xc0, 0x1e, 0x34, 0x7d, 0x69, 0x25, 0x6f, 0xf7,
    0x05, 0x7b, 0x20, 0x1f, 0x3e, 0x04, 0x34, 0x3b, 0x2b, 0xc8, 0x1e, 0x67,
    0x00, 0x9e, 0xa6, 0x59, 0xc1, 0x20, 0xe0, 0xc6, 0x06, 0xed, 0x2a, 0xeb,
    0xe8, 0xa6, 0x71, 0x96, 0x48, 0x1e, 0xf3, 0xc5, 0x30, 0x1b, 0xc1, 0x73,
    0xa3, 0x3c, 0x61, 0xed, 0x93, 0x19, 0x16, 0xd2, 0x1a, 0x0e, 0x6d, 0x9a,
    0xe7, 0x39, 0x81, 0xdd, 0x3e, 0xb2, 0xa3, 0x3b, 0x33, 0xa8, 0x4e, 0xce,
    0xbf, 0xbe, 0x42, 0x24, 0x9f, 0x54, 0xa3, 0xd8, 0x17, 0x03, 0x8e, 0xc6,
    0xc6, 0x0e, 0x89, 0x98, 0xdc, 0x9e, 0xbd, 0x17, 0xb9, 0x68, 0x87, 0xbd,
    0x3c, 0x69, 0xc7, 0xb4, 0x54, 0x7f, 0x40, 0x2f, 0x24, 0x98, 0x1f, 0x52,
    0x93, 0xe0, 0xce, 0x5e, 0x77, 0x07, 0xaa, 0xf3, 0x33, 0xb9, 0xbd, 0x98,
    0x21, 0x95, 0xaf, 0xff, 0xab, 0x10, 0xa8, 0x0d, 0x53, 0xa9, 0xec, 0xca,
    0x12, 0x95, 0x79, 0xd5, 0xf5, 0xfd, 0xdd, 0x6d, 0xc5, 0x24, 0x56, 0x40,
    0xf8, 0x3c, 0xf3, 0xbf, 0x9a, 0xe7, 0xf8, 0x39, 0x45, 0x5a, 0x14, 0xae,
    0xaf, 0xfc, 0x2a, 0x17, 0x7d, 0x7a, 0x5e, 0x93, 0x11, 0x0f, 0x74, 0xf9,
    0xea, 0x27, 0xed, 0x22, 0x4d, 0xf2, 0x58, 0x68, 0x17, 0x53, 0x68, 0x3a,
    0xe1, 0x75, 0x5a, 0xe4, 0xa8, 0xd6, 0x16, 0xfb, 0xae, 0x8c, 0xc6, 0x86,
    0xea, 0x06, 0xa3, 0x1b, 0x39, 0xdf, 0x7a, 0x56, 0x37, 0x35, 0x83, 0x9a,
    0xad, 0xc4, 0xac, 0x05, 0xf7, 0xf4, 0xb9, 0xed, 0xc6, 0xb1, 0x73, 0x57,
    0x6f, 0xdc, 0xc7, 0xce, 0x30, 0x72, 0xdc, 0xed, 0x29, 0xde, 0xe8, 0x35,
    0x59, 0x66, 0xdb, 0x7d, 0x25, 0xbb, 0x2f, 0x61, 0x3e, 0xa6, 0xe3, 0x2a,
    0x7c, 0x51, 0x3c, 0xc2, 0x47, 0x4b, 0x71, 0xb3, 0xdb, 0x7d, 0x5f, 0x8a,
    0x64, 0xc6, 0x6f, 0x7c, 0xbe, 0xad, 0xf3, 0x41, 0x7d, 0x7b, 0x7f, 0x60,
    0xf2, 0x7e, 0x23, 0x56, 0x6a, 0xdb, 0x11, 0xda, 0x10, 0xc7, 0x04, 0x9c,
    0xe1, 0x29, 0xfe, 0x55, 0xa6, 0x5a, 0xd1, 0x6f, 0x60, 0xdf, 0xec, 0xaa,
    0x1f, 0xaa, 0x05, 0x36, 0xc5, 0x4f, 0x66, 0xa3, 0xa0, 0xe4, 0x1e, 0x04,
    0x00, 0x10, 0xc2, 0x8b, 0x2c, 0xe6, 0xc5, 0xe5, 0xc9, 0xc0, 0x93, 0x59,
    0x9b, 0x1b, 0xcb, 0x0d, 0xdd, 0x4d, 0x23, 0xef, 0x4a, 0x6a, 0x49, 0x13,
    0x6a, 0x31, 0xd7, 0x69, 0xec, 0xd1, 0x4c, 0xa4, 0xdd, 0x83, 0xe6, 0x6d,
    0x90, 0xa9, 0x3a, 0xc1, 0x01, 0x94, 0x88, 0x75, 0xb7, 0x84, 0xa3, 0x94,
    0x0b, 0x02, 0x4e, 0x3f, 0x8c, 0xe2, 0xd0, 0x45, 0x42, 0xfe, 0x67, 0x14,
    0xcb, 0xf0, 0x05, 0x39, 0xf6, 0x50, 0x00, 0x5b, 0xa5, 0x8e, 0xba, 0x04,
    0x37, 0x7e, 0x37, 0x34, 0xbf, 0xe9, 0xff, 0x99, 0xb6, 0xca, 0xbf, 0xa0,
    0x87, 0x43, 0x36, 0x9e, 0x48, 0x47, 0xe3, 0xb1, 0x54, 0x45, 0x25, 0x1a,
    0x94, 0xb6, 0x42, 0x70, 0xf6, 0x18, 0xa5, 0x96, 0xce, 0x94, 0xe2, 0x2c,
    0x1f, 0x71, 0xe4, 0x0f, 0xd1, 0x97, 0x65, 0x49, 0x8b, 0xc2, 0x1c, 0x9a,
    0x59, 0xab, 0x7e, 0xb7, 0x7c, 0xae, 0xe8, 0x1e, 0xaf, 0xed, 0x0d, 0xe8,
    0xd5, 0x42, 0x4e, 0xe3, 0xce, 0xff, 0x86, 0x0e, 0xab, 0xb3, 0xb1, 0x38,
    0x1f, 0xa5, 0x28, 0x76, 0x42, 0xec, 0x50, 0xea, 0x9e, 0xe9, 0x57, 0x8a,
    0x8b, 0x7a, 0xbc, 0x00, 0xeb, 0x18, 0x7b, 0x15, 0x8c, 0x75, 0x66, 0x9c,
    0x17, 0x5d, 0x50, 0xe3, 0x00, 0xa4, 0xe0, 0x0b, 0xae, 0x5a, 0x53, 0x33,
    0xa7, 0x59, 0x33, 0x93, 0x86, 0x01, 0x18, 0x3f, 0x8a, 0x69, 0xbf, 0x54,
    0x7d, 0x5b, 0xe4, 0x9b, 0x7f, 0xae, 0xa3, 0x91, 0xbd, 0x2a, 0x4f, 0x5c,
    0xab, 0x05, 0x76, 0x42, 0x20, 0x5b, 0x55, 0x43, 0x7f, 0x99, 0xcc, 0x81,
    0x14, 0xcc, 0x21, 0xba, 0x9e, 0x9f, 0x16, 0xe8, 0x84, 0x4c, 0xf9, 0xda,
    0xd5, 0x39, 0x31, 0x40, 0x9c, 0xf4, 0xef, 0x6c, 0x6e, 0x65, 0xe7, 0x7f,
    0x21, 0xee, 0x2b, 0x3e, 0x70, 0x92, 0x71, 0x29, 0xa4, 0xb5, 0xd7, 0x80,
    0x44, 0xea, 0x70, 0x31, 0x26, 0x4b, 0xce, 0x6a,
  ]),
  // 32-byte expectedSharedSecret
  expectedSharedSecret: new Uint8Array([
    0x53, 0x2e, 0x3b, 0x9a, 0xf0, 0x8e, 0x5f, 0x55, 0x28, 0x92, 0x9b, 0x76,
    0x2f, 0xb6, 0xe4, 0xd3, 0x0b, 0x28, 0x86, 0xf0, 0x18, 0xf9, 0x70, 0x78,
    0x41, 0x99, 0xf3, 0x15, 0xe3, 0xf5, 0xcf, 0xc3,
  ]),
};

// ML-KEM-1024 test vectors
ml_kem_vectors['ML-KEM-1024'] = {
  // 1568-byte publicKey
  publicKey: new Uint8Array([
    0x51, 0xe6, 0x70, 0x71, 0x69, 0x47, 0x5b, 0x3a, 0x30, 0x8f, 0x01, 0x40,
    0x59, 0x58, 0x3b, 0x83, 0x04, 0xcd, 0x2d, 0x93, 0x68, 0x7e, 0x53, 0x15,
    0x83, 0x46, 0x44, 0x79, 0x35, 0x10, 0xd8, 0xbc, 0xb4, 0x6d, 0x90, 0x53,
    0xaf, 0xe0, 0xcb, 0x91, 0x09, 0x5f, 0x39, 0xac, 0x78, 0x2b, 0x8a, 0x61,
    0x27, 0x81, 0xc9, 0xff, 0x6a, 0x4e, 0xf7, 0xb1, 0x7b, 0xb7, 0x62, 0xc1,
    0x38, 0xb5, 0x43, 0xf4, 0x86, 0x54, 0xe6, 0x79, 0x70, 0x66, 0xec, 0xce,
    0x85, 0xd4, 0x3d, 0x42, 0xe7, 0x93, 0x44, 0x6b, 0x74, 0xe3, 0x49, 0x29,
    0x6b, 0x44, 0x5a, 0xfd, 0x2c, 0x9f, 0x45, 0x64, 0x64, 0x97, 0xd1, 0x08,
    0x3f, 0x32, 0x9b, 0xc5, 0x72, 0x3b, 0x3b, 0x62, 0x56, 0x39, 0x6a, 0x13,
    0x5c, 0x31, 0x03, 0x00, 0x41, 0x1b, 0xfb, 0x17, 0x45, 0x03, 0x50, 0xb7,
    0xe1, 0x80, 0x83, 0x2c, 0x00, 0x38, 0xe2, 0x45, 0x0e, 0x78, 0xf5, 0x18,
    0xee, 0x31, 0x84, 0x42, 0xcc, 0xa1, 0x36, 0xab, 0x93, 0x8e, 0xf8, 0x79,
    0x75, 0x25, 0x8b, 0xf2, 0xcc, 0x51, 0x62, 0xb1, 0xa9, 0x3d, 0x8a, 0x51,
    0xea, 0x52, 0xa1, 0xa8, 0xd4, 0xca, 0x23, 0xb9, 0xb6, 0x0b, 0xd6, 0x8c,
    0x7f, 0x41, 0x86, 0xa9, 0x80, 0x69, 0x99, 0xcc, 0x88, 0x6f, 0xa3, 0x69,
    0x2f, 0xfc, 0xbb, 0x46, 0xaa, 0xa2, 0x8f, 0x85, 0x6f, 0x9a, 0x77, 0x43,
    0x57, 0x40, 0x2f, 0xb0, 0xa5, 0xce, 0x80, 0xf6, 0x96, 0x31, 0xe5, 0x23,
    0x36, 0x72, 0x9e, 0x04, 0x38, 0xa1, 0xe9, 0x3a, 0x21, 0x4a, 0xe9, 0x9f,
    0x15, 0x26, 0x3e, 0xff, 0x13, 0x5d, 0xe0, 0xa9, 0x42, 0xd8, 0xb3, 0xc2,
    0x61, 0xb4, 0x22, 0xc0, 0x34, 0xb1, 0xbe, 0xc7, 0x90, 0x36, 0xb0, 0xa0,
    0x41, 0xc3, 0x7b, 0xe0, 0x33, 0x34, 0xae, 0x42, 0xcf, 0x86, 0x13, 0x28,
    0x3e, 0xe8, 0x0e, 0x69, 0x31, 0x49, 0x89, 0xf3, 0x69, 0x6f, 0x18, 0x25,
    0xbc, 0x53, 0xc8, 0x94, 0x32, 0x3e, 0x17, 0x75, 0xc7, 0x2f, 0x77, 0x94,
    0x15, 0xb8, 0x84, 0x87, 0xec, 0x26, 0xf4, 0xb1, 0x64, 0x46, 0xa0, 0xaa,
    0xb0, 0xe5, 0x22, 0x6b, 0x83, 0x7b, 0x8d, 0x13, 0x29, 0x7e, 0x31, 0xb4,
    0x7b, 0x4b, 0x41, 0xa4, 0x9b, 0x82, 0x3f, 0x69, 0x64, 0xe5, 0x37, 0x8a,
    0x78, 0x06, 0x3a, 0xfa, 0x24, 0xb5, 0xe6, 0x29, 0x4f, 0x27, 0x0b, 0xba,
    0x5a, 0x7b, 0x90, 0xe4, 0x2a, 0x2d, 0x6b, 0xa4, 0x41, 0x9f, 0x85, 0x8a,
    0xdb, 0xb1, 0x8f, 0x90, 0x1c, 0x37, 0xa0, 0xf2, 0x78, 0xbf, 0x6c, 0x46,
    0x8e, 0x72, 0x3f, 0x00, 0xbc, 0xba, 0x37, 0x10, 0x80, 0x9b, 0xd5, 0x5e,
    0x35, 0xbb, 0xb5, 0x20, 0xdc, 0x9f, 0x44, 0x61, 0x46, 0x65, 0x00, 0x6f,
    0x71, 0x3b, 0x5b, 0xa2, 0x64, 0xbb, 0x26, 0xb7, 0x10, 0x6d, 0x89, 0xbb,
    0x71, 0x4c, 0x65, 0xc0, 0xf3, 0x78, 0xdf, 0x16, 0x51, 0xa5, 0x75, 0xcd,
    0x63, 0x77, 0xa2, 0x83, 0x74, 0xb7, 0x66, 0x8b, 0xb6, 0xb1, 0x43, 0x66,
    0x12, 0xa3, 0x9c, 0x71, 0xea, 0xa4, 0x82, 0xeb, 0x78, 0xb7, 0xd0, 0x7d,
    0x49, 0x14, 0x87, 0x3e, 0x36, 0x38, 0x42, 0x90, 0xa7, 0xc4, 0x47, 0x86,
    0xe9, 0xb3, 0x7b, 0x8b, 0x42, 0x78, 0x82, 0x06, 0x9f, 0x0a, 0x90, 0x18,
    0xb4, 0x87, 0xa5, 0xff, 0xa8, 0xbc, 0x83, 0xd5, 0x2a, 0xab, 0x57, 0x95,
    0x63, 0x97, 0xac, 0x60, 0x56, 0x31, 0x3b, 0x94, 0xb5, 0x3c, 0xe1, 0xc3,
    0x9b, 0x71, 0x7e, 0x9b, 0xe2, 0x8b, 0xc7, 0xca, 0x12, 0xc4, 0x93, 0x8e,
    0x48, 0xbb, 0x03, 0x1a, 0x56, 0x39, 0x62, 0xc0, 0x5f, 0x25, 0xa4, 0x06,
    0xda, 0x2b, 0x7c, 0x1b, 0x98, 0x3a, 0x55, 0x5c, 0x5a, 0xe7, 0x93, 0x62,
    0x2c, 0x31, 0x93, 0xc4, 0xc1, 0x75, 0xfe, 0x0a, 0x8d, 0xfe, 0x20, 0xc1,
    0xcb, 0xb9, 0x4d, 0x96, 0x97, 0x16, 0x01, 0x60, 0x87, 0x8c, 0x67, 0x20,
    0xee, 0xf4, 0x4f, 0x8c, 0x22, 0x54, 0x9c, 0xf6, 0x2a, 0x2b, 0x4c, 0xbf,
    0xfc, 0x11, 0x9b, 0xd1, 0xc4, 0x6a, 0x10, 0xd0, 0x66, 0x1d, 0x5c, 0x4b,
    0x1a, 0x92, 0x77, 0xaa, 0x31, 0x00, 0xd8, 0xe3, 0x63, 0x68, 0x99, 0xbe,
    0xe5, 0x43, 0x12, 0x7c, 0xbb, 0x2a, 0x8c, 0x70, 0xb6, 0x76, 0x8c, 0xc5,
    0x1a, 0xa4, 0x39, 0x93, 0x87, 0x25, 0x87, 0x71, 0x87, 0xaa, 0x25, 0x3e,
    0xea, 0x51, 0xc6, 0x78, 0x4c, 0x29, 0xb3, 0x65, 0x07, 0xe4, 0x03, 0x9c,
    0x37, 0xb8, 0x45, 0xee, 0x4b, 0x05, 0x81, 0x55, 0xa3, 0xb8, 0x51, 0xca,
    0x68, 0x5c, 0x05, 0x4f, 0x80, 0x86, 0xca, 0x95, 0x58, 0x24, 0xab, 0x41,
    0x44, 0xc4, 0x36, 0x8d, 0xdc, 0x70, 0x76, 0x4a, 0x18, 0x4c, 0x2a, 0x2a,
    0xbe, 0xcc, 0x84, 0xad, 0xd7, 0x65, 0x07, 0x36, 0xa0, 0xf8, 0x86, 0x5e,
    0xc0, 0xc6, 0xb4, 0xbe, 0x22, 0x34, 0x5c, 0xeb, 0xc6, 0xed, 0x7a, 0x27,
    0xd5, 0x61, 0x61, 0xf3, 0x50, 0xa6, 0x05, 0xeb, 0x4b, 0x3f, 0x18, 0xa6,
    0x85, 0xdb, 0x16, 0x06, 0x35, 0x2e, 0x05, 0x2a, 0x97, 0xe9, 0xa5, 0xcf,
    0xb3, 0xb1, 0xc9, 0x09, 0xf5, 0x54, 0x5c, 0xe0, 0xa4, 0x19, 0xc6, 0x05,
    0xb7, 0x85, 0x94, 0x0f, 0x32, 0xc6, 0x22, 0xe3, 0x17, 0x87, 0xc5, 0xa3,
    0x61, 0xf4, 0x5e, 0xcd, 0xa5, 0x0b, 0x4b, 0x75, 0x46, 0xe7, 0x55, 0xaa,
    0x62, 0x67, 0x9f, 0x13, 0xea, 0xaa, 0x78, 0x75, 0x5f, 0x31, 0x18, 0x99,
    0x1b, 0x0a, 0x57, 0x92, 0x49, 0x59, 0x9a, 0x39, 0x21, 0x47, 0x11, 0x52,
    0x63, 0x4b, 0x4f, 0xe4, 0x01, 0xb1, 0x1c, 0xe7, 0x18, 0x2c, 0x54, 0xa3,
    0x21, 0x89, 0x9a, 0x94, 0xb4, 0x45, 0xb7, 0xca, 0x32, 0xbe, 0x5c, 0x13,
    0x02, 0xf7, 0x7e, 0x51, 0xdc, 0x86, 0xfc, 0xf3, 0x61, 0x59, 0x3b, 0x13,
    0xeb, 0x9c, 0xb0, 0x1d, 0xf3, 0xb1, 0x69, 0x93, 0xc1, 0x57, 0xc5, 0x66,
    0xac, 0x0b, 0xbc, 0xe3, 0x10, 0x83, 0xcb, 0xb1, 0x49, 0x53, 0x5b, 0x05,
    0xfd, 0xc8, 0x66, 0x55, 0xa5, 0x76, 0x65, 0x42, 0x34, 0x1f, 0x99, 0xb9,
    0xf2, 0x74, 0x77, 0x18, 0xfb, 0x58, 0xef, 0x1c, 0x00, 0x11, 0x18, 0x4c,
    0x21, 0xe3, 0xca, 0x80, 0xb1, 0xb9, 0x12, 0x8b, 0x79, 0x6b, 0x16, 0x9c,
    0x2b, 0x0a, 0xad, 0x8e, 0xbb, 0x2d, 0xa5, 0x36, 0x9f, 0x44, 0xdb, 0x2c,
    0x99, 0x5c, 0xa5, 0x67, 0x56, 0xc6, 0x68, 0xe4, 0xbd, 0xfe, 0x38, 0x86,
    0x2c, 0xc7, 0xba, 0xe4, 0xd1, 0xae, 0x50, 0x5c, 0x6e, 0x93, 0x6c, 0xba,
    0xae, 0x9b, 0x42, 0xe5, 0xbb, 0x28, 0x68, 0xc1, 0x41, 0xc2, 0x5b, 0x81,
    0xed, 0x7c, 0xc7, 0x06, 0x84, 0x6e, 0xa9, 0xa0, 0x59, 0xea, 0x65, 0x96,
    0x02, 0xb4, 0x29, 0xdc, 0x91, 0x11, 0xf1, 0xb0, 0xb3, 0x18, 0xf7, 0x40,
    0x2f, 0xe2, 0x06, 0x98, 0xa9, 0x3b, 0x77, 0x09, 0x78, 0xd6, 0x03, 0x5d,
    0xb8, 0xd4, 0x06, 0x5c, 0x49, 0x27, 0x5f, 0xfa, 0xbe, 0x68, 0x75, 0xc6,
    0x62, 0x15, 0x6d, 0x2a, 0x07, 0xbd, 0x3d, 0x91, 0xcc, 0x9a, 0x70, 0x3f,
    0x0f, 0x1b, 0x63, 0x99, 0x03, 0x63, 0xe4, 0x9b, 0xbf, 0xb6, 0x7c, 0x86,
    0x78, 0x27, 0x59, 0xf1, 0xe3, 0xaf, 0xd1, 0x09, 0x4d, 0x66, 0xb6, 0x10,
    0x0d, 0x87, 0x2b, 0x72, 0x54, 0xbd, 0xa0, 0xb1, 0x7b, 0x17, 0xb9, 0xcd,
    0x15, 0x44, 0x50, 0x9f, 0x9a, 0x72, 0xb7, 0x9c, 0x21, 0x96, 0x92, 0x54,
    0x82, 0x3c, 0x50, 0x13, 0x24, 0x4c, 0x68, 0x1a, 0x77, 0x28, 0x29, 0x78,
    0x69, 0xbb, 0x7c, 0xae, 0x71, 0x6f, 0x9d, 0x59, 0x86, 0x8d, 0x0c, 0x2a,
    0xef, 0x98, 0x21, 0x53, 0xe2, 0x18, 0xab, 0x55, 0xb8, 0xce, 0x96, 0x9f,
    0x31, 0x85, 0x26, 0x8a, 0x88, 0x0c, 0x31, 0x98, 0x87, 0x38, 0x58, 0x9d,
    0x42, 0xb8, 0x1b, 0xbc, 0xe5, 0xae, 0xdb, 0x29, 0xb0, 0xe9, 0x93, 0x37,
    0xf2, 0x38, 0x9a, 0xa5, 0x43, 0x50, 0x28, 0x97, 0x42, 0x45, 0x63, 0x84,
    0x66, 0x91, 0x87, 0xd2, 0xc6, 0x91, 0x8c, 0x59, 0x03, 0x3c, 0x92, 0x49,
    0x69, 0xa3, 0x67, 0x51, 0xb1, 0x01, 0x34, 0x54, 0x99, 0x75, 0xb2, 0x77,
    0xaf, 0xd9, 0x03, 0x3f, 0x50, 0xce, 0x65, 0xdc, 0x63, 0x3e, 0x5a, 0x1d,
    0x01, 0xa3, 0xb6, 0x13, 0x8c, 0x6f, 0x01, 0xf7, 0xae, 0xa1, 0x79, 0xc7,
    0xc8, 0xc7, 0x9e, 0x4b, 0xfb, 0x20, 0x3f, 0xd9, 0xb2, 0x8f, 0xa2, 0x3c,
    0x14, 0xe6, 0x55, 0xba, 0x77, 0x91, 0x92, 0x8a, 0xc4, 0x6f, 0xe1, 0xa6,
    0xb8, 0xb9, 0x36, 0x58, 0x09, 0x27, 0x68, 0xe6, 0x5e, 0x85, 0xc5, 0xae,
    0xd9, 0xe8, 0x97, 0xdd, 0x8a, 0x45, 0x71, 0x2a, 0xab, 0xcb, 0x7c, 0x19,
    0x19, 0x07, 0x65, 0x68, 0x49, 0x55, 0x9e, 0xd8, 0x4d, 0x40, 0x77, 0xc1,
    0x14, 0xd9, 0x11, 0xf9, 0xe8, 0x26, 0x70, 0x28, 0xa5, 0x85, 0x6a, 0x90,
    0x23, 0xba, 0x51, 0x08, 0x67, 0x86, 0x68, 0x92, 0x67, 0xa5, 0x6b, 0x06,
    0xe6, 0x28, 0x1f, 0x1b, 0xc3, 0x43, 0x4b, 0x01, 0xbf, 0x96, 0xb0, 0x24,
    0x3e, 0x08, 0x86, 0xd7, 0xf4, 0x37, 0x25, 0xf9, 0xaa, 0x59, 0x8b, 0x51,
    0x5c, 0xea, 0x40, 0x1b, 0x77, 0x51, 0xe1, 0xa2, 0x59, 0x81, 0x65, 0x26,
    0x23, 0x2a, 0x75, 0xd0, 0x72, 0x74, 0xf6, 0xbc, 0x4b, 0xd0, 0xd1, 0xa6,
    0x1e, 0xbb, 0x11, 0x80, 0x4a, 0xa7, 0x9f, 0x09, 0x40, 0x08, 0xe5, 0xa1,
    0x90, 0x85, 0x43, 0x1a, 0xc1, 0x1c, 0x50, 0x8a, 0x6f, 0xbd, 0x50, 0x26,
    0x8a, 0x8c, 0x80, 0x21, 0xc4, 0xb1, 0x9b, 0xfa, 0x56, 0x90, 0x97, 0x20,
    0xbf, 0xb7, 0x26, 0xca, 0xe9, 0xa7, 0xb7, 0x73, 0x6f, 0xaf, 0x17, 0xcf,
    0xba, 0x9b, 0x3b, 0x4a, 0x32, 0xad, 0xbb, 0x04, 0x50, 0xe9, 0x00, 0x24,
    0xbb, 0xe8, 0x2c, 0xdb, 0xb0, 0x2f, 0x62, 0x00, 0x5e, 0xf3, 0x34, 0x79,
    0x8c, 0xb3, 0xbd, 0x7f, 0xda, 0xa7, 0xfa, 0x63, 0x5f, 0xe3, 0xa6, 0x43,
    0xef, 0x74, 0x5f, 0x10, 0x37, 0xcb, 0x6b, 0x82, 0x4b, 0x7c, 0x60, 0x85,
    0x15, 0xe3, 0x7f, 0x5b, 0x73, 0xa4, 0x88, 0x24, 0x8d, 0xe1, 0x7c, 0x66,
    0x5d, 0x3b, 0xb4, 0xd9, 0x25, 0x75, 0x26, 0x6a, 0x0f, 0x65, 0x65, 0x26,
    0x4e, 0xb6, 0xa4, 0x64, 0x3b, 0x52, 0xb3, 0xd2, 0x3a, 0x80, 0x25, 0x46,
    0x10, 0x58, 0x5c, 0x22, 0xc3, 0x30, 0xa1, 0xe2, 0x35, 0xeb, 0xc7, 0x3d,
    0xe0, 0xba, 0xbf, 0x9b, 0x39, 0xa9, 0xc5, 0xf4, 0x8e, 0xf0, 0xac, 0x06,
    0x0f, 0xe9, 0x6a, 0x00, 0xfa, 0x4b, 0xe7, 0x6b, 0xbc, 0x47, 0x28, 0x37,
    0x1d, 0xe9, 0x64, 0x6d, 0xfa, 0x7d, 0x5c, 0x83, 0x3d, 0xe1, 0xf6, 0x46,
    0x28, 0x76, 0x33, 0xde, 0xb4, 0x1f, 0x46, 0x76, 0xc7, 0x44, 0x72, 0x25,
    0x07, 0xf1, 0xc3, 0x53, 0xa8, 0x5e, 0x85, 0xea, 0x10, 0xb3, 0xd4, 0x3e,
    0x8a, 0x78, 0x4c, 0x3e, 0xf2, 0x62, 0xf2, 0x81, 0xbd, 0xd5, 0xdb, 0x44,
    0xe0, 0x3c, 0x4e, 0xca, 0xd2, 0xa0, 0x5b, 0x48, 0x0b, 0xa1, 0x99, 0xbb,
    0x32, 0xbb, 0x07, 0xaf, 0xc4, 0x62, 0x57, 0xf9, 0x5b, 0xdf, 0x51, 0x6f,
    0xea, 0x63, 0xc6, 0x6c, 0xc4, 0x84, 0x26, 0xfa, 0xca, 0xcc, 0x06, 0x56,
    0xb7, 0xf6, 0x01, 0x79, 0xf7, 0x92, 0xb7, 0xd6, 0x86, 0xdf, 0xe7, 0x07,
    0xd7, 0xb9, 0x16, 0xb1, 0xe8, 0xb2, 0x49, 0x50, 0xc7, 0x4b, 0x9b, 0x60,
    0x01, 0x60, 0x4e, 0x5d, 0x33, 0x3a, 0x35, 0x99, 0x2a, 0x7c, 0xc4, 0x4c,
    0xe3, 0xbc, 0x1b, 0xbd, 0xb8, 0xc7, 0x2f, 0x08, 0x42, 0x8d, 0x8a, 0x6e,
    0x59, 0x20, 0x61, 0x9d, 0x81, 0x96, 0xa7, 0xd3, 0x26, 0x95, 0x33, 0xbd,
    0xcd, 0x34, 0x35, 0x18, 0x3b, 0x5d, 0x6e, 0x98,
  ]),
  // 64-byte privateSeed
  privateSeed: new Uint8Array([
    0xd7, 0x10, 0xa2, 0xbc, 0x47, 0x89, 0x36, 0x8c, 0xf2, 0x0a, 0xf5, 0xfe,
    0xee, 0xdc, 0x8b, 0x9a, 0x8d, 0x0a, 0x88, 0xeb, 0xd7, 0x70, 0xf9, 0x1e,
    0x9a, 0x44, 0x11, 0x46, 0x52, 0x6f, 0x6b, 0x0e, 0x71, 0x1d, 0x94, 0x5a,
    0x87, 0x86, 0xbd, 0xce, 0x9f, 0x16, 0x7d, 0xdc, 0x5d, 0xa8, 0xc7, 0xab,
    0x96, 0xdc, 0x30, 0x5d, 0x6a, 0x36, 0x63, 0x19, 0xd5, 0xf8, 0xa6, 0x92,
    0x4f, 0x18, 0x39, 0x59,
  ]),
  // 1568-byte sampleCiphertext
  sampleCiphertext: new Uint8Array([
    0xd5, 0x4d, 0xf4, 0xd6, 0x79, 0x31, 0x4c, 0xfd, 0x6f, 0x32, 0x91, 0xcb,
    0x64, 0x4b, 0x99, 0x73, 0x14, 0x5a, 0x78, 0x8c, 0x98, 0xef, 0x94, 0xe6,
    0x8e, 0x9f, 0x8d, 0x1f, 0x92, 0xeb, 0x84, 0x23, 0x96, 0x84, 0x9e, 0x69,
    0x14, 0xd8, 0xcf, 0x53, 0x09, 0x02, 0x57, 0x88, 0x2f, 0x26, 0xb1, 0xfb,
    0x4c, 0x07, 0xa2, 0xb6, 0xad, 0xea, 0xf3, 0xbd, 0x56, 0x8c, 0x5d, 0x3c,
    0x5b, 0x54, 0x32, 0x0d, 0x95, 0x0f, 0xa5, 0x59, 0x80, 0xaf, 0x8d, 0x96,
    0xfd, 0x7d, 0x49, 0x65, 0x82, 0x5b, 0x63, 0x88, 0x42, 0x92, 0x9f, 0x7b,
    0x6a, 0xcf, 0x5d, 0xfd, 0x30, 0x33, 0xf3, 0xf3, 0x45, 0xaf, 0x31, 0x32,
    0x80, 0xe0, 0x10, 0x5f, 0xaa, 0xdd, 0x42, 0x71, 0x5f, 0xff, 0x55, 0x55,
    0x0c, 0xaa, 0x64, 0x36, 0x89, 0x67, 0xf1, 0x58, 0xca, 0x3a, 0x7d, 0x00,
    0xae, 0xb4, 0xdf, 0x1e, 0xcc, 0xde, 0x24, 0x0f, 0x5b, 0x21, 0x10, 0xef,
    0xe6, 0x5f, 0x58, 0xe9, 0xb3, 0xee, 0x54, 0x98, 0x7e, 0x07, 0xea, 0xe1,
    0x95, 0x27, 0x9a, 0xfa, 0x37, 0x3d, 0x74, 0x62, 0xa4, 0x8d, 0x9c, 0x79,
    0xb7, 0xc8, 0xa3, 0xf8, 0x16, 0x2d, 0x84, 0x30, 0xbd, 0x0d, 0x97, 0xbd,
    0x90, 0x14, 0x36, 0x29, 0x7c, 0x12, 0x3e, 0x41, 0xf7, 0x40, 0x96, 0x06,
    0x54, 0x69, 0xd5, 0x87, 0xb9, 0xe7, 0x42, 0x77, 0x3f, 0xfe, 0xf9, 0x13,
    0x46, 0xe3, 0x51, 0xbb, 0x95, 0xb4, 0x3b, 0x8c, 0x08, 0x2a, 0x28, 0x7b,
    0x97, 0x98, 0x91, 0x17, 0x4e, 0x71, 0x86, 0xdc, 0x8c, 0xf2, 0xd6, 0x4a,
    0x07, 0x71, 0x1f, 0x6e, 0x9f, 0x17, 0xcf, 0x02, 0xad, 0xdc, 0xc3, 0xb8,
    0x03, 0xfd, 0xc2, 0xe3, 0xee, 0xc9, 0xd3, 0x91, 0x84, 0x1f, 0x0b, 0x38,
    0x5e, 0x2d, 0x3e, 0x09, 0x08, 0xab, 0x84, 0x18, 0x82, 0x67, 0xce, 0xdd,
    0xcf, 0xb6, 0x9d, 0x2f, 0x44, 0x4f, 0x69, 0x00, 0x88, 0x16, 0x45, 0x8d,
    0xa4, 0xda, 0xd5, 0x9a, 0x79, 0xe3, 0x37, 0x83, 0x33, 0x9c, 0xcc, 0xeb,
    0x55, 0x24, 0xa0, 0x22, 0x7f, 0x11, 0x4a, 0x23, 0x67, 0xdb, 0xcc, 0x5f,
    0x97, 0x85, 0xef, 0x15, 0x66, 0x5e, 0x92, 0x1e, 0x87, 0x7b, 0x24, 0x05,
    0x87, 0x67, 0x43, 0xec, 0xed, 0x6d, 0x76, 0xaf, 0x9d, 0x4a, 0xa6, 0xa6,
    0x80, 0x33, 0xc2, 0x43, 0x51, 0x58, 0xd7, 0xb0, 0x10, 0x60, 0x58, 0xef,
    0x98, 0x52, 0xa8, 0x1a, 0x46, 0x2b, 0xfb, 0x3c, 0xf8, 0xb1, 0x60, 0x27,
    0xe5, 0xe0, 0x82, 0x50, 0xc1, 0x2c, 0xb1, 0xe4, 0x13, 0x06, 0x68, 0x17,
    0x36, 0x23, 0x35, 0x6f, 0x97, 0x93, 0xdb, 0x05, 0xbd, 0x06, 0x5e, 0xa3,
    0x6a, 0x61, 0x32, 0x6c, 0xca, 0xf5, 0x3d, 0x2e, 0xc0, 0xa1, 0x34, 0xdc,
    0x1f, 0xc6, 0xc7, 0x2a, 0x40, 0x3d, 0x27, 0x46, 0x30, 0xb7, 0x34, 0x64,
    0xaa, 0xa1, 0x6b, 0x46, 0xa7, 0x1c, 0x82, 0xd8, 0xa0, 0x27, 0xcb, 0x50,
    0x05, 0xf2, 0x24, 0x26, 0xc0, 0xb5, 0x31, 0x4b, 0x04, 0xb7, 0x08, 0xd7,
    0xac, 0xa3, 0xf4, 0xb8, 0x53, 0x8e, 0xc1, 0x92, 0x53, 0xf9, 0x40, 0xb4,
    0xb8, 0x15, 0xaf, 0x22, 0xce, 0x82, 0xbd, 0xcd, 0x7d, 0xa8, 0x5a, 0x61,
    0xac, 0x18, 0x7c, 0x92, 0xef, 0x38, 0xc8, 0xc2, 0x99, 0x00, 0x51, 0x91,
    0x64, 0x82, 0x37, 0x47, 0xea, 0xa5, 0xf6, 0x8b, 0xea, 0x24, 0xe8, 0x7e,
    0x62, 0x3c, 0xb7, 0x4d, 0xac, 0x2c, 0x7b, 0x57, 0xfa, 0x1f, 0x28, 0x53,
    0x16, 0xfd, 0x74, 0x4b, 0x83, 0x80, 0x0e, 0xf3, 0x66, 0x36, 0xcd, 0xf5,
    0x29, 0x23, 0x0d, 0xc6, 0x9e, 0x7b, 0xb2, 0x8b, 0xc5, 0xc6, 0x48, 0xdb,
    0x1d, 0xbb, 0x61, 0x48, 0xae, 0x05, 0x10, 0x99, 0x9b, 0x48, 0x23, 0x8c,
    0x10, 0x50, 0xee, 0x5e, 0xa0, 0x49, 0x86, 0x27, 0x4e, 0xfe, 0xa8, 0x63,
    0xde, 0x71, 0xf5, 0x52, 0x8c, 0xef, 0xcc, 0xd3, 0x9e, 0x0e, 0x17, 0x9b,
    0x57, 0x49, 0xb7, 0x27, 0x29, 0x01, 0x3c, 0xbb, 0x1e, 0x85, 0xb9, 0x6a,
    0x13, 0x47, 0x59, 0xd8, 0x0b, 0xca, 0xb2, 0xa5, 0xe4, 0xeb, 0x93, 0xfd,
    0x7e, 0xef, 0x26, 0xae, 0x23, 0xed, 0x1e, 0x07, 0xd5, 0x91, 0x72, 0xa4,
    0x8d, 0x09, 0xae, 0xef, 0xfa, 0xfe, 0x12, 0xad, 0x46, 0xd7, 0x91, 0xbf,
    0xc6, 0xa7, 0x13, 0x30, 0x7d, 0xad, 0x2b, 0x8e, 0xd4, 0x14, 0x87, 0xf2,
    0x89, 0xeb, 0x2c, 0xca, 0xb8, 0x36, 0x12, 0xb0, 0xec, 0x61, 0xc8, 0xdc,
    0x32, 0x80, 0xae, 0x89, 0x9a, 0x4b, 0x57, 0xe2, 0xe1, 0x33, 0xb5, 0xdb,
    0x0d, 0x89, 0x6a, 0xd4, 0x18, 0xa5, 0xaf, 0xef, 0x5d, 0xab, 0x36, 0xf8,
    0x7c, 0x64, 0x79, 0x32, 0x39, 0x67, 0x2d, 0x50, 0xa6, 0x7b, 0x6a, 0xc1,
    0x6d, 0x6f, 0xcb, 0xac, 0x5d, 0x3e, 0x71, 0x1d, 0x48, 0x7c, 0xcd, 0x0e,
    0x4a, 0xc1, 0xc9, 0x64, 0xaa, 0x51, 0x55, 0xcc, 0x3b, 0xa0, 0x10, 0xb5,
    0x78, 0x3d, 0xcd, 0xd0, 0xef, 0x10, 0x56, 0x7e, 0x7c, 0xf1, 0x98, 0x62,
    0xc0, 0x0d, 0x71, 0x23, 0x02, 0x41, 0xef, 0x13, 0x29, 0xc5, 0x21, 0x3d,
    0x09, 0x83, 0xa5, 0x8f, 0x56, 0x5c, 0x12, 0xdd, 0x78, 0x6d, 0x68, 0xd8,
    0xbc, 0x31, 0x15, 0x8d, 0xe6, 0xcd, 0x02, 0x73, 0xbd, 0xfd, 0x8e, 0x58,
    0xf2, 0x16, 0x48, 0x96, 0x00, 0x57, 0x5b, 0x9f, 0x37, 0x34, 0xcf, 0xde,
    0x2a, 0x22, 0xc6, 0xf3, 0x30, 0x17, 0x56, 0x28, 0x50, 0x19, 0xc7, 0x77,
    0xf2, 0x3e, 0xed, 0x8f, 0x10, 0x11, 0x09, 0xe9, 0xff, 0xbd, 0x75, 0x65,
    0x52, 0x3b, 0x5c, 0x0f, 0xb4, 0x95, 0x09, 0xe6, 0x6a, 0x28, 0x91, 0x5e,
    0x26, 0xbf, 0xce, 0xfc, 0x75, 0x5c, 0xc0, 0x2d, 0xc8, 0x63, 0x7f, 0x31,
    0xd3, 0x59, 0xf0, 0xe2, 0xa7, 0xe8, 0x21, 0x4c, 0x99, 0xd5, 0x2f, 0x29,
    0x9f, 0x8c, 0x1f, 0x2c, 0xba, 0x34, 0xff, 0x1e, 0x96, 0x74, 0x58, 0x17,
    0x1a, 0x40, 0xe3, 0xc4, 0x46, 0xf0, 0xfd, 0x2b, 0x44, 0x3a, 0x06, 0x03,
    0x9f, 0x30, 0xac, 0xe8, 0xa0, 0x7e, 0xc9, 0xf1, 0x57, 0x7d, 0xb6, 0xf9,
    0x52, 0x4f, 0x1e, 0x70, 0x5e, 0xd7, 0x97, 0xe4, 0xa6, 0xf9, 0x9f, 0xed,
    0xa6, 0x05, 0x72, 0x1e, 0xbc, 0x68, 0x8f, 0x1a, 0x72, 0xe0, 0xb2, 0x67,
    0xe9, 0xcc, 0x4f, 0x26, 0x4f, 0x5a, 0x6c, 0x46, 0xda, 0x62, 0x0a, 0x47,
    0xf5, 0x89, 0xab, 0x0f, 0x80, 0x49, 0x3e, 0x18, 0xe5, 0xc0, 0x55, 0x9f,
    0x97, 0x18, 0xcc, 0x99, 0xb3, 0xb2, 0xa9, 0xb8, 0xdb, 0xfe, 0x0d, 0x94,
    0x16, 0xec, 0xe2, 0x62, 0x26, 0x5e, 0x93, 0x18, 0x09, 0x4a, 0x24, 0xf9,
    0xc0, 0x10, 0x3c, 0xcd, 0xcf, 0x77, 0xd7, 0xcd, 0x00, 0xde, 0xcd, 0x22,
    0x01, 0x60, 0x2b, 0x8f, 0x49, 0x86, 0x40, 0x70, 0x21, 0xee, 0x68, 0x3e,
    0x1a, 0x1e, 0x21, 0x58, 0x7a, 0xff, 0x70, 0x52, 0xd3, 0x0f, 0x76, 0x97,
    0x1e, 0x9c, 0x34, 0x86, 0xa4, 0x81, 0xdf, 0x81, 0xb2, 0x24, 0xc1, 0x69,
    0x56, 0x52, 0x37, 0x46, 0x4e, 0xee, 0xa0, 0xd0, 0xc6, 0xb2, 0xe9, 0x3f,
    0x35, 0xbd, 0xe3, 0xd0, 0x87, 0x36, 0xce, 0x85, 0xb8, 0xac, 0x48, 0xec,
    0xf4, 0x9d, 0xa7, 0x90, 0xed, 0x8b, 0x26, 0xff, 0x13, 0x1e, 0x55, 0xa3,
    0x81, 0x74, 0x03, 0xf5, 0x85, 0x03, 0xa2, 0x28, 0x43, 0x16, 0x55, 0xc2,
    0x8b, 0xb5, 0x84, 0x32, 0x3e, 0xd0, 0x2b, 0xde, 0x2f, 0x70, 0x0c, 0x96,
    0x4e, 0x59, 0x51, 0xb7, 0x19, 0x10, 0xdd, 0x19, 0x0d, 0x71, 0xfc, 0x37,
    0xa1, 0xfd, 0x19, 0x31, 0xe7, 0xa6, 0x52, 0x5c, 0x23, 0x1d, 0xf5, 0xe0,
    0x69, 0xe0, 0x2d, 0xb1, 0x76, 0xf2, 0xe0, 0xcf, 0xf5, 0x68, 0x33, 0x9d,
    0x05, 0x0e, 0x7c, 0x76, 0x7a, 0x4a, 0xf8, 0x54, 0x09, 0xb6, 0x0f, 0x9a,
    0x36, 0xba, 0x25, 0x26, 0x01, 0x57, 0xe4, 0x32, 0xc4, 0xa5, 0xe6, 0x57,
    0x18, 0xe4, 0x74, 0xa2, 0xfd, 0xee, 0x8e, 0x95, 0x4f, 0x35, 0x33, 0x3c,
    0xb0, 0x03, 0x5f, 0x65, 0xc8, 0x65, 0x59, 0x38, 0x9e, 0x98, 0x5f, 0x63,
    0x3d, 0x13, 0xa6, 0x19, 0x3c, 0x6f, 0x81, 0x40, 0x27, 0x5a, 0x30, 0x5c,
    0xbe, 0x67, 0x59, 0x96, 0xf6, 0x83, 0x53, 0x2f, 0xed, 0x01, 0x30, 0xb4,
    0xae, 0x13, 0x0c, 0xee, 0xc7, 0x47, 0x6b, 0xa0, 0xb7, 0x9e, 0xf0, 0xc3,
    0x60, 0x6e, 0x07, 0x88, 0x49, 0x47, 0xc1, 0x8f, 0x39, 0x20, 0xa3, 0x2a,
    0x3b, 0x39, 0xf6, 0x6c, 0xcd, 0xa8, 0x2c, 0x15, 0x9b, 0x37, 0x18, 0xf2,
    0x66, 0xd9, 0x0d, 0xe8, 0x31, 0xc9, 0x01, 0xcc, 0x75, 0x8c, 0xd0, 0xdf,
    0xe4, 0xa4, 0xaf, 0xfb, 0x4d, 0xe7, 0x7a, 0xad, 0x1e, 0x8f, 0x9d, 0xdf,
    0x5a, 0xcf, 0x39, 0xcb, 0x65, 0x94, 0xb5, 0x00, 0x99, 0x49, 0xe5, 0xbc,
    0xa5, 0x02, 0x98, 0xd9, 0xad, 0x8b, 0xc7, 0xae, 0x02, 0x1c, 0x48, 0x9b,
    0x30, 0x4d, 0x7b, 0xe8, 0xfc, 0xde, 0x0e, 0x18, 0xbf, 0x4a, 0x81, 0x7d,
    0x79, 0xf7, 0xb5, 0x12, 0xd6, 0x2b, 0x30, 0xaf, 0xf6, 0xd2, 0xbc, 0x31,
    0xa2, 0x94, 0x0d, 0x07, 0x4e, 0x6f, 0x78, 0xc0, 0x13, 0xc8, 0x22, 0x06,
    0x96, 0xcf, 0xd0, 0x2e, 0xc8, 0x31, 0x45, 0xe7, 0xb9, 0x80, 0x2a, 0x97,
    0x04, 0x2c, 0x28, 0xe9, 0xe6, 0x19, 0x57, 0xca, 0xfb, 0x7d, 0xc4, 0x5d,
    0x2b, 0xa1, 0x29, 0x72, 0x23, 0xdb, 0x25, 0x3a, 0xd5, 0xc1, 0x7a, 0x71,
    0xc7, 0xde, 0x34, 0xb6, 0x77, 0x27, 0xbf, 0xff, 0xb6, 0xea, 0x54, 0x24,
    0x72, 0x58, 0x55, 0x0a, 0xf9, 0x63, 0x75, 0x1a, 0xe4, 0x3e, 0x2a, 0x24,
    0x09, 0xb6, 0x35, 0x95, 0xe8, 0x23, 0x90, 0xfc, 0x24, 0xc6, 0x71, 0x82,
    0xb5, 0x74, 0xad, 0xc1, 0x4c, 0xc7, 0xf6, 0x53, 0x64, 0x28, 0xad, 0x93,
    0xee, 0x47, 0xe9, 0x1a, 0x58, 0x9a, 0x51, 0x96, 0x3d, 0xe7, 0x3a, 0xee,
    0x5b, 0x8b, 0x05, 0x0e, 0x37, 0xda, 0x2c, 0x89, 0x9b, 0x0a, 0x7b, 0x67,
    0xe5, 0x86, 0xc2, 0x5e, 0xfa, 0x76, 0xa2, 0x38, 0x91, 0xec, 0x12, 0xf9,
    0x35, 0x47, 0x8c, 0x99, 0x70, 0xf7, 0xce, 0xe6, 0xac, 0xf9, 0x2e, 0x3f,
    0x45, 0x7c, 0x35, 0xe6, 0x33, 0xbf, 0x2a, 0xcf, 0x08, 0x7b, 0xd0, 0xab,
    0x5a, 0xc2, 0x7a, 0x6d, 0xf9, 0xfe, 0x09, 0x7a, 0x29, 0xe0, 0xcf, 0x38,
    0x93, 0xdf, 0xe4, 0xda, 0x6b, 0x66, 0x0c, 0xe2, 0x83, 0x64, 0xa6, 0xfb,
    0x74, 0x25, 0x78, 0x9b, 0x74, 0xf7, 0x05, 0xd8, 0xe1, 0x39, 0x48, 0x1b,
    0x60, 0x06, 0x16, 0xc9, 0xc3, 0xa9, 0xc2, 0xad, 0xd0, 0xf8, 0x86, 0x2b,
    0x44, 0xe4, 0xc1, 0x4e, 0xd4, 0x26, 0x8f, 0x8e, 0xd9, 0xa6, 0xa1, 0xef,
    0xbb, 0xac, 0x2c, 0x98, 0x82, 0xba, 0xdd, 0x14, 0x8d, 0x14, 0xe0, 0x09,
    0xd1, 0x50, 0x44, 0xcc, 0x4e, 0x03, 0x59, 0x92, 0x00, 0x9a, 0x60, 0x36,
    0xba, 0xd6, 0xa9, 0xae, 0x75, 0xfd, 0x36, 0x59, 0x87, 0x7c, 0xd3, 0x47,
    0xa4, 0x5d, 0x99, 0xe9, 0x9d, 0xb2, 0x17, 0x55, 0x83, 0xed, 0x3c, 0xeb,
    0x25, 0x60, 0xa8, 0xfd, 0xcf, 0xa3, 0x5c, 0x15, 0x09, 0x31, 0x5d, 0x4c,
    0x8f, 0xb0, 0xe4, 0xa0, 0xac, 0x29, 0x81, 0x13, 0x28, 0x56, 0x29, 0x26,
    0x1d, 0xd9, 0xb2, 0xb3, 0x8f, 0xee, 0x18, 0x1c, 0xc9, 0x57, 0xa1, 0xcb,
    0x58, 0x24, 0x71, 0x1a, 0x67, 0xb1, 0xdc, 0xe4, 0x0d, 0x99, 0xca, 0x28,
    0xf9, 0x23, 0xb2, 0xf9, 0x9f, 0x2b, 0x38, 0x30, 0x96, 0x43, 0xb1, 0x4c,
    0x01, 0x41, 0x35, 0x02, 0x12, 0x47, 0xb6, 0xe8, 0xd1, 0x15, 0xb2, 0x4b,
    0xed, 0xf9, 0xbb, 0x20, 0x6c, 0x7e, 0xe1, 0xf9, 0x2a, 0xa6, 0x2c, 0xb9,
    0x78, 0xc1, 0xb8, 0xdb, 0x4f, 0x25, 0x9a, 0x9c,
  ]),
  // 32-byte expectedSharedSecret
  expectedSharedSecret: new Uint8Array([
    0x2f, 0x52, 0x11, 0x10, 0xa9, 0xe8, 0x53, 0x86, 0x70, 0x13, 0xce, 0xe3,
    0x4a, 0x38, 0xf1, 0x07, 0xbe, 0xa1, 0xc4, 0x68, 0x90, 0x67, 0x16, 0x08,
    0xe4, 0xec, 0xa1, 0x13, 0xed, 0xe9, 0x09, 0x7e,
  ]),
};
