// Flags: --permission --allow-fs-read=*

'use strict';

const { mustCall, skip, isWindows, isIBMi } = require('../common');
const assert = require('assert');
const { isMainThread } = require('worker_threads');

if (!isMainThread) {
  skip('process.execve is not available in Workers');
} else if (isWindows || isIBMi) {
  skip('process.execve is not available in Windows or IBM i');
}

if (process.argv[2] === 'replaced') {
  assert.fail('process.execve should not have been allowed.');
} else {
  assert.throws(mustCall(() => {
    process.execve(process.execPath, [process.execPath, __filename, 'replaced'], process.env);
  }), { code: 'ERR_ACCESS_DENIED', permission: 'ChildProcess', resource: process.execPath });
}
