/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_nl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Moskou-standaardtijd",
               "",
               "Moskou-zomertijd",
               "",
               "Moskou-tijd",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistaanse standaardtijd",
               "",
               "Pakistaanse zomertijd",
               "",
               "Pakistaanse tijd",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-standaardtijd",
               "",
               "Magadan-zomertijd",
               "",
               "Magadan-tijd",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Midden-Europese standaardtijd",
               "CET",
               "Midden-Europese zomertijd",
               "CEST",
               "Midden-Europese tijd",
               "CET",
            };
        final String[] Acre = new String[] {
               "Acre-standaardtijd",
               "",
               "Acre-zomertijd",
               "",
               "Acre-tijd",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Eastern-standaardtijd",
               "",
               "Eastern-zomertijd",
               "",
               "Eastern-tijd",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-eilandse standaardtijd",
               "",
               "Lord Howe-eilandse zomertijd",
               "",
               "Lord Howe-eilandse tijd",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nieuw-Zeelandse standaardtijd",
               "",
               "Nieuw-Zeelandse zomertijd",
               "",
               "Nieuw-Zeelandse tijd",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indische Oceaan-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakoetsk-standaardtijd",
               "",
               "Jakoetsk-zomertijd",
               "",
               "Jakoetsk-tijd",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oost-Timorese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosraese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Oost-Europese standaardtijd",
               "EET",
               "Oost-Europese zomertijd",
               "EEST",
               "Oost-Europese tijd",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "West-Argentijnse standaardtijd",
               "",
               "West-Argentijnse zomertijd",
               "",
               "West-Argentijnse tijd",
               "",
            };
        final String[] Ponape = new String[] {
               "Pohnpei-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliviaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint Pierre en Miquelon-standaardtijd",
               "",
               "Saint Pierre en Miquelon-zomertijd",
               "",
               "Saint Pierre en Miquelon-tijd",
               "",
            };
        final String[] Indochina = new String[] {
               "Indochinese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinenburg-standaardtijd",
               "",
               "Jekaterinenburg-zomertijd",
               "",
               "Jekaterinenburg-tijd",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis en Futunase tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Zuid-Afrikaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line-eilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Oezbeekse standaardtijd",
               "",
               "Oezbeekse zomertijd",
               "",
               "Oezbeekse tijd",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-standaardtijd",
               "",
               "Ulaanbaatar-zomertijd",
               "",
               "Ulaanbaatar-tijd",
               "",
            };
        final String[] America_Central = new String[] {
               "Central-standaardtijd",
               "",
               "Central-zomertijd",
               "",
               "Central-tijd",
               "",
            };
        final String[] Niue = new String[] {
               "Niuese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-eilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandeilandse standaardtijd",
               "",
               "Falklandeilandse zomertijd",
               "",
               "Falklandeilandse tijd",
               "",
            };
        final String[] Apia = new String[] {
               "Apia-standaardtijd",
               "",
               "Apia-zomertijd",
               "",
               "Apia-tijd",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauruaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "West-Kazachse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmaseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unionse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Cocoseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham-standaardtijd",
               "",
               "Chatham-zomertijd",
               "",
               "Chatham-tijd",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentijnse standaardtijd",
               "",
               "Argentijnse zomertijd",
               "",
               "Argentijnse tijd",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiereilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagoseilandse standaardtijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezolaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixeilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kaapverdische standaardtijd",
               "",
               "Kaapverdische zomertijd",
               "",
               "Kaapverdische tijd",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkeilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoaanse standaardtijd",
               "",
               "Samoaanse zomertijd",
               "",
               "Samoaanse tijd",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Cubaanse standaardtijd",
               "",
               "Cubaanse zomertijd",
               "",
               "Cubaanse tijd",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipijnse standaardtijd",
               "",
               "Filipijnse zomertijd",
               "",
               "Filipijnse tijd",
               "",
            };
        final String[] French_Southern = new String[] {
               "Franse zuidelijke en Antarctische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nieuw-Caledonische standaardtijd",
               "",
               "Nieuw-Caledonische zomertijd",
               "",
               "Nieuw-Caledonische tijd",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruneise tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Iraanse standaardtijd",
               "",
               "Iraanse zomertijd",
               "",
               "Iraanse tijd",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadzjiekse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongaanse standaardtijd",
               "",
               "Tongaanse zomertijd",
               "",
               "Tongaanse tijd",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bengalese standaardtijd",
               "",
               "Bengalese zomertijd",
               "",
               "Bengalese tijd",
               "",
            };
        final String[] Peru = new String[] {
               "Peruaanse standaardtijd",
               "",
               "Peruaanse zomertijd",
               "",
               "Peruaanse tijd",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Oost-Groenlandse standaardtijd",
               "",
               "Oost-Groenlandse zomertijd",
               "",
               "Oost-Groenlandse tijd",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oost-Indonesische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Oost-Australische standaardtijd",
               "",
               "Oost-Australische zomertijd",
               "",
               "Oost-Australische tijd",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frans-Guyaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Colombiaanse standaardtijd",
               "",
               "Colombiaanse zomertijd",
               "",
               "Colombiaanse tijd",
               "",
            };
        final String[] Chile = new String[] {
               "Chileense standaardtijd",
               "",
               "Chileense zomertijd",
               "",
               "Chileense tijd",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberteilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkoetsk-standaardtijd",
               "",
               "Irkoetsk-zomertijd",
               "",
               "Irkoetsk-tijd",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgische standaardtijd",
               "",
               "Georgische zomertijd",
               "",
               "Georgische tijd",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Tsjojbalsan-standaardtijd",
               "",
               "Tsjojbalsan-zomertijd",
               "",
               "Tsjojbalsan-tijd",
               "",
            };
        final String[] China = new String[] {
               "Chinese standaardtijd",
               "",
               "Chinese zomertijd",
               "",
               "Chinese tijd",
               "",
            };
        final String[] Armenia = new String[] {
               "Armeense standaardtijd",
               "",
               "Armeense zomertijd",
               "",
               "Armeense tijd",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centraal-Afrikaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Japanse standaardtijd",
               "",
               "Japanse zomertijd",
               "",
               "Japanse tijd",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei-standaardtijd",
               "",
               "Taipei-zomertijd",
               "",
               "Taipei-tijd",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd-standaardtijd",
               "",
               "Hovd-zomertijd",
               "",
               "Hovd-tijd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Midden-Australische westelijke standaardtijd",
               "",
               "Midden-Australische westelijke zomertijd",
               "",
               "Midden-Australische westelijke tijd",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin-standaardtijd",
               "",
               "Sachalin-zomertijd",
               "",
               "Sachalin-tijd",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguayaanse standaardtijd",
               "",
               "Paraguayaanse zomertijd",
               "",
               "Paraguayaanse tijd",
               "",
            };
        final String[] Casey = new String[] {
               "Casey tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Malaysia = new String[] {
               "Maleisische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Geco\u00f6rdineerde wereldtijd",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiaanse standaardtijd",
               "",
               "Mauritiaanse zomertijd",
               "",
               "Mauritiaanse tijd",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Oost-Afrikaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalleilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland-standaardtijd",
               "",
               "Newfoundland-zomertijd",
               "",
               "Newfoundland-tijd",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongse standaardtijd",
               "",
               "Hongkongse zomertijd",
               "",
               "Hongkongse tijd",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic-standaardtijd",
               "",
               "Atlantic-zomertijd",
               "",
               "Atlantic-tijd",
               "",
            };
        final String[] Israel = new String[] {
               "Isra\u00eblische standaardtijd",
               "",
               "Isra\u00eblische zomertijd",
               "",
               "Isra\u00eblische tijd",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Centraal-Indonesische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-standaardtijd",
               "",
               "Omsk-zomertijd",
               "",
               "Omsk-tijd",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayaanse standaardtijd",
               "",
               "Uruguayaanse zomertijd",
               "",
               "Uruguayaanse tijd",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuaanse standaardtijd",
               "",
               "Vanuatuaanse zomertijd",
               "",
               "Vanuatuaanse tijd",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-standaardtijd",
               "",
               "Novosibirsk-zomertijd",
               "",
               "Novosibirsk-tijd",
               "",
            };
        final String[] Singapore = new String[] {
               "Singaporese standaardtijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-standaardtijd",
               "",
               "Azoren-zomertijd",
               "",
               "Azoren-tijd",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinaamse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-standaardtijd",
               "",
               "Krasnojarsk-zomertijd",
               "",
               "Krasnojarsk-tijd",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazone-standaardtijd",
               "",
               "Amazone-zomertijd",
               "",
               "Amazone-tijd",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oost-Kazachse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fijische standaardtijd",
               "",
               "Fijische zomertijd",
               "",
               "Fijische tijd",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamtsjatski-standaardtijd",
               "",
               "Petropavlovsk-Kamtsjatski-zomertijd",
               "",
               "Petropavlovsk-Kamtsjatski-tijd",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-eilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleoetische standaardtijd",
               "",
               "Hawaii-Aleoetische zomertijd",
               "",
               "Hawaii-Aleoetische tijd",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Midden-Australische standaardtijd",
               "",
               "Midden-Australische zomertijd",
               "",
               "Midden-Australische tijd",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Pacific-standaardtijd",
               "",
               "Pacific-zomertijd",
               "",
               "Pacific-tijd",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmeense standaardtijd",
               "",
               "Turkmeense zomertijd",
               "",
               "Turkmeense tijd",
               "",
            };
        final String[] Europe_Western = new String[] {
               "West-Europese standaardtijd",
               "WET",
               "West-Europese zomertijd",
               "WEST",
               "West-Europese tijd",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Guyaanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairneilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Belause tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbeidzjaanse standaardtijd",
               "",
               "Azerbeidzjaanse zomertijd",
               "",
               "Azerbeidzjaanse tijd",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexicaanse Pacific-standaardtijd",
               "",
               "Mexicaanse Pacific-zomertijd",
               "",
               "Mexicaanse Pacific-tijd",
               "",
            };
        final String[] Africa_Western = new String[] {
               "West-Afrikaanse standaardtijd",
               "",
               "West-Afrikaanse zomertijd",
               "",
               "West-Afrikaanse tijd",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Zuid-Georgische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Paaseilandse standaardtijd",
               "",
               "Paaseilandse zomertijd",
               "",
               "Paaseilandse tijd",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Noordwest-Mexicaanse standaardtijd",
               "",
               "Noordwest-Mexicaanse zomertijd",
               "",
               "Noordwest-Mexicaanse tijd",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "West-Groenlandse standaardtijd",
               "",
               "West-Groenlandse zomertijd",
               "",
               "West-Groenlandse tijd",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadoraanse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf-standaardtijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Koreaanse standaardtijd",
               "",
               "Koreaanse zomertijd",
               "",
               "Koreaanse tijd",
               "",
            };
        final String[] Australia_Western = new String[] {
               "West-Australische standaardtijd",
               "",
               "West-Australische zomertijd",
               "",
               "West-Australische tijd",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "West-Indonesische tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain-standaardtijd",
               "",
               "Mountain-zomertijd",
               "",
               "Mountain-tijd",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesaseilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabische standaardtijd",
               "",
               "Arabische zomertijd",
               "",
               "Arabische tijd",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska-standaardtijd",
               "",
               "Alaska-zomertijd",
               "",
               "Alaska-tijd",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-standaardtijd",
               "",
               "Vladivostok-zomertijd",
               "",
               "Vladivostok-tijd",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-eilandse tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papoea-Nieuw-Guineese tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-standaardtijd",
               "",
               "Fernando de Noronha-zomertijd",
               "",
               "Fernando de Noronha-tijd",
               "",
            };
        final String[] Brasilia = new String[] {
               "Braziliaanse standaardtijd",
               "",
               "Braziliaanse zomertijd",
               "",
               "Braziliaanse tijd",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr-standaardtijd",
               "",
               "Anadyr-zomertijd",
               "",
               "Anadyr-tijd",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-standaardtijd",
               "",
               "Samara-zomertijd",
               "",
               "Samara-tijd",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Pyongyang-tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indiase tijd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Cookeilandse standaardtijd",
               "",
               "Cookeilandse halve zomertijd",
               "",
               "Cookeilandse tijd",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Hawaii-Aleoetische standaardtijd",
                    "HST",
                    "Hawaii-Aleoetische zomertijd",
                    "HDT",
                    "Hawaii-Aleoetische tijd",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marquesaseilanden" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Britse zomertijd",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Noord-Dakota" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Doesjanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londen" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Tsjojbalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berlijn" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinique" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.America/Lower_Princes", "Beneden Prinsen Kwartier" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Noord-Dakota" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Zuid-Georgia" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom-Penh" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "timezone.excity.Europe/Rome", "Rome" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Muscat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Noord-Dakota" },
            { "timezone.excity.Asia/Atyrau", "At\u0131raw" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bisjkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "onbekende stad" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Oezjhorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Bakoe" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Algiers" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoem" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Ierse standaardtijd",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Sint-Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Isle of Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Parijs" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Boedapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "Urumqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadishu" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Koeweit" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskou" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "",
                    "Britse zomertijd",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dhaka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaapverdi\u00eb" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "timezone.excity.America/Eirunepe", "Eirunepe" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Christmaseiland" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqtau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praag" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkoetsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakoetsk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Tasjkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Sjanghai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Paaseiland" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Canarische Eilanden" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Ca\u00efro" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tom\u00e9" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vaticaanstad" },
            { "timezone.excity.Asia/Almaty", "Alma-Ata" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beiroet" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Europe/Bucharest", "Boekarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Athene" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "Antarctica/Casey", Casey },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damascus" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minhstad" },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinenburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Mexico-Stad" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Pacific/Gambier", "\u00celes Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporizja" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10",
                new String[] {
                    "Hawaii-Aleoetische standaardtijd",
                    "HST",
                    "Hawaii-Aleoetische zomertijd",
                    "HDT",
                    "Hawaii-Aleoetische tijd",
                    "HST",
                }
            },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Qyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mauritius" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manilla" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanboel" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Asia/Singapore", "Singapore" },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Wenen" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nicosia" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "Faer\u00f6er" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Asjchabad" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagosarchipel" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "timezone.excity.Asia/Kabul", "Kabul" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Cocoseilanden" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldiven" },
        };
        return data;
    }
}
