/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_eu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ban = "baliera";
        final String metaValue_bug = "buginera";
        final String metaValue_chr = "txerokiera";
        final String metaValue_si = "sinhala";
        final String metaValue_tl = "tagaloa";
        final String metaValue_vai = "vaiera";
        final Object[][] data = new Object[][] {
            { "001", "Mundua" },
            { "002", "Afrika" },
            { "003", "Ipar Amerika" },
            { "005", "Hego Amerika" },
            { "009", "Ozeania" },
            { "011", "Mendebaldeko Afrika" },
            { "013", "Erdialdeko Amerika" },
            { "014", "Ekialdeko Afrika" },
            { "015", "Ipar Afrika" },
            { "017", "Erdialdeko Afrika" },
            { "018", "Hegoaldeko Afrika" },
            { "019", "Amerika" },
            { "021", "Amerikako iparraldea" },
            { "029", "Karibea" },
            { "030", "Ekialdeko Asia" },
            { "034", "Hego Asia" },
            { "035", "Hego-ekialdeko Asia" },
            { "039", "Hego Europa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Mikronesia eskualdea" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Erdialdeko Asia" },
            { "145", "Mendebaldeko Asia" },
            { "150", "Europa" },
            { "151", "Ekialdeko Europa" },
            { "154", "Ipar Europa" },
            { "155", "Mendebaldeko Europa" },
            { "202", "Saharaz hegoaldeko Afrika" },
            { "419", "Latinoamerika" },
            { "AC", "Ascension uhartea" },
            { "AD", "Andorra" },
            { "AE", "Arabiar Emirerri Batuak" },
            { "AF", "Afganistan" },
            { "AG", "Antigua eta Barbuda" },
            { "AI", "Aingira" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "AR", "Argentina" },
            { "AS", "Samoa Estatubatuarra" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia-Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgika" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibeko Herbehereak" },
            { "BR", "Brasil" },
            { "BS", "Bahamak" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet uhartea" },
            { "BW", "Botswana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Cocos (Keeling) uharteak" },
            { "CD", "Kongoko Errepublika Demokratikoa" },
            { "CF", "Afrika Erdiko Errepublika" },
            { "CG", "Kongo" },
            { "CH", "Suitza" },
            { "CI", "Boli Kosta" },
            { "CK", "Cook uharteak" },
            { "CL", "Txile" },
            { "CM", "Kamerun" },
            { "CN", "Txina" },
            { "CO", "Kolonbia" },
            { "CP", "Clipperton uhartea" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas uhartea" },
            { "CY", "Zipre" },
            { "CZ", "Txekia" },
            { "DE", "Alemania" },
            { "DG", "Diego Garc\u00eda" },
            { "DJ", "Djibuti" },
            { "DK", "Danimarka" },
            { "DM", "Dominika" },
            { "DO", "Dominikar Errepublika" },
            { "DZ", "Aljeria" },
            { "EA", "Ceuta eta Melilla" },
            { "EC", "Ekuador" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "Mendebaldeko Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Espainia" },
            { "ET", "Etiopia" },
            { "EU", "Europar Batasuna" },
            { "EZ", "Eurogunea" },
            { "FI", "Finlandia" },
            { "FJ", "Fiji" },
            { "FK", "Falklandak" },
            { "FM", "Mikronesia" },
            { "FO", "Faroe uharteak" },
            { "FR", "Frantzia" },
            { "GA", "Gabon" },
            { "GB", "Erresuma Batua" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Frantsesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekuatore Ginea" },
            { "GR", "Grezia" },
            { "GS", "Hegoaldeko Georgia eta Hegoaldeko Sandwich uharteak" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginea Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong Txinako AEB" },
            { "HM", "Heard eta McDonald uharteak" },
            { "HN", "Honduras" },
            { "HR", "Kroazia" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Kanariak" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Man uhartea" },
            { "IN", "India" },
            { "IO", "Indiako Ozeanoko lurralde britainiarra" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordania" },
            { "JP", "Japonia" },
            { "KE", "Kenya" },
            { "KG", "Kirgizistan" },
            { "KH", "Kanbodia" },
            { "KI", "Kiribati" },
            { "KM", "Komoreak" },
            { "KN", "Saint Kitts eta Nevis" },
            { "KP", "Ipar Korea" },
            { "KR", "Hego Korea" },
            { "KW", "Kuwait" },
            { "KY", "Kaiman uharteak" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "LC", "Santa Luzia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxenburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "San Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall Uharteak" },
            { "MK", "Ipar Mazedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "Macau Txinako AEB" },
            { "MP", "Ipar Mariana uharteak" },
            { "MQ", "Martinika" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurizio" },
            { "MV", "Maldivak" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambike" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Berria" },
            { "NE", "Niger" },
            { "NF", "Norfolk uhartea" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Herbehereak" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Zeelanda Berria" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinesia Frantsesa" },
            { "PG", "Papua Ginea Berria" },
            { "PH", "Filipinak" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "Saint-Pierre eta Mikelune" },
            { "PN", "Pitcairn uharteak" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinar Lurralde Okupatuak" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Qatar" },
            { "QO", "Mugaz kanpoko Ozeania" },
            { "RE", "Reunion" },
            { "RO", "Errumania" },
            { "RS", "Serbia" },
            { "RU", "Errusia" },
            { "RW", "Ruanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Salomon Uharteak" },
            { "SC", "Seychelleak" },
            { "SD", "Sudan" },
            { "SE", "Suedia" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard eta Jan Mayen uharteak" },
            { "SK", "Eslovakia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Hego Sudan" },
            { "ST", "Sao Tome eta Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Swazilandia" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turk eta Caico uharteak" },
            { "TD", "Txad" },
            { "TF", "Hegoaldeko lurralde frantsesak" },
            { "TG", "Togo" },
            { "TH", "Thailandia" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Ekialdeko Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkia" },
            { "TT", "Trinidad eta Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Ameriketako Estatu Batuetako Kanpoaldeko Uharte Txikiak" },
            { "UN", "Nazio Batuak" },
            { "US", "Ameriketako Estatu Batuak" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikano Hiria" },
            { "VC", "Saint Vincent eta Grenadinak" },
            { "VE", "Venezuela" },
            { "VG", "Birjina uharte britainiarrak" },
            { "VI", "Birjina uharte amerikarrak" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis eta Futuna" },
            { "WS", "Samoa" },
            { "XA", "Sasiazentuak" },
            { "XB", "Pseudobidia" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Hegoafrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Eskualde ezezaguna" },
            { "aa", "afarera" },
            { "ab", "abkhaziera" },
            { "af", "afrikaansa" },
            { "ak", "akanera" },
            { "am", "amharera" },
            { "an", "aragoiera" },
            { "ar", "arabiera" },
            { "as", "assamera" },
            { "av", "avarera" },
            { "ay", "aimara" },
            { "az", "azerbaijanera" },
            { "ba", "baxkirera" },
            { "be", "bielorrusiera" },
            { "bg", "bulgariera" },
            { "bi", "bislama" },
            { "bm", "bambarera" },
            { "bn", "bengalera" },
            { "bo", "tibetera" },
            { "br", "bretoiera" },
            { "bs", "bosniera" },
            { "ca", "katalana" },
            { "ce", "txetxenera" },
            { "ch", "txamorroera" },
            { "co", "korsikera" },
            { "cs", "txekiera" },
            { "cu", "elizako eslaviera" },
            { "cv", "txuvaxera" },
            { "cy", "galesa" },
            { "da", "daniera" },
            { "de", "alemana" },
            { "dv", "dhivehia" },
            { "dz", "dzongkha" },
            { "ee", "eweera" },
            { "el", "greziera" },
            { "en", "ingelesa" },
            { "eo", "esperantoa" },
            { "es", "espainiera" },
            { "et", "estoniera" },
            { "eu", "euskara" },
            { "fa", "persiera" },
            { "ff", "fula" },
            { "fi", "finlandiera" },
            { "fj", "fijiera" },
            { "fo", "faroera" },
            { "fr", "frantsesa" },
            { "fy", "frisiera" },
            { "ga", "irlandera" },
            { "gd", "Eskoziako gaelikoa" },
            { "gl", "galiziera" },
            { "gn", "guaraniera" },
            { "gu", "gujaratera" },
            { "gv", "manxera" },
            { "ha", "hausa" },
            { "he", "hebreera" },
            { "hi", "hindia" },
            { "hr", "kroaziera" },
            { "ht", "Haitiko kreolera" },
            { "hu", "hungariera" },
            { "hy", "armeniera" },
            { "hz", "hereroera" },
            { "ia", "interlingua" },
            { "id", "indonesiera" },
            { "ie", "interlingue" },
            { "ig", "igboera" },
            { "ii", "Sichuango yiera" },
            { "io", "idoa" },
            { "is", "islandiera" },
            { "it", "italiera" },
            { "iu", "inuitera" },
            { "ja", "japoniera" },
            { "jv", "javera" },
            { "ka", "georgiera" },
            { "kg", "kikongoa" },
            { "ki", "kikuyuera" },
            { "kj", "kuanyama" },
            { "kk", "kazakhera" },
            { "kl", "groenlandiera" },
            { "km", "khemerera" },
            { "kn", "kannada" },
            { "ko", "koreera" },
            { "kr", "kanuriera" },
            { "ks", "kaxmirera" },
            { "ku", "kurduera" },
            { "kv", "komiera" },
            { "kw", "kornubiera" },
            { "ky", "kirgizera" },
            { "la", "latina" },
            { "lb", "luxenburgera" },
            { "lg", "luganda" },
            { "li", "limburgera" },
            { "ln", "lingala" },
            { "lo", "laosera" },
            { "lt", "lituaniera" },
            { "lu", "Katangako lubera" },
            { "lv", "letoniera" },
            { "mg", "malgaxea" },
            { "mh", "marshallera" },
            { "mi", "maoriera" },
            { "mk", "mazedoniera" },
            { "ml", "malabarera" },
            { "mn", "mongoliera" },
            { "mr", "marathera" },
            { "ms", "malaysiera" },
            { "mt", "maltera" },
            { "my", "birmaniera" },
            { "na", "nauruera" },
            { "nb", "bokm\u00e5l (norvegiera)" },
            { "nd", "iparraldeko ndebeleera" },
            { "ne", "nepalera" },
            { "ng", "ndonga" },
            { "nl", "nederlandera" },
            { "nn", "nynorsk (norvegiera)" },
            { "no", "norvegiera" },
            { "nr", "hegoaldeko ndebelera" },
            { "nv", "navajoera" },
            { "ny", "chewera" },
            { "oc", "okzitaniera" },
            { "om", "oromoera" },
            { "or", "oriya" },
            { "os", "osetiera" },
            { "pa", "punjabera" },
            { "pl", "poloniera" },
            { "ps", "paxtunera" },
            { "pt", "portugesa" },
            { "qu", "kitxua" },
            { "rm", "erretorromaniera" },
            { "rn", "rundiera" },
            { "ro", "errumaniera" },
            { "ru", "errusiera" },
            { "rw", "kinyaruanda" },
            { "sa", "sanskritoa" },
            { "sc", "sardiniera" },
            { "sd", "sindhia" },
            { "se", "iparraldeko samiera" },
            { "sg", "sangoa" },
            { "sh", "serbokroaziera" },
            { "si", metaValue_si },
            { "sk", "eslovakiera" },
            { "sl", "esloveniera" },
            { "sm", "samoera" },
            { "sn", "shonera" },
            { "so", "somaliera" },
            { "sq", "albaniera" },
            { "sr", "serbiera" },
            { "ss", "swatiera" },
            { "st", "hegoaldeko sothoera" },
            { "su", "sundanera" },
            { "sv", "suediera" },
            { "sw", "swahilia" },
            { "ta", "tamilera" },
            { "te", "telugua" },
            { "tg", "tajikera" },
            { "th", "thailandiera" },
            { "ti", "tigrinyera" },
            { "tk", "turkmenera" },
            { "tl", metaValue_tl },
            { "tn", "tswanera" },
            { "to", "tongera" },
            { "tr", "turkiera" },
            { "ts", "tsongera" },
            { "tt", "tatarera" },
            { "tw", "twia" },
            { "ty", "tahitiera" },
            { "ug", "uigurrera" },
            { "uk", "ukrainera" },
            { "ur", "urdua" },
            { "uz", "uzbekera" },
            { "ve", "vendera" },
            { "vi", "vietnamera" },
            { "vo", "volap\u00fck" },
            { "wa", "waloiera" },
            { "wo", "wolofera" },
            { "xh", "xhosera" },
            { "yi", "yiddisha" },
            { "yo", "jorubera" },
            { "zh", "txinera" },
            { "zu", "zuluera" },
            { "ace", "acehnera" },
            { "ach", "acholiera" },
            { "ada", "adangmera" },
            { "ady", "adigera" },
            { "agq", "aghemera" },
            { "ain", "ainuera" },
            { "ale", "aleutera" },
            { "alt", "hegoaldeko altaiera" },
            { "ann", "oboloera" },
            { "anp", "angikera" },
            { "arn", "mapudunguna" },
            { "arp", "arapahoera" },
            { "ars", "Najdeko arabiera" },
            { "asa", "asua" },
            { "ast", "asturiera" },
            { "atj", "atikamekwera" },
            { "awa", "awadhiera" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bem", "bembera" },
            { "bez", "benera" },
            { "bho", "bhojpurera" },
            { "bin", "edoera" },
            { "bla", "siksikera" },
            { "brx", "bodoera" },
            { "bug", metaValue_bug },
            { "byn", "bilenera" },
            { "cay", "cayugera" },
            { "ccp", "chakmera" },
            { "ceb", "cebuanoera" },
            { "cgg", "chiga" },
            { "chk", "chuukera" },
            { "chm", "mariera" },
            { "cho", "txoktawera" },
            { "chp", "chipewyera" },
            { "chr", metaValue_chr },
            { "chy", "txeienera" },
            { "ckb", "erdialdeko kurduera" },
            { "clc", "chilcotinera" },
            { "crg", "metisera" },
            { "crj", "hego-ekialdeko creera" },
            { "crk", "lautadetako creera" },
            { "crl", "ipar-ekialdeko creera" },
            { "crm", "Mooseko creera" },
            { "crr", "Carolinako algonkinera" },
            { "crs", "Seychelleetako kreolera" },
            { "csw", "zingiretako creera" },
            { "dak", "dakotera" },
            { "dar", "darginera" },
            { "dav", "taitera" },
            { "dgr", "dogribera" },
            { "dje", "zarma" },
            { "doi", "dogria" },
            { "dsb", "behe-sorabiera" },
            { "dua", "dualera" },
            { "dyo", "fonyi jolera" },
            { "dzg", "dazaera" },
            { "ebu", "embuera" },
            { "efi", "efikera" },
            { "eka", "ekajuka" },
            { "ewo", "ewondoa" },
            { "fil", "filipinera" },
            { "fon", "fonera" },
            { "frc", "cajun frantsesa" },
            { "frr", "iparraldeko frisiera" },
            { "fur", "friulera" },
            { "gaa", "gaera" },
            { "gag", "gagauzera" },
            { "gez", "ge\u2019eza" },
            { "gil", "kiribatiera" },
            { "gor", "gorontaloera" },
            { "gsw", "Suitzako alemana" },
            { "guz", "gusiiera" },
            { "gwi", "gwich\u2019inera" },
            { "hai", "haidera" },
            { "haw", "hawaiiera" },
            { "hax", "hegoaldeko haidera" },
            { "hil", "hiligaynonera" },
            { "hmn", "hmonga" },
            { "hsb", "goi-sorabiera" },
            { "hup", "hupera" },
            { "hur", "halkomelema" },
            { "iba", "ibanera" },
            { "ibb", "ibibioera" },
            { "ikt", "Kanada mendebaldeko inuitera" },
            { "ilo", "ilocanoera" },
            { "inh", "ingushera" },
            { "jbo", "lojbana" },
            { "jgo", "ngomba" },
            { "jmc", "machamea" },
            { "kab", "kabiliera" },
            { "kac", "jingphoera" },
            { "kaj", "jjua" },
            { "kam", "kambera" },
            { "kbd", "kabardiera" },
            { "kcg", "tyapa" },
            { "kde", "makondeera" },
            { "kea", "Cabo Verdeko kreolera" },
            { "kfo", "koroa" },
            { "kgp", "kaingangera" },
            { "kha", "khasiera" },
            { "khq", "koyra chiinia" },
            { "kkj", "kakoa" },
            { "kln", "kalenjinera" },
            { "kmb", "kimbundua" },
            { "koi", "komi-permyakera" },
            { "kok", "konkanera" },
            { "kpe", "kpelleera" },
            { "krc", "karachayera-balkarera" },
            { "krl", "kareliera" },
            { "kru", "kurukhera" },
            { "ksb", "shambalera" },
            { "ksf", "bafiera" },
            { "ksh", "koloniera" },
            { "kum", "kumykera" },
            { "kwk", "kwakwala" },
            { "lad", "ladinoa" },
            { "lag", "langiera" },
            { "lez", "lezginera" },
            { "lij", "liguriera" },
            { "lil", "lillooetera" },
            { "lkt", "lakotera" },
            { "lou", "Louisianako kreolera" },
            { "loz", "loziera" },
            { "lrc", "iparraldeko lurera" },
            { "lsm", "saamia" },
            { "lua", "Kasai mendebaldeko lubera" },
            { "lun", "lundera" },
            { "luo", "luoera" },
            { "lus", "mizoera" },
            { "luy", "luhyera" },
            { "mad", "madurera" },
            { "mag", "magadhera" },
            { "mai", "maithilia" },
            { "mak", "makassarera" },
            { "mas", "masaiera" },
            { "mdf", "mokxera" },
            { "men", "mendeera" },
            { "mer", "meruera" },
            { "mfe", "Mauritaniako kreolera" },
            { "mgh", "makhuwa-meettoera" },
            { "mgo", "meta\u02bcera" },
            { "mic", "mikmakera" },
            { "min", "minangkabauera" },
            { "mni", "manipurera" },
            { "moe", "innuera" },
            { "moh", "mohawkera" },
            { "mos", "mossiera" },
            { "mua", "mudangera" },
            { "mul", "zenbait hizkuntza" },
            { "mus", "muscogeera" },
            { "mwl", "mirandesa" },
            { "myv", "erziera" },
            { "mzn", "mazandarandera" },
            { "nap", "napoliera" },
            { "naq", "namera" },
            { "nds", "behe-alemana" },
            { "new", "newarera" },
            { "nia", "niasera" },
            { "niu", "niueera" },
            { "nmg", "kwasiera" },
            { "nnh", "ngiemboonera" },
            { "nog", "nogaiera" },
            { "nqo", "n\u2019koera" },
            { "nso", "pediera" },
            { "nus", "nuerera" },
            { "nyn", "nkoreera" },
            { "ojb", "ipar-mendebaldeko ojibwa" },
            { "ojc", "erdialdeko ojibwa" },
            { "ojs", "oji-creera" },
            { "ojw", "mendebaldeko ojibwa" },
            { "oka", "okanaganera" },
            { "pag", "pangasinanera" },
            { "pam", "pampangera" },
            { "pap", "papiamentoa" },
            { "pau", "palauera" },
            { "pcm", "Nigeriako pidgina" },
            { "pis", "pijina" },
            { "pqm", "maliseet-passamaquoddyera" },
            { "prg", "prusiera" },
            { "quc", "quicheera" },
            { "rap", "rapanuia" },
            { "rar", "rarotongera" },
            { "rhg", "rohingyera" },
            { "rof", "romboa" },
            { "rup", "aromaniera" },
            { "rwk", "rwera" },
            { "sad", "sandaweera" },
            { "sah", "sakhera" },
            { "saq", "samburuera" },
            { "sat", "santalera" },
            { "sba", "ngambayera" },
            { "sbp", "sanguera" },
            { "scn", "siziliera" },
            { "sco", "eskoziera" },
            { "seh", "senera" },
            { "ses", "koyraboro sennia" },
            { "shi", "tachelhita" },
            { "shn", "shanera" },
            { "slh", "lushootseeda" },
            { "sma", "hegoaldeko samiera" },
            { "smj", "Luleko samiera" },
            { "smn", "Inariko samiera" },
            { "sms", "skolten samiera" },
            { "snk", "soninkera" },
            { "srn", "srananera" },
            { "ssy", "sahoa" },
            { "str", "itsasarteetako salishera" },
            { "suk", "sukumera" },
            { "swb", "komoreera" },
            { "syr", "asiriera" },
            { "tce", "hegoaldeko tutchoneera" },
            { "tem", "temnea" },
            { "teo", "tesoera" },
            { "tet", "tetuma" },
            { "tgx", "tagishera" },
            { "tht", "tahltanera" },
            { "tig", "tigrea" },
            { "tlh", "klingonera" },
            { "tli", "tlingitera" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "tarokoa" },
            { "ttm", "iparraldeko tutchoneera" },
            { "tum", "tumbukera" },
            { "tvl", "tuvaluera" },
            { "twq", "tasawaqa" },
            { "tyv", "tuvera" },
            { "tzm", "Erdialdeko Atlaseko amazigera" },
            { "udm", "udmurtera" },
            { "umb", "umbundua" },
            { "und", "hizkuntza ezezaguna" },
            { "vai", metaValue_vai },
            { "vec", "veneziera" },
            { "vun", "vunjoa" },
            { "wae", "walserera" },
            { "wal", "welayta" },
            { "war", "samerera" },
            { "wuu", "wu txinera" },
            { "xal", "kalmykera" },
            { "xog", "sogera" },
            { "yav", "yangbenera" },
            { "ybb", "yemba" },
            { "yrl", "nheengatua" },
            { "yue", "kantonera" },
            { "zgh", "amazigera estandarra" },
            { "zun", "zu\u00f1ia" },
            { "zxx", "ez dago eduki linguistikorik" },
            { "zza", "zazera" },
            { "Adlm", "adlam" },
            { "Aghb", "Kaukasoko albaniera" },
            { "Ahom", "ahomera" },
            { "Arab", "arabiarra" },
            { "Aran", "nastaliq" },
            { "Armi", "aramiera inperiarra" },
            { "Armn", "armeniarra" },
            { "Avst", "avestera" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", "bengalarra" },
            { "Bhks", "bhaiksuki" },
            { "Bopo", "bopomofoa" },
            { "Brah", "brahmiera" },
            { "Brai", "braillea" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", "txakma" },
            { "Cans", "Kanadiako aborigenen silabiko bateratua" },
            { "Cari", "kariera" },
            { "Cham", "txamera" },
            { "Cher", metaValue_chr },
            { "Chrs", "korasmiera" },
            { "Copt", "koptikera" },
            { "Cpmn", "zipro-minoera" },
            { "Cprt", "ziprera" },
            { "Cyrl", "zirilikoa" },
            { "Deva", "devanagaria" },
            { "Diak", "dives akuru" },
            { "Dogr", "dogrera" },
            { "Dsrt", "deseret" },
            { "Dupl", "duployiar takigrafia" },
            { "Egyp", "egiptoar hieroglifikoak" },
            { "Elba", "elbasanera" },
            { "Elym", "elimaikera" },
            { "Ethi", "etiopiarra" },
            { "Geor", "georgiarra" },
            { "Glag", "glagolitikera" },
            { "Gong", "gunjala gondi" },
            { "Gonm", "masaram gondiera" },
            { "Goth", "gotikoa" },
            { "Gran", "grantha" },
            { "Grek", "grekoa" },
            { "Gujr", "gujaratarra" },
            { "Guru", "gurmukhia" },
            { "Hanb", "h\u00e4nera" },
            { "Hang", "hangula" },
            { "Hani", "idazkera txinatarra" },
            { "Hano", "hanunuera" },
            { "Hans", "sinplifikatua" },
            { "Hant", "tradizionala" },
            { "Hatr", "hatreoera" },
            { "Hebr", "hebrearra" },
            { "Hira", "hiragana" },
            { "Hluw", "hieroglifiko anatoliarrak" },
            { "Hmng", "pahawh hmongera" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "Hrkt", "silabario japoniarrak" },
            { "Hung", "hungariera zaharra" },
            { "Ital", "italiera zaharra" },
            { "Jamo", "jamo-bihurketa" },
            { "Java", "javaniera" },
            { "Jpan", "japoniarra" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Kawi", "kawi" },
            { "Khar", "kharoshthi" },
            { "Khmr", "khemerarra" },
            { "Khoj", "khojkiera" },
            { "Kits", "khitanerako script txikiak" },
            { "Knda", "kanadarra" },
            { "Kore", "korearra" },
            { "Kthi", "kaithiera" },
            { "Lana", "lannera" },
            { "Laoo", "laosarra" },
            { "Latn", "latinoa" },
            { "Lepc", "leptxa" },
            { "Limb", "linbuera" },
            { "Lina", "A linearra" },
            { "Linb", "B linearra" },
            { "Lisu", "fraserera" },
            { "Lyci", "liziera" },
            { "Lydi", "lidiera" },
            { "Mahj", "mahajaniera" },
            { "Maka", "makasarrera" },
            { "Mand", "mandaera" },
            { "Mani", "manikeoa" },
            { "Marc", "martxenera" },
            { "Medf", "medefaidrinera" },
            { "Mend", "mende" },
            { "Merc", "meroitiar etzana" },
            { "Mero", "meroitirra" },
            { "Mlym", "malayalamarra" },
            { "Modi", "modiera" },
            { "Mong", "mongoliarra" },
            { "Mroo", "mroera" },
            { "Mtei", "meitei mayekera" },
            { "Mult", "multaniera" },
            { "Mymr", "birmaniarra" },
            { "Nagm", "nag mundariera" },
            { "Nand", "nandinagariera" },
            { "Narb", "iparraldeko arabiera zaharra" },
            { "Nbat", "nabatera" },
            { "Newa", "newaera" },
            { "Nkoo", "n\u2019ko" },
            { "Nshu", "nushuera" },
            { "Ogam", "oghamera" },
            { "Olck", "ol txikiera" },
            { "Orkh", "orkhonera" },
            { "Orya", "oriyarra" },
            { "Osge", "osagera" },
            { "Osma", "osmaiera" },
            { "Ougr", "uigurrera zaharra" },
            { "Palm", "palmiera" },
            { "Pauc", "pau cin hau" },
            { "Perm", "permiera zaharra" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavi inskripzioak" },
            { "Phlp", "Pahlavi salmo-liburua" },
            { "Phnx", "feniziera" },
            { "Plrd", "polardera fonetikoa" },
            { "Prti", "Partiera inskripzioak" },
            { "Qaag", "zauagiera" },
            { "Rjng", "Rejang" },
            { "Rohg", "hanifiera" },
            { "Runr", "errunikoa" },
            { "Samr", "samariera" },
            { "Sarb", "hegoaldeko arabiera zaharra" },
            { "Saur", "saurashtra" },
            { "Sgnw", "zeinu-idazketa" },
            { "Shaw", "shaviera" },
            { "Shrd", "sharada" },
            { "Sidd", "siddham" },
            { "Sind", "khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "sogdiera" },
            { "Sogo", "sogdiera zaharra" },
            { "Sora", "sora sompeng" },
            { "Soyo", "soyomboera" },
            { "Sund", "sudanera" },
            { "Sylo", "syloti nagriera" },
            { "Syrc", "siriera" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takriera" },
            { "Tale", "tai le" },
            { "Talu", "tai lue berria" },
            { "Taml", "tamilarra" },
            { "Tang", "tangutera" },
            { "Tavt", "tai viet" },
            { "Telu", "teluguarra" },
            { "Tfng", "tifinagera" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", "thailandiarra" },
            { "Tibt", "tibetarra" },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "totoera" },
            { "Ugar", "ugaritiera" },
            { "Vaii", metaValue_vai },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wanchoera" },
            { "Xpeo", "pertsiera zaharra" },
            { "Xsux", "sumero-akadiera kuneiformea" },
            { "Yezi", "yezidiera" },
            { "Yiii", "yiera" },
            { "Zanb", "zanabazar koadroa" },
            { "Zinh", "heredatua" },
            { "Zmth", "matematikako notazioa" },
            { "Zsye", "emotikonoa" },
            { "Zsym", "ikurrak" },
            { "Zxxx", "idatzi gabea" },
            { "Zyyy", "ohikoa" },
            { "Zzzz", "idazkera ezezaguna" },
            { "de_AT", "Austriako alemana" },
            { "de_CH", "Suitzako aleman garaia" },
            { "en_AU", "Australiako ingelesa" },
            { "en_CA", "Kanadako ingelesa" },
            { "en_GB", "Britainia Handiko ingelesa" },
            { "en_US", "ingeles amerikarra" },
            { "es_ES", "espainiera (Europa)" },
            { "es_MX", "Mexikoko espainiera" },
            { "fa_AF", "daria" },
            { "fr_CA", "Kanadako frantsesa" },
            { "fr_CH", "Suitzako frantsesa" },
            { "nl_BE", "flandriera" },
            { "pt_BR", "Brasilgo portugesa" },
            { "pt_PT", "Europako portugesa" },
            { "ro_MD", "moldaviera" },
            { "sw_CD", "Kongoko swahilia" },
            { "%%1901", "ortografia aleman tradizionala" },
            { "%%1994", "Resiako ortografia estandarizatua" },
            { "%%1996", "1996ko ortografia alemana" },
            { "ar_001", "arabiera moderno estandarra" },
            { "es_419", "Latinoamerikako espainiera" },
            { "key.ca", "Egutegia" },
            { "key.cf", "Moneta-formatua" },
            { "key.co", "Ordenatzeko irizpidea" },
            { "key.cu", "Moneta" },
            { "key.hc", "Ordu-zikloa (12 vs 24)" },
            { "key.lb", "Lerro-jauziaren estiloa" },
            { "key.ms", "Neurketa-sistema" },
            { "key.nu", "Zenbakiak" },
            { "key.tz", "Ordu-zona" },
            { "key.va", "Eskualdeko ezarpenen aldaera" },
            { "nds_NL", "behe-saxoiera" },
            { "%%ALUKU", "Aluku dialektoa" },
            { "%%BARLA", "Caboverdeeraren barlavento dialekto taldea" },
            { "%%BISKE", "San Giorgio / Bila dialektoa" },
            { "%%BOONT", "Boontling" },
            { "%%CORNU", "cornishera" },
            { "%%GALLO", "Galiera" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Ortografia arrunta" },
            { "%%KSCOR", "Ortografia estandarra" },
            { "%%LIPAW", "Resiako lipovaz dialektoa" },
            { "%%NEDIS", "Natisoneko dialektoa" },
            { "%%NJIVA", "Gniva/Njiva dialektoa" },
            { "%%NULIK", "Volapuk modernoa" },
            { "%%OSOJS", "Oseacco/Osojane dialektoa" },
            { "%%PEANO", "Peano" },
            { "%%POSIX", "Ordenagailua" },
            { "%%PUTER", "Puterera" },
            { "%%RIGIK", "Volapuk klasikoa" },
            { "%%ROZAJ", "Resiera" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Stolvizza/Solbica dialektoa" },
            { "%%SOTAV", "Caboverdeerako sotavento dialekto taldea" },
            { "%%UCCOR", "Ortografia bateratua" },
            { "zh_Hans", "txinera sinplifikatua" },
            { "zh_Hant", "txinera tradizionala" },
            { "%%AO1990", "1990eko portugesaren ortografia-hitzarmena" },
            { "%%ARANES", "Aranera" },
            { "%%ASANTE", "ASANTEERA" },
            { "%%AUVERN", "Auverniako okzitaniera" },
            { "%%CISAUP", "galiar-italiarra" },
            { "%%CREISS", "Languedocera" },
            { "%%DAJNKO", "Dajnko alfabetoa" },
            { "%%EKAVSK", "Serbiera ekavierako ahoskerarekin" },
            { "%%FONIPA", "IPA ahoskera" },
            { "%%FONUPA", "UPa ahoskera" },
            { "%%GASCON", "GASKOI" },
            { "%%GRITAL", "Grital" },
            { "%%NDYUKA", "Ndyuka dialektoa" },
            { "%%NICARD", "Nicard" },
            { "%%PAMAKA", "Pamaka dialektoa" },
            { "%%PINYIN", "Pinyin erromanizazioa" },
            { "%%SCOUSE", "Scouse" },
            { "%%SIMPLE", "SOILA" },
            { "%%TARASK", "Taraskievica ortografia" },
            { "%%UCRCOR", "Ortografia berrikusi bateratua" },
            { "%%ULSTER", "Ulster" },
            { "%%UNIFON", "Alfabeto fonetiko unifonoa" },
            { "%%ABL1943", "1943ko ortografia-formulazioa" },
            { "%%AKUAPEM", "AKUAPIMERA" },
            { "%%ALALC97", "ALA-LC erromanizazioa, 1997ko edizioa" },
            { "%%ARKAIKA", "Esperanto arkaikoa" },
            { "%%BALANKA", "Aniieraren balanka dialektoa" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "Bohoric alfabetoa" },
            { "%%EMODENG", "Ingeles moderno goiztiarra" },
            { "%%FONNAPA", "Fonnapa" },
            { "%%GRCLASS", "Okzitaniera klasikoa" },
            { "%%GRMISTR", "Grmistr" },
            { "%%HEPBURN", "Hepburn erromanizazioa" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%LEMOSIN", "Limousinera" },
            { "%%METELKO", "Metelko alfabetoa" },
            { "%%MONOTON", "Tonu bakarra" },
            { "%%PAHAWH2", "Pahawh2" },
            { "%%PAHAWH3", "Pahawh3" },
            { "%%PAHAWH4", "Pahawh4" },
            { "%%POLYTON", "Tonu anitza" },
            { "%%PROVENC", "Proventzera" },
            { "%%REVISED", "Ortografia berrikusia" },
            { "%%SURSILV", "Sursilv" },
            { "%%SUTSILV", "Sutsilv" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "frantses ertain amaieratik 1606ra" },
            { "%%1694ACAD", "frantses moderno goiztiarra" },
            { "%%1959ACAD", "akademikoa" },
            { "%%BAKU1926", "Turkieraren latindar alfabeto bateratua" },
            { "%%BASICENG", "Oinarrizko ingelesa" },
            { "%%BISCAYAN", "Mendebaldeko euskara" },
            { "%%BORNHOLM", "Bornholmera" },
            { "%%COLB1945", "1945eko Portugal eta Barasilgo ortografia-hitzarmena" },
            { "%%FONKIRSH", "Fonkirsh" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "%%HOGNORSK", "Hognorsk" },
            { "%%HSISTEMO", "Hsistemo" },
            { "%%IJEKAVSK", "Serbiera ijekavieraren ahoskerarekin" },
            { "%%IVANCHOV", "Ivantxov" },
            { "%%JYUTPING", "Jyutping" },
            { "%%KOCIEWIE", "Kociewie" },
            { "%%LENGADOC", "Lengadocera" },
            { "%%LUNA1918", "Luna1918" },
            { "%%NEWFOUND", "TERNUA" },
            { "%%OXENDICT", "Oxfordeko ingeles-hiztegiko ortografia" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "Eskoziar ingeles estandarra" },
            { "%%SPANGLIS", "SPANGLISH" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%SYNNEJYL", "Synnejyl" },
            { "%%TONGYONG", "Tongyong" },
            { "%%TUNUMIIT", "Tunumiit" },
            { "%%VALENCIA", "Valentziera" },
            { "%%VALLADER", "Vallader" },
            { "%%VECDRUKA", "Vecdruka" },
            { "%%VIVARAUP", "Vivaraup" },
            { "%%WADEGILE", "Wade-Giles erromanizazioa" },
            { "%%XSISTEMO", "Xsistemo" },
            { "type.ca.roc", "Minguo egutegia" },
            { "type.co.eor", "Europako ordenatzeko arauak" },
            { "type.hc.h11", "12 orduko sistema (0\u201311)" },
            { "type.hc.h12", "12 orduko sistema (1\u201312)" },
            { "type.hc.h23", "24 orduko sistema (0\u201323)" },
            { "type.hc.h24", "24 orduko sistema (1\u201324)" },
            { "type.m0.bgn", "US BGN transliterazioa" },
            { "type.nu.ahom", "Ahom digituak" },
            { "type.nu.arab", "Digitu arabiar-hindikoak" },
            { "type.nu.armn", "Zenbaki armeniarrak" },
            { "type.nu.bali", "Digitu balitarrak" },
            { "type.nu.beng", "Digitu bengalarrak" },
            { "type.nu.brah", "Brahmi digituak" },
            { "type.nu.cakm", "Txakma digituak" },
            { "type.nu.cham", "Txam digituak" },
            { "type.nu.cyrl", "Zenbaki zirilikoak" },
            { "type.nu.deva", "Digitu devanagariak" },
            { "type.nu.diak", "Dives Akuru digituak" },
            { "type.nu.ethi", "Zenbaki etiopiarrak" },
            { "type.nu.geor", "Zenbaki georgiarrak" },
            { "type.nu.gong", "Gunjala Gondi digituak" },
            { "type.nu.gonm", "Masaram Gondi digituak" },
            { "type.nu.grek", "Zenbaki grekoak" },
            { "type.nu.gujr", "Digitu gujaratarrak" },
            { "type.nu.guru", "Digitu gurmukhiak" },
            { "type.nu.hans", "Zenbaki txinatar sinplifikatuak" },
            { "type.nu.hant", "Zenbaki txinatar tradizionalak" },
            { "type.nu.hebr", "Zenbaki hebrearrak" },
            { "type.nu.hmng", "Pahawh Hmong digituak" },
            { "type.nu.hmnp", "Nyiakeng Puachue Hmong digituak" },
            { "type.nu.java", "Digitu javatarrak" },
            { "type.nu.jpan", "Zenbaki japoniarrak" },
            { "type.nu.kali", "Kayah Li digituak" },
            { "type.nu.kawi", "kawi digituak" },
            { "type.nu.khmr", "Digitu khemerarrak" },
            { "type.nu.knda", "Digitu kannadarrak" },
            { "type.nu.lana", "Tai Tham Hora digituak" },
            { "type.nu.laoo", "Digitu laostarrak" },
            { "type.nu.latn", "Digitu mendebaldarrak" },
            { "type.nu.lepc", "Digitu leptxatarrak" },
            { "type.nu.limb", "Digitu limbutarrak" },
            { "type.nu.mlym", "Digitu malayalamarrak" },
            { "type.nu.modi", "Modi digituak" },
            { "type.nu.mong", "Digitu mongoliarrak" },
            { "type.nu.mroo", "Mro digituak" },
            { "type.nu.mtei", "Meetei Mayek digituak" },
            { "type.nu.mymr", "Digitu birmaniarrak" },
            { "type.nu.nagm", "nag mundari digituak" },
            { "type.nu.nkoo", "N\u2019Ko digituak" },
            { "type.nu.olck", "Ol Chiki digituak" },
            { "type.nu.orya", "Digitu oriyarrak" },
            { "type.nu.osma", "Digitu osmanyarrak" },
            { "type.nu.rohg", "Hanifi digitu rohingyak" },
            { "type.nu.saur", "Digitu saurashtrarrak" },
            { "type.nu.shrd", "Digitu sharadarrak" },
            { "type.nu.sind", "Digitu khudawadiarrak" },
            { "type.nu.sinh", "Sinhala Lith digituak" },
            { "type.nu.sora", "Sora Sompeng digituak" },
            { "type.nu.sund", "Digitu sundadarrak" },
            { "type.nu.takr", "Digitu takriarrak" },
            { "type.nu.talu", "Digitu tai lue berriak" },
            { "type.nu.taml", "Zenbaki tamilar tradizionalak" },
            { "type.nu.telu", "Digitu teluguarrak" },
            { "type.nu.thai", "Digitu thailandiarrak" },
            { "type.nu.tibt", "Digitu tibetarrak" },
            { "type.nu.tirh", "Tirhuta digituak" },
            { "type.nu.tnsa", "tangsar digituak" },
            { "type.nu.vaii", "Vai digituak" },
            { "type.nu.wara", "Warang Citi digituak" },
            { "type.nu.wcho", "Wancho digituak" },
            { "type.ca.dangi", "Dangi egutegia" },
            { "type.co.ducet", "Unicode hurrenkera lehenetsia" },
            { "type.co.emoji", "Emojien hurrenkera" },
            { "type.lb.loose", "Lerro-jauziaren estilo malgua" },
            { "type.nu.roman", "Zenbaki erromatarrak" },
            { "type.ca.coptic", "Egutegi koptoa" },
            { "type.ca.hebrew", "Hebrear egutegia" },
            { "type.ca.indian", "Indiar egutegia" },
            { "type.co.compat", "Aurreko hurrenkera, bateragarria izateko" },
            { "type.co.pinyin", "Pinyin hurrenkera" },
            { "type.co.search", "Bilaketa orokorra" },
            { "type.co.stroke", "Tarteen araberako hurrenkera" },
            { "type.co.unihan", "Radical trazuen hurrenkera" },
            { "type.co.zhuyin", "Zhuyin hurrenkera" },
            { "type.d0.fwidth", "Zabalera osoko karaktere-bihurketa" },
            { "type.d0.hwidth", "Zabalera erdiko karaktere-bihurketa" },
            { "type.lb.normal", "Lerro-jauziaren estilo arrunta" },
            { "type.lb.strict", "Lerro-jauziaren estilo zorrotza" },
            { "type.m0.ungegn", "UN GEGN transliterazioa" },
            { "type.ms.metric", "Sistema metrikoa" },
            { "type.nu.native", "Zenbaki-sistema" },
            { "type.ca.chinese", "Txinatar egutegia" },
            { "type.ca.islamic", "Islamiar egutegia" },
            { "type.ca.iso8601", "ISO-8601 egutegia" },
            { "type.ca.persian", "Egutegi persiarra" },
            { "type.cf.account", "Kontabilitateko moneta-formatua" },
            { "type.co.big5han", "Txinera tradizionalaren alfabetoa-Big5" },
            { "type.d0.npinyin", "Zenbakizko bihurketa" },
            { "type.nu.arabext", "Digitu arabiar-hindiko hedatuak" },
            { "type.nu.armnlow", "Zenbaki armeniarrak minuskulaz" },
            { "type.nu.finance", "Finantza-zenbakiak" },
            { "type.nu.greklow", "Zenbaki grekoak minuskulaz" },
            { "type.nu.hanidec", "Zenbaki hamartar txinatarrak" },
            { "type.nu.hansfin", "Finantzetarako zenbaki txinatar sinplifikatuak" },
            { "type.nu.hantfin", "Finantzetarako zenbaki txinatar tradizionalak" },
            { "type.nu.jpanfin", "Finantzetarako zenbaki japoniarrak" },
            { "type.nu.mathdbl", "Marra bikoitzeko digitu matematikoak" },
            { "type.nu.tamldec", "Digitu tamilarrak" },
            { "type.ca.buddhist", "Egutegi budista" },
            { "type.ca.ethiopic", "Egutegi etiopiarra" },
            { "type.ca.japanese", "Japoniar egutegia" },
            { "type.cf.standard", "Moneta-formatu estandarra" },
            { "type.co.phonetic", "Ordenatzeko irizpide fonetikoa" },
            { "type.co.reformed", "Erreformaren araberako hurrenkera" },
            { "type.co.searchjl", "Bilatu hangularen lehen kontsonantearen arabera" },
            { "type.co.standard", "Ordenatzeko irizpide estandarra" },
            { "type.ms.uksystem", "Neurketa-sistema inperiala" },
            { "type.ms.ussystem", "Neurketa-sistema anglosaxoia" },
            { "type.nu.fullwide", "Zabalera osoko digituak" },
            { "type.nu.lanatham", "Tai Tham Tham digituak" },
            { "type.nu.mathbold", "Digitu matematiko lodiak" },
            { "type.nu.mathmono", "Zuriune bakarreko digitu matematikoak" },
            { "type.nu.mathsanb", "Sans-Serif Bold digitu matematikoak" },
            { "type.nu.mathsans", "Sans-Serif digitu matematikoak" },
            { "type.nu.mymrshan", "Shan digitu birmaniarrak" },
            { "type.nu.mymrtlng", "Tai Laing digitu birmaniarrak" },
            { "type.nu.romanlow", "Zenbaki erromatarrak minuskulaz" },
            { "type.ca.gregorian", "Egutegi gregoriarra" },
            { "type.co.gb2312han", "Txinera sinplifikatuaren alfabetoa -GB2312" },
            { "type.co.phonebook", "Telefonoen zerrenda" },
            { "type.co.dictionary", "Hurrenkera alfabetikoa" },
            { "type.co.traditional", "Tradizionala" },
            { "type.nu.traditional", "Zenbaki tradizionalak" },
            { "type.ca.islamic-rgsa", "Islamiar egutegia (Saudi Arabia, ikuspegiak)" },
            { "type.ca.islamic-tbla", "Islamiar egutegia (taula-formakoa, gai astronomikokoa)" },
            { "type.ca.islamic-civil", "Islamiar egutegia (taula-formakoa, garai zibilekoa)" },
            { "type.ca.islamic-umalqura", "Islamiar egutegia (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem egutegi etiopiarra" },
        };
        return data;
    }
}
