/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_nn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Apia = new String[] {
               "normaltid for Apia",
               "",
               "sommartid for Apia",
               "",
               "tidssone for Apia",
               "",
            };
        final String[] Cook = new String[] {
               "normaltid for Cook\u00f8yane",
               "",
               "sommartid for Cook\u00f8yane",
               "",
               "tidssone for Cook\u00f8yane",
               "",
            };
        final String[] Cuba = new String[] {
               "kubansk normaltid",
               "",
               "kubansk sommartid",
               "",
               "kubansk tid",
               "",
            };
        final String[] Fiji = new String[] {
               "fijiansk normaltid",
               "",
               "fijiansk sommartid",
               "",
               "fijiansk tid",
               "",
            };
        final String[] Hovd = new String[] {
               "normaltid for Khovd",
               "",
               "sommartid for Khovd",
               "",
               "tidssone for Khovd",
               "",
            };
        final String[] Iran = new String[] {
               "iransk normaltid",
               "",
               "iransk sommartid",
               "",
               "iransk tid",
               "",
            };
        final String[] Omsk = new String[] {
               "normaltid for Omsk",
               "",
               "sommartid for Omsk",
               "",
               "tidssone for Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "peruansk normaltid",
               "",
               "peruansk sommartid",
               "",
               "peruansk tid",
               "",
            };
        final String[] Truk = new String[] {
               "tidssone for Chuuk\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "chilensk normaltid",
               "",
               "chilensk sommartid",
               "",
               "chilensk tid",
               "",
            };
        final String[] China = new String[] {
               "kinesisk normaltid",
               "",
               "kinesisk sommartid",
               "",
               "kinesisk tid",
               "",
            };
        final String[] Cocos = new String[] {
               "tidssone for Kokos\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "japansk normaltid",
               "",
               "japansk sommartid",
               "",
               "japansk tid",
               "",
            };
        final String[] Korea = new String[] {
               "koreansk normaltid",
               "",
               "koreansk sommartid",
               "",
               "koreansk tid",
               "",
            };
        final String[] Samoa = new String[] {
               "samoansk normaltid",
               "",
               "samoansk sommartid",
               "",
               "samoansk tid",
               "",
            };
        final String[] Tonga = new String[] {
               "tongansk normaltid",
               "",
               "tongansk sommartid",
               "",
               "tongansk tid",
               "",
            };
        final String[] Alaska = new String[] {
               "alaskisk normaltid",
               "AKST",
               "alaskisk sommartid",
               "AKDT",
               "alaskisk tid",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "normaltid for Amazonas",
               "",
               "sommartid for Amazonas",
               "",
               "tidssone for Amazonas",
               "",
            };
        final String[] Azores = new String[] {
               "asorisk normaltid",
               "",
               "asorisk sommartid",
               "",
               "asorisk tid",
               "",
            };
        final String[] Easter = new String[] {
               "normaltid for P\u00e5ske\u00f8ya",
               "",
               "sommartid for P\u00e5ske\u00f8ya",
               "",
               "tidssone for P\u00e5ske\u00f8ya",
               "",
            };
        final String[] Israel = new String[] {
               "israelsk normaltid",
               "",
               "israelsk sommartid",
               "",
               "israelsk tid",
               "",
            };
        final String[] Moscow = new String[] {
               "normaltid for Moskva",
               "",
               "sommartid for Moskva",
               "",
               "tidssone for Moskva",
               "",
            };
        final String[] Taipei = new String[] {
               "normaltid for Taipei",
               "",
               "sommartid for Taipei",
               "",
               "tidssone for Taipei",
               "",
            };
        final String[] Wallis = new String[] {
               "tidssone for Wallis- og Futuna\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabisk normaltid",
               "",
               "arabisk sommartid",
               "",
               "arabisk tid",
               "",
            };
        final String[] Armenia = new String[] {
               "armensk normaltid",
               "",
               "armensk sommartid",
               "",
               "armensk tid",
               "",
            };
        final String[] Chatham = new String[] {
               "normaltid for Chatham",
               "",
               "sommartid for Chatham",
               "",
               "tidssone for Chatham",
               "",
            };
        final String[] Georgia = new String[] {
               "georgisk normaltid",
               "",
               "georgisk sommartid",
               "",
               "georgisk tid",
               "",
            };
        final String[] Irkutsk = new String[] {
               "normaltid for Irkutsk",
               "",
               "sommartid for Irkutsk",
               "",
               "tidssone for Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "normaltid for Magadan",
               "",
               "sommartid for Magadan",
               "",
               "tidssone for Magadan",
               "",
            };
        final String[] Norfolk = new String[] {
               "normaltid for Norfolk\u00f8ya",
               "",
               "sommartid for Norfolk\u00f8ya",
               "",
               "tidssone for Norfolk\u00f8ya",
               "",
            };
        final String[] Noronha = new String[] {
               "normaltid for Fernando de Noronha",
               "",
               "sommartid for Fernando de Noronha",
               "",
               "tidssone for Fernando de Noronha",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguayansk normaltid",
               "",
               "uruguayansk sommartid",
               "",
               "uruguayansk tid",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatisk normaltid",
               "",
               "vanuatisk sommartid",
               "",
               "vanuatisk tid",
               "",
            };
        final String[] Yakutsk = new String[] {
               "normaltid for Jakutsk",
               "",
               "sommartid for Jakutsk",
               "",
               "tidssone for Jakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "normaltid for den nordamerikanske atlanterhavskysten",
               "AST",
               "sommartid for den nordamerikanske atlanterhavskysten",
               "ADT",
               "tidssone for den nordamerikanske atlanterhavskysten",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "normaltid for Brasilia",
               "",
               "sommartid for Brasilia",
               "",
               "tidssone for Brasilia",
               "",
            };
        final String[] Colombia = new String[] {
               "kolombiansk normaltid",
               "",
               "kolombiansk sommartid",
               "",
               "kolombiansk tid",
               "",
            };
        final String[] Falkland = new String[] {
               "normaltid for Falklands\u00f8yane",
               "",
               "sommartid for Falklands\u00f8yane",
               "",
               "tidssone for Falklands\u00f8yane",
               "",
            };
        final String[] Mongolia = new String[] {
               "normaltid for Ulan Bator",
               "",
               "sommartid for Ulan Bator",
               "",
               "tidssone for Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistansk normaltid",
               "",
               "pakistansk sommartid",
               "",
               "pakistansk tid",
               "",
            };
        final String[] Paraguay = new String[] {
               "paraguayansk normaltid",
               "",
               "paraguayansk sommartid",
               "",
               "paraguayansk tid",
               "",
            };
        final String[] Sakhalin = new String[] {
               "normaltid for Sakhalin",
               "",
               "sommartid for Sakhalin",
               "",
               "tidssone for Sakhalin",
               "",
            };
        final String[] Argentina = new String[] {
               "argentinsk normaltid",
               "",
               "argentinsk sommartid",
               "",
               "argentinsk tid",
               "",
            };
        final String[] Galapagos = new String[] {
               "tidssone for Gal\u00e1pagos\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkongkinesisk normaltid",
               "",
               "hongkongkinesisk sommartid",
               "",
               "hongkongkinesisk tid",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "normaltid for Lord Howe-\u00f8ya",
               "",
               "sommartid for Lord Howe-\u00f8ya",
               "",
               "tidssone for Lord Howe-\u00f8ya",
               "",
            };
        final String[] Marquesas = new String[] {
               "tidssone for Marquesas\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "mauritisk normaltid",
               "",
               "mauritisk sommartid",
               "",
               "mauritisk tid",
               "",
            };
        final String[] Volgograd = new String[] {
               "normaltid for Volgograd",
               "",
               "sommartid for Volgograd",
               "",
               "tidssone for Volgograd",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "aserbajdsjansk normaltid",
               "",
               "aserbajdsjansk sommartid",
               "",
               "aserbajdsjansk tid",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladeshisk normaltid",
               "",
               "bangladeshisk sommartid",
               "",
               "bangladeshisk tid",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kappverdisk normaltid",
               "",
               "kappverdisk sommartid",
               "",
               "kappverdisk tid",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "austtimoresisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "usbekisk normaltid",
               "",
               "usbekisk sommartid",
               "",
               "usbekisk tid",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "normaltid for Krasnojarsk",
               "",
               "sommartid for Krasnojarsk",
               "",
               "tidssone for Krasnojarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "nyzealandsk normaltid",
               "",
               "nyzealandsk sumartid",
               "",
               "nyzealandsk tid",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "normaltid for Novosibirsk",
               "",
               "sommartid for Novosibirsk",
               "",
               "tidssone for Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "filippinsk normaltid",
               "",
               "filippinsk sommartid",
               "",
               "filippinsk tid",
               "",
            };
        final String[] Vladivostok = new String[] {
               "normaltid for Vladivostok",
               "",
               "sommartid for Vladivostok",
               "",
               "tidssone for Vladivostok",
               "",
            };
        final String[] Line_Islands = new String[] {
               "tidssone for Line\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "normaltid for Newfoundland",
               "",
               "sommartid for Newfoundland",
               "",
               "tidssone for Newfoundland",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "turkmensk normaltid",
               "",
               "turkmensk sommartid",
               "",
               "turkmensk tid",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "kaledonsk normaltid",
               "",
               "kaledonsk sommartid",
               "",
               "kaledonsk tid",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "normaltid for Jekaterinburg",
               "",
               "sommartid for Jekaterinburg",
               "",
               "tidssone for Jekaterinburg",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "austafrikansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "vestafrikansk standardtid",
               "",
               "vestafrikansk sommartid",
               "",
               "vestafrikansk tid",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "tidssone for Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "sentraleuropeisk standardtid",
               "CET",
               "sentraleuropeisk sommartid",
               "CEST",
               "sentraleuropeisk tid",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "austeuropeisk standardtid",
               "EET",
               "austeuropeisk sommartid",
               "EEST",
               "austeuropeisk tid",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "vesteuropeisk standardtid",
               "WET",
               "vesteuropeisk sommartid",
               "WEST",
               "vesteuropeisk tid",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "normaltid for den meksikanske stillehavskysten",
               "",
               "sommartid for den meksikanske stillehavskysten",
               "",
               "tidssone for den meksikanske stillehavskysten",
               "",
            };
        final String[] America_Central = new String[] {
               "normaltid for sentrale Nord-Amerika",
               "CST",
               "sommartid for sentrale Nord-Amerika",
               "CDT",
               "tidssone for sentrale Nord-Amerika",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "normaltid for den nordamerikanske austkysten",
               "EST",
               "sommartid for den nordamerikansk austkysten",
               "EDT",
               "tidssone for den nordamerikanske austkysten",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "normaltid for den nordamerikanske stillehavskysten",
               "PST",
               "sommartid for den nordamerikanske stillehavskysten",
               "PDT",
               "tidssone for den nordamerikanske stillehavskysten",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "tidssone for Dei franske s\u00f8rterritoria",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "tidssone for Gilbert\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "normaltid for Hawaii og Aleutene",
               "HAST",
               "sommartid for Hawaii og Aleutene",
               "HADT",
               "tidssone for Hawaii og Aleutene",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "tidssone for Phoenix\u00f8yane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "normaltid for Saint-Pierre-et-Miquelon",
               "",
               "sommartid for Saint-Pierre-et-Miquelon",
               "",
               "tidssone for Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "normaltid for Rocky Mountains (USA)",
               "MST",
               "sommartid for Rocky Mountains (USA)",
               "MDT",
               "tidssone for Rocky Mountains (USA)",
               "MT",
            };
        final String[] Mexico_Northwest = new String[] {
               "normaltid for nordvestlege Mexico",
               "",
               "sommartid for nordvestlege Mexico",
               "",
               "tidssone for nordvestlege Mexico",
               "",
            };
        final String[] Australia_Central = new String[] {
               "sentralaustralsk standardtid",
               "",
               "sentralaustralsk sommartid",
               "",
               "sentralaustralsk tid",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "austaustralsk standardtid",
               "",
               "austaustralsk sommartid",
               "",
               "austaustralsk tid",
               "",
            };
        final String[] Australia_Western = new String[] {
               "vestaustralsk standardtid",
               "",
               "vestaustralsk sommartid",
               "",
               "vestaustralsk tid",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "austgr\u00f8nlandsk normaltid",
               "",
               "austgr\u00f8nlandsk sommartid",
               "",
               "austgr\u00f8nlandsk tid",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "vestgr\u00f8nlandsk normaltid",
               "",
               "vestgr\u00f8nlandsk sommartid",
               "",
               "vestgr\u00f8nlandsk tid",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "austindonesisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "austkasakhstansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "vest-sentralaustralsk standardtid",
               "",
               "vest-sentralaustralsk sommartid",
               "",
               "vest-sentralaustralsk tid",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Riyadh", Arabian },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Pacific/Yap", Truk },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Karachi", Pakistan },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Truk", Truk },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Douala", Africa_Western },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "",
                    "",
                    "irsk sommartid",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "",
                    "",
                    "britisk sommartid",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "",
                    "",
                    "britisk sommartid",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Pacific/Easter", Easter },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Antigua", Atlantic },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Khovd" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Etc/Unknown", "ukjend by" },
            { "timezone.excity.Asia/Rangoon", "Yang\u00f4n" },
            { "timezone.excity.Indian/Cocos", "Kokos\u00f8yane" },
            { "timezone.excity.Asia/Ashgabat", "Asjgabat" },
            { "timezone.excity.Indian/Comoro", "Komorane" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cayman", "Cayman\u00f8yane" },
            { "timezone.excity.America/Cuiaba", "Cuiaba" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Choibalsan", "Tsjojbalsan" },
            { "timezone.excity.Atlantic/Azores", "Asorane" },
            { "timezone.excity.Atlantic/Canary", "Kanari\u00f8yane" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e6r\u00f8yane" },
            { "timezone.excity.Indian/Maldives", "Maldivane" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos\u00f8yane" },
        };
        return data;
    }
}
