import { ServerConnection } from '@jupyterlab/services';
import { ISignal } from '@lumino/signaling';
import { ILanguageServerManager, TLanguageServerConfigurations, TLanguageServerId, TSessionMap, TSpecsMap } from './tokens';
import { ServerSpecProperties } from './schema';
export declare class LanguageServerManager implements ILanguageServerManager {
    constructor(options: ILanguageServerManager.IOptions);
    /**
     * Check if the manager is enabled or disabled
     */
    get isEnabled(): boolean;
    /**
     * Check if the manager is disposed.
     */
    get isDisposed(): boolean;
    /**
     * Get server connection settings.
     */
    get settings(): ServerConnection.ISettings;
    /**
     * Get the language server specs.
     */
    get specs(): TSpecsMap;
    /**
     * Get the status end point.
     */
    get statusUrl(): string;
    /**
     * Signal emitted when a  language server session is changed
     */
    get sessionsChanged(): ISignal<ILanguageServerManager, void>;
    /**
     * Get the map of language server sessions.
     */
    get sessions(): TSessionMap;
    /**
     * A promise resolved when this server manager is ready.
     */
    get ready(): Promise<void>;
    /**
     * Get the status code of server's responses.
     */
    get statusCode(): number;
    /**
     * Enable the language server services
     */
    enable(): Promise<void>;
    /**
     * Disable the language server services
     */
    disable(): void;
    /**
     * Dispose the manager.
     */
    dispose(): void;
    /**
     * Update the language server configuration.
     */
    setConfiguration(configuration: TLanguageServerConfigurations): void;
    /**
     * Get matching language server for input language option.
     */
    getMatchingServers(options: ILanguageServerManager.IGetServerIdOptions): TLanguageServerId[];
    /**
     * Get matching language server spec for input language option.
     */
    getMatchingSpecs(options: ILanguageServerManager.IGetServerIdOptions): TSpecsMap;
    /**
     * Fetch the server session list from the status endpoint. The server
     * manager is ready once this method finishes.
     */
    fetchSessions(): Promise<void>;
    /**
     * Version number of sever session.
     */
    protected version: number;
    /**
     * Check if input language option maths the language server spec.
     */
    protected isMatchingSpec(options: ILanguageServerManager.IGetServerIdOptions, spec: ServerSpecProperties): boolean;
    /**
     * Helper function to warn a message only once.
     */
    protected warnOnce(arg: string): void;
    /**
     * Compare the rank of two servers with the same language.
     */
    protected compareRanks(a: TLanguageServerId, b: TLanguageServerId): number;
    /**
     * map of language server sessions.
     */
    private _sessions;
    /**
     * Map of language server specs.
     */
    private _specs;
    /**
     * Server connection setting.
     */
    private _settings;
    /**
     * Base URL to connect to the language server handler.
     */
    private _baseUrl;
    /**
     * Status code of server response
     */
    private _statusCode;
    /**
     * Number of connection retry, default to 2.
     */
    private _retries;
    /**
     * Interval between each retry, default to 10s.
     */
    private _retriesInterval;
    /**
     * Language server configuration.
     */
    private _configuration;
    /**
     * Set of emitted warning message, message in this set will not be warned again.
     */
    private _warningsEmitted;
    /**
     * A promise resolved when this server manager is ready.
     */
    private _ready;
    /**
     * Signal emitted when a  language server session is changed
     */
    private _sessionsChanged;
    private _isDisposed;
    /**
     * Check if the manager is enabled or disabled
     */
    private _enabled;
}
