import asyncio
import textwrap

from tests.utils import clear_log_text, get_kernel, get_log_text


def test_python_magic() -> None:
    kernel = get_kernel()

    text = "%python imp"
    comp = asyncio.run(kernel.do_complete(text, len(text)))

    assert "import" in comp["matches"]

    helpstr = kernel.get_help_on("%python bin")
    assert "Return the binary representation of an integer" in helpstr, helpstr


def test_python_magic2() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%python retval = 1", None))
    assert "1" in get_log_text(kernel)

    asyncio.run(
        kernel.do_execute(
            textwrap.dedent("""\
    %%python
    def test(a):
        return a + 1
    retval = test(2)"""),
            None,
        )
    )
    assert "3" in get_log_text(kernel)

    asyncio.run(
        kernel.do_execute(
            textwrap.dedent("""\
    %%python
    def test(a):
        return a + 1
    test(2)"""),
            None,
        )
    )
    assert "3" in get_log_text(kernel)


def test_python_magic3() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%%python -e\n1 + 2", None))
    magic = kernel.get_magic("%%python")
    assert magic.retval is None  # type:ignore[attr-defined]

    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%%python\n1 + 2", None))
    magic = kernel.get_magic("%%python")
    assert magic.retval == 3  # type:ignore[attr-defined]

    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%%python\n1 + 2\n2 + 3", None))
    magic = kernel.get_magic("%%python")
    assert magic.retval == 5  # type:ignore[attr-defined]

    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%%python\nretval = 1 + 2\n2 + 3", None))
    magic = kernel.get_magic("%%python")
    assert magic.retval == 3  # type:ignore[attr-defined]

    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%%python\nimport math", None))
    magic = kernel.get_magic("%%python")
    assert magic.retval is None  # type:ignore[attr-defined]


def test_python_magic4() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("?%python", None))
    assert "%python CODE" in get_log_text(kernel)

    clear_log_text(kernel)

    ret = asyncio.run(kernel.do_execute("?%python a", None))
    assert ret["payload"][0]["data"]["text/plain"] == 'No help available for "a"'
    ret = asyncio.run(kernel.do_execute("?%%python a.b", None))
    assert ret["payload"][0]["data"]["text/plain"] == 'No help available for "a.b"'

    ret = asyncio.run(kernel.do_execute("??%%python oct", None))
    assert (
        "Return the octal representation of an integer"
        in ret["payload"][0]["data"]["text/plain"]
    ), ret["payload"][0]["data"]["text/plain"]


def test_python_magic5() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%python print('hello')"))

    assert "hello" in get_log_text(kernel)
