import asyncio
import os

from tests.utils import clear_log_text, get_kernel, get_log_text


def test_cd_magic() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%cd ~"))
    assert os.getcwd() == os.path.expanduser("~"), os.getcwd()
    clear_log_text(kernel)
    asyncio.run(kernel.do_execute("%cd"))
    assert os.getcwd() in get_log_text(kernel)
