/*
 *  RSGISStandardDN2RadianceCalibration.h
 *  RSGIS_LIB
 *
 *  Created by Pete Bunting on 23/05/2011.
 *  Copyright 2011 RSGISLib. All rights reserved.
 *  This file is part of RSGISLib.
 * 
 *  RSGISLib is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  RSGISLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with RSGISLib.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#ifndef RSGISStandardDN2RadianceCalibration_H
#define RSGISStandardDN2RadianceCalibration_H

#include <iostream>
#include <string>

#include "gdal_priv.h"

#include "img/RSGISImageCalcException.h"
#include "img/RSGISCalcImageValue.h"
#include "img/RSGISCalcImage.h"

// mark all exported classes/functions with DllExport to have
// them exported by Visual Studio
#undef DllExport
#ifdef _MSC_VER
    #ifdef rsgis_calib_EXPORTS
        #define DllExport   __declspec( dllexport )
    #else
        #define DllExport   __declspec( dllimport )
    #endif
#else
    #define DllExport
#endif

namespace rsgis{namespace calib{
    
	struct DllExport LandsatRadianceGainsOffsets
    {
        unsigned int band;
        float lMax;
        float lMin;
        float qCalMax;
        float qCalMin;
    };
    
    struct DllExport RSGISSaturatedPixelInfo
    {
        unsigned int band;
        float satVal;
    };
    
    struct DllExport LandsatRadianceGainsOffsetsMultiAdd
    {
        unsigned int band;
        float addVal;
        float multiVal;
    };
    
    struct DllExport SPOTRadianceGainsOffsets
    {
        unsigned int band;
        float bias;
        float gain;
    };
    
    struct DllExport IkonosRadianceGainsOffsets
    {
        std::string bandName;
        unsigned int band;
        float calCoef;
        float bandwidth;
    };
    
    struct DllExport ASTERRadianceGainsOffsets
    {
        std::string bandName;
        unsigned int band;
        float unitConCoef;
    };
    
    struct DllExport IRSRadianceGainsOffsets
    {
        std::string bandName;
        unsigned int band;
        float lMax;
        float lMin;
        float qCalMax;
        float qCalMin;
    };
    
    struct DllExport Quickbird16bitRadianceGainsOffsets
    {
        std::string bandName;
        unsigned int band;
        float calFactor;
        float bandIntegrate;
    };
    
    struct DllExport Quickbird8bitRadianceGainsOffsets
    {
        std::string bandName;
        unsigned int band;
        float calFactor;
        float bandIntegrate;
        float k;
    };
    
    struct DllExport WorldView2RadianceGainsOffsets
    {
        std::string bandName;
        unsigned int band;
        double absCalFact;
        double effBandWidth;
    };
	
	class DllExport RSGISLandsatRadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISLandsatRadianceCalibration(unsigned int numberOutBands, LandsatRadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISLandsatRadianceCalibration(){};
    protected:
        LandsatRadianceGainsOffsets *radGainOff;
    };
    
    class DllExport RSGISLandsatRadianceCalibrationMultiAdd : public rsgis::img::RSGISCalcImageValue
    {
    public:
        RSGISLandsatRadianceCalibrationMultiAdd(unsigned int numberOutBands, LandsatRadianceGainsOffsetsMultiAdd *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISLandsatRadianceCalibrationMultiAdd(){};
    protected:
        LandsatRadianceGainsOffsetsMultiAdd *radGainOff;
    };
    
    class DllExport RSGISSPOTRadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISSPOTRadianceCalibration(unsigned int numberOutBands, SPOTRadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISSPOTRadianceCalibration(){};
    protected:
        SPOTRadianceGainsOffsets *radGainOff;
    };
    
    class DllExport RSGISIkonosRadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISIkonosRadianceCalibration(unsigned int numberOutBands, IkonosRadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISIkonosRadianceCalibration(){};
    protected:
        IkonosRadianceGainsOffsets *radGainOff;
    };
    
    class DllExport RSGISASTERRadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISASTERRadianceCalibration(unsigned int numberOutBands, ASTERRadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISASTERRadianceCalibration(){};
    protected:
        ASTERRadianceGainsOffsets *radGainOff;
    };
    
    class DllExport RSGISIRSRadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISIRSRadianceCalibration(unsigned int numberOutBands, IRSRadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISIRSRadianceCalibration(){};
    protected:
        IRSRadianceGainsOffsets *radGainOff;
    };

	class DllExport RSGISQuickbird16bitRadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISQuickbird16bitRadianceCalibration(unsigned int numberOutBands, Quickbird16bitRadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISQuickbird16bitRadianceCalibration(){};
    protected:
        Quickbird16bitRadianceGainsOffsets *radGainOff;
    };
    
    class DllExport RSGISQuickbird8bitRadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISQuickbird8bitRadianceCalibration(unsigned int numberOutBands, Quickbird8bitRadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISQuickbird8bitRadianceCalibration(){};
    protected:
        Quickbird8bitRadianceGainsOffsets *radGainOff;
    };

    class DllExport RSGISWorldView2RadianceCalibration : public rsgis::img::RSGISCalcImageValue
    {
    public: 
        RSGISWorldView2RadianceCalibration(unsigned int numberOutBands, WorldView2RadianceGainsOffsets *radGainOff):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->radGainOff = radGainOff;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISWorldView2RadianceCalibration(){};
    protected:
        WorldView2RadianceGainsOffsets *radGainOff;
    };

    
    class DllExport RSGISIdentifySaturatePixels : public rsgis::img::RSGISCalcImageValue
    {
    public:
        RSGISIdentifySaturatePixels(unsigned int numberOutBands, RSGISSaturatedPixelInfo *saturatePxlInfo):rsgis::img::RSGISCalcImageValue(numberOutBands)
        {
            this->saturatePxlInfo = saturatePxlInfo;
        };
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISIdentifySaturatePixels(){};
    protected:
        RSGISSaturatedPixelInfo *saturatePxlInfo;
    };

}}

#endif

