
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                    User Interface                     //
//                                                       //
//                    Program: SAGA                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                     DLG_Date.h                        //
//                                                       //
//          Copyright (C) 2025 by Olaf Conrad            //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#ifndef _HEADER_INCLUDED__SAGA_GUI__DLG_Date_H
#define _HEADER_INCLUDED__SAGA_GUI__DLG_Date_H


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include "dlg_base.h"


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CDLG_Date : public CDLG_Base
{
	DECLARE_CLASS(CDLG_Date)

public:
	CDLG_Date(const wxString &Caption, class CSG_DateTime &Date);


protected:

 	class CSG_DateTime			*m_pDate = NULL;

	class wxCalendarCtrl		*m_pControl = NULL;


	virtual void				Save_Changes	(void);

	virtual void				Set_Position	(wxRect r);

	void						On_Now			(wxCommandEvent &event);


	DECLARE_EVENT_TABLE()
};


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
class CDLG_Date_Picker : public wxDialog
{
	DECLARE_CLASS(CDLG_Date_Picker)

public:
	CDLG_Date_Picker(wxWindow *pParent, const wxString &Caption, class CSG_DateTime &Date);


protected:

	class CSG_DateTime			*m_pDate = NULL;

	class wxCalendarCtrl		*m_pControl = NULL;


	virtual void				On_Changed		(class wxCalendarEvent &event);


	DECLARE_EVENT_TABLE()
};


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#endif // #ifndef _HEADER_INCLUDED__SAGA_GUI__DLG_Date_H
