# python

> Python language interpreter.
> More information: <https://docs.python.org/using/cmdline.html>.

- Start a REPL (interactive shell):

`python`

- Execute a specific Python file:

`python {{path/to/file.py}}`

- Execute a specific Python file and start a REPL:

`python -i {{path/to/file.py}}`

- Execute a Python expression:

`python -c "{{expression}}"`

- Run the script of the specified library module:

`python -m {{module}} {{arguments}}`

- Install a package using `pip`:

`python -m pip install {{package}}`

- Interactively debug a Python script:

`python -m pdb {{path/to/file.py}}`

- Start the built-in HTTP server on port 8000 in the current directory:

`python -m http.server`
