;; $D exports one function for each place in the spec where may_leave is
;; guarded to be true and ensures that the call traps before any other guard.
;; Since each trap tears down the instance, a fresh instance of $Tester is
;; created for each export call.
(component definition $Tester
  (component $C
    (core module $CM
      (func (export "import"))
    )
    (core instance $cm (instantiate $CM))
    (func (export "import") (canon lift (core func $cm "import")))
  )
  (component $D
    (import "import" (func $import))

    (core module $Memory (memory (export "mem") 1))
    (core instance $memory (instantiate $Memory))
    (type $R (resource (rep i32)))
    (type $ST (stream u32))
    (type $FT (future u32))
    (canon resource.new $R (core func $resource.new))
    (canon resource.drop $R (core func $resource.drop))
    (canon task.return (core func $task.return))
    (canon task.cancel (core func $task.cancel))
    (canon thread.yield (core func $yield))
    (canon waitable-set.new (core func $waitable-set.new))
    (canon waitable-set.wait (memory $memory "mem") (core func $waitable-set.wait))
    (canon waitable-set.poll (memory $memory "mem") (core func $waitable-set.poll))
    (canon waitable-set.drop (core func $waitable-set.drop))
    (canon waitable.join (core func $waitable.join))
    (canon subtask.cancel (core func $subtask.cancel))
    (canon subtask.drop (core func $subtask.drop))
    (canon stream.new $ST (core func $stream.new))
    (canon stream.read $ST (memory $memory "mem") (core func $stream.read))
    (canon stream.write $ST (memory $memory "mem") (core func $stream.write))
    (canon stream.cancel-read $ST (core func $stream.cancel-read))
    (canon stream.cancel-write $ST (core func $stream.cancel-write))
    (canon stream.drop-readable $ST (core func $stream.drop-readable))
    (canon stream.drop-writable $ST (core func $stream.drop-writable))
    (canon future.new $FT (core func $future.new))
    (canon future.read $FT (memory $memory "mem") (core func $future.read))
    (canon future.write $FT (memory $memory "mem") (core func $future.write))
    (canon future.cancel-read $FT (core func $future.cancel-read))
    (canon future.cancel-write $FT (core func $future.cancel-write))
    (canon future.drop-readable $FT (core func $future.drop-readable))
    (canon future.drop-writable $FT (core func $future.drop-writable))
    (core module $DM
      (import "" "mem" (memory 1))
      (import "" "import" (func $import))
      (import "" "resource.new" (func $resource.new (param i32) (result i32)))
      (import "" "resource.drop" (func $resource.drop (param i32)))
      (import "" "task.return" (func $task.return))
      (import "" "task.cancel" (func $task.cancel))
      (import "" "yield" (func $yield (result i32)))
      (import "" "waitable-set.new" (func $waitable-set.new (result i32)))
      (import "" "waitable-set.wait" (func $waitable-set.wait (param i32 i32) (result i32)))
      (import "" "waitable-set.poll" (func $waitable-set.poll (param i32 i32) (result i32)))
      (import "" "waitable-set.drop" (func $waitable-set.drop (param i32)))
      (import "" "waitable.join" (func $waitable.join (param i32 i32)))
      (import "" "subtask.cancel" (func $subtask.cancel (param i32) (result i32)))
      (import "" "subtask.drop" (func $subtask.drop (param i32)))
      (import "" "stream.new" (func $stream.new (result i64)))
      (import "" "stream.read" (func $stream.read (param i32 i32 i32) (result i32)))
      (import "" "stream.write" (func $stream.write (param i32 i32 i32) (result i32)))
      (import "" "stream.cancel-read" (func $stream.cancel-read (param i32) (result i32)))
      (import "" "stream.cancel-write" (func $stream.cancel-write (param i32) (result i32)))
      (import "" "stream.drop-readable" (func $stream.drop-readable (param i32)))
      (import "" "stream.drop-writable" (func $stream.drop-writable (param i32)))
      (import "" "future.new" (func $future.new (result i64)))
      (import "" "future.read" (func $future.read (param i32 i32) (result i32)))
      (import "" "future.write" (func $future.write (param i32 i32) (result i32)))
      (import "" "future.cancel-read" (func $future.cancel-read (param i32) (result i32)))
      (import "" "future.cancel-write" (func $future.cancel-write (param i32) (result i32)))
      (import "" "future.drop-readable" (func $future.drop-readable (param i32)))
      (import "" "future.drop-writable" (func $future.drop-writable (param i32)))

      (func (export "noop"))
      (func (export "trap-calling-import") (call $import))
      (func (export "trap-calling-resource-new") (drop (call $resource.new (i32.const 0))))
      (func (export "trap-calling-resource-drop") (call $resource.drop (i32.const 0)))
      (func (export "trap-calling-task-return") (call $task.return))
      (func (export "trap-calling-task-cancel") (call $task.cancel))
      (func (export "trap-calling-yield") (drop (call $yield)))
      (func (export "trap-calling-waitable-set-new") (drop (call $waitable-set.new)))
      (func (export "trap-calling-waitable-set-wait") (drop (call $waitable-set.wait (i32.const 0) (i32.const 0))))
      (func (export "trap-calling-waitable-set-poll") (drop (call $waitable-set.poll (i32.const 0) (i32.const 0))))
      (func (export "trap-calling-waitable-set-drop") (call $waitable-set.drop (i32.const 0)))
      (func (export "trap-calling-waitable-join") (call $waitable.join (i32.const 0) (i32.const 0)))
      (func (export "trap-calling-subtask-cancel") (drop (call $subtask.cancel (i32.const 0))))
      (func (export "trap-calling-subtask-drop") (call $subtask.drop (i32.const 0)))
      (func (export "trap-calling-stream-new") (drop (call $stream.new)))
      (func (export "trap-calling-stream-read") (drop (call $stream.read (i32.const 0) (i32.const 0) (i32.const 0))))
      (func (export "trap-calling-stream-write") (drop (call $stream.write (i32.const 0) (i32.const 0) (i32.const 0))))
      (func (export "trap-calling-stream-cancel-read") (drop (call $stream.cancel-read (i32.const 0))))
      (func (export "trap-calling-stream-cancel-write") (drop (call $stream.cancel-write (i32.const 0))))
      (func (export "trap-calling-stream-drop-readable") (call $stream.drop-readable (i32.const 0)))
      (func (export "trap-calling-stream-drop-writable") (call $stream.drop-writable (i32.const 0)))
      (func (export "trap-calling-future-new") (drop (call $future.new)))
      (func (export "trap-calling-future-read") (drop (call $future.read (i32.const 0) (i32.const 0))))
      (func (export "trap-calling-future-write") (drop (call $future.write (i32.const 0) (i32.const 0))))
      (func (export "trap-calling-future-cancel-read") (drop (call $future.cancel-read (i32.const 0))))
      (func (export "trap-calling-future-cancel-write") (drop (call $future.cancel-write (i32.const 0))))
      (func (export "trap-calling-future-drop-readable") (call $future.drop-readable (i32.const 0)))
      (func (export "trap-calling-future-drop-writable") (call $future.drop-writable (i32.const 0)))
    )
    (canon lower (func $import) (core func $import'))
    (core instance $dm (instantiate $DM (with "" (instance
      (export "mem" (memory $memory "mem"))
      (export "import" (func $import'))
      (export "resource.new" (func $resource.new))
      (export "resource.drop" (func $resource.drop))
      (export "task.return" (func $task.return))
      (export "task.cancel" (func $task.cancel))
      (export "yield" (func $yield))
      (export "waitable-set.new" (func $waitable-set.new))
      (export "waitable-set.wait" (func $waitable-set.wait))
      (export "waitable-set.poll" (func $waitable-set.poll))
      (export "waitable-set.drop" (func $waitable-set.drop))
      (export "waitable.join" (func $waitable.join))
      (export "subtask.cancel" (func $subtask.cancel))
      (export "subtask.drop" (func $subtask.drop))
      (export "stream.new" (func $stream.new))
      (export "stream.read" (func $stream.read))
      (export "stream.write" (func $stream.write))
      (export "stream.cancel-read" (func $stream.cancel-read))
      (export "stream.cancel-write" (func $stream.cancel-write))
      (export "stream.drop-readable" (func $stream.drop-readable))
      (export "stream.drop-writable" (func $stream.drop-writable))
      (export "future.new" (func $future.new))
      (export "future.read" (func $future.read))
      (export "future.write" (func $future.write))
      (export "future.cancel-read" (func $future.cancel-read))
      (export "future.cancel-write" (func $future.cancel-write))
      (export "future.drop-readable" (func $future.drop-readable))
      (export "future.drop-writable" (func $future.drop-writable))
    ))))
    (func (export "trap-calling-import") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-import"))))
    (func (export "trap-calling-resource-new") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-resource-new"))))
    (func (export "trap-calling-resource-drop") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-resource-drop"))))
    (func (export "trap-calling-task-return") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-task-return"))))
    (func (export "trap-calling-task-cancel") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-task-cancel"))))
    (func (export "trap-calling-yield") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-yield"))))
    (func (export "trap-calling-waitable-set-new") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-waitable-set-new"))))
    (func (export "trap-calling-waitable-set-wait") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-waitable-set-wait"))))
    (func (export "trap-calling-waitable-set-poll") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-waitable-set-poll"))))
    (func (export "trap-calling-waitable-set-drop") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-waitable-set-drop"))))
    (func (export "trap-calling-waitable-join") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-waitable-join"))))
    (func (export "trap-calling-subtask-cancel") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-subtask-cancel"))))
    (func (export "trap-calling-subtask-drop") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-subtask-drop"))))
    (func (export "trap-calling-stream-new") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-stream-new"))))
    (func (export "trap-calling-stream-read") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-stream-read"))))
    (func (export "trap-calling-stream-write") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-stream-write"))))
    (func (export "trap-calling-stream-cancel-read") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-stream-cancel-read"))))
    (func (export "trap-calling-stream-cancel-write") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-stream-cancel-write"))))
    (func (export "trap-calling-stream-drop-readable") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-stream-drop-readable"))))
    (func (export "trap-calling-stream-drop-writable") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-stream-drop-writable"))))
    (func (export "trap-calling-future-new") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-future-new"))))
    (func (export "trap-calling-future-read") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-future-read"))))
    (func (export "trap-calling-future-write") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-future-write"))))
    (func (export "trap-calling-future-cancel-read") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-future-cancel-read"))))
    (func (export "trap-calling-future-cancel-write") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-future-cancel-write"))))
    (func (export "trap-calling-future-drop-readable") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-future-drop-readable"))))
    (func (export "trap-calling-future-drop-writable") (canon lift (core func $dm "noop") (post-return (func $dm "trap-calling-future-drop-writable"))))
  )
  (instance $c (instantiate $C))
  (instance $d (instantiate $D (with "import" (func $c "import"))))
  (func (export "trap-calling-import") (alias export $d "trap-calling-import"))
  (func (export "trap-calling-resource-new") (alias export $d "trap-calling-resource-new"))
  (func (export "trap-calling-resource-drop") (alias export $d "trap-calling-resource-drop"))
  (func (export "trap-calling-task-return") (alias export $d "trap-calling-task-return"))
  (func (export "trap-calling-task-cancel") (alias export $d "trap-calling-task-cancel"))
  (func (export "trap-calling-yield") (alias export $d "trap-calling-yield"))
  (func (export "trap-calling-waitable-set-new") (alias export $d "trap-calling-waitable-set-new"))
  (func (export "trap-calling-waitable-set-wait") (alias export $d "trap-calling-waitable-set-wait"))
  (func (export "trap-calling-waitable-set-poll") (alias export $d "trap-calling-waitable-set-poll"))
  (func (export "trap-calling-waitable-set-drop") (alias export $d "trap-calling-waitable-set-drop"))
  (func (export "trap-calling-waitable-join") (alias export $d "trap-calling-waitable-join"))
  (func (export "trap-calling-subtask-cancel") (alias export $d "trap-calling-subtask-cancel"))
  (func (export "trap-calling-subtask-drop") (alias export $d "trap-calling-subtask-drop"))
  (func (export "trap-calling-stream-new") (alias export $d "trap-calling-stream-new"))
  (func (export "trap-calling-stream-read") (alias export $d "trap-calling-stream-read"))
  (func (export "trap-calling-stream-write") (alias export $d "trap-calling-stream-write"))
  (func (export "trap-calling-stream-cancel-read") (alias export $d "trap-calling-stream-cancel-read"))
  (func (export "trap-calling-stream-cancel-write") (alias export $d "trap-calling-stream-cancel-write"))
  (func (export "trap-calling-stream-drop-readable") (alias export $d "trap-calling-stream-drop-readable"))
  (func (export "trap-calling-stream-drop-writable") (alias export $d "trap-calling-stream-drop-writable"))
  (func (export "trap-calling-future-new") (alias export $d "trap-calling-future-new"))
  (func (export "trap-calling-future-read") (alias export $d "trap-calling-future-read"))
  (func (export "trap-calling-future-write") (alias export $d "trap-calling-future-write"))
  (func (export "trap-calling-future-cancel-read") (alias export $d "trap-calling-future-cancel-read"))
  (func (export "trap-calling-future-cancel-write") (alias export $d "trap-calling-future-cancel-write"))
  (func (export "trap-calling-future-drop-readable") (alias export $d "trap-calling-future-drop-readable"))
  (func (export "trap-calling-future-drop-writable") (alias export $d "trap-calling-future-drop-writable"))
)

(component instance $i1 $Tester)
(assert_trap (invoke "trap-calling-import") "cannot leave component instance")
(component instance $i2 $Tester)
(assert_trap (invoke "trap-calling-resource-new") "cannot leave component instance")
(component instance $i3 $Tester)
(assert_trap (invoke "trap-calling-resource-drop") "cannot leave component instance")
(component instance $i4 $Tester)
(assert_trap (invoke "trap-calling-task-return") "cannot leave component instance")
(component instance $i5 $Tester)
(assert_trap (invoke "trap-calling-task-cancel") "cannot leave component instance")
(component instance $i6 $Tester)
(assert_trap (invoke "trap-calling-yield") "cannot leave component instance")
(component instance $i7 $Tester)
(assert_trap (invoke "trap-calling-waitable-set-new") "cannot leave component instance")
(component instance $i8 $Tester)
(assert_trap (invoke "trap-calling-waitable-set-wait") "cannot leave component instance")
(component instance $i9 $Tester)
(assert_trap (invoke "trap-calling-waitable-set-poll") "cannot leave component instance")
(component instance $i10 $Tester)
(assert_trap (invoke "trap-calling-waitable-set-drop") "cannot leave component instance")
(component instance $i11 $Tester)
(assert_trap (invoke "trap-calling-waitable-join") "cannot leave component instance")
(component instance $i12 $Tester)
(assert_trap (invoke "trap-calling-subtask-cancel") "cannot leave component instance")
(component instance $i13 $Tester)
(assert_trap (invoke "trap-calling-subtask-drop") "cannot leave component instance")
(component instance $i14 $Tester)
(assert_trap (invoke "trap-calling-stream-new") "cannot leave component instance")
(component instance $i15 $Tester)
(assert_trap (invoke "trap-calling-stream-read") "cannot leave component instance")
(component instance $i16 $Tester)
(assert_trap (invoke "trap-calling-stream-write") "cannot leave component instance")
(component instance $i17 $Tester)
(assert_trap (invoke "trap-calling-stream-cancel-read") "cannot leave component instance")
(component instance $i18 $Tester)
(assert_trap (invoke "trap-calling-stream-cancel-write") "cannot leave component instance")
(component instance $i19 $Tester)
(assert_trap (invoke "trap-calling-stream-drop-readable") "cannot leave component instance")
(component instance $i20 $Tester)
(assert_trap (invoke "trap-calling-stream-drop-writable") "cannot leave component instance")
(component instance $i21 $Tester)
(assert_trap (invoke "trap-calling-future-new") "cannot leave component instance")
(component instance $i22 $Tester)
(assert_trap (invoke "trap-calling-future-read") "cannot leave component instance")
(component instance $i23 $Tester)
(assert_trap (invoke "trap-calling-future-write") "cannot leave component instance")
(component instance $i24 $Tester)
(assert_trap (invoke "trap-calling-future-cancel-read") "cannot leave component instance")
(component instance $i25 $Tester)
(assert_trap (invoke "trap-calling-future-cancel-write") "cannot leave component instance")
(component instance $i26 $Tester)
(assert_trap (invoke "trap-calling-future-drop-readable") "cannot leave component instance")
(component instance $i27 $Tester)
(assert_trap (invoke "trap-calling-future-drop-writable") "cannot leave component instance")
