/* automatically generated by rust-bindgen 0.72.0 */

#[repr(i32)]
#[doc = " @enum ov_status_e\n @ingroup ov_base_c_api\n @brief This enum contains codes for all possible return values of the interface functions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ov_status_e {
    #[doc = "!< SUCCESS"]
    OK = 0,
    #[doc = "!< GENERAL_ERROR"]
    GENERAL_ERROR = -1,
    #[doc = "!< NOT_IMPLEMENTED"]
    NOT_IMPLEMENTED = -2,
    #[doc = "!< NETWORK_NOT_LOADED"]
    NETWORK_NOT_LOADED = -3,
    #[doc = "!< PARAMETER_MISMATCH"]
    PARAMETER_MISMATCH = -4,
    #[doc = "!< NOT_FOUND"]
    NOT_FOUND = -5,
    #[doc = "!< OUT_OF_BOUNDS"]
    OUT_OF_BOUNDS = -6,
    #[doc = "!< UNEXPECTED"]
    UNEXPECTED = -7,
    #[doc = "!< REQUEST_BUSY"]
    REQUEST_BUSY = -8,
    #[doc = "!< RESULT_NOT_READY"]
    RESULT_NOT_READY = -9,
    #[doc = "!< NOT_ALLOCATED"]
    NOT_ALLOCATED = -10,
    #[doc = "!< INFER_NOT_STARTED"]
    INFER_NOT_STARTED = -11,
    #[doc = "!< NETWORK_NOT_READ"]
    NETWORK_NOT_READ = -12,
    #[doc = "!< INFER_CANCELLED"]
    INFER_CANCELLED = -13,
    #[doc = "!< INVALID_C_PARAM"]
    INVALID_C_PARAM = -14,
    #[doc = "!< UNKNOWN_C_ERROR"]
    UNKNOWN_C_ERROR = -15,
    #[doc = "!< NOT_IMPLEMENT_C_METHOD"]
    NOT_IMPLEMENT_C_METHOD = -16,
    #[doc = "!< UNKNOW_EXCEPTION"]
    UNKNOW_EXCEPTION = -17,
}
impl ov_element_type_e {
    pub const DYNAMIC: ov_element_type_e = ov_element_type_e::UNDEFINED;
}
#[repr(u32)]
#[doc = " @enum ov_element_type_e\n @ingroup ov_base_c_api\n @brief This enum contains codes for element type, which is aligned with ov::element::Type_t in\n src/core/include/openvino/core/type/element_type.hpp"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ov_element_type_e {
    #[doc = "!< Undefined element type"]
    UNDEFINED = 0,
    #[doc = "!< boolean element type"]
    OV_BOOLEAN = 1,
    #[doc = "!< bf16 element type"]
    BF16 = 2,
    #[doc = "!< f16 element type"]
    F16 = 3,
    #[doc = "!< f32 element type"]
    F32 = 4,
    #[doc = "!< f64 element type"]
    F64 = 5,
    #[doc = "!< i4 element type"]
    I4 = 6,
    #[doc = "!< i8 element type"]
    I8 = 7,
    #[doc = "!< i16 element type"]
    I16 = 8,
    #[doc = "!< i32 element type"]
    I32 = 9,
    #[doc = "!< i64 element type"]
    I64 = 10,
    #[doc = "!< binary element type"]
    U1 = 11,
    #[doc = "!< u2 element type"]
    U2 = 12,
    #[doc = "!< u3 element type"]
    U3 = 13,
    #[doc = "!< u4 element type"]
    U4 = 14,
    #[doc = "!< u6 element type"]
    U6 = 15,
    #[doc = "!< u8 element type"]
    U8 = 16,
    #[doc = "!< u16 element type"]
    U16 = 17,
    #[doc = "!< u32 element type"]
    U32 = 18,
    #[doc = "!< u64 element type"]
    U64 = 19,
    #[doc = "!< nf4 element type"]
    NF4 = 20,
    #[doc = "!< f8e4m3 element type"]
    F8E4M3 = 21,
    #[doc = "!< f8e5m2 element type"]
    F8E5M3 = 22,
    #[doc = "!< string element type"]
    STRING = 23,
    #[doc = "!< f4e2m1 element type"]
    F4E2M1 = 24,
    #[doc = "!< f8e8m0 element type"]
    F8E8M0 = 25,
}
#[doc = " @brief encryption_func is a function pointer that encrypt or decrypt the input memory, example of this function is\n codec(const char* input, const size_t in_size, const char* output, size_t* out_size)\n This function needs to be called twice,\n the first call to obtain out_size (the size of output buffer), the second call to obtain output buffer.\n The first call output is nullptr, before the second call, the caller needs to apply for output\n memory based on the out_size returned by the first call.\n the memory of parameter output is allocated and released by the caller.\n @param input The pointer to the input buffer.\n @param in_size The size of input.\n @param output The pointer to the encrypted/decrypted buffer.\n @param out_size The size of output."]
pub type encryption_func = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_char,
        arg2: usize,
        arg3: *mut ::std::os::raw::c_char,
        arg4: *mut usize,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_encryption_callbacks {
    pub encrypt_func: encryption_func,
    pub decrypt_func: encryption_func,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_encryption_callbacks"][::std::mem::size_of::<ov_encryption_callbacks>() - 16usize];
    ["Alignment of ov_encryption_callbacks"]
        [::std::mem::align_of::<ov_encryption_callbacks>() - 8usize];
    ["Offset of field: ov_encryption_callbacks::encrypt_func"]
        [::std::mem::offset_of!(ov_encryption_callbacks, encrypt_func) - 0usize];
    ["Offset of field: ov_encryption_callbacks::decrypt_func"]
        [::std::mem::offset_of!(ov_encryption_callbacks, decrypt_func) - 8usize];
};
#[doc = " @struct ov_dimension\n @ingroup ov_dimension_c_api\n @brief This is a structure interface equal to ov::Dimension"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_dimension {
    #[doc = "!< The lower inclusive limit for the dimension."]
    pub min: i64,
    #[doc = "!< The upper inclusive limit for the dimension."]
    pub max: i64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_dimension"][::std::mem::size_of::<ov_dimension>() - 16usize];
    ["Alignment of ov_dimension"][::std::mem::align_of::<ov_dimension>() - 8usize];
    ["Offset of field: ov_dimension::min"][::std::mem::offset_of!(ov_dimension, min) - 0usize];
    ["Offset of field: ov_dimension::max"][::std::mem::offset_of!(ov_dimension, max) - 8usize];
};
#[doc = " @struct ov_dimension\n @ingroup ov_dimension_c_api\n @brief This is a structure interface equal to ov::Dimension"]
pub type ov_dimension_t = ov_dimension;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_layout {
    _unused: [u8; 0],
}
#[doc = " @struct ov_layout_t\n @ingroup ov_layout_c_api\n @brief type define ov_layout_t from ov_layout"]
pub type ov_layout_t = ov_layout;
#[doc = " @struct ov_rank_t\n @ingroup ov_rank_c_api\n @brief type define ov_rank_t from ov_dimension_t"]
pub type ov_rank_t = ov_dimension_t;
#[doc = " @struct ov_shape_t\n @ingroup ov_shape_c_api\n @brief Reprents a static shape."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_shape_t {
    #[doc = "!< the rank of shape"]
    pub rank: i64,
    #[doc = "!< the dims of shape"]
    pub dims: *mut i64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_shape_t"][::std::mem::size_of::<ov_shape_t>() - 16usize];
    ["Alignment of ov_shape_t"][::std::mem::align_of::<ov_shape_t>() - 8usize];
    ["Offset of field: ov_shape_t::rank"][::std::mem::offset_of!(ov_shape_t, rank) - 0usize];
    ["Offset of field: ov_shape_t::dims"][::std::mem::offset_of!(ov_shape_t, dims) - 8usize];
};
#[doc = " @struct ov_partial_shape\n @ingroup ov_partial_shape_c_api\n @brief It represents a shape that may be partially or totally dynamic.\n A PartialShape may have:\n Dynamic rank. (Informal notation: `?`)\n Static rank, but dynamic dimensions on some or all axes.\n     (Informal notation examples: `{1,2,?,4}`, `{?,?,?}`, `{-1,-1,-1}`)\n Static rank, and static dimensions on all axes.\n     (Informal notation examples: `{1,2,3,4}`, `{6}`, `{}`)\n\n An interface to make user can initialize ov_partial_shape_t"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_partial_shape {
    #[doc = "!< The rank"]
    pub rank: ov_rank_t,
    #[doc = "!< The dimension"]
    pub dims: *mut ov_dimension_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_partial_shape"][::std::mem::size_of::<ov_partial_shape>() - 24usize];
    ["Alignment of ov_partial_shape"][::std::mem::align_of::<ov_partial_shape>() - 8usize];
    ["Offset of field: ov_partial_shape::rank"]
        [::std::mem::offset_of!(ov_partial_shape, rank) - 0usize];
    ["Offset of field: ov_partial_shape::dims"]
        [::std::mem::offset_of!(ov_partial_shape, dims) - 16usize];
};
#[doc = " @struct ov_partial_shape\n @ingroup ov_partial_shape_c_api\n @brief It represents a shape that may be partially or totally dynamic.\n A PartialShape may have:\n Dynamic rank. (Informal notation: `?`)\n Static rank, but dynamic dimensions on some or all axes.\n     (Informal notation examples: `{1,2,?,4}`, `{?,?,?}`, `{-1,-1,-1}`)\n Static rank, and static dimensions on all axes.\n     (Informal notation examples: `{1,2,3,4}`, `{6}`, `{}`)\n\n An interface to make user can initialize ov_partial_shape_t"]
pub type ov_partial_shape_t = ov_partial_shape;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_output_const_port {
    _unused: [u8; 0],
}
#[doc = " @struct ov_output_const_port_t\n @ingroup ov_node_c_api\n @brief type define ov_output_const_port_t from ov_output_const_port"]
pub type ov_output_const_port_t = ov_output_const_port;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_output_port {
    _unused: [u8; 0],
}
#[doc = " @struct ov_output_port_t\n @ingroup ov_node_c_api\n @brief type define ov_output_port_t from ov_output_port"]
pub type ov_output_port_t = ov_output_port;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_tensor {
    _unused: [u8; 0],
}
#[doc = " @struct ov_tensor_t\n @ingroup ov_tensor_c_api\n @brief type define ov_tensor_t from ov_tensor"]
pub type ov_tensor_t = ov_tensor;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_infer_request {
    _unused: [u8; 0],
}
#[doc = " @struct ov_infer_request_t\n @ingroup ov_infer_request_c_api\n @brief type define ov_infer_request_t from ov_infer_request"]
pub type ov_infer_request_t = ov_infer_request;
#[doc = " @struct ov_callback_t\n @ingroup ov_infer_request_c_api\n @brief Completion callback definition about the function and args"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_callback_t {
    #[doc = "!< The callback func"]
    pub callback_func:
        ::std::option::Option<unsafe extern "C" fn(args: *mut ::std::os::raw::c_void)>,
    #[doc = "!< The args of callback func"]
    pub args: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_callback_t"][::std::mem::size_of::<ov_callback_t>() - 16usize];
    ["Alignment of ov_callback_t"][::std::mem::align_of::<ov_callback_t>() - 8usize];
    ["Offset of field: ov_callback_t::callback_func"]
        [::std::mem::offset_of!(ov_callback_t, callback_func) - 0usize];
    ["Offset of field: ov_callback_t::args"][::std::mem::offset_of!(ov_callback_t, args) - 8usize];
};
#[doc = " @struct ov_ProfilingInfo_t\n @ingroup ov_infer_request_c_api\n @brief Store profiling info data"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_profiling_info_t {
    #[doc = "!< status"]
    pub status: ov_profiling_info_t_Status,
    #[doc = "!< The absolute time, in microseconds, that the node ran (in total)."]
    pub real_time: i64,
    #[doc = "!< The net host CPU time that the node ran."]
    pub cpu_time: i64,
    #[doc = "!< Name of a node."]
    pub node_name: *const ::std::os::raw::c_char,
    #[doc = "!< Execution type of a unit."]
    pub exec_type: *const ::std::os::raw::c_char,
    #[doc = "!< Node type."]
    pub node_type: *const ::std::os::raw::c_char,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ov_profiling_info_t_Status {
    #[doc = "!< A node is not executed."]
    NOT_RUN = 0,
    #[doc = "!< A node is optimized out during graph optimization phase."]
    OPTIMIZED_OUT = 1,
    #[doc = "!< A node is executed."]
    EXECUTED = 2,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_profiling_info_t"][::std::mem::size_of::<ov_profiling_info_t>() - 48usize];
    ["Alignment of ov_profiling_info_t"][::std::mem::align_of::<ov_profiling_info_t>() - 8usize];
    ["Offset of field: ov_profiling_info_t::status"]
        [::std::mem::offset_of!(ov_profiling_info_t, status) - 0usize];
    ["Offset of field: ov_profiling_info_t::real_time"]
        [::std::mem::offset_of!(ov_profiling_info_t, real_time) - 8usize];
    ["Offset of field: ov_profiling_info_t::cpu_time"]
        [::std::mem::offset_of!(ov_profiling_info_t, cpu_time) - 16usize];
    ["Offset of field: ov_profiling_info_t::node_name"]
        [::std::mem::offset_of!(ov_profiling_info_t, node_name) - 24usize];
    ["Offset of field: ov_profiling_info_t::exec_type"]
        [::std::mem::offset_of!(ov_profiling_info_t, exec_type) - 32usize];
    ["Offset of field: ov_profiling_info_t::node_type"]
        [::std::mem::offset_of!(ov_profiling_info_t, node_type) - 40usize];
};
#[doc = " @struct ov_profiling_info_list_t\n @ingroup ov_infer_request_c_api\n @brief A list of profiling info data"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_profiling_info_list_t {
    #[doc = "!< The list of ov_profilling_info_t"]
    pub profiling_infos: *mut ov_profiling_info_t,
    #[doc = "!< The list size"]
    pub size: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_profiling_info_list_t"]
        [::std::mem::size_of::<ov_profiling_info_list_t>() - 16usize];
    ["Alignment of ov_profiling_info_list_t"]
        [::std::mem::align_of::<ov_profiling_info_list_t>() - 8usize];
    ["Offset of field: ov_profiling_info_list_t::profiling_infos"]
        [::std::mem::offset_of!(ov_profiling_info_list_t, profiling_infos) - 0usize];
    ["Offset of field: ov_profiling_info_list_t::size"]
        [::std::mem::offset_of!(ov_profiling_info_list_t, size) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_model {
    _unused: [u8; 0],
}
#[doc = " @struct ov_model_t\n @ingroup ov_model_c_api\n @brief type define ov_model_t from ov_model"]
pub type ov_model_t = ov_model;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_remote_context {
    _unused: [u8; 0],
}
pub type ov_remote_context_t = ov_remote_context;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_compiled_model {
    _unused: [u8; 0],
}
#[doc = " @struct ov_compiled_model_t\n @ingroup ov_compiled_model_c_api\n @brief type define ov_compiled_model_t from ov_compiled_model"]
pub type ov_compiled_model_t = ov_compiled_model;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_core {
    _unused: [u8; 0],
}
#[doc = " @struct ov_core_t\n @ingroup ov_core_c_api\n @brief type define ov_core_t from ov_core"]
pub type ov_core_t = ov_core;
#[doc = " @struct ov_version\n @ingroup ov_core_c_api\n @brief Represents OpenVINO version information"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_version {
    #[doc = "!< A string representing OpenVINO version"]
    pub buildNumber: *const ::std::os::raw::c_char,
    #[doc = "!< A string representing OpenVINO description"]
    pub description: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_version"][::std::mem::size_of::<ov_version>() - 16usize];
    ["Alignment of ov_version"][::std::mem::align_of::<ov_version>() - 8usize];
    ["Offset of field: ov_version::buildNumber"]
        [::std::mem::offset_of!(ov_version, buildNumber) - 0usize];
    ["Offset of field: ov_version::description"]
        [::std::mem::offset_of!(ov_version, description) - 8usize];
};
#[doc = " @struct ov_version\n @ingroup ov_core_c_api\n @brief Represents OpenVINO version information"]
pub type ov_version_t = ov_version;
#[doc = " @struct ov_core_version\n @ingroup ov_core_c_api\n @brief  Represents version information that describes device and ov runtime library"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_core_version_t {
    #[doc = "!< A device name"]
    pub device_name: *const ::std::os::raw::c_char,
    #[doc = "!< Version"]
    pub version: ov_version_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_core_version_t"][::std::mem::size_of::<ov_core_version_t>() - 24usize];
    ["Alignment of ov_core_version_t"][::std::mem::align_of::<ov_core_version_t>() - 8usize];
    ["Offset of field: ov_core_version_t::device_name"]
        [::std::mem::offset_of!(ov_core_version_t, device_name) - 0usize];
    ["Offset of field: ov_core_version_t::version"]
        [::std::mem::offset_of!(ov_core_version_t, version) - 8usize];
};
#[doc = " @struct ov_core_version_list\n @ingroup ov_core_c_api\n @brief  Represents version information that describes all devices and ov runtime library"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_core_version_list_t {
    #[doc = "!< An array of device versions"]
    pub versions: *mut ov_core_version_t,
    #[doc = "!< A number of versions in the array"]
    pub size: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_core_version_list_t"][::std::mem::size_of::<ov_core_version_list_t>() - 16usize];
    ["Alignment of ov_core_version_list_t"]
        [::std::mem::align_of::<ov_core_version_list_t>() - 8usize];
    ["Offset of field: ov_core_version_list_t::versions"]
        [::std::mem::offset_of!(ov_core_version_list_t, versions) - 0usize];
    ["Offset of field: ov_core_version_list_t::size"]
        [::std::mem::offset_of!(ov_core_version_list_t, size) - 8usize];
};
#[doc = " @struct ov_available_devices_t\n @ingroup ov_core_c_api\n @brief Represent all available devices."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_available_devices_t {
    #[doc = "!< devices' name"]
    pub devices: *mut *mut ::std::os::raw::c_char,
    #[doc = "!< devices' number"]
    pub size: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of ov_available_devices_t"][::std::mem::size_of::<ov_available_devices_t>() - 16usize];
    ["Alignment of ov_available_devices_t"]
        [::std::mem::align_of::<ov_available_devices_t>() - 8usize];
    ["Offset of field: ov_available_devices_t::devices"]
        [::std::mem::offset_of!(ov_available_devices_t, devices) - 0usize];
    ["Offset of field: ov_available_devices_t::size"]
        [::std::mem::offset_of!(ov_available_devices_t, size) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_preprocess_prepostprocessor {
    _unused: [u8; 0],
}
#[doc = " @struct ov_preprocess_prepostprocessor_t\n @ingroup ov_prepostprocess_c_api\n @brief type define ov_preprocess_prepostprocessor_t from ov_preprocess_prepostprocessor"]
pub type ov_preprocess_prepostprocessor_t = ov_preprocess_prepostprocessor;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_preprocess_input_info {
    _unused: [u8; 0],
}
#[doc = " @struct ov_preprocess_input_info_t\n @ingroup ov_prepostprocess_c_api\n @brief type define ov_preprocess_input_info_t from ov_preprocess_input_info"]
pub type ov_preprocess_input_info_t = ov_preprocess_input_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_preprocess_input_tensor_info {
    _unused: [u8; 0],
}
#[doc = " @struct ov_preprocess_input_tensor_info_t\n @ingroup ov_prepostprocess_c_api\n @brief type define ov_preprocess_input_tensor_info_t from ov_preprocess_input_tensor_info"]
pub type ov_preprocess_input_tensor_info_t = ov_preprocess_input_tensor_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_preprocess_output_info {
    _unused: [u8; 0],
}
#[doc = " @struct ov_preprocess_output_info_t\n @ingroup ov_prepostprocess_c_api\n @brief type define ov_preprocess_output_info_t from ov_preprocess_output_info"]
pub type ov_preprocess_output_info_t = ov_preprocess_output_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_preprocess_output_tensor_info {
    _unused: [u8; 0],
}
#[doc = " @struct ov_preprocess_output_tensor_info_t\n @ingroup ov_prepostprocess_c_api\n @brief type define ov_preprocess_output_tensor_info_t from ov_preprocess_output_tensor_info"]
pub type ov_preprocess_output_tensor_info_t = ov_preprocess_output_tensor_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_preprocess_input_model_info {
    _unused: [u8; 0],
}
#[doc = " @struct ov_preprocess_input_model_info_t\n @ingroup ov_prepostprocess_c_api\n @brief type define ov_preprocess_input_model_info_t from ov_preprocess_input_model_info"]
pub type ov_preprocess_input_model_info_t = ov_preprocess_input_model_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ov_preprocess_preprocess_steps {
    _unused: [u8; 0],
}
#[doc = " @struct ov_preprocess_preprocess_steps_t\n @ingroup ov_prepostprocess_c_api\n @brief type define ov_preprocess_preprocess_steps_t from ov_preprocess_preprocess_steps"]
pub type ov_preprocess_preprocess_steps_t = ov_preprocess_preprocess_steps;
#[repr(u32)]
#[doc = " @enum ov_color_format_e\n @ingroup ov_prepostprocess_c_api\n @brief This enum contains enumerations for color format."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ov_color_format_e {
    #[doc = "!< Undefine color format"]
    UNDEFINE = 0,
    #[doc = "!< Image in NV12 format as single tensor"]
    NV12_SINGLE_PLANE = 1,
    #[doc = "!< Image in NV12 format represented as separate tensors for Y and UV planes."]
    NV12_TWO_PLANES = 2,
    #[doc = "!< Image in I420 (YUV) format as single tensor"]
    I420_SINGLE_PLANE = 3,
    #[doc = "!< Image in I420 format represented as separate tensors for Y, U and V planes."]
    I420_THREE_PLANES = 4,
    #[doc = "!< Image in RGB interleaved format (3 channels)"]
    RGB = 5,
    #[doc = "!< Image in BGR interleaved format (3 channels)"]
    BGR = 6,
    #[doc = "!< Image in GRAY format (1 channel)"]
    GRAY = 7,
    #[doc = "!< Image in RGBX interleaved format (4 channels)"]
    RGBX = 8,
    #[doc = "!< Image in BGRX interleaved format (4 channels)"]
    BGRX = 9,
}
#[repr(u32)]
#[doc = " @enum ov_preprocess_resize_algorithm_e\n @ingroup ov_prepostprocess_c_api\n @brief This enum contains codes for all preprocess resize algorithm."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ov_preprocess_resize_algorithm_e {
    #[doc = "!< linear algorithm"]
    RESIZE_LINEAR = 0,
    #[doc = "!< cubic algorithm"]
    RESIZE_CUBIC = 1,
    #[doc = "!< nearest algorithm"]
    RESIZE_NEAREST = 2,
}
#[repr(u32)]
#[doc = " @enum ov_padding_mode_e\n @ingroup ov_prepostprocess_c_api\n @brief This enum contains enumeration for  padding mode."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ov_padding_mode_e {
    #[doc = "!< Pads with given constant value."]
    CONSTANT = 0,
    #[doc = "!< Pads with tensor edge values."]
    EDGE = 1,
    #[doc = "!< Pads with reflection of tensor data along axis. Values on the edges are not duplicated."]
    REFLECT = 2,
    #[doc = "!<  Pads similar like `REFLECT` but values on the edges are duplicated."]
    SYMMETRIC = 3,
}
