#
# Zeek documentation build configuration file, created by sphinx-quickstart
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os
import sys

extensions = []

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath("ext"))

# -- General configuration -----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions += [
    "zeek",
    "sphinx.ext.todo",
    "zeek_pygments",
    "spicy-pygments",
    "literal-emph",
    "sphinx.ext.extlinks",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix of source filenames.
source_suffix = ".rst"

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Zeek"
copyright = "by the Zeek Project"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
#

version = "source"

try:
    # Use the actual Zeek version if available
    with open("../VERSION") as f:
        version = f.readline().strip()
except:
    try:
        import re

        import git

        repo = git.Repo(os.path.abspath("."))
        version = "git/master"

        version_tag_re = r"v\d+\.\d+(\.\d+)?"
        version_tags = [
            t
            for t in repo.tags
            if t.commit == repo.head.commit and re.match(version_tag_re, str(t))
        ]
        # Note: sorting by tag date doesn't necessarily give correct
        # order in terms of version numbers, but doubtful that will ever be
        # a problem (if we ever do re-tag an old version number on a given
        # commit such that it is incorrectly found as the most recent version,
        # we can just re-tag all the other version numbers on that same commit)
        version_tags = sorted(version_tags, key=lambda t: t.tag.tagged_date)

        if version_tags:
            version = str(version_tags[-1])

    except:
        pass

# The full version, including alpha/beta/rc tags.
release = version

# In terms of the actual hyperlink URL, a more ideal/stable way to reference
# source code on GitHub would be by commit hash, but that can be tricky to
# update in a way that produces stable Sphinx/reST configuration: don't want
# to update the commit-hash for every Zeek commit unless it actually produces
# new content, and also don't want to accidentally make it easy for people to
# insert unreachable commits when manually running
# `zeek/ci/update-zeekygen-docs.sh`.
#
# We only have a few versions of docs that actually matter: `master` and
# `release/.*`, and the tip of those branches will always be in sync with
# auto-generated content by simply having `zeek/ci/update-zeekygen-docs.sh`
# change this to `release/.*` when needed.
zeek_code_version = 'release/7.2'
zeek_code_url = f"https://github.com/zeek/zeek/blob/{zeek_code_version}"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
today_fmt = "%B %d, %Y"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = [".#*", "script-reference/autogenerated-*"]

# The reST default role (used for this markup: `text`) to use for all documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
show_authors = True

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

highlight_language = "none"

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []


# -- Options for HTML output ---------------------------------------------------

html_theme = "sphinx_rtd_theme"

# Set canonical URL from the Read the Docs Domain
html_baseurl = os.environ.get("READTHEDOCS_CANONICAL_URL", "")

# Tell Jinja2 templates the build is running on Read the Docs
if os.environ.get("READTHEDOCS", "") == "True":
    if "html_context" not in globals():
        html_context = {}
    html_context["READTHEDOCS"] = True

html_last_updated_fmt = "%B %d, %Y"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    "analytics_id": "UA-144186885-1",
    "collapse_navigation": False,
    "display_version": True,
    "style_external_links": True,
}

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> Documentation".
html_title = f"Book of Zeek ({release})"

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = "images/zeek-logo-sidebar.png"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "images/zeek-favicon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]


def setup(app):
    app.add_css_file("theme_overrides.css")
    from sphinx.highlighting import lexers
    from zeek_pygments import ZeekLexer

    lexers["zeek"] = ZeekLexer()
    app.add_config_value("zeek-code-url", zeek_code_url, "env")


# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {
#'**': ['localtoc.html', 'sourcelink.html', 'searchbox.html'],
# }

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = "zeek-docs"

# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
# latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
# latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
    ("index", "Zeek.tex", "Zeek Documentation", "The Zeek Project", "manual"),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# If true, show page references after internal links.
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
# latex_show_urls = False

# Additional stuff for the LaTeX preamble.
# latex_preamble = ''

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_domain_indices = True

# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [("index", "zeek", "Zeek Documentation", ["The Zeek Project"], 1)]

# -- Options for todo plugin --------------------------------------------
todo_include_todos = True

extlinks = {
    "slacklink": ("https://zeek.org/slack%s", None),
    "discourselink": ("https://community.zeek.org/%s", None),
    "spicylink": ("https://docs.zeek.org/projects/spicy/en/latest/%s", None),
}
extlinks_detect_hardcoded_links = True
